/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.google.common.collect.Lists;
import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintDataProvider;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.PrintServicePluginProxy;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.validation.FieldScanner;
import kd.bos.report.AbstractReportModel;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.print.dataprovider.ReportDataProvider;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.ShowBosPrintingProgress;
import kd.fi.gl.reciprocal.ReciprocalInitUtils;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.report.ReportFormUtil;
import kd.fi.gl.report.ReportPrintHelper;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.util.DateUtil;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.VoucherUtil;

public class ACAccountCheckRptFilterPlugin
extends AbstractReportFormPlugin {
    private static final String DATERANGE_STARTDATE = "daterange_startdate";
    private static final String DATERANGE_ENDDATE = "daterange_enddate";
    private static final Log log = LogFactory.getLog(ACAccountCheckRptFilterPlugin.class);
    private static final String ORG = "org";
    private static String ENTRY_ENTITY = "entryentity";
    private static final String EXPORT_EXCEL = "exportexcel";
    private static final LocaleString TXT_AMOUNT = new LocaleString(ResManager.loadKDString((String)"\u91d1\u989d", (String)"ACAccountCheckRptFilterPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    private static final String FIELD_NAME = "fieldname";
    private static final String VALUE = "value";
    private static final String startPeriod = "startperiod";
    private static final String endPeriod = "endperiod";
    private static final String assistDb = "gl_assist_bd";
    private static final String startDate = "daterange_startdate";
    private static final String endDate = "daterange_enddate";
    private static final String bookeddate = "bookeddate";
    private Map<Long, String> acOrg = new HashMap<Long, String>();
    private static final String bosentity = "bos_org";
    private static final String cusentity = "bd_customer";
    private static final String supentity = "bd_supplier";
    private static final String[] Entity_Strs = new String[]{"bos_org", "bd_customer", "bd_supplier"};
    private static final String[] Qty_List = new String[]{"measureunit", "debitqty", "creditqty", "endqty"};

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener(arg0 -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
            IReportListModel reportModel = list.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            String voucherId = rowData.getString("voucherid");
            if (StringUtils.isNotBlank((CharSequence)voucherId) && !voucherId.equals("0")) {
                this.viewVoucher(voucherId, reportModel);
            }
        });
        this.getPageCache().remove("daterange_startdate");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getControl("voucherfiltergridap");
        filterGrid.setEntityNumber("gl_voucher");
        this.setVoucherFilterFields(filterGrid);
    }

    private void setVoucherFilterFields(FilterGrid filterGrid) {
        ArrayList<String> filterFileds = new ArrayList<String>(19);
        filterFileds.add("billno");
        filterFileds.add("edescription");
        filterFileds.add("vouchertype.number");
        filterFileds.add("bizdate");
        filterFileds.add(bookeddate);
        filterFileds.add("description");
        filterFileds.add("billstatus");
        filterFileds.add("ispost");
        filterFileds.add("creator.number");
        filterFileds.add("auditor.number");
        filterFileds.add("cashier.number");
        filterFileds.add("poster.number");
        filterFileds.add("currency.number");
        filterFileds.add("debitori");
        filterFileds.add("creditori");
        filterFileds.add("debitlocal");
        filterFileds.add("creditlocal");
        filterFileds.add("debitrpt");
        filterFileds.add("creditrpt");
        filterGrid.setFilterFieldKeys(filterFileds);
    }

    public void viewVoucher(String id, IReportListModel reportModel) {
        long orgId = ((DynamicObject)this.getModel().getValue(ORG)).getLong("id");
        VoucherUtil.hyperVoucher(orgId, Long.parseLong(id), (IFormView)this.getView(), VoucherUtil.getVoucherIdList(reportModel, "voucherid", this.getModel().getEntryCurrentRowIndex("reportlistap")));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ENTRY_ENTITY});
        this.addItemClickListeners(new String[]{"asstopr"});
        BasedataEdit fieldname = (BasedataEdit)this.getControl(FIELD_NAME);
        fieldname.addBeforeF7SelectListener(evt -> {
            IDataModel model = this.getModel();
            DynamicObject account = (DynamicObject)model.getValue("account1");
            if (account != null) {
                DynamicObjectCollection items = account.getDynamicObjectCollection("checkitementry");
                HashSet<Object> assT = new HashSet<Object>();
                for (DynamicObject item : items) {
                    if (!item.getBoolean("enaccheck")) continue;
                    assT.add(item.get("asstactitem_id"));
                }
                DynamicObjectCollection entries = model.getEntryEntity("entryentity");
                HashSet<Object> s = new HashSet<Object>();
                for (DynamicObject entry : entries) {
                    s.add(entry.get("fieldname_id"));
                }
                QFilter qFilter = new QFilter("id", "in", assT);
                qFilter.and(new QFilter("id", "not in", s));
                ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
            } else {
                ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("id", "=", (Object)0L));
            }
            Long orgId = (Long)this.getModel().getValue("org_id");
            if (orgId != null && orgId != 0L) {
                ArrayList<Long> orgIds = new ArrayList<Long>(1);
                orgIds.add(orgId);
                ((ListShowParameter)evt.getFormShowParameter()).setUseOrgIds(orgIds);
            }
        });
        BasedataEdit ass = (BasedataEdit)this.getControl(VALUE);
        ass.addBeforeF7SelectListener(e1 -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            DynamicObject dyn = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex);
            DynamicObject assisType = dyn.getDynamicObject(FIELD_NAME);
            if (assisType == null) {
                e1.setCancel(true);
                return;
            }
            String valuetype = assisType.getString("valuetype");
            if (!"2".equals(valuetype)) {
                return;
            }
            DynamicObject valueSource = assisType.getDynamicObject("assistanttype");
            String number = valueSource.getString("number");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("group.number", "=", (Object)number));
            ListShowParameter showParam = (ListShowParameter)e1.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            filterParam.setQFilters(qFilters);
        });
        BasedataEdit account = (BasedataEdit)this.getControl("account1");
        account.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            param.setCustomParam("acct_filter", (Object)"true");
            List qFilters = param.getListFilterParameter().getQFilters();
            qFilters.addAll(this.getAccountFilter());
            Long orgId = (Long)this.getModel().getValue("org_id");
            Long bookTypeId = (Long)this.getModel().getValue("booktype_id");
            long accountbook = (Long)this.getModel().getValue("accounttable_id");
            ArrayList<Long> accountIds = new ArrayList<Long>();
            Date startDate = (Date)this.getModel().getValue("daterange_startdate");
            if (startDate != null) {
                try (DataSet info = ReciprocalInitUtils.queryIsEndInitReciprocalInit((boolean)false, (Long)orgId, (Long)bookTypeId, (Long)accountbook);){
                    while (info.hasNext()) {
                        Row infos = info.next();
                        Date endInitPeriodBeginDate = infos.getDate("begindate");
                        if (endInitPeriodBeginDate == null || endInitPeriodBeginDate.compareTo(startDate) > 0) continue;
                        accountIds.add(infos.getLong("account"));
                    }
                }
            }
            qFilters.add(new QFilter("masterid", "in", accountIds));
        });
    }

    private List<QFilter> getAccountFilter() {
        QFilter acctRefFilter;
        DynamicObject endPeriod;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        Object value = this.getModel().getValue("accounttable_id");
        QFilter atF = new QFilter("accounttable", "=", value);
        qFilters.add(atF);
        Date endDate = (Date)this.getModel().getValue("daterange_enddate");
        Long periodType = (Long)this.getModel().getValue("periodtype_id");
        if (Objects.isNull(endDate)) {
            endDate = new Date();
            this.getModel().setValue("daterange_enddate", (Object)endDate);
        }
        if ((endPeriod = GLUtil.getPeriodByDate((Date)endDate, (long)periodType)) != null && (acctRefFilter = BalanceTransferUtils.getAccountRefFilter((Date)endPeriod.getDate("enddate"))) != null) {
            qFilters.add(acctRefFilter);
        }
        qFilters.add(new QFilter("accheck", "=", (Object)true));
        Long orgId = (Long)this.getModel().getValue("org_id");
        Long bookTypeId = (Long)this.getModel().getValue("booktype_id");
        qFilters.add(ReciprocalUtils.queryEndInitActFilter(Collections.singleton(orgId), (Long)bookTypeId));
        qFilters.add(BaseDataServiceHelper.getBaseDataIdInFilter((String)"bd_accountview", (Long)orgId));
        qFilters.add(new QFilter("isleaf", "=", (Object)"1"));
        return qFilters;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        int rowIndex;
        MainEntityType type = e.getOriginalEntityType();
        EntryProp entry = (EntryProp)type.getProperty(ENTRY_ENTITY);
        MulBasedataProp prop = (MulBasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(VALUE);
        IDataModel model = this.getModel();
        DynamicObject assisType = (DynamicObject)model.getValue(FIELD_NAME, rowIndex = model.getEntryCurrentRowIndex(ENTRY_ENTITY));
        if (assisType == null) {
            return;
        }
        DynamicObject valueSource = null;
        String entityId = null;
        String valuetype = assisType.getString("valuetype");
        if ("1".equals(valuetype)) {
            valueSource = assisType.getDynamicObject("valuesource");
            entityId = valueSource.getString("id");
        } else if ("2".equals(valuetype)) {
            valueSource = assisType.getDynamicObject("assistanttype");
            entityId = "bos_assistantdata_detail";
        }
        if (valueSource != null) {
            prop.setBaseEntityId(entityId);
            BasedataProp baseProp = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
            baseProp.setBaseEntityId(entityId);
            baseProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        ReportList reportllistap = (ReportList)this.getView().getControl("reportllistap");
        reportllistap.selectRows(1);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeSet = e.getChangeSet()[0];
        Object value = changeSet.getNewValue();
        if ("account1".equals(key)) {
            this.setFlexInfo(model);
        }
        if (value == null) {
            return;
        }
        switch (key) {
            case "daterange_startdate": {
                this.setPeriod(key, changeSet);
                break;
            }
            case "daterange_enddate": {
                this.setPeriod(key, changeSet);
                this.setAccountTable();
                this.setDefaultAccount(model, (Long)this.getModel().getValue("org_id"));
                break;
            }
            case "org": {
                Long orgId = ((DynamicObject)value).getLong("id");
                this.setEntityBookType(orgId);
                break;
            }
            case "booktype": {
                Long bookTypeId = ((DynamicObject)value).getLong("id");
                this.setBook(bookTypeId);
                break;
            }
            case "accounttable": {
                Long accountTableId = ((DynamicObject)value).getLong("id");
                this.setAccount(accountTableId);
                break;
            }
            case "periodtype": {
                String str = this.getPageCache().get("ptSpMap");
                Map ptSpMap = (Map)GLUtil.fromSerializedString((String)str);
                long periodType = ((DynamicObject)value).getLong("id");
                this.setPeriodFilter(periodType, ptSpMap);
                break;
            }
            case "account": {
                DynamicObjectCollection accCols = (DynamicObjectCollection)value;
                if (accCols.size() == 0) {
                    return;
                }
                List levels = accCols.stream().map(x -> x.getDynamicObject("fbasedataid")).mapToInt(x -> x.getInt("level")).boxed().collect(Collectors.toList());
                this.getModel().setValue("accountlevel", Collections.max(levels));
            }
        }
    }

    private void setAccountTable() {
        Date endDate;
        long periodTypeId;
        long bookTypeId;
        IDataModel model = this.getModel();
        long orgId = (Long)model.getValue("org_id");
        List acctTableIds = ReportUtils.getVerAcctTable((long)orgId, (long)(bookTypeId = ((Long)model.getValue("booktype_id")).longValue()), (long)(periodTypeId = ((Long)model.getValue("periodtype_id")).longValue()), (Date)(endDate = (Date)model.getValue("daterange_enddate")));
        if (!acctTableIds.isEmpty()) {
            model.setValue("accounttable", acctTableIds.get(0));
            BasedataEdit acctTblEdit = (BasedataEdit)this.getControl("accounttable");
            acctTblEdit.setQFilters(Collections.singletonList(new QFilter("id", "in", (Object)acctTableIds)));
        }
    }

    private void setPeriod(String daterange, ChangeData changeSet) {
        IDataModel model = this.getModel();
        DynamicObject period = null;
        DynamicObject periodType = (DynamicObject)model.getValue("periodtype");
        if (null == periodType) {
            return;
        }
        long type = periodType.getLong("id");
        if (changeSet == null) {
            period = GLUtil.getPeriodByDate((Date)new Date(), (long)type);
        } else {
            Date newValue = (Date)changeSet.getNewValue();
            if (newValue == null) {
                return;
            }
            period = "daterange_startdate".equals(daterange) ? this.getPeriodByDate(newValue, type) : GLUtil.getPeriodByDate((Date)newValue, (long)type);
        }
        if (period == null) {
            if (Objects.isNull(this.getPageCache().get("daterange_startdate"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u9009\u62e9\u65f6\u95f4\u6240\u5bf9\u5e94\u7684\u671f\u95f4\u3002", (String)"ACAccountCheckRptFilterPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                this.getPageCache().put("daterange_startdate", "true");
            }
            return;
        }
        switch (daterange) {
            case "daterange_startdate": {
                model.setValue(startPeriod, (Object)period.getLong("id"));
                break;
            }
            case "daterange_enddate": {
                model.setValue(endPeriod, (Object)period.getLong("id"));
            }
        }
    }

    private DynamicObject getPeriodByDate(Date date, long periodType) {
        Date end = DateUtil.makeDateOnDayEnd((Date)date);
        QFilter f = new QFilter("beginDate", "<=", (Object)end);
        QFilter g = new QFilter("enddate", ">=", (Object)end);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        String selectField = "id,periodtype.id,periodyear,periodnumber,begindate,enddate,isadjustperiod,number,name";
        DynamicObjectCollection period = QueryServiceHelper.query((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t}, (String)"id asc");
        if (!period.isEmpty()) {
            return (DynamicObject)period.get(0);
        }
        return null;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        HashMap acNoticeMap = new HashMap(16);
        Boolean flag = (Boolean)ThreadCache.get((Object)"isPrintOperation");
        if (flag == null || !flag.booleanValue()) {
            List voucherIds = rowData.stream().filter(row -> row.getLong("voucherid") != 0L).map(row -> row.getLong("voucherid")).distinct().collect(Collectors.toList());
            List vchIdsPartition = Lists.partition(voucherIds, (int)999);
            for (List vchIds : vchIdsPartition) {
                QFilter[] qf = new QFilter[]{new QFilter("voucher", "in", (Object)vchIds)};
                DataSet resultDt = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + ".queryACnotice"), (String)"gl_acnotice", (String)"voucher,voucherentry,checkstatus", (QFilter[])qf, null);
                resultDt.forEach(ac -> acNoticeMap.put(ac.getLong("voucherentry"), ac.getBoolean("checkstatus")));
            }
        }
        FilterInfo filterInfo = queryParam.getFilter();
        long orgId = (Long)this.getModel().getValue("org_id");
        Boolean isShowByAccountDC = (Boolean)GLUtil.getSystemParam((String)"showbyaccountdc", (Long)orgId);
        if (isShowByAccountDC == null) {
            isShowByAccountDC = false;
        }
        String dc = filterInfo.getDynamicObject("account1").getString("dc");
        boolean showTip = false;
        for (DynamicObject row2 : rowData) {
            if ("1".equals(row2.getString("rowtype"))) {
                showTip = true;
            }
            row2.set("checkstatus", acNoticeMap.get(row2.getLong("entryid")));
            BigDecimal endlocal = row2.getBigDecimal("endlocal");
            if (endlocal == null || GLUtil.isZero((BigDecimal)endlocal)) {
                row2.set("dc", (Object)"0");
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)dc)) continue;
            BigDecimal dcVal = new BigDecimal(dc);
            BigDecimal endForVal = row2.getBigDecimal("endfor").multiply(dcVal);
            BigDecimal endLocalVal = row2.getBigDecimal("endlocal").multiply(dcVal);
            BigDecimal endQtyVal = row2.getBigDecimal("endqty");
            if (!(isShowByAccountDC.booleanValue() || endForVal.compareTo(BigDecimal.ZERO) >= 0 && endLocalVal.compareTo(BigDecimal.ZERO) >= 0)) {
                dcVal = dcVal.multiply(new BigDecimal("-1"));
                endForVal = endForVal.abs();
                endLocalVal = endLocalVal.abs();
                endQtyVal = endQtyVal.negate();
            }
            row2.set("dc", (Object)dcVal.toString());
            row2.set("endfor", (Object)endForVal);
            row2.set("endlocal", (Object)endLocalVal);
            row2.set("endqty", (Object)endQtyVal);
        }
        this.setLabel(rowData);
        FilterItemInfo itemInfo = filterInfo.getFilterItem(EXPORT_EXCEL);
        if (itemInfo != null) {
            this.dealAssgrpDisplay(rowData, "aspnumber");
        }
        this.dealAssgrpDisplay(gridPK, rowData);
        this.dealBookeddate(gridPK, rowData);
        if (showTip && ReportUtils.checkIfDetailOutOfLimit((ReportQueryParam)this.getView().getQueryParam()).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u5185\u7684\u51ed\u8bc1\u6570\u636e\u91cf\u8d85\u51fa\u9650\u5236\uff0c\u8d85\u51fa\u9650\u5236\u7684\u51ed\u8bc1\u4ec5\u8ba1\u5165\u672c\u671f\u5408\u8ba1\u548c\u672c\u5e74\u7d2f\u8ba1\uff0c\u4e0d\u4f1a\u5728\u5217\u8868\u548c\u5bfc\u51fa\u4e2d\u663e\u793a\u3002", (String)"ACAccountCheckRptFilterPlugin_27", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
        }
    }

    private void dealAssgrpDisplay(DynamicObjectCollection rowData, String endSplit) {
        if (CollectionUtils.isEmpty((Collection)rowData)) {
            return;
        }
        ArrayList<String> numberObject = new ArrayList<String>();
        DataEntityPropertyCollection properties = rowData.getDynamicObjectType().getProperties();
        if (!CollectionUtils.isEmpty((Collection)properties)) {
            for (IDataEntityProperty property : properties) {
                if (!property.getName().endsWith(endSplit) || !properties.stream().anyMatch(item -> item.getName().equals(property.getName().substring(0, property.getName().indexOf("."))))) continue;
                numberObject.add(property.getName().substring(0, property.getName().indexOf(".") + 1));
            }
        }
        if (!CollectionUtils.isEmpty(numberObject)) {
            for (DynamicObject rowDatum : rowData) {
                for (String field : numberObject) {
                    DynamicObject dynamicObject = rowDatum.getDynamicObject(field);
                    if (null == dynamicObject) continue;
                    rowDatum.set(field + endSplit, (Object)dynamicObject.getString("number"));
                }
            }
        }
    }

    private void dealAssgrpDisplay(String gridPK, DynamicObjectCollection rowData) {
        if ("reportllistap".equals(gridPK) && !CollectionUtils.isEmpty((Collection)rowData)) {
            ArrayList<String> numberObject = new ArrayList<String>();
            DataEntityPropertyCollection properties = rowData.getDynamicObjectType().getProperties();
            if (!CollectionUtils.isEmpty((Collection)properties)) {
                for (IDataEntityProperty property : properties) {
                    if (!property.getName().endsWith(".number") || !properties.stream().anyMatch(item -> item.getName().equals(property.getName().substring(0, property.getName().indexOf("."))))) continue;
                    numberObject.add(property.getName().substring(0, property.getName().indexOf(".")));
                }
            }
            if (!CollectionUtils.isEmpty(numberObject)) {
                for (DynamicObject rowDatum : rowData) {
                    for (String field : numberObject) {
                        DynamicObject dynamicObject = rowDatum.getDynamicObject(field);
                        if (null == dynamicObject) continue;
                        rowDatum.set(field + ".number", (Object)dynamicObject.getString("number"));
                    }
                }
            }
        }
    }

    private void setLabel(DynamicObjectCollection rowData) {
        String info = this.getPageCache().get("info");
        String amount = this.getPageCache().get("amount");
        if (info != null && amount != null && !rowData.isEmpty()) {
            DynamicObject dyo = (DynamicObject)rowData.get(rowData.size() - 1);
            if (StringUtils.isNotBlank((CharSequence)info)) {
                BigDecimal decimal = dyo.getBigDecimal("endlocal");
                int dc = dyo.getInt("dc");
                if (dc != 1) {
                    decimal = decimal.negate();
                }
                if (decimal.add(new BigDecimal(amount)).compareTo(BigDecimal.ZERO) != 0) {
                    info = String.format(ResManager.loadKDString((String)"%s\uff0c\u671f\u672b\u4f59\u989d\u5bf9\u8d26\u4e0d\u5e73\u3002", (String)"ACAccountCheckRptFilterPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), info);
                }
                Label la = (Label)this.getControl("acorgendlocal");
                la.setText(info);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"acorgendlocal"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"acorgendlocal"});
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "addnewbtn": {
                this.getModel().createNewEntryRow(ENTRY_ENTITY);
                break;
            }
            case "removebtn": {
                IDataModel model = this.getModel();
                EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
                int[] selectRows = entryGrid.getSelectRows();
                model.deleteEntryRows(ENTRY_ENTITY, selectRows);
                break;
            }
            case "barprint": {
                this.printOperation();
                break;
            }
            case "exportallexcel": {
                this.syncexportall();
            }
        }
    }

    private void syncexportall() {
        ReportQueryParam queryParam = this.getQueryParam();
        FilterItemInfo item = queryParam.getFilter().getFilterItem(EXPORT_EXCEL);
        if (item == null) {
            queryParam.getFilter().addFilterItem(EXPORT_EXCEL, (Object)"all");
        } else {
            item.setValue((Object)"all");
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gl_reportexportall");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("entitynumber", this.getView().getEntityId());
        showParameter.getCustomParams().put("entityname", this.getView().getFormShowParameter().getFormConfig().getCaption().toString());
        showParameter.getCustomParams().put("queryparam", SerializationUtils.serializeToBase64((Object)queryParam));
        showParameter.getCustomParams().put("selectobj", SerializationUtils.serializeToBase64((Object)"0"));
        this.getView().showForm(showParameter);
    }

    private void printOperation() {
        String formId = "gl_rpt_acaccountcheck";
        Object defaultTemplateId = ReportPrintHelper.getDefaultTemplateId(formId);
        if (ObjectUtils.isEmpty((Object)defaultTemplateId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f\u3002", (String)"SubLedgerFormRpt_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportView rptFormView = (ReportView)this.getExportAllView(this.getView().getPageId());
        ReportListModel listModel = (ReportListModel)rptFormView.getReportList().getReportModel();
        int rowCount = listModel.getRowCount();
        if (rowCount == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"SubLedgerFormRpt_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        String pageId = rptFormView.getPageId();
        ShowBosPrintingProgress.showProgressForm(rowCount, formId, pageId, defaultTemplateId, "", (IFormView)this.getView());
        this.clearExport();
    }

    public static IPrintDataProvider createReportDataProvider(String pageId, String formId, PrintMetadata printMeta) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        ReportDataProvider provider = null;
        ArrayList pluginMap = new ArrayList();
        for (Plugin p : printMeta.getRootAp().getPlugins()) {
            if (!p.isEnabled()) continue;
            HashMap<String, Object> mp = new HashMap<String, Object>(1);
            mp.put("type", p.getType());
            mp.put("className", p.getClassName());
            pluginMap.add(mp);
        }
        PrintServicePluginProxy proxy = null;
        Map customFields = null;
        if (!pluginMap.isEmpty()) {
            proxy = new PrintServicePluginProxy(pluginMap);
        }
        FieldScanner fieldScanner = new FieldScanner(printMeta);
        customFields = fieldScanner.scanCustomFields();
        provider = new ReportDataProvider(pageId, entityType, customFields, proxy);
        return provider;
    }

    public IFormView getExportAllView(String pageId) {
        ReportQueryParam queryParam = this.getQueryParam();
        FilterItemInfo item = queryParam.getFilter().getFilterItem(EXPORT_EXCEL);
        if (item == null) {
            queryParam.getFilter().addFilterItem(EXPORT_EXCEL, (Object)"all");
        } else {
            item.setValue((Object)"all");
        }
        ReportList leftList = (ReportList)this.getControl("reportllistap");
        IReportListModel leftReportModel = leftList.getReportModel();
        int leftIndex = leftList.getEntryState().getFocusRow();
        int count = leftReportModel.getRowCount();
        if (leftIndex == -1 && count > 0) {
            leftIndex = 1;
        }
        DynamicObject obj = null;
        if (leftIndex > -1) {
            obj = leftReportModel.getRowData(leftIndex);
        }
        ReportList list = (ReportList)this.getControl("reportlistap");
        IReportCache reportCache = ReportCacheManager.getInstance().getCache();
        reportCache.setReportQueryParam(pageId == null ? Uuid16.create().toString() : pageId, queryParam);
        AbstractReportModel reportModel = (AbstractReportModel)list.getReportModel();
        reportModel.setPageId(pageId == null ? Uuid16.create().toString() : pageId);
        list.setAsynQuery(true);
        list.submitTask(queryParam, (Object)obj);
        return list.getView();
    }

    private void setFlexInfo(IDataModel model) {
        DynamicObject account = (DynamicObject)model.getValue("account1");
        if (account != null) {
            TableValueSetter tvs = new TableValueSetter(new String[0]);
            tvs.addField(FIELD_NAME, new Object[0]);
            model.deleteEntryData("entryentity");
            DynamicObjectCollection items = account.getDynamicObjectCollection("checkitementry");
            for (DynamicObject item : items) {
                if (!item.getBoolean("enaccheck")) continue;
                tvs.addRow(new Object[]{item.getDynamicObject("asstactitem").getPkValue()});
            }
            AbstractFormDataModel m = (AbstractFormDataModel)model;
            m.beginInit();
            m.batchCreateNewEntryRow("entryentity", tvs);
            m.endInit();
            this.getView().updateView("entryentity");
            DynamicObjectCollection c = new DynamicObjectCollection();
            c.add((Object)account);
            model.setValue("account", (Object)c);
            String actMap = this.getPageCache().get("accountmap");
            if (actMap != null) {
                Map map = (Map)SerializationUtils.fromJsonString((String)actMap, Map.class);
                Object org = model.getValue("org_ID");
                Object type = model.getValue("booktype_ID");
                String str = org + "_" + type + "_" + account.getLong("masterid");
                if (map.containsKey(str)) {
                    DynamicObject begin;
                    DateRangeEdit date = (DateRangeEdit)this.getControl("daterange");
                    Long periodid = null;
                    if (map.get(str) instanceof Long) {
                        periodid = (Long)map.get(str);
                    } else if (map.get(str) instanceof Integer) {
                        periodid = Long.parseLong(map.get(str) + "");
                    }
                    if (periodid != null && periodid != 0L && (begin = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate", (QFilter[])new QFilter("id", "=", (Object)periodid).toArray())) != null) {
                        date.setMinDate(begin.getDate("begindate"));
                    }
                }
            }
        } else {
            String actMap = this.getPageCache().get("accountmap");
            if (actMap != null) {
                Map map = (Map)SerializationUtils.fromJsonString((String)actMap, Map.class);
                Collection values = map.values();
                long minPeriod = 0L;
                for (Number number : values) {
                    if (minPeriod == 0L) {
                        minPeriod = Long.parseLong(number.toString());
                        continue;
                    }
                    minPeriod = Math.min(Long.parseLong(number.toString()), minPeriod);
                }
                if (minPeriod != 0L) {
                    DynamicObject begin = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate", (QFilter[])new QFilter("id", "=", (Object)minPeriod).toArray());
                    DateRangeEdit date = (DateRangeEdit)this.getControl("daterange");
                    date.setMinDate(begin.getDate("begindate"));
                }
            }
        }
        int count = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] rows = IntStream.range(0, count).toArray();
        entryGrid.selectRows(rows, 0);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        GlFormUtil.setSelectedFlexItems(this.getModel(), (EntryGrid)this.getControl(ENTRY_ENTITY), queryParam.getFilter());
        if (filterInfo.getLong(ORG) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ACAccountCheckRptFilterPlugin_9", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("booktype") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"ACAccountCheckRptFilterPlugin_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("accounttable") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u8868\u3002", (String)"ACAccountCheckRptFilterPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("periodtype") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u7c7b\u578b\u3002", (String)"ACAccountCheckRptFilterPlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong(startPeriod) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u3002", (String)"ACAccountCheckRptFilterPlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong(endPeriod) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u3002", (String)"ACAccountCheckRptFilterPlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getValue("daterange_startdate") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ACAccountCheckRptFilterPlugin_14", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong(startPeriod) > filterInfo.getLong(endPeriod)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"ACAccountCheckRptFilterPlugin_15", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("account1") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u3002", (String)"ACAccountCheckRptFilterPlugin_16", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getFlexFilterItems().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"ACAccountCheckRptFilterPlugin_17", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        String period = ReportUtils.isOverAcctVer((Date)filterInfo.getDate("daterange_startdate"), (Date)filterInfo.getDate("daterange_enddate"), (long)filterInfo.getLong("periodtype"), (long)filterInfo.getLong(ORG), (long)filterInfo.getLong("booktype"));
        if (Objects.nonNull(period)) {
            String msg = String.format(ResManager.loadKDString((String)"\u9009\u62e9\u65e5\u671f\u5bf9\u5e94%s\u8fdb\u884c\u4e86\u79d1\u76ee\u8868\u7248\u672c\u5316\uff0c\u4e0d\u5141\u8bb8\u67e5\u8be2\uff0c\u8bf7\u8c03\u6574\u3002", (String)"ACAccountCheckRptFilterPlugin_18", (String)"fi-gl-formplugin", (Object[])new Object[0]), period);
            this.getView().showTipNotification(msg);
            return false;
        }
        this.beforeQuerySetParam(queryParam);
        return true;
    }

    private void beforeQuerySetParam(ReportQueryParam queryParam) {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(ENTRY_ENTITY);
        FilterInfo filterInfo = queryParam.getFilter();
        HashMap<String, FilterItemInfo> filterMap = new HashMap<String, FilterItemInfo>(filterInfo.getFlexFilterItems().size());
        for (FilterItemInfo item : filterInfo.getFlexFilterItems()) {
            filterMap.put(item.getPropName(), item);
        }
        block8: for (int i = 0; i < rowCount; ++i) {
            String valueType;
            String flexfield;
            FilterItemInfo item;
            DynamicObject assisType = (DynamicObject)model.getValue(FIELD_NAME, i);
            if (assisType == null || (item = (FilterItemInfo)filterMap.get(flexfield = assisType.getString("flexfield"))) == null) continue;
            switch (valueType = assisType.getString("valuetype")) {
                case "1": 
                case "2": {
                    String entityId;
                    Object value = item.getValue();
                    if (value == null) continue block8;
                    if ("2".equals(valueType)) {
                        entityId = "bos_assistantdata_detail";
                    } else {
                        DynamicObject valueSource = assisType.getDynamicObject("valuesource");
                        entityId = valueSource.getString("id");
                    }
                    this.setMasterIdById(item, value, entityId);
                }
            }
        }
    }

    private void setMasterIdById(FilterItemInfo item, Object value, String entityId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        if (dataEntityType instanceof BasedataEntityType && ((BasedataEntityType)dataEntityType).getMasteridType() != 0) {
            String masterIdPropName = ((BasedataEntityType)dataEntityType).getMasteridPropName();
            HashSet<Object> val = new HashSet<Object>();
            try (DataSet set = QueryServiceHelper.queryDataSet((String)"gl assist report filter", (String)entityId, (String)"masterid", (QFilter[])new QFilter("id", "in", value).toArray(), null);){
                while (set.hasNext()) {
                    val.add(set.next().get(masterIdPropName));
                }
            }
            item.setValue(val);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initOrg();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{startPeriod, endPeriod, "account", "measureunits", "orgview", "acorgendlocal"});
        this.initCurrency();
    }

    private void initCurrency() {
        ComboEdit currency = (ComboEdit)this.getControl("currency");
        currency.setComboItems(ReportUtils.getCurrencyItems((boolean)true, (boolean)true));
    }

    private void initOrg() {
        BasedataEdit orgEdit = (BasedataEdit)this.getControl(ORG);
        Set orgSet = AccSysUtil.getAcctOrgPkList2((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW);
        this.getPageCache().put("_permOrgList", GLUtil.toSerializedString((Object)orgSet));
        GlFormUtil.setF7ClickFilter(orgEdit, new QFilter("id", "in", (Object)orgSet));
        Long defaultOrgId = AccSysUtil.getDefaultOrgId((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW);
        if (!orgSet.contains(defaultOrgId)) {
            defaultOrgId = this.getDefaultOrg(new ArrayList<Long>(orgSet));
        }
        this.getModel().setValue(ORG, (Object)defaultOrgId);
        this.setEntityBookType(defaultOrgId);
    }

    private Long getDefaultOrg(List<Long> orgList) {
        return GlFormUtil.getDefaultAcctOrg(orgList);
    }

    private void setEntityBookType(Long orgId) {
        HashSet<Long> childOrg = new HashSet<Long>();
        childOrg.add(orgId);
        this.getPageCache().put("_childOrgSet", GLUtil.toSerializedString(childOrg));
        Long defaultBookType = null;
        ArrayList<Long> bookTypes = new ArrayList<Long>();
        QFilter orgFiler = new QFilter(ORG, "=", (Object)orgId);
        DynamicObjectCollection btCol = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype id, bookstype.accounttype type", (QFilter[])new QFilter[]{orgFiler});
        for (DynamicObject bt : btCol) {
            bookTypes.add(bt.getLong("id"));
            if (!"1".equals(bt.getString("type"))) continue;
            defaultBookType = bt.getLong("id");
        }
        if (defaultBookType == null && bookTypes.size() > 0) {
            defaultBookType = (Long)bookTypes.get(0);
        }
        if (defaultBookType == null) {
            return;
        }
        this.setBT(bookTypes, defaultBookType);
    }

    private void setBT(Collection<Long> bookTypes, long defaultBookType) {
        BasedataEdit bookTypeEdit = (BasedataEdit)this.getControl("booktype");
        GlFormUtil.setF7ClickFilter(bookTypeEdit, new QFilter("id", "in", bookTypes));
        this.getView().setVisible(Boolean.valueOf(bookTypes.size() > 1), new String[]{"booktype"});
        this.getModel().setValue("booktype", (Object)defaultBookType);
        this.setBook(defaultBookType);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        FilterInfo filter = event.getQueryParam().getFilter();
        ThreadService.execute(() -> this.getOtherOrgInfo(event), (TaskType)TaskType.GL_QUERY_AC_ACCT_BALANCE_ASYN);
        String currency = filter.getString("currency");
        AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)filter.getLong(ORG), (long)filter.getLong("booktype"));
        Long baseCurrency = book.getBaseCurrencyId();
        boolean isBaseCurrency = false;
        if (currency != null) {
            isBaseCurrency = "basecurrency".equals(currency) || currency.equals(baseCurrency.toString());
        }
        this.setColumnVisible(event.getColumns(), isBaseCurrency, isBaseCurrency, filter.getBoolean("showqty"));
    }

    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        IDataModel model = this.getModel();
        model.setValue("daterange_startdate", scheme.get("daterange_startdate"));
        model.setValue("daterange_enddate", scheme.get("daterange_enddate"));
    }

    private String getACOrgBal(FilterInfo filterInfo) {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<Long, String> org : this.acOrg.entrySet()) {
            DynamicObject supplier;
            QFilter[] qf = new QFilter[]{new QFilter("internal_company_id", "=", (Object)filterInfo.getLong(ORG)), new QFilter("enable", "=", (Object)"1")};
            DynamicObjectCollection bizs = QueryServiceHelper.query((String)"bd_bizpartner", (String)"id", (QFilter[])qf);
            HashSet<Long> set = new HashSet<Long>();
            for (DynamicObject biz : bizs) {
                set.add(biz.getLong("id"));
            }
            Map<String, String> map = ACAccountCheckRptFilterPlugin.getMap();
            HashMap<String, Object> value = new HashMap<String, Object>();
            DynamicObject customer = QueryServiceHelper.queryOne((String)cusentity, (String)"id,name", (QFilter[])new QFilter("bizpartner", "in", set).toArray());
            if (customer != null) {
                value.put(map.get(cusentity), customer.get("id"));
            }
            if ((supplier = QueryServiceHelper.queryOne((String)supentity, (String)"id,name", (QFilter[])new QFilter("bizpartner", "in", set).toArray())) != null) {
                value.put(map.get(supentity), supplier.get("id"));
            }
            value.put(map.get(bosentity), filterInfo.getLong(ORG));
            QFilter[] q = new QFilter[]{new QFilter("asstype", "in", value.keySet()), new QFilter("assval", "in", value.values())};
            DynamicObjectCollection hgs = QueryServiceHelper.query((String)assistDb, (String)"hg,asstype", (QFilter[])q);
            ArrayList<Long> ids = new ArrayList<Long>();
            HashSet<String> assTy = new HashSet<String>();
            for (DynamicObject hg : hgs) {
                ids.add(hg.getLong("hg"));
                assTy.add(hg.getString("asstype"));
            }
            BigDecimal amount = this.getDateBalance(filterInfo, org.getKey(), ids);
            if (amount != null && amount.compareTo(BigDecimal.ZERO) != 0) {
                DynamicObjectCollection names = QueryServiceHelper.query((String)"bd_asstacttype", (String)"name,flexfield,valuesource", (QFilter[])new QFilter("flexfield", "in", assTy).toArray());
                for (DynamicObject name : names) {
                    DynamicObject one = QueryServiceHelper.queryOne((String)name.getString("valuesource"), (String)"name", (QFilter[])new QFilter("id", "=", value.get(name.getString("flexfield"))).toArray());
                    str.append(name.getString("name"));
                    str.append(":");
                    str.append(one.getString("name"));
                    str.append(" |");
                }
                StringBuilder strTemp = new StringBuilder();
                strTemp.append(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7 %1$s \u7684\u6838\u7b97\u7ef4\u5ea6   %2$s \u671f\u672b\u4f59\u989d\u4e3a:\u501f\u65b9 %3$s\u3002", (String)"ACAccountCheckRptFilterPlugin_20", (String)"fi-gl-formplugin", (Object[])new Object[0]), org.getValue(), str.toString(), amount.setScale(2).toString()));
                str = strTemp;
                this.getPageCache().put("info", str.toString());
                this.getPageCache().put("amount", amount.setScale(2).toString());
                continue;
            }
            this.getPageCache().put("info", null);
        }
        return str.toString();
    }

    private static Map<String, String> getMap() {
        LinkedHashMap<String, String> appMap = new LinkedHashMap<String, String>();
        QFilter qf = new QFilter("valuesource", "in", (Object)Entity_Strs);
        DynamicObjectCollection values = QueryServiceHelper.query((String)"bd_asstacttype", (String)"flexfield,valuesource", (QFilter[])qf.toArray());
        values.forEach(dyo -> {
            switch (dyo.getString("valuesource")) {
                case "bos_org": {
                    appMap.put(bosentity, dyo.getString("flexfield"));
                    break;
                }
                case "bd_customer": {
                    appMap.put(cusentity, dyo.getString("flexfield"));
                    break;
                }
                case "bd_supplier": {
                    appMap.put(supentity, dyo.getString("flexfield"));
                }
            }
        });
        return appMap;
    }

    private BigDecimal getDateBalance(FilterInfo filterInfo, Long org, List<Long> ids) {
        String balanceSel = "beginlocal, debitfor debitfor, creditfor creditfor, debitlocal, creditlocal, beginfor endfor, endlocal, assgrp assgrpid";
        String select = "entries.debitori debitfor,entries.creditori creditfor,entries.debitlocal debitlocal,entries.creditlocal creditlocal, entries.assgrp assgrpid, entries.account.dc dc";
        DynamicObject startDa = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate", (QFilter[])new QFilter("id", "=", (Object)filterInfo.getLong(startPeriod)).toArray());
        QFilter orgF = new QFilter(ORG, "=", (Object)org);
        QFilter assId = new QFilter("entries.assgrp", "in", ids);
        QFilter booktype = new QFilter("booktype", "=", (Object)filterInfo.getLong("booktype"));
        QFilter starperiodF = new QFilter("period", "=", (Object)filterInfo.getLong(startPeriod));
        if (filterInfo.getLong(startPeriod) == filterInfo.getLong(endPeriod)) {
            QFilter dataF = new QFilter(bookeddate, ">=", (Object)filterInfo.getDate("daterange_startdate")).and(new QFilter(bookeddate, "<=", (Object)this.getLastHour(filterInfo.getDate("daterange_enddate"))));
            DataSet startV = VoucherQueryUtils.queryDataSet((String)select, (QFilter[])new QFilter[]{dataF, orgF, assId, booktype, starperiodF}, null, (int)-1);
            startV = startV.groupBy(new String[]{"assgrpid", "dc"}).sum("debitlocal").sum("creditlocal").finish().select("debitlocal - creditlocal endlocal,dc");
            BigDecimal amount = BigDecimal.ZERO;
            while (startV.hasNext()) {
                Row next = startV.next();
                amount = amount.add(next.getBigDecimal("endlocal"));
            }
            return amount;
        }
        QFilter startdataF = new QFilter(bookeddate, ">=", (Object)startDa.getDate("begindate")).and(new QFilter(bookeddate, "<=", (Object)this.getLastHour(filterInfo.getDate("daterange_startdate"))));
        DataSet startV = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + "voucherQuery"), (String)"gl_voucher", (String)select, (QFilter[])new QFilter[]{startdataF, orgF, assId, booktype, starperiodF}, null);
        DataSet startBalance = ACAccountCheckRptFilterPlugin.getBalance(org, filterInfo, balanceSel, ids, filterInfo.getLong(startPeriod), filterInfo.getLong(startPeriod));
        startV = startV.groupBy(new String[]{"assgrpid"}).sum("debitlocal").sum("creditlocal").finish();
        startV = startV.select(new String[]{"debitlocal - creditlocal sumendlocal", "assgrpid"});
        startBalance = startBalance.groupBy(new String[]{"assgrpid"}).sum("beginlocal").finish();
        startBalance = startBalance.join(startV, JoinType.LEFT).on("assgrpid", "assgrpid").select(new String[]{"beginlocal", "case when sumendlocal == null  then 0 else sumendlocal end sumendlocal"}).finish();
        startBalance = startBalance.select("beginlocal+sumendlocal beginlocal");
        QFilter endperiodF = new QFilter("period", "=", (Object)filterInfo.getLong(startPeriod));
        QFilter enddateF = new QFilter(bookeddate, "<", (Object)filterInfo.getDynamicObject(endPeriod).getDate("enddate")).and(new QFilter(bookeddate, ">=", (Object)filterInfo.getDate("daterange_enddate")));
        DataSet endV = VoucherQueryUtils.queryDataSet((String)select, (QFilter[])new QFilter[]{enddateF, orgF, assId, booktype, endperiodF}, null, (int)-1);
        DataSet endBalance = ACAccountCheckRptFilterPlugin.getBalance(org, filterInfo, balanceSel, ids, filterInfo.getLong(endPeriod), filterInfo.getLong(endPeriod));
        endV = endV.groupBy(new String[]{"assgrpid"}).sum("debitlocal").sum("creditlocal").finish();
        endV = endV.select(new String[]{"debitlocal - creditlocal sumendlocal", "assgrpid"});
        endBalance = endBalance.groupBy(new String[]{"assgrpid"}).sum("endlocal").finish();
        endBalance = endBalance.join(endV, JoinType.LEFT).on("assgrpid", "assgrpid").select(new String[]{"endlocal", "case when sumendlocal == null  then 0 else sumendlocal end sumendlocal"}).finish().select("endlocal-sumendlocal endlocal");
        BigDecimal amount = BigDecimal.ZERO;
        while (startBalance.hasNext()) {
            Row next = startBalance.next();
            amount = amount.add(next.getBigDecimal("beginlocal"));
        }
        BigDecimal endamout = BigDecimal.ZERO;
        while (endBalance.hasNext()) {
            Row next = endBalance.next();
            endamout = endamout.add(next.getBigDecimal("endlocal"));
        }
        if (amount.compareTo(endamout) == 0) {
            return amount;
        }
        return endamout.subtract(amount);
    }

    private static DataSet getBalance(Long orgId, FilterInfo filterInfo, String balanceSel, List<Long> assrgIds, long startPeriodId, long endPeriodId) {
        AccountBookInfo defaultBook;
        long bookTypeId = filterInfo.getLong("booktype");
        if (bookTypeId == 0L && (defaultBook = AccSysUtil.getDefaultBookFromAccSys((Long)((Long)filterInfo.getDynamicObject(ORG).getPkValue()))) != null) {
            bookTypeId = defaultBook.getBookTypeId();
        }
        QueryParam param = new QueryParam();
        param.setOnlyLeafAcctBal(true);
        if (assrgIds != null) {
            param.setAssGrpIds(new HashSet<Long>(assrgIds));
        }
        if (filterInfo.getDynamicObjectCollection("measureunits") != null) {
            DynamicObjectCollection unitsDynColl = filterInfo.getDynamicObjectCollection("measureunits");
            ArrayList<Long> uList = new ArrayList<Long>();
            for (DynamicObject dyn : unitsDynColl) {
                uList.add(dyn.getLong("id"));
            }
            param.setMeasureUnitIds(uList.toArray(new Long[0]));
        }
        long currencyId = 0L;
        String currencyVal = filterInfo.getString("currency");
        if (!"basecurrency".equals(currencyVal) && !"allcurrency".equals(currencyVal)) {
            currencyId = Long.parseLong(filterInfo.getString("currency"));
            param.setCurrencyIds(new Long[]{currencyId});
        }
        BalanceQueryExecutor balanceQueryExecutor = BalanceQueryExecutor.getInstance();
        DataSet balanceData = balanceQueryExecutor.getBalance(balanceSel, new Long[]{orgId}, bookTypeId, filterInfo.getLong("accounttable"), startPeriodId, endPeriodId, param);
        return balanceData;
    }

    private void setColumnVisible(List<AbstractReportColumn> columns, boolean showCurrencyColumn, boolean isBaseCurrency, boolean showQty) {
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                ReportColumn col = (ReportColumn)column;
                String key = col.getFieldKey();
                if (key == null) continue;
                if (key.equals("currencycolumn")) {
                    col.setHide(showCurrencyColumn);
                    continue;
                }
                if (isBaseCurrency && key.endsWith("for")) {
                    col.setHide(isBaseCurrency);
                    continue;
                }
                if (isBaseCurrency && key.equals("endfor")) {
                    col.setCaption(TXT_AMOUNT);
                    continue;
                }
                if (showQty || !Arrays.asList(Qty_List).contains(key)) continue;
                col.setHide(!showQty);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup colGroup = (ReportColumnGroup)column;
            this.setColumnVisible(colGroup.getChildren(), showCurrencyColumn, isBaseCurrency, showQty);
        }
    }

    private Date getLastHour(Date date) {
        if (date != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            c.set(11, 23);
            c.set(12, 59);
            c.set(13, 59);
            date = c.getTime();
            return date;
        }
        return new Date();
    }

    private void setBook(Long bookTypeId) {
        IDataModel model = this.getModel();
        model.setValue("daterange_startdate", (Object)LocalDate.now());
        model.setValue("daterange_enddate", (Object)LocalDate.now());
        Set childOrgSet = new HashSet();
        String str = this.getPageCache().get("_childOrgSet");
        if (str != null) {
            childOrgSet = (Set)GLUtil.fromSerializedString((String)str);
        }
        List bookInfoList = AccSysUtil.getBookFromAccSys(childOrgSet, (long)bookTypeId);
        int size = bookInfoList.size();
        HashSet<Long> periodTypes = new HashSet<Long>(size);
        HashSet<Long> baseCurs = new HashSet<Long>(size);
        HashMap<String, Long> map = new HashMap<String, Long>();
        this.setAccountTable();
        long defaultPeriodType = 0L;
        long defaultBaseCur = 0L;
        HashMap ptSpMap = new HashMap();
        for (int i = 0; i < size; ++i) {
            AccountBookInfo book = (AccountBookInfo)bookInfoList.get(i);
            long periodtype = book.getPeriodTypeId();
            long startperiod = book.getStartPeriodId();
            long baseCurrencyId = book.getBaseCurrencyId();
            GlFormUtil.putMap(ptSpMap, periodtype, startperiod);
            periodTypes.add(periodtype);
            baseCurs.add(baseCurrencyId);
            if (i == 0) {
                defaultPeriodType = periodtype;
                defaultBaseCur = baseCurrencyId;
            }
            long accountbook = (Long)this.getModel().getValue("accounttable_id");
            try (DataSet info = ReciprocalInitUtils.queryIsEndInitReciprocalInit((boolean)false, (Long)book.getOrgId(), (Long)book.getBookTypeId(), (Long)accountbook);){
                while (info.hasNext()) {
                    Row infos = info.next();
                    String str1 = book.getOrgId() + "_" + book.getBookTypeId() + "_" + infos.getString("account");
                    map.put(str1, infos.getLong("endinitperiod"));
                }
                continue;
            }
        }
        this.getPageCache().put("ptSpMap", GLUtil.toSerializedString(ptSpMap));
        model.setValue("account", null);
        BasedataEdit periodTypeEdit = (BasedataEdit)this.getControl("periodtype");
        GlFormUtil.setF7ClickFilter(periodTypeEdit, new QFilter("id", "in", periodTypes));
        this.getView().setVisible(Boolean.valueOf(periodTypes.size() > 1), new String[]{"periodtype"});
        model.setValue("periodtype", (Object)defaultPeriodType);
        model.setValue("currency", (Object)defaultBaseCur);
        Long orgId = (Long)model.getValue("org_id");
        this.setOrgTypeAndRpt(childOrgSet.contains(orgId), baseCurs.size() > 1);
        this.setPeriod("daterange_startdate", null);
        this.setPeriod("daterange_enddate", null);
        this.getPageCache().put("accountmap", SerializationUtils.toJsonString(map));
        this.setDefaultAccount(model, orgId);
    }

    private void setDefaultAccount(IDataModel model, Long orgId) {
        List<QFilter> acctFilters = this.getAccountFilter();
        DynamicObjectCollection acctColl = QueryServiceHelper.query((String)"bd_accountview", (String)"id", (QFilter[])acctFilters.toArray(new QFilter[0]));
        if (acctColl != null) {
            List acctIdSet = acctColl.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            DynamicObject account1 = (DynamicObject)model.getValue("account1");
            if (account1 != null) {
                if (acctIdSet.size() > 0 && !acctIdSet.contains(account1.getLong("id"))) {
                    model.setValue("account1", acctIdSet.get(0));
                } else if (!acctIdSet.contains(account1.getLong("id"))) {
                    model.setValue("account1", null);
                }
            } else if (acctIdSet.size() > 0) {
                model.setValue("account1", acctIdSet.get(0));
            }
        } else {
            model.setValue("account1", null);
        }
        this.setFlexInfo(model);
    }

    private void setOrgTypeAndRpt(boolean isEntityOrg, boolean isMulCur) {
    }

    private void setAccount(Long accountTable) {
        this.getModel().setValue("account1", null);
        if (accountTable == null || accountTable == 0L) {
            return;
        }
        List com = ReportFormUtil.createAcctLevel((Object)accountTable);
        if (com != null && !com.isEmpty()) {
            ComboEdit levelEdit = (ComboEdit)this.getControl("accountlevel");
            levelEdit.setComboItems(com);
            this.getModel().setValue("accountlevel", (Object)((ComboItem)com.get(0)).getValue());
        }
    }

    private void setPeriodFilter(long periodType, Map<Long, Set<Long>> ptSpMap) {
        BasedataEdit startPeriod = (BasedataEdit)this.getControl(startPeriod);
        BasedataEdit endPeriod = (BasedataEdit)this.getControl(endPeriod);
        Set<Long> spSet = ptSpMap.get(periodType);
        Long minPeriod = spSet == null || spSet.size() == 0 ? null : Collections.min(spSet);
        GlFormUtil.setF7ClickFilter(startPeriod, new QFilter("id", ">=", (Object)minPeriod));
        GlFormUtil.setF7ClickFilter(endPeriod, new QFilter("id", ">=", (Object)minPeriod));
        this.getModel().setValue(startPeriod, (Object)minPeriod);
        this.getModel().setValue(endPeriod, (Object)minPeriod);
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        if (evt.getFilter().getDate("daterange_startdate") != null) {
            StringBuilder sb = new StringBuilder();
            FilterInfo filter = evt.getFilter();
            String dateformatStr = InteServiceHelper.getDateFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
            SimpleDateFormat format = new SimpleDateFormat(dateformatStr);
            String dateStr = format.format(evt.getFilter().getDate("daterange_startdate")) + " ~ " + format.format(evt.getFilter().getDate("daterange_enddate"));
            sb.append(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a", (String)"ACAccountCheckRptFilterPlugin_24", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            sb.append(this.getDisplayName(filter.getDynamicObject(ORG)));
            sb.append("; ");
            sb.append(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\uff1a", (String)"ACAccountCheckRptFilterPlugin_25", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            sb.append(dateStr);
            sb.append("; ");
            sb.append(ResManager.loadKDString((String)"\u79d1\u76ee\u8868\uff1a", (String)"ACAccountCheckRptFilterPlugin_26", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            sb.append(this.getDisplayName(filter.getDynamicObject("accounttable")));
            evt.setFormatedFilterString(sb.toString());
        }
    }

    private String getDisplayName(DynamicObject object) {
        return object == null ? "" : object.getString("name");
    }

    private void getOtherOrgInfo(CreateColumnEvent event) {
        FilterInfo filter = event.getQueryParam().getFilter();
        DynamicObject select = (DynamicObject)event.getSelectedObj();
        if (select != null) {
            List flexFilterItems = filter.getFlexFilterItems();
            ArrayList<String> assKeys = new ArrayList<String>(flexFilterItems.size());
            for (FilterItemInfo itemInfo : flexFilterItems) {
                String key = itemInfo.getPropName();
                assKeys.add(key);
            }
            Map<String, String> map = ACAccountCheckRptFilterPlugin.getMap();
            String key = (String)assKeys.get(0);
            String assValue = map.get(bosentity);
            if (assKeys.contains(assValue)) {
                key = assValue;
                DynamicObject value = select.getDynamicObject(key);
                this.acOrg.put(value.getLong("id"), value.getString("name"));
            } else if (map.containsValue(key)) {
                DynamicObject value = select.getDynamicObject(key);
                value.getLong("bizpartner_id");
                DynamicObject internalOrg = QueryServiceHelper.queryOne((String)"bd_bizpartner", (String)"internal_company id,internal_company.name name", (QFilter[])new QFilter("id", "=", value.get("bizpartner_id")).toArray());
                if (internalOrg == null) {
                    return;
                }
                this.acOrg.put(internalOrg.getLong("id"), internalOrg.getString("name"));
            }
            this.getACOrgBal(filter);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"acorgendlocal"});
        }
    }

    private void dealBookeddate(String gridPK, DynamicObjectCollection rowData) {
        DynamicObject endperiodObj;
        Long endPeriod;
        Long rowPeriod;
        int size;
        if ("reportlistap".equals(gridPK) && !rowData.isEmpty() && (size = rowData.size()) > 2 && (rowPeriod = Long.valueOf(((DynamicObject)rowData.get(size - 1)).getLong("period.id"))).equals(endPeriod = (Long)(endperiodObj = (DynamicObject)this.getModel().getValue(endPeriod)).get("id"))) {
            ((DynamicObject)rowData.get(size - 2)).set("datefield", this.getModel().getValue("daterange_enddate"));
            ((DynamicObject)rowData.get(size - 1)).set("datefield", this.getModel().getValue("daterange_enddate"));
        }
    }

    private void clearExport() {
        Object filterItems;
        Iterator iterator = this.getQueryParam().getFilter().getFilterItems().iterator();
        while (iterator.hasNext()) {
            filterItems = (FilterItemInfo)iterator.next();
            if (!Objects.equals(filterItems.getPropName(), EXPORT_EXCEL)) continue;
            iterator.remove();
        }
        filterItems = this.getQueryParam().getFilter().getFilterItems(EXPORT_EXCEL);
        filterItems.clear();
        IReportCache reportCache = ReportCacheManager.getInstance().getCache();
        reportCache.setReportQueryParam(this.getView().getPageId(), this.getQueryParam());
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        int count = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] rows = IntStream.range(0, count).toArray();
        entryGrid.selectRows(rows, 0);
    }
}

