/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.IFrameMessage;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.control.IFrame;
import kd.bos.form.field.BasedataEdit;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.report.GLRptTemplatePlugin;
import kd.fi.gl.util.GlFormUtil;

public class AccBalQingFormRpt
extends GLRptTemplatePlugin {
    private static final String CACHE_QUERY_PARAM = "queryparam";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ASS_PROP = "assprop";
    private static final String QINGANALYSIS = "qinganalysisap";

    @Override
    protected BasedataEdit getOrgEdit() {
        return (BasedataEdit)this.getControl("orgs");
    }

    @Override
    protected List<Long> getOrgValue() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
        return orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    @Override
    protected void setDefaultOrg(Long orgId) {
        if (orgId == null || orgId == 0L) {
            this.getModel().setValue("orgs", null);
        } else {
            this.getModel().setValue("orgs", (Object)new Long[]{orgId});
        }
    }

    @Override
    protected List<Long> getFilterOrg(FilterInfo filterInfo) {
        List value;
        ArrayList<Long> result = new ArrayList<Long>();
        FilterItemInfo itemInfo = filterInfo.getFilterItem("orgs");
        if (itemInfo != null && (value = (List)itemInfo.getValue()) != null) {
            for (DynamicObject dyn : value) {
                result.add(dyn.getLong("id"));
            }
        }
        return result;
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        boolean isSingleOrgManageMode;
        String formatedFilterString = evt.getFormatedFilterString();
        FilterInfo filter = evt.getFilter();
        if (Objects.equals(this.getPageCache().get("enableMulCur"), "true")) {
            formatedFilterString = GlFormUtil.getMulCurFormatedFilterString(filter.getString("mulcur"), formatedFilterString);
            evt.setFormatedFilterString(formatedFilterString);
        }
        if (isSingleOrgManageMode = SingleOrgContextHelper.isSingleOrgManageMode()) {
            return;
        }
        Long parentOrg = this.getParentOrg();
        String name = "";
        if (parentOrg != null && parentOrg != 0L) {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)parentOrg, (String)"bos_org");
            name = org.getString("name");
        }
        String result = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a%1$s; %2$s\u3002", (String)"AccBalQingFormRpt_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), name, formatedFilterString);
        evt.setFormatedFilterString(result);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{QINGANALYSIS});
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{QINGANALYSIS});
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList<DynamicObject> results = new ArrayList<DynamicObject>(entryEntity.size());
        for (DynamicObject dyn : entryEntity) {
            results.add(dyn);
        }
        filterInfo.addFilterItem(ASS_PROP, results);
        this.getPageCache().put(CACHE_QUERY_PARAM, SerializationUtils.serializeToBase64((Object)queryParam));
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.refetchQingData();
    }

    private void refetchQingData() {
        IFrameMessage message = new IFrameMessage();
        message.setType("reExtractData");
        IFrame frame = (IFrame)this.getView().getControl(QINGANALYSIS);
        frame.postMessage(message);
    }
}

