/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.report.ReportFormUtil;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.PermissonType;

public class AccountRefBalanceFormPlugin
extends AbstractReportFormPlugin {
    private static final String ROWTYPE = "rowtype";
    private static final String _ID = ".id";
    private static final String SHOWASSIST = "showassist";
    private static final String DC_DEBIT = "1";
    private static final String ID = "id";

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo.getLong("effectiveperiod") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"AccountRefBalanceFormPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        Long preAcctId = 0L;
        Long preAssgrpId = 0L;
        Long preCurrencyId = 0L;
        FilterInfo filterInfo = queryParam.getFilter();
        boolean isShowAssist = filterInfo.getBoolean(SHOWASSIST);
        Long orgId = filterInfo.getLong("org");
        Boolean isShowByDC = this.isShowByAccDc(orgId);
        BigDecimal totalOldDebit = BigDecimal.ZERO;
        BigDecimal totalOldCredit = BigDecimal.ZERO;
        BigDecimal totalNewDebit = BigDecimal.ZERO;
        BigDecimal totalNewCredit = BigDecimal.ZERO;
        BigDecimal totalDiff = BigDecimal.ZERO;
        for (DynamicObject row : rowData) {
            String rowType = row.getString(ROWTYPE);
            if ("0".equals(rowType)) {
                boolean isEql;
                this.setAmountByDC(isShowByDC, row, "oldaccountid", "olddebitfor", "oldcreditfor");
                this.setAmountByDC(isShowByDC, row, "oldaccountid", "olddebitlocal", "oldcreditlocal");
                Long newAccountId = row.getLong("newaccountid.id");
                Long newAssgrpId = row.getLong("newassgrpid.id");
                Long currencyId = row.getLong("currencyfor.id");
                boolean bl = isEql = preAcctId.equals(newAccountId) && preCurrencyId.equals(currencyId);
                if (isShowAssist) {
                    boolean bl2 = isEql = isEql && preAssgrpId.equals(newAssgrpId);
                }
                if (isEql) {
                    row.set("newaccountid", null);
                    row.set("newaccountname", null);
                    row.set("newassgrpid", null);
                    row.set("newdebitfor", null);
                    row.set("newcreditfor", null);
                    row.set("newdebitlocal", null);
                    row.set("newcreditlocal", null);
                    row.set("dc", null);
                    row.set("diffamountfor", null);
                    row.set("diffamountlocal", null);
                } else {
                    preAcctId = newAccountId;
                    preAssgrpId = newAssgrpId;
                    preCurrencyId = currencyId;
                    this.setAmountByDC(isShowByDC, row, "newaccountid", "newdebitfor", "newcreditfor");
                    this.setAmountByDC(isShowByDC, row, "newaccountid", "newdebitlocal", "newcreditlocal");
                }
                totalOldDebit = totalOldDebit.add(row.getBigDecimal("olddebitlocal"));
                totalOldCredit = totalOldCredit.add(row.getBigDecimal("oldcreditlocal"));
                totalNewDebit = totalNewDebit.add(row.getBigDecimal("newdebitlocal"));
                totalNewCredit = totalNewCredit.add(row.getBigDecimal("newcreditlocal"));
                totalDiff = totalDiff.add(row.getBigDecimal("diffamountlocal"));
                continue;
            }
            row.set("olddebitlocal", (Object)totalOldDebit);
            row.set("oldcreditlocal", (Object)totalOldCredit);
            row.set("newdebitlocal", (Object)totalNewDebit);
            row.set("newcreditlocal", (Object)totalNewCredit);
            row.set("diffamountlocal", (Object)totalDiff);
            if (totalDiff.compareTo(BigDecimal.ZERO) > 0) {
                row.set("dc", (Object)DC_DEBIT);
                continue;
            }
            if (totalDiff.compareTo(BigDecimal.ZERO) < 0) {
                row.set("dc", (Object)"-1");
                continue;
            }
            row.set("dc", (Object)"0");
        }
    }

    private void setAmountByDC(Boolean isShowByDC, DynamicObject row, String accountField, String debitField, String creditField) {
        if (!isShowByDC.booleanValue()) {
            return;
        }
        DynamicObject account = row.getDynamicObject(accountField);
        if (account == null) {
            return;
        }
        String dc = account.getString("dc");
        BigDecimal debitAmt = row.getBigDecimal(debitField);
        BigDecimal creditAmt = row.getBigDecimal(creditField);
        if (DC_DEBIT.equals(dc)) {
            if (creditAmt.compareTo(BigDecimal.ZERO) > 0) {
                row.set(debitField, (Object)creditAmt.negate());
                row.set(creditField, (Object)0);
            }
        } else if (debitAmt.compareTo(BigDecimal.ZERO) > 0) {
            row.set(debitField, (Object)0);
            row.set(creditField, (Object)debitAmt.negate());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setBook();
        this.initCurrency();
    }

    private List<ComboItem> getCurrencyItems() {
        ArrayList<ComboItem> currColl = new ArrayList<ComboItem>();
        ComboItem allCur = new ComboItem();
        allCur.setValue("allcurrency");
        allCur.setCaption(AccountRefBalanceFormPlugin.getAllCurrency());
        currColl.add(allCur);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_currency", (String)"id, name", null);
        for (DynamicObject obj : coll) {
            ComboItem item = new ComboItem();
            item.setValue(obj.getString(ID));
            item.setCaption(new LocaleString(obj.getString("name")));
            currColl.add(item);
        }
        return currColl;
    }

    private static LocaleString getAllCurrency() {
        return new LocaleString(ResManager.loadKDString((String)"\u6240\u6709\u5e01\u79cd", (String)"AccountRefBalanceFormPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    private void initCurrency() {
        ComboEdit currency = (ComboEdit)this.getControl("currency");
        currency.setComboItems(this.getCurrencyItems());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        if (value == null) {
            return;
        }
        switch (propertyName) {
            case "org": 
            case "booktype": {
                this.setBook();
                break;
            }
            case "effectiveperiod": {
                long btId;
                List tableIds;
                IDataModel model = this.getModel();
                long endPeriod = ((DynamicObject)value).getLong(ID);
                ArrayList<Long> orgIds = new ArrayList<Long>();
                Long orgId = (Long)this.getModel().getValue("org_id");
                if (orgId != null && orgId != 0L) {
                    orgIds.add(orgId);
                }
                if ((tableIds = ReportFormUtil.getVerAcctTable(orgIds, (long)(btId = ((Long)model.getValue("booktype_id")).longValue()), (long)endPeriod)).isEmpty()) break;
                BasedataEdit accountTableEdit = (BasedataEdit)this.getControl("accounttable");
                GlFormUtil.setF7ClickFilter(accountTableEdit, new QFilter(ID, "in", (Object)tableIds));
                model.setValue("accounttable", tableIds.get(0));
            }
        }
    }

    private void setBook() {
        this.initPeriod();
    }

    private void initPeriod() {
        Long orgId = (Long)this.getModel().getValue("org_id");
        Long bookTypeId = (Long)this.getModel().getValue("booktype_id");
        Set periodIds = BalanceTransferUtils.queryEffectivePeriod((Long)orgId, (Long)bookTypeId);
        BasedataEdit periodEdit = (BasedataEdit)this.getControl("effectiveperiod");
        periodEdit.setQFilter(new QFilter(ID, "in", (Object)periodIds));
        if (periodIds.isEmpty()) {
            this.getModel().setValue("effectiveperiod", null);
        } else {
            this.getModel().setValue("effectiveperiod", Collections.max(periodIds));
        }
    }

    private Boolean isShowByAccDc(Long orgId) {
        Boolean bIsShowByAccountDC = (Boolean)GLUtil.getSystemParam((String)"showbyaccountdc", (Long)orgId);
        if (bIsShowByAccountDC == null) {
            bIsShowByAccountDC = Boolean.FALSE;
        }
        return bIsShowByAccountDC;
    }

    public void afterSetModelValue(DynamicObject scheme) {
        IDataModel model = this.getModel();
        ArrayList<Long> newOrgs = new ArrayList<Long>();
        Set<Long> allPermOrgs = this.getPermOrgs();
        if (model.getProperty("orgs") != null) {
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
            if (!CollectionUtils.isEmpty((Collection)orgs)) {
                orgs.stream().map(org -> org.getLong("fbasedataid.id")).forEach(newOrgs::add);
                boolean allLegalOrg = allPermOrgs.containsAll(newOrgs);
                if (!allLegalOrg) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u65b9\u6848\u7ec4\u7ec7\u7684\u67e5\u8be2\u6743\u9650\uff0c\u65e0\u6cd5\u52a0\u8f7d\u65b9\u6848\u3002", (String)"GLRptTemplatePlugin_100", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                    model.setValue("orgs", null);
                }
            }
        } else {
            Long orgId = (Long)model.getValue("org_id");
            if (orgId == 0L) {
                return;
            }
            newOrgs.add(orgId);
            boolean allLegalOrg = allPermOrgs.containsAll(newOrgs);
            if (!allLegalOrg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u65b9\u6848\u7ec4\u7ec7\u7684\u67e5\u8be2\u6743\u9650\uff0c\u65e0\u6cd5\u52a0\u8f7d\u65b9\u6848\u3002", (String)"GLRptTemplatePlugin_100", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                model.setValue("org", null);
            }
        }
    }

    protected Set<Long> getPermOrgs() {
        Set permOrgs;
        String str = this.getPageCache().get("_permOrgList");
        if (str != null) {
            permOrgs = (Set)GLUtil.fromSerializedString((String)str);
        } else {
            Boolean isSupVir = (Boolean)this.getModel().getValue("issupvir");
            permOrgs = AccSysUtil.getAcctOrgPkList2((String)this.getView().getEntityId(), (boolean)isSupVir, (PermissonType)PermissonType.VIEW);
        }
        return new HashSet<Long>(permOrgs);
    }
}

