/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.report.ReportPrintHelper;

public class AccountSumPrint
extends AbstractPrintServicePlugin {
    private static final String[] rowDataStringFieldKeys = new String[]{"number.number", "number.name", "curfor.name", "curlocal"};
    private static final String[] rowDataAmountFieldKeys = new String[]{"debit", "credit"};
    private static final String[] headBaseDataFieldKeys = new String[]{"org", "booktype", "startperiod", "endperiod"};
    private static final String CURRENCY_HEAD = "currency";
    private static final String ATTACHNUM = "attachnum";
    private static final String VOUCHERNUM = "vouchernum";
    private static final String SHOWBILLNO = "showbillno";
    private FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        super.customPrintDataEntities(e);
        ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>();
        String pageId = e.getPageId();
        ReportListModel listModel = ReportPrintHelper.getListModel(pageId);
        if (listModel == null) {
            return;
        }
        ReportQueryParam param = listModel.getReportQueryParam();
        FilterInfo filterInfo = param.getFilter();
        if (e.isMainDs()) {
            DynamicObjectType customDT = new DynamicObjectType();
            customDT.registerProperty("id", String.class, (Object)"", false);
            DynamicObject printDyn = new DynamicObject(customDT);
            printDyn.set("id", (Object)"1");
            dyns.add(printDyn);
            e.setDataEntities(dyns);
        } else if ("head".equals(e.getDataSourceName())) {
            DynamicObjectType customDT = new DynamicObjectType();
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(e, headBaseDataFieldKeys);
            ReportPrintHelper.registerStringProperty(customDT, headBaseDataFields);
            ReportPrintHelper.registerStringProperty(customDT, CURRENCY_HEAD, VOUCHERNUM, ATTACHNUM, SHOWBILLNO);
            DynamicObject printDyn = new DynamicObject(customDT);
            ReportPrintHelper.handleBaseDataFilterInfo(filterInfo, printDyn, headBaseDataFields);
            ReportPrintHelper.handleCurrencyNameById(filterInfo, printDyn, CURRENCY_HEAD);
            String id = RequestContext.get().getUserId();
            String vouchernum = new DistributeCache(CacheModule.report).get(String.format("%s_%s", "VoucherSummaryQueryRpt_count", id));
            String attachnum = new DistributeCache(CacheModule.report).get(String.format("%s_%s", "VoucherSummaryQueryRpt_attachNum", id));
            String showbillno = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7\uff1a%s", (String)"VoucherSummaryFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), new DistributeCache(CacheModule.report).get(String.format("%s_%s", "VoucherSummaryQueryRpt_showBillno", id)));
            printDyn.set(VOUCHERNUM, (Object)vouchernum);
            printDyn.set(ATTACHNUM, (Object)attachnum);
            printDyn.set(SHOWBILLNO, (Object)showbillno);
            dyns.add(printDyn);
            e.setDataEntities(dyns);
        } else {
            int count = listModel.getRowCount();
            DynamicObjectCollection ds = listModel.getRowData(0, count);
            if (ds == null || ds.isEmpty()) {
                return;
            }
            DynamicObjectType customDt = new DynamicObjectType("reportlist");
            String[] rowDataStringFields = ReportPrintHelper.getExistFileds(e, rowDataStringFieldKeys);
            String[] rowDataAmountFields = ReportPrintHelper.getExistFileds(e, rowDataAmountFieldKeys);
            ReportPrintHelper.registerStringProperty(customDt, new String[][]{rowDataAmountFields, rowDataStringFields});
            int i = 1;
            for (DynamicObject rowData : ds) {
                DynamicObject printRow = new DynamicObject(customDt);
                ReportPrintHelper.handleStringFields(rowData, printRow, rowDataStringFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, "currencyid", (boolean)Boolean.FALSE, rowDataAmountFieldKeys);
                if (i == count) {
                    printRow.set("number.number", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"DailyFormRptPrint_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
                dyns.add(printRow);
                ++i;
            }
            e.setDataEntities(dyns);
        }
    }
}

