/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.util.GLUtil;

public class AcctBalQingAssistFilterPlugin
extends AbstractReportFormPlugin {
    private static final String SELECTED_FIELDS = "selectedfields";
    private static final String SHOW_ASSIST = "showassist";
    private static final String REMOVEBTN = "removebtn";
    private static final String ADDNEWBTN = "addnewbtn";
    private static final String VALUE_TYPE = "valuetype";
    private static final String FLEX_FIELD = "flexfield";
    private static final String VALUE_SOURCE = "valuesource";
    private static final String GL_ASSIST_PROP_FORM = "gl_assist_prop_form";
    private static final String ASSIST_PROP_CALLBACK = "assistpropcallback";
    private static final String ASS_PROP_NAME = "assistpropname";
    private static final String ASS_PROP_FIELD = "assistpropfield";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FIELD_NAME = "fieldname";

    protected String[] getAssistValueType() {
        return new String[]{"1", "2"};
    }

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{ENTRY_ENTITY, FIELD_NAME, ASS_PROP_NAME});
        this.addItemClickListeners(new String[]{"asstopr"});
        BasedataEdit acc = (BasedataEdit)this.getControl(FIELD_NAME);
        acc.addBeforeF7SelectListener(e -> {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            ArrayList<String> ffList = new ArrayList<String>();
            DynamicObjectCollection dync = this.getModel().getEntryEntity(ENTRY_ENTITY);
            for (DynamicObject dyn : dync) {
                DynamicObject fieldname = dyn.getDynamicObject(FIELD_NAME);
                if (fieldname == null) continue;
                String flexfield = fieldname.getString(FLEX_FIELD);
                ffList.add(flexfield);
            }
            QFilter f = new QFilter(VALUE_TYPE, "in", (Object)this.getAssistValueType());
            qFilters.add(f);
            f = new QFilter(FLEX_FIELD, "not in", ffList);
            qFilters.add(f);
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            filterParam.getQFilters().addAll(qFilters);
        });
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "addnewbtn": {
                this.getModel().createNewEntryRow(ENTRY_ENTITY);
                break;
            }
            case "removebtn": {
                IDataModel model = this.getModel();
                int rowIndex = model.getEntryCurrentRowIndex(ENTRY_ENTITY);
                model.deleteEntryRow(ENTRY_ENTITY, rowIndex);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String Key2 = control.getKey();
        if (ASS_PROP_NAME.equals(Key2)) {
            int curIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            DynamicObject dyAssist = (DynamicObject)this.getModel().getValue(FIELD_NAME, curIndex);
            if (dyAssist == null) {
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(GL_ASSIST_PROP_FORM);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam(VALUE_SOURCE, (Object)dyAssist.getString("valuesource.number"));
            String fields = (String)this.getModel().getValue(ASS_PROP_FIELD, curIndex);
            if (!StringUtils.isEmpty((String)fields)) {
                parameter.setCustomParam(SELECTED_FIELDS, (Object)fields);
            }
            parameter.setCustomParam(VALUE_SOURCE, (Object)dyAssist.getString("valuesource.number"));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ASSIST_PROP_CALLBACK));
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object result = closedCallBackEvent.getReturnData();
        if (result == null) {
            return;
        }
        if (ASSIST_PROP_CALLBACK.equals(closedCallBackEvent.getActionId())) {
            int curIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            Map map = (Map)result;
            String names = String.join((CharSequence)",", map.values());
            String fieldValues = GLUtil.toSerializedString((Object)map);
            this.setAssistPropValue(names, fieldValues, curIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData data = e.getChangeSet()[0];
        String propertyName = e.getProperty().getName();
        Object newValue = data.getNewValue();
        if (newValue == null) {
            return;
        }
        switch (propertyName) {
            case "account": {
                DynamicObjectCollection accCols = (DynamicObjectCollection)newValue;
                if (accCols.isEmpty()) break;
                this.setFlexField(accCols);
                break;
            }
            case "fieldname": {
                this.setAssistPropValue(null, null, data.getRowIndex());
                break;
            }
            case "showassist": {
                if (!((Boolean)newValue).booleanValue()) {
                    this.getModel().deleteEntryData(ENTRY_ENTITY);
                    break;
                }
                this.getModel().createNewEntryRow(ENTRY_ENTITY);
                break;
            }
            case "assistpropname": {
                if (newValue != null && !StringUtils.isEmpty((String)newValue.toString())) break;
                this.getModel().setValue(ASS_PROP_FIELD, null, data.getRowIndex());
            }
        }
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        super.setOtherEntryFilter(filterInfo);
        HashMap otherEntryFilter = new HashMap();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList<DynamicObject> saveEntrys = new ArrayList<DynamicObject>();
        for (DynamicObject entry : entryEntity) {
            saveEntrys.add(entry);
        }
        otherEntryFilter.put(ENTRY_ENTITY, saveEntrys);
        filterInfo.setOtherEntryFilter(otherEntryFilter);
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        DynamicObjectCollection assistProp = scheme.getDynamicObjectCollection(ENTRY_ENTITY);
        if (assistProp.size() > 0) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData(ENTRY_ENTITY);
            model.batchCreateNewEntryRow(ENTRY_ENTITY, assistProp.size());
            int i = 0;
            for (DynamicObject entry : assistProp) {
                model.setValue(FIELD_NAME, entry.get(FIELD_NAME), i);
                model.setValue(ASS_PROP_FIELD, entry.get(ASS_PROP_FIELD), i);
                model.setValue(ASS_PROP_NAME, entry.get(ASS_PROP_NAME), i);
                ++i;
            }
            model.endInit();
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    private void setAssistPropValue(String propName, String fieldName, int rowIndex) {
        this.getModel().setValue(ASS_PROP_NAME, (Object)propName, rowIndex);
        this.getModel().setValue(ASS_PROP_FIELD, (Object)fieldName, rowIndex);
    }

    private void setFlexField(DynamicObjectCollection accounts) {
        ArrayList<Set<Long>> assList = new ArrayList<Set<Long>>();
        for (DynamicObject account : accounts) {
            long id = account.getLong("fbasedataid_id");
            Set<Long> assistIds = this.getAssistByAcc(id);
            assList.add(assistIds);
        }
        Set<Long> assCom = "gl_rpt_assistactbalance".equals(this.getView().getEntityId()) || "gl_reciprocal_acct_report".equals(this.getView().getEntityId()) || "gl_rpt_agingschedule".equals(this.getView().getEntityId()) ? this.getUnion(assList) : this.getIntersection(assList);
        this.setEntryEntity(assCom);
    }

    protected void setEntryEntity(Set<Long> assCom) {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(ENTRY_ENTITY);
        ArrayList<Long> list = new ArrayList<Long>(assCom);
        for (int i = 0; i < list.size(); ++i) {
            dataModel.createNewEntryRow(ENTRY_ENTITY);
            dataModel.setValue(FIELD_NAME, (Object)list.get(i), i);
        }
    }

    private Set<Long> getIntersection(List<Set<Long>> assList) {
        Set<Long> result = new LinkedHashSet<Long>();
        if (assList.size() == 0) {
            return result;
        }
        result = assList.get(0);
        for (int i = 1; i < assList.size(); ++i) {
            result.retainAll((Collection)assList.get(i));
        }
        return result;
    }

    private Set<Long> getUnion(List<Set<Long>> assList) {
        LinkedHashSet<Long> result = new LinkedHashSet<Long>();
        for (Set<Long> ass : assList) {
            result.addAll(ass);
        }
        return result;
    }

    protected Set<Long> getAssistByAcc(long accId) {
        LinkedHashSet<Long> result = new LinkedHashSet<Long>();
        QFilter accFilter = new QFilter("id", "=", (Object)accId);
        QFilter typeFilter = new QFilter("checkitementry.asstactitem.valuetype", "in", (Object)this.getAssistValueType());
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bd_accountview", (String)"checkitementry.asstactitem assist", (QFilter[])new QFilter[]{accFilter, typeFilter});
        for (DynamicObject col : cols) {
            result.add(col.getLong("assist"));
        }
        return result;
    }
}

