/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.report.NavToSubLedgerRpt;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.VoucherUtil;

public class AdjustVoucherRptFormPlugin
extends AbstractReportFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit account = (BasedataEdit)this.getControl("account");
        account.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            QFilter qf = new QFilter("ischangecurrency", "=", (Object)"1");
            param.getListFilterParameter().getQFilters().add(qf);
        });
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(evt -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
            DynamicObject rowData = control.getReportModel().getRowData(rowIndex);
            String name = evt.getFieldName();
            FilterInfo curinfo = this.getQueryParam().getFilter();
            DynamicObject acct = rowData.getDynamicObject("accountid");
            long masterid = acct.getLong("masterid");
            switch (name) {
                case "accountid": {
                    curinfo.getFilterItem("account").setValue((Object)masterid);
                    FilterItemInfo filterItem = curinfo.getFilterItem("accountlevel");
                    if (filterItem != null && acct.containsProperty("level")) {
                        filterItem.setValue((Object)acct.getInt("level"));
                    }
                    new NavToSubLedgerRpt.SLBuilder(this.getQueryParam(), (IFormView)this.getView()).accountId(Long.valueOf(masterid)).build().apply();
                    break;
                }
                case "assgrp": {
                    DynamicObject item = rowData.getDynamicObject("assgrp");
                    curinfo.getFilterItem("account").setValue((Object)acct.getLong("id"));
                    String value = item.getString("value");
                    JSONObject jsonObject = JSONObject.parseObject((String)value);
                    ArrayList flexfilters = new ArrayList(jsonObject.size());
                    jsonObject.forEach((key, value1) -> flexfilters.add(new FilterItemInfo(key, value1, "=")));
                    curinfo.setFlexFilterItems(flexfilters);
                    this.navToRpt(this.getQueryParam().getFilter(), "gl_rpt_subsidiaryledger");
                    break;
                }
                case "vouchernumber": {
                    long vid = rowData.getLong("vid");
                    if (vid == 0L) break;
                    this.navToVoucher(vid);
                    break;
                }
            }
        });
    }

    private void navToRpt(FilterInfo curinfo, String formid) {
        ReportShowParameter report = new ReportShowParameter();
        report.setFormId(formid);
        report.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryParam = new ReportQueryParam();
        if ("gl_rpt_subledger".equals(formid)) {
            curinfo.addFilterItem("searchtype", (Object)"1");
        }
        queryParam.setFilter(curinfo);
        report.setQueryParam(queryParam);
        this.getView().showForm((FormShowParameter)report);
    }

    private void navToVoucher(long vid) {
        VoucherUtil.hyperVoucher(vid, (IFormView)this.getView());
    }

    public void afterCreateNewData(EventObject e) {
        this.initCurrency();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"accountlevel"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"accountlevel"});
        this.setDisplayTotal(false);
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        String formatedFilterString = evt.getFormatedFilterString();
        FilterInfo filter = evt.getFilter();
        if (Objects.equals(this.getPageCache().get("enableMulCur"), "true")) {
            formatedFilterString = GlFormUtil.getMulCurFormatedFilterString(filter.getString("mulcur"), formatedFilterString);
            evt.setFormatedFilterString(formatedFilterString);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        this.setDisplayTotal(true);
        FilterInfo filterInfo = queryParam.getFilter();
        long orgId = filterInfo.getLong("org");
        queryParam.getCustomParam().put("flexorgidfield", "flexorgid");
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String id = RequestContext.get().getRequestId();
        String totalRevenue = new DistributeCache(CacheModule.report).get(String.format("%s_%s", "AdjustVoucherRptFormPlugin_total_revenue", id));
        this.getModel().setValue("total_revenue", (Object)new BigDecimal(totalRevenue));
        String totalLoss = new DistributeCache(CacheModule.report).get(String.format("%s_%s", "AdjustVoucherRptFormPlugin_total_loss", id));
        this.getModel().setValue("total_loss", (Object)new BigDecimal(totalLoss));
        String total1 = new DistributeCache(CacheModule.report).get(String.format("%s_%s", "AdjustVoucherRptFormPlugin_total", id));
        this.getModel().setValue("total", (Object)new BigDecimal(total1));
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        long orgId = filterInfo.getLong("org");
        long bookTypeId = filterInfo.getLong("booktype");
        String currency = filterInfo.getString("currency");
        long basecurrencyId = 0L;
        long exchangeTableID = 0L;
        DynamicObject endPeriodDyn = (DynamicObject)this.getModel().getValue("endperiod");
        Date endDate = endPeriodDyn.getDate("enddate");
        if (currency != null && orgId != 0L && bookTypeId != 0L) {
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
            basecurrencyId = bookInfo.getBaseCurrencyId();
            exchangeTableID = bookInfo.getExrateTableId();
        }
        HashMap<Long, Integer> oIdToPMap = new HashMap<Long, Integer>();
        oIdToPMap.put(0L, 1);
        boolean isAllCurrency = "allcurrency".equals(currency);
        if (isAllCurrency) {
            for (DynamicObject row : rowData) {
                long rowCurrencyId = row.getLong("forcur_id");
                if (oIdToPMap.get(rowCurrencyId) == null) {
                    this.getPrecision(exchangeTableID, basecurrencyId, rowCurrencyId, endDate, oIdToPMap);
                }
                int precision = oIdToPMap.get(rowCurrencyId) == null ? 8 : (Integer)oIdToPMap.get(rowCurrencyId);
                BigDecimal beforeRate = row.getBigDecimal("beforeadjustrate");
                row.set("beforeadjustrate", (Object)beforeRate.setScale(precision, 4));
                row.set("adjustrate", (Object)row.getBigDecimal("adjustrate").setScale(precision, 4));
            }
        } else {
            long currencyId = basecurrencyId;
            if (!"basecurrency".equals(currency)) {
                currencyId = Long.parseLong(currency);
            }
            if (oIdToPMap.get(currencyId) == null) {
                this.getPrecision(exchangeTableID, basecurrencyId, currencyId, endDate, oIdToPMap);
            }
            int precision = oIdToPMap.get(currencyId) == null ? 8 : (Integer)oIdToPMap.get(currencyId);
            for (DynamicObject row : rowData) {
                BigDecimal beforeRate = row.getBigDecimal("beforeadjustrate");
                row.set("beforeadjustrate", (Object)beforeRate.setScale(precision, 4));
                row.set("adjustrate", (Object)row.getBigDecimal("adjustrate").setScale(precision, 4));
            }
        }
    }

    private void getPrecision(long exchangeTableID, long basecurrencyId, long currencyId, Date date, Map<Long, Integer> oIdToPMap) {
        int precision = GLUtil.getRatePrecision((Long)exchangeTableID, (Long)currencyId, (Long)basecurrencyId, (Date)date);
        oIdToPMap.put(currencyId, precision);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        if (value == null) {
            return;
        }
        if ("org".equals(propertyName) || "booktype".equals(propertyName)) {
            this.getModel().setValue("currency", (Object)"allcurrency");
        }
    }

    private void initCurrency() {
        ComboEdit currency = (ComboEdit)this.getControl("currency");
        currency.setComboItems(this.getCurrencyItems());
        this.getModel().setValue("currency", (Object)"allcurrency");
    }

    private static LocaleString getALL_CURRENCY() {
        return new LocaleString(ResManager.loadKDString((String)"\u6240\u6709\u5e01\u79cd", (String)"AdjustVoucherRptFormPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    private List<ComboItem> getCurrencyItems() {
        ArrayList<ComboItem> currColl = new ArrayList<ComboItem>();
        ComboItem allCur = new ComboItem();
        allCur.setValue("allcurrency");
        allCur.setCaption(AdjustVoucherRptFormPlugin.getALL_CURRENCY());
        currColl.add(allCur);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_currency", (String)"id, name", null);
        for (DynamicObject obj : coll) {
            ComboItem item = new ComboItem();
            item.setValue(obj.getString("id"));
            item.setCaption(new LocaleString(obj.getString("name")));
            currColl.add(item);
        }
        return currColl;
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List columns = event.getColumns();
        for (AbstractReportColumn column : columns) {
            ReportColumn col;
            String key;
            if (!(column instanceof ReportColumn) || !(key = (col = (ReportColumn)column).getFieldKey()).equals("forcur") || !"allcurrency".equals(this.getQueryParam().getFilter().getValue("currency"))) continue;
            col.setHide(false);
        }
    }

    private void setDisplayTotal(boolean isDisplay) {
        this.getView().setVisible(Boolean.valueOf(isDisplay), new String[]{"totallap"});
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        super.preProcessExportData(exportColumns, data, numberFormatProvider);
        if (!data.isEmpty()) {
            String revenue = ResManager.loadKDString((String)"\u6536\u76ca\u5408\u8ba1\uff1a", (String)"AdjustVoucherRptFormPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            String loss = ResManager.loadKDString((String)"\u635f\u5931\u5408\u8ba1\uff1a", (String)"AdjustVoucherRptFormPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            String total = ResManager.loadKDString((String)"\u8c03\u6c47\u91d1\u989d\u5408\u8ba1\uff1a", (String)"AdjustVoucherRptFormPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            DynamicObject row1 = new DynamicObject(data.getDynamicObjectType());
            DynamicObject row2 = new DynamicObject(data.getDynamicObjectType());
            DynamicObject row3 = new DynamicObject(data.getDynamicObjectType());
            row1.set("name", (Object)revenue);
            row1.set("vouchernumber", (Object)((BigDecimal)this.getModel().getValue("total_revenue")).setScale(4, RoundingMode.HALF_UP));
            row2.set("name", (Object)loss);
            row2.set("vouchernumber", (Object)((BigDecimal)this.getModel().getValue("total_loss")).setScale(4, RoundingMode.HALF_UP));
            row3.set("name", (Object)total);
            row3.set("vouchernumber", (Object)((BigDecimal)this.getModel().getValue("total")).setScale(4, RoundingMode.HALF_UP));
            data.add((Object)row1);
            data.add((Object)row2);
            data.add((Object)row3);
        }
    }
}

