/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.report.GLRptTemplatePlugin;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.SubsiDiaryHelper;

public class AssistRptFilterPlugin
extends AbstractReportFormPlugin {
    private static Log logger = LogFactory.getLog(AssistRptFilterPlugin.class);
    protected static final String GROUP_STANDARD = "groupstandard";
    protected static final String SHOW_TYPE = "showtype";
    protected static final String ASSIST_LEVEL = "asstlevel";
    protected static final String VALUE_TXT = "textinput";
    protected static final List<String> grpEntity = new ArrayList<String>(3);

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType type;
        try {
            type = e.getNewEntityType() == null ? (MainEntityType)e.getOriginalEntityType().clone() : e.getNewEntityType();
        }
        catch (CloneNotSupportedException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
        EntryProp entry = (EntryProp)type.getProperty("entryentity");
        MulBasedataProp prop = (MulBasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty("value");
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("entryentity");
        DynamicObject assisType = (DynamicObject)model.getValue("fieldname", rowIndex);
        if (assisType == null) {
            return;
        }
        DynamicObject valueSource = null;
        String entityId = null;
        String valuetype = assisType.getString("valuetype");
        if (AssistValueType.isBaseData((String)valuetype)) {
            valueSource = assisType.getDynamicObject("valuesource");
            entityId = valueSource.getString("id");
        } else if (AssistValueType.isAssistData((String)valuetype)) {
            valueSource = assisType.getDynamicObject("assistanttype");
            entityId = "bos_assistantdata_detail";
        }
        if (valueSource != null) {
            prop.setBaseEntityId(entityId);
            IDataEntityType entryType = prop.getItemType();
            BasedataProp baseProp = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
            baseProp.setBaseEntityId(entityId);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            baseProp.setComplexType((IDataEntityType)dataEntityType);
            Object bd_idProp = (PKFieldProp)prop.getItemType().getProperties().get((Object)"fbasedataid_id");
            entryType.getProperties().remove(bd_idProp);
            bd_idProp = dataEntityType.getPrimaryKey() instanceof VarcharProp ? new VarcharProp() : new LongProp();
            bd_idProp.setPrimaryKey(false);
            bd_idProp.setName("fbasedataid_id");
            baseProp.setRefIdProp((IDataEntityProperty)bd_idProp);
            ((DynamicObjectType)entryType).addProperty((DynamicProperty)bd_idProp);
        }
        e.setNewEntityType(type);
    }

    protected String[] getAssistValueType() {
        return new String[]{"1", "2"};
    }

    public void registerListener(EventObject eventObject) {
        IDataModel model = this.getModel();
        List<String> comassistList = this.getComassistFieldByPageCache();
        if (!comassistList.isEmpty()) {
            this.addClickListeners(comassistList.toArray(new String[comassistList.size()]));
            this.comassistF7(comassistList);
        }
        this.addClickListeners(new String[]{"entryentity", "fieldname", "value"});
        this.addItemClickListeners(new String[]{"asstopr"});
        BasedataEdit acc = (BasedataEdit)this.getControl("fieldname");
        acc.addBeforeF7SelectListener(e -> {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            ArrayList<String> ffList = new ArrayList<String>();
            DynamicObjectCollection dync = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject dyn : dync) {
                DynamicObject fieldname = dyn.getDynamicObject("fieldname");
                if (fieldname == null) continue;
                String flexfield = fieldname.getString("flexfield");
                ffList.add(flexfield);
            }
            QFilter f = new QFilter("valuetype", "in", (Object)this.getAssistValueType());
            qFilters.add(f);
            f = new QFilter("flexfield", "not in", ffList);
            qFilters.add(f);
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            filterParam.getQFilters().addAll(qFilters);
            showParam.setUseOrgIds(this.getOrgs());
        });
        BasedataEdit ass = (BasedataEdit)this.getControl("value");
        ass.addBeforeF7SelectListener(e -> {
            int rowIndex = model.getEntryCurrentRowIndex("entryentity");
            DynamicObject dyn = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            DynamicObject assisType = dyn.getDynamicObject("fieldname");
            if (assisType == null) {
                e.setCancel(true);
                return;
            }
            String valuetype = assisType.getString("valuetype");
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            DynamicObjectCollection value = (DynamicObjectCollection)model.getValue("value", rowIndex);
            Object[] selVals = value.stream().map(x -> x.get("fbasedataid_id")).toArray();
            showParam.setSelectedRows(selVals);
            showParam.setF7ClickByFilter(true);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            String entityName = null;
            if (AssistValueType.isBaseData((String)valuetype)) {
                List<Long> orgs;
                entityName = assisType.getDynamicObject("valuesource").getString("number");
                QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityName, orgs = this.getOrgs(), (boolean)false);
                if (orgFilter != null) {
                    qFilters.add(orgFilter);
                }
                List properties = dyn.getDynamicObjectType().getProperties().stream().map(x -> x.getName()).collect(Collectors.toList());
                if (grpEntity.contains(entityName) && properties.contains(GROUP_STANDARD)) {
                    Long standardId = (Long)model.getValue("groupstandard_id", rowIndex);
                    showParam.setCustomParam("groupStandard", (Object)standardId);
                    String selectedField = entityName.substring(3);
                    QFilter relationJoinQFilter = QFilter.join((String)"id", (String)(entityName + "groupdetail." + selectedField), (QFilter)QFilter.of((String)(entityName + "groupdetail.standard = ? "), (Object[])new Object[]{standardId}), (ORMHint.JoinHint)ORMHint.JoinHint.INNER, (boolean)true);
                    qFilters.add(relationJoinQFilter);
                }
                filterParam.getQFilters().addAll(qFilters);
            } else if (AssistValueType.isAssistData((String)valuetype)) {
                entityName = "bos_assistantdata_detail";
                DynamicObject valueSource = assisType.getDynamicObject("assistanttype");
                qFilters.add(new QFilter("group", "=", (Object)valueSource.getLong("id")));
                List<Long> orgs = this.getOrgs();
                String flexField = assisType.getString("flexfield");
                FlexProperty flexProperty = FlexUtils.getFlexProperty((String)flexField);
                long assistantTypeId = Long.parseLong(flexProperty.getAssistantType());
                QFilter orgFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)assistantTypeId, orgs);
                if (orgFilter != null) {
                    qFilters.add(orgFilter);
                }
                filterParam.getQFilters().addAll(qFilters);
                showParam.setUseOrgIds(orgs);
            }
            if (AssistValueType.isBaseData((String)valuetype)) {
                String flexField = assisType.getString("flexfield");
                if (!"bos_org".equals(entityName)) {
                    return;
                }
                ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
                String orgFuncId = SubsiDiaryHelper.getOrgFuncId((String)valuetype, (String)entityName, (String)flexField);
                param.setCustomParam("orgFuncId", (Object)orgFuncId);
            }
        });
    }

    private List<String> getComassistFieldByPageCache() {
        ArrayList<String> comassistList = new ArrayList(8);
        String comassistStr = this.getPageCache().get("comassist");
        if (!StringUtils.isBlank((CharSequence)comassistStr)) {
            comassistList = (List)SerializationUtils.fromJsonString((String)comassistStr, List.class);
        } else {
            BasedataEdit comAssistEdit;
            int index = 1;
            while ((comAssistEdit = (BasedataEdit)this.getControl("comassist" + index)) != null) {
                comassistList.add("comassist" + index);
                ++index;
            }
            if (!comassistList.isEmpty()) {
                this.getPageCache().put("comassist", SerializationUtils.toJsonString(comassistList));
            }
        }
        return comassistList;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
    }

    private void comassistF7(List<String> comassistList) {
        for (String comassistField : comassistList) {
            BasedataEdit comAssist = (BasedataEdit)this.getControl(comassistField);
            comAssist.addBeforeF7SelectListener(e -> {
                IDataModel model = this.getModel();
                ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
                ListFilterParameter filterParam = showParam.getListFilterParameter();
                DynamicObjectCollection value = (DynamicObjectCollection)model.getValue(comassistField);
                Object[] selVals = value.stream().map(x -> x.get("fbasedataid_id")).toArray();
                showParam.setSelectedRows(selVals);
                showParam.setF7ClickByFilter(true);
                DynamicObject acctTableDyn = (DynamicObject)model.getValue("accounttable");
                if (!this.containComAssistEntry(acctTableDyn)) {
                    return;
                }
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                DynamicObjectCollection accTableColl = acctTableDyn.getDynamicObjectCollection("comassistentry");
                DynamicObject row = (DynamicObject)accTableColl.get(Integer.parseInt(comassistField.substring(comassistField.length() - 1)) - 1);
                String valType = row.getString("valuesourcetype");
                if (valType == null) {
                    return;
                }
                String entityName = null;
                if (AssistValueType.isAssistData((String)valType)) {
                    entityName = "bos_assistantdata_detail";
                    DynamicObject valueSource = row.getDynamicObject("assistantvaluesource");
                    qFilters.add(new QFilter("group", "=", (Object)valueSource.getLong("id")));
                } else if (row.getDynamicObject("valuesource") != null) {
                    DynamicObject valTypeObj = row.getDynamicObject("valuesource");
                    entityName = valTypeObj.getString("number");
                }
                if (entityName != null) {
                    long orgId = this.getOrgId();
                    QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)orgId);
                    if (orgFilter != null) {
                        qFilters.add(orgFilter);
                    }
                    qFilters.addAll(filterParam.getQFilters());
                    filterParam.setQFilters(qFilters);
                }
            });
        }
    }

    private long getOrgId() {
        List<Long> orgs = this.getOrgs();
        return GLRptTemplatePlugin.getParentOrgByChildre(orgs);
    }

    private List<Long> getOrgs() {
        if (this.hasProperty("orgs")) {
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
            return orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
        }
        ArrayList<Long> result = new ArrayList<Long>();
        Long value = (Long)this.getModel().getValue("org_id");
        if (value != null && value != 0L) {
            result.add(value);
        }
        return result;
    }

    private boolean hasProperty(String name) {
        return this.getModel().getProperty(name) != null;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "addnewbtn": {
                this.getModel().createNewEntryRow("entryentity");
                break;
            }
            case "removebtn": {
                IDataModel model = this.getModel();
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int[] selectRows = entryGrid.getSelectRows();
                model.deleteEntryRows("entryentity", selectRows);
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (queryParam == null || queryParam.getFilter() == null) {
            return false;
        }
        FilterInfo filterInfo = queryParam.getFilter();
        GlFormUtil.setSelectedFlexItems(this.getModel(), (EntryGrid)this.getControl("entryentity"), filterInfo);
        if (filterInfo.getFlexFilterItems().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"AssistRptFilterPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        int assistFilterLimit = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.report.assist.filter.limit", (int)50);
        if (filterInfo.getFlexFilterItems().size() > assistFilterLimit) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u7c7b\u578b\u7ec4\u5408\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u3002", (String)"SubsiDiaryTreeFormRpt_16", (String)"fi-gl-formplugin", (Object[])new Object[0]), assistFilterLimit));
            return false;
        }
        this.beforeQuerySetParam(queryParam);
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
    }

    protected void beforeQuerySetParam(ReportQueryParam queryParam) {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("entryentity");
        FilterInfo filterInfo = queryParam.getFilter();
        HashMap<String, FilterItemInfo> filterMap = new HashMap<String, FilterItemInfo>(filterInfo.getFlexFilterItems().size());
        for (FilterItemInfo item : filterInfo.getFlexFilterItems()) {
            filterMap.put(item.getPropName(), item);
        }
        block14: for (int i = 0; i < rowCount; ++i) {
            String flexfield;
            FilterItemInfo item;
            DynamicObject assisType = (DynamicObject)model.getValue("fieldname", i);
            if (assisType == null || (item = (FilterItemInfo)filterMap.get(flexfield = assisType.getString("flexfield"))) == null) continue;
            String valueType = assisType.getString("valuetype");
            switch (AssistValueType.getTypeEnum((String)valueType)) {
                case baseData: 
                case assistData: {
                    String entityId;
                    Object value = item.getValue();
                    if (value == null) continue block14;
                    if (AssistValueType.isAssistData((String)valueType)) {
                        entityId = "bos_assistantdata_detail";
                    } else {
                        DynamicObject valueSource = assisType.getDynamicObject("valuesource");
                        entityId = valueSource.getString("id");
                    }
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                    if (!(dataEntityType instanceof BasedataEntityType) || ((BasedataEntityType)dataEntityType).getMasteridType() == 0) continue block14;
                    String masterIdPropName = ((BasedataEntityType)dataEntityType).getMasteridPropName();
                    HashSet<Object> val = new HashSet<Object>();
                    try (DataSet set = QueryServiceHelper.queryDataSet((String)"gl assist report filter", (String)entityId, (String)"masterid", (QFilter[])new QFilter("id", "in", value).toArray(), null);){
                        while (set.hasNext()) {
                            val.add(set.next().get(masterIdPropName));
                        }
                    }
                    item.setValue(val);
                    continue block14;
                }
                case manualTxt: {
                    this.setAssistTxtValue(model, i, item);
                }
            }
        }
    }

    protected void setAssistTxtValue(IDataModel model, int i, FilterItemInfo item) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData data = e.getChangeSet()[0];
        String propertyName = e.getProperty().getName();
        Object newValue = data.getNewValue();
        int seq = data.getRowIndex();
        switch (propertyName) {
            case "account": {
                DynamicObjectCollection oldAccCols;
                if (newValue == null) {
                    return;
                }
                DynamicObjectCollection accCols = (DynamicObjectCollection)newValue;
                Object oldValue = e.getChangeSet()[0].getOldValue();
                if (oldValue != null && (oldAccCols = (DynamicObjectCollection)oldValue).size() == accCols.size()) {
                    List oldIds = oldAccCols.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
                    List newIds = accCols.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
                    oldIds.removeAll(newIds);
                    if (oldIds.size() == 0) {
                        return;
                    }
                }
                if (accCols.isEmpty()) break;
                this.setFlexField(accCols);
                break;
            }
            case "fieldname": {
                model.setValue("value", null, seq);
                break;
            }
            case "groupstandard": {
                model.setValue("value", null, seq);
                break;
            }
            case "accounttable": {
                if (!this.containShowComAssist()) break;
                if (newValue == null || !((Boolean)model.getValue("showcomassist")).booleanValue()) {
                    List<String> comassistList = this.getComassistFieldByPageCache();
                    this.getPageCache().put("comassist", null);
                    return;
                }
                this.bindAccTableAssist();
            }
        }
    }

    private boolean containShowComAssist() {
        return this.getModel().getProperty("showcomassist") != null;
    }

    private void bindAccTableAssist() {
        IDataModel model = this.getModel();
        List<String> comassistList = this.getComassistFieldByPageCache();
        DynamicObject acctTableDyn = (DynamicObject)model.getValue("accounttable");
        if (!this.containComAssistEntry(acctTableDyn)) {
            return;
        }
        DynamicObjectCollection accTableColl = acctTableDyn.getDynamicObjectCollection("comassistentry");
        if (((Boolean)model.getValue("showcomassist")).booleanValue()) {
            // empty if block
        }
        if (accTableColl.isEmpty()) {
            this.clearComAssist(comassistList);
            return;
        }
    }

    private boolean containComAssistEntry(DynamicObject dynObj) {
        return dynObj != null && dynObj.containsProperty("comassistentry");
    }

    private void bindEntity(MulBasedataProp prop, String entityId) {
        prop.setBaseEntityId(entityId);
        BasedataProp baseProp = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
        baseProp.setBaseEntityId(entityId);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        baseProp.setDisplayName(dataEntityType.getDisplayName());
        prop.setDisplayName(dataEntityType.getDisplayName());
        baseProp.setComplexType((IDataEntityType)dataEntityType);
    }

    private void clearComAssist(List<String> comassistList) {
        for (String comassistField : comassistList) {
            this.getModel().setValue(comassistField, null);
        }
    }

    protected void setFlexField(DynamicObjectCollection accounts) {
        ArrayList<Set<Long>> assList = new ArrayList<Set<Long>>();
        for (DynamicObject account : accounts) {
            long id = account.getLong("fbasedataid_id");
            Set<Long> assistIds = this.getAssistByAcc(id);
            assList.add(assistIds);
        }
        Set<Long> assCom = "gl_rpt_assistactbalance".equals(this.getView().getEntityId()) || "gl_rpt_agingschedule".equals(this.getView().getEntityId()) ? this.getUnion(assList) : this.getIntersection(assList);
        this.setEntryEntity(assCom);
    }

    protected void setEntryEntity(Set<Long> assCom) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        DynamicObjectCollection entryEntityClone = new DynamicObjectCollection(entryEntity.getDynamicObjectType(), entryEntity.getParent());
        CloneUtils cloneUtils = new CloneUtils(false, true);
        for (DynamicObject entryObj : entryEntity) {
            entryEntityClone.add((Object)((DynamicObject)cloneUtils.clone(entryObj.getDataEntityType(), (Object)entryObj)));
        }
        Iterator iterator = entryEntityClone.iterator();
        while (iterator.hasNext()) {
            DynamicObject entryObject = (DynamicObject)iterator.next();
            DynamicObject asstType = entryObject.getDynamicObject("fieldname");
            if (asstType == null) {
                iterator.remove();
                continue;
            }
            Long pkValue = asstType.getLong("id");
            if (assCom.remove(pkValue)) continue;
            iterator.remove();
        }
        model.deleteEntryData("entryentity");
        int rowIndex = 0;
        if (!entryEntityClone.isEmpty()) {
            MainEntityType type = model.getDataEntityType();
            EntryProp entryProp = (EntryProp)type.getProperty("entryentity");
            for (DynamicObject entryObject : entryEntityClone) {
                List properties;
                DynamicObject asstType = entryObject.getDynamicObject("fieldname");
                String entityNumber = null;
                String valueType = asstType.getString("valuetype");
                if (AssistValueType.isAssistData((String)valueType)) {
                    entityNumber = "bos_assistantdata_detail";
                } else if (AssistValueType.isBaseData((String)valueType)) {
                    DynamicObject valueSource = asstType.getDynamicObject("valuesource");
                    if (valueSource == null) continue;
                    entityNumber = valueSource.getString("id");
                }
                rowIndex = model.createNewEntryRow("entryentity");
                model.setValue("fieldname", asstType.getPkValue(), rowIndex);
                Object item = entryObject.get("value");
                if (entityNumber != null) {
                    MulBasedataProp prop = (MulBasedataProp)entryProp.getDynamicCollectionItemPropertyType().getProperty("value");
                    prop.setBaseEntityId(entityNumber);
                    BasedataProp baseProp = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
                    baseProp.setBaseEntityId(entityNumber);
                    baseProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber));
                    DynamicObjectCollection valueObjs = (DynamicObjectCollection)item;
                    List<Object> fbasedataid = valueObjs.stream().map(o -> o.get("fbasedataid_id")).collect(Collectors.toList());
                    if (!fbasedataid.isEmpty()) {
                        model.setValue("value", (Object)fbasedataid.toArray(new Object[0]), rowIndex);
                    }
                }
                if ((properties = entryObject.getDynamicObjectType().getProperties().stream().map(x -> x.getName()).collect(Collectors.toList())).contains(GROUP_STANDARD)) {
                    DynamicObject valuesource;
                    if (asstType != null && (valuesource = asstType.getDynamicObject("valuesource")) != null && grpEntity.contains(valuesource.getString("id"))) {
                        String formId = valuesource.getString("id") + GROUP_STANDARD;
                        BasedataProp prop = (BasedataProp)entryProp.getDynamicCollectionItemPropertyType().getProperty(GROUP_STANDARD);
                        prop.setBaseEntityId(formId);
                        prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)formId));
                        Object val = entryObject.get("groupstandard_id");
                        model.setValue(GROUP_STANDARD, val, rowIndex);
                    } else {
                        model.setValue(GROUP_STANDARD, null, rowIndex);
                    }
                }
                if (properties.contains(SHOW_TYPE)) {
                    model.setValue(SHOW_TYPE, entryObject.get(SHOW_TYPE), rowIndex);
                }
                if (properties.contains(ASSIST_LEVEL)) {
                    model.setValue(ASSIST_LEVEL, entryObject.get(ASSIST_LEVEL), rowIndex);
                }
                if (!properties.contains(VALUE_TXT)) continue;
                model.setValue(VALUE_TXT, entryObject.get(VALUE_TXT), rowIndex);
            }
        }
        for (Long assist : assCom) {
            rowIndex = model.createNewEntryRow("entryentity");
            model.setValue("fieldname", (Object)assist, rowIndex);
        }
        int count = this.getModel().getEntryRowCount("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = IntStream.range(0, count).toArray();
        entryGrid.selectRows(rows, 0);
    }

    private Set<Long> getIntersection(List<Set<Long>> assList) {
        Set<Long> result = new LinkedHashSet<Long>();
        if (assList.size() == 0) {
            return result;
        }
        result = assList.get(0);
        for (int i = 1; i < assList.size(); ++i) {
            result.retainAll((Collection)assList.get(i));
        }
        return result;
    }

    protected Set<Long> getUnion(List<Set<Long>> assList) {
        LinkedHashSet<Long> result = new LinkedHashSet<Long>();
        for (Set<Long> ass : assList) {
            result.addAll(ass);
        }
        return result;
    }

    protected Set<Long> getAssistByAcc(long accId) {
        LinkedHashSet<Long> result = new LinkedHashSet<Long>();
        QFilter accFilter = new QFilter("id", "=", (Object)accId);
        QFilter typeFilter = new QFilter("checkitementry.asstactitem.valuetype", "in", (Object)this.getAssistValueType());
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bd_accountview", (String)"checkitementry.asstactitem assist", (QFilter[])new QFilter[]{accFilter, typeFilter});
        for (DynamicObject col : cols) {
            result.add(col.getLong("assist"));
        }
        return result;
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        int count = this.getModel().getEntryRowCount("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = IntStream.range(0, count).toArray();
        entryGrid.selectRows(rows, 0);
    }

    static {
        grpEntity.add("bd_customer");
        grpEntity.add("bd_supplier");
        grpEntity.add("bd_material");
    }
}

