/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterOutputWidgetEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.print.core.plugin.event.EndExportEvent;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.report.ReportPrintHelper;
import kd.fi.gl.report.SubsiDiaryCataloguePlugin;

public class AssistTotalCataloguePlugin
extends AbstractPrintPlugin {
    private static final Log LOGGER = LogFactory.getLog(SubsiDiaryCataloguePlugin.class);
    private Map<String, Integer> startPageMap = new LinkedHashMap<String, Integer>(6);
    private static final String ASSIST = "Text12";
    private static final String[] headBaseDataFieldKeys = new String[]{"org", "booktype"};
    private static final String EMPTY = "";
    private String assist = "nullvalue";
    private String org = "";
    private String booktype = "";

    public void loadCustomData(CustomDataLoadEvent evt) {
        CustomDataSource dataSource = evt.getDataSource();
        String pageId = dataSource.getPageId();
        ReportListModel model = ReportPrintHelper.getListModel(pageId);
        if (model == null) {
            return;
        }
        if ("reporthead".equals(dataSource.getDsName())) {
            List field = dataSource.getQueryField();
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(field, headBaseDataFieldKeys);
            DataRowSet dsRow = new DataRowSet();
            ReportQueryParam param = model.getReportQueryParam();
            FilterInfo filter = param.getFilter();
            ReportPrintHelper.handleAccountBaseDataFilterInfo(filter, dsRow, headBaseDataFields);
            this.org = String.valueOf(dsRow.getField("org"));
            this.booktype = String.valueOf(dsRow.getField("booktype"));
        }
    }

    public void afterOutputWidget(AfterOutputWidgetEvent evt) {
        String widgetKey = evt.getWidgetKey();
        int pageIndex = evt.getPageIndex();
        if (ASSIST.equals(widgetKey)) {
            TextField outputValue = (TextField)evt.getOutputValue();
            this.assist = (String)outputValue.getValue();
        }
        if (!"nullvalue".equals(this.assist) && !this.startPageMap.containsKey(String.valueOf(this.assist))) {
            this.startPageMap.put(String.valueOf(this.assist), pageIndex + 1);
        }
    }

    public void endExport(EndExportEvent evt) {
        String entity = evt.getPrtAttach().getFormId();
        String cacheKey = entity + "_" + this.org + "_" + this.booktype;
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.report);
        cache.put(cacheKey, SerializationUtils.toJsonString(this.startPageMap));
        if (DebugTrace.enable()) {
            LOGGER.info("This is AssistTotalCataloguePlugin cacheValue:" + SerializationUtils.toJsonString(this.startPageMap));
        }
    }
}

