/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.BeforeLoadDataEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.report.ReportPrintHelper;
import kd.fi.gl.util.FlexUtils;

public class AssistTotalRptPrint
extends AbstractPrintPlugin {
    private static final String ROW_DATA_CACHE_KEY = "SubsiDiaryRptPrint_RowDatas";
    private static final String PAGE_HEAD_CACHE_KEY = "SubsiDiaryRptPrint_pageHead";
    private static final String[] headFieldKeys = new String[]{"id", "showassist"};
    private static final String[] rowDataStringFieldKeys = new String[]{"accountnumber", "accountname", "measureunit.name", "currencycolumn.name", "periodid.name", "basecurrency.name"};
    private static final String[] rowDataQtyFieldKeys = new String[]{"beginqty", "yeardebitqty", "yearcreditqty", "debitqty", "creditqty", "endqty"};
    private static final String[] rowDataDcFieldKeys = new String[]{"begindc", "enddc"};
    private static final String[] rowDataAmountLocalFieldKeys = new String[]{"beginlocal", "debitlocal", "creditlocal", "yeardebitlocal", "yearcreditlocal", "endlocal"};
    private static final String[] rowDataAmountForFieldKeys = new String[]{"beginfor", "beginprice", "debitprice", "debitfor", "creditprice", "creditfor", "yeardebitfor", "yeardebitprice", "yearcreditfor", "yearcreditprice", "endprice", "endfor"};
    private static final String[] rowDataDecimalFieldKeys = new String[]{"localrate"};
    private static final String SEQ = "fseq";
    private static final String[] headBaseDataFieldKeys = new String[]{"org", "orgview", "booktype", "periodtype", "startperiod", "endperiod", "accounttable", "currencyrpt"};
    private static final String[] headMulBaseDataFieldKeys = new String[]{"measureunits"};
    private static final String CURRENCY_HEAD = "currency";
    private static final String CURRENCY_LOCAL = "basecurrency";
    private static final String CURRENCY_FOR = "currencycolumn";
    private static final String MEASUREUNITFIELD = "measureunit";
    private FormatObject fobj;
    private Map<String, String> assgrpFieldNameProp = new HashMap<String, String>(8);

    public void loadCustomData(CustomDataLoadEvent evt) {
        CustomDataSource dataSource = evt.getDataSource();
        String pageId = dataSource.getPageId();
        ReportListModel model = ReportPrintHelper.getListModel(pageId);
        if (model == null) {
            return;
        }
        if ("reporthead".equals(dataSource.getDsName())) {
            DataRowSet dsRow = new DataRowSet();
            Map pageHeadAccAndAss = (Map)ThreadCache.get((Object)PAGE_HEAD_CACHE_KEY);
            String[] accAndAss = (String[])pageHeadAccAndAss.get(Integer.parseInt(dataSource.getPkId().toString()));
            dsRow.put(headFieldKeys[1], (Field)new TextField(accAndAss[0]));
            List field = dataSource.getQueryField();
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(field, headBaseDataFieldKeys);
            String[] headMulBaseDataFields = ReportPrintHelper.getExistFileds(field, headMulBaseDataFieldKeys);
            ReportQueryParam param = model.getReportQueryParam();
            FilterInfo filter = param.getFilter();
            ReportPrintHelper.handleBaseDataFilterInfo(filter, dsRow, headBaseDataFields);
            ReportPrintHelper.handleMulBaseDataFilterInfo(filter, dsRow, headMulBaseDataFields);
            ReportPrintHelper.handleCurrencyNameById(filter, dsRow, CURRENCY_HEAD);
            List customDataRows = evt.getCustomDataRows();
            customDataRows.add(dsRow);
        } else if ("reportlist".equals(dataSource.getDsName())) {
            Map rowDatasMap = (Map)ThreadCache.get((Object)ROW_DATA_CACHE_KEY);
            int index = Integer.parseInt(dataSource.getPkId().toString());
            String dataIndexs = (String)rowDatasMap.get(index);
            String[] indexStr = dataIndexs.split("-");
            int startIndex = Integer.parseInt(indexStr[0]);
            int length = Integer.parseInt(indexStr[1]) - startIndex;
            DynamicObjectCollection ds = model.getRowData(startIndex, length);
            ReportQueryParam param = model.getReportQueryParam();
            FilterInfo filter = param.getFilter();
            List field = dataSource.getQueryField();
            String[] rowDataStringFields = ReportPrintHelper.getExistFileds(field, rowDataStringFieldKeys);
            String[] rowDataAmountForFields = ReportPrintHelper.getExistFileds(field, rowDataAmountForFieldKeys);
            String[] rowDataAmountLocalFields = ReportPrintHelper.getExistFileds(field, rowDataAmountLocalFieldKeys);
            String[] rowDataQtyFields = ReportPrintHelper.getExistFileds(field, rowDataQtyFieldKeys);
            String[] rowDataDcFields = ReportPrintHelper.getExistFileds(field, rowDataDcFieldKeys);
            String[] rowDataDecimalFields = ReportPrintHelper.getExistFileds(field, rowDataDecimalFieldKeys);
            this.fobj = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
            boolean showqty = filter.getBoolean("showqty");
            String basecurrency = filter.getString(CURRENCY_HEAD);
            boolean noForAmount = CURRENCY_LOCAL.equals(basecurrency);
            int temp = 1;
            List customDataRows = evt.getCustomDataRows();
            for (DynamicObject rowData : ds) {
                DataRowSet printRow = new DataRowSet();
                printRow.put(SEQ, (Field)new TextField(String.valueOf(temp)));
                ++temp;
                ReportPrintHelper.handleStringFields(rowData, printRow, rowDataStringFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_LOCAL, false, rowDataAmountLocalFields);
                if (noForAmount) {
                    if (field.contains("currencycolumn.name")) {
                        printRow.put("currencycolumn.name", (Field)new TextField(""));
                    }
                } else {
                    ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_FOR, false, rowDataAmountForFields);
                }
                ReportPrintHelper.handleDecimalFields(rowData, printRow, this.fobj, false, rowDataDecimalFields);
                ReportPrintHelper.handleDcFields(rowData, printRow, rowDataDcFields);
                if (showqty) {
                    ReportPrintHelper.handleQtyFields(rowData, printRow, false, MEASUREUNITFIELD, this.fobj, rowDataQtyFields);
                }
                customDataRows.add(printRow);
            }
        }
    }

    public void beforeLoadData(BeforeLoadDataEvent evt) {
        super.beforeLoadData(evt);
        PrtDataSource dataSource = evt.getDataSource();
        if (dataSource instanceof MainDataSource) {
            String pageId = ((MainDataSource)dataSource).getPageId();
            ReportListModel model = ReportPrintHelper.getListModel(pageId);
            if (model == null) {
                return;
            }
            FilterInfo filterInfo = model.getReportQueryParam().getFilter();
            List filterItemInfos = filterInfo.getFlexFilterItems();
            List<String> flexFields = filterItemInfos.stream().map(FilterItemInfo::getPropName).collect(Collectors.toList());
            Map flexInfoMap = FlexUtils.batchGetFlexProperty((String[])flexFields.toArray(new String[0]));
            for (int i = 0; i < filterItemInfos.size(); ++i) {
                String flexName = ((FilterItemInfo)filterItemInfos.get(i)).getPropName();
                String valueSource = ((FlexProperty)flexInfoMap.get(flexName)).getValueSource();
                String nameProp = "name";
                if (StringUtils.isNotEmpty((CharSequence)valueSource)) {
                    BasedataEntityType entity = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)((FlexProperty)flexInfoMap.get(flexName)).getValueSource());
                    nameProp = entity.getNameProperty();
                }
                this.assgrpFieldNameProp.put(flexName, nameProp);
            }
        }
    }

    public void afterLoadData(AfterLoadDataEvent e) {
        super.afterLoadData(e);
        PrtDataSource dataSource = e.getDataSource();
        if (dataSource instanceof MainDataSource) {
            Object param;
            String pageId = ((MainDataSource)dataSource).getPageId();
            ReportListModel model = ReportPrintHelper.getListModel(pageId);
            if (model == null) {
                return;
            }
            Map extParam = this.getExtParam();
            if (!extParam.isEmpty() && (param = this.getExtParam().get("pageID")) != null) {
                String pageIDForPrint = param.toString();
                model.setReportTaskResult(model.getReportCache().getReportTaskResult(pageIDForPrint, "reportlistap"));
            }
            Map<String, String> keyToCaption = this.getKeyToCaption(model);
            DynamicObjectCollection rowDatas = model.getRowData(0, model.getRowCount());
            HashMap<Integer, String> rowIndexsByPage = new HashMap<Integer, String>(1);
            HashMap<Integer, String[]> pageToaccAndass = new HashMap<Integer, String[]>(1);
            String tempStr = "null";
            int key = 1;
            DataRowSet oldDsRow = null;
            List dataRowSets = e.getDataRowSets();
            if (dataRowSets != null && dataRowSets.size() > 0) {
                oldDsRow = (DataRowSet)dataRowSets.get(0);
            }
            ArrayList<DataRowSet> dataRows = new ArrayList<DataRowSet>(1);
            for (DynamicObject rowData : rowDatas) {
                String assistVal = this.getAssistVal(keyToCaption, rowData);
                int rowNo = rowData.getInt(SEQ);
                if (assistVal.equalsIgnoreCase(tempStr)) continue;
                if (rowIndexsByPage.get(key) == null && key != rowNo) {
                    rowIndexsByPage.put(key, key - 1 + "-" + (rowNo - 1));
                }
                DataRowSet dsRow = null;
                dsRow = oldDsRow == null ? new DataRowSet() : oldDsRow.deepCopy();
                tempStr = assistVal;
                key = rowNo;
                pageToaccAndass.put(key, new String[]{assistVal});
                dsRow.put(headFieldKeys[0], (Field)new TextField(rowNo + ""));
                dataRows.add(dsRow);
            }
            e.setDataRowSets(dataRows);
            if (!rowDatas.isEmpty()) {
                rowIndexsByPage.put(key, key - 1 + "-" + rowDatas.size());
            }
            ThreadCache.put((Object)ROW_DATA_CACHE_KEY, rowIndexsByPage);
            ThreadCache.put((Object)PAGE_HEAD_CACHE_KEY, pageToaccAndass);
        }
    }

    private String getAssistVal(Map<String, String> keyToCaption, DynamicObject rowData) {
        ArrayList<String> allAssistVal = new ArrayList<String>(keyToCaption.size());
        for (Map.Entry<String, String> entry : keyToCaption.entrySet()) {
            StringBuilder sb = new StringBuilder(entry.getValue()).append("\uff1a");
            Object assistObj = rowData.get(entry.getKey());
            if (assistObj instanceof DynamicObject) {
                DynamicObject assistDyn = (DynamicObject)assistObj;
                String flexField = entry.getKey();
                if (flexField.contains(".")) {
                    flexField = flexField.split("\\.")[0];
                }
                sb.append(assistDyn.getString(this.assgrpFieldNameProp.get(flexField)));
                allAssistVal.add(sb.toString());
                continue;
            }
            if (null == assistObj || "".equals(assistObj)) continue;
            sb.append(assistObj);
            allAssistVal.add(sb.toString());
        }
        return String.join((CharSequence)"\uff1b", allAssistVal);
    }

    private Map<String, String> getKeyToCaption(ReportListModel listModel) {
        List listColumns = listModel.getColumns();
        HashMap<String, String> keyToCaption = new HashMap<String, String>(listColumns.size());
        for (int i = 1; i < listColumns.size(); ++i) {
            ReportColumn column = (ReportColumn)listColumns.get(i);
            String key = column.getFieldKey();
            if (column.isHide()) continue;
            if ("accountnumber".equals(key)) break;
            String caption = column.getCaption().getLocaleValue();
            keyToCaption.put(key, caption);
        }
        return keyToCaption.entrySet().stream().sorted((o1, o2) -> ((String)o2.getKey()).compareTo((String)o1.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> newValue, LinkedHashMap::new));
    }
}

