/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.AbstractReportModel;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.model.JsonObjectAdapter;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.ShowBosPrintingProgress;
import kd.fi.gl.report.FlexHandler;
import kd.fi.gl.report.ReportPrintHelper;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.ShowByAccountDCParam;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.LeftTreeUtil;
import kd.fi.gl.util.SubsiDiaryLeftQueryHelper;

public class AssistTotalTreeFormRpt
extends AbstractReportFormPlugin
implements RowClickEventListener,
ItemClickListener,
CellClickListener {
    private static final Log logger = LogFactory.getLog(AssistTotalTreeFormRpt.class);
    private static final String treeEntryKey = "treeentryentity";
    private static final String ENTRY_KEY = "entryentity";
    private static final String FLEXFIELD = "flexfield";
    private static final String valueSource = "valuesource";
    private static final String showType = "showtype";
    private static final String groupStandard = "groupstandard";
    private static final String groupValue = "groupstandard_id";
    private static final String FIELD_NAME = "fieldname";
    private static final String TREE_NAME = "treename";
    private static final String BASEDATA = "basedata";
    private static final String PREFIX_AD = "assistantdata";
    private static final String PREFIX_TXT = "textfield";
    private static final String REPORT = "reportlistap";
    private static final String CUSTOMSORTENTRY = "customsortentry";

    private static LocaleString getTxtAmount() {
        return new LocaleString(ResManager.loadKDString((String)"\u91d1\u989d", (String)"AssistTotalTreeFormRpt_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid eGrid = (EntryGrid)this.getControl(ENTRY_KEY);
        eGrid.addCellClickListener((CellClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(treeEntryKey);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        ReportList list = (ReportList)this.getControl(REPORT);
        list.addHyperClickListener(evt -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(REPORT);
            DynamicObject rowData = list.getReportModel().getRowData(rowIndex);
            if ("accountnumber".equals(evt.getFieldName())) {
                DynamicObject account = rowData.getDynamicObject("accountid");
                this.viewAsstledger(account.getLong("id"));
            } else if ("currencyid".equals(evt.getFieldName())) {
                DynamicObject account = rowData.getDynamicObject("accountid");
                DynamicObject currency = rowData.getDynamicObject("currencyid");
                this.viewAsstledgerByCurrency(account.getLong("id"), currency.getLong("id"));
            }
        });
    }

    public void cellClick(CellClickEvent arg0) {
        if (arg0.getFieldKey().equals(groupStandard)) {
            this.setComboVal(arg0.getRow());
        }
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "syncexportall": {
                this.syncExportAll("all");
                break;
            }
            case "printview": {
                this.printOperation("single");
                break;
            }
            case "printall": {
                this.printOperation("all");
                break;
            }
            case "refresh": {
                this.refresh();
                break;
            }
        }
    }

    private void printOperation(String flag) {
        if (!AccSysUtil.isPerm((String)this.getView().getEntityId(), (String)"4730fc9e000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5206\u914d\u6253\u5370\u6743\u9650\u3002", (String)"SubsiDiaryTreeFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportView rptFormView = (ReportView)this.getExportAllView(flag);
        if (rptFormView == null) {
            return;
        }
        String formId = "gl_assisttotal";
        Object defaultTemplateId = ReportPrintHelper.getDefaultTemplateId(formId);
        if (ObjectUtils.isEmpty((Object)defaultTemplateId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f\u3002", (String)"SubsiDiaryTreeFormRpt_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportListModel listModel = (ReportListModel)rptFormView.getReportList().getReportModel();
        int rowCount = listModel.getRowCount();
        if (rowCount == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"SubsiDiaryTreeFormRpt_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        String pageId = rptFormView.getPageId();
        JSONObject extParam = JsonObjectAdapter.getEmpty().registerContext("pageID", (Object)listModel.getPageId()).getSource();
        ShowBosPrintingProgress.showProgressFormV2(rowCount, formId, pageId, defaultTemplateId, "", (IFormView)this.getView(), extParam, null);
    }

    public IFormView getExportAllView(String flag) {
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        List filterItems = filter.getFilterItems("exportexcel");
        if (Objects.isNull(filterItems)) {
            filter.addFilterItem("exportexcel", (Object)flag, "=");
        } else {
            filterItems.clear();
            queryParam.getFilter().getFilterItems().removeIf(filterItemInfo -> "exportexcel".equals(filterItemInfo.getPropName()));
            filter.addFilterItem("exportexcel", (Object)flag, "=");
        }
        IDataModel model = this.getModel();
        TreeEntryGrid leftList = (TreeEntryGrid)this.getControl(treeEntryKey);
        int leftIndex = leftList.getEntryState().getFocusRow();
        int count = model.getEntryRowCount(treeEntryKey);
        if (leftIndex == -1 && count > 0) {
            leftIndex = 0;
        }
        DynamicObject obj = null;
        if (leftIndex <= -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"SubsiDiaryTreeFormRpt_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return null;
        }
        obj = model.getEntryRowEntity(treeEntryKey, leftIndex);
        Map<String, Object> param = this.getRowEntityMap(obj);
        ReportList list = (ReportList)this.getControl(REPORT);
        IReportCache reportCache = ReportCacheManager.getInstance().getCache();
        reportCache.setReportQueryParam(this.getView().getPageId(), queryParam);
        AbstractReportModel reportModel = (AbstractReportModel)list.getReportModel();
        reportModel.setPageId(this.getView().getPageId());
        list.setAsynQuery(true);
        list.submitTask(queryParam, param);
        return list.getView();
    }

    private void refresh() {
        this.getPageCache().remove("rowindex");
        if (this.getModel().getEntryRowCount(treeEntryKey) > 0) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(treeEntryKey);
            int[] rows = entryGrid.getSelectRows();
            int row = rows.length > 0 ? rows[0] : 0;
            entryGrid.entryRowClick(Integer.valueOf(row));
            entryGrid.selectRows(row);
        }
    }

    private void syncExportAll(String flagKey) {
        if (!AccSysUtil.isPerm((String)this.getView().getEntityId(), (String)"0YH1MN9OTQ4J")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5206\u914d\u5bfc\u51fa\u6743\u9650\u3002", (String)"SubsiDiaryTreeFormRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportQueryParam queryParam = this.getQueryParam();
        List filterItems = queryParam.getFilter().getFilterItems("exportexcel");
        if (Objects.isNull(filterItems)) {
            queryParam.getFilter().addFilterItem("exportexcel", (Object)flagKey, "=");
        } else {
            filterItems.clear();
            filterItems.add(new FilterItemInfo("exportexcel", (Object)flagKey, "="));
        }
        TreeEntryGrid leftList = (TreeEntryGrid)this.getControl(treeEntryKey);
        int leftIndex = leftList.getEntryState().getFocusRow();
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(treeEntryKey);
        if (leftIndex == -1 && count > 0) {
            leftIndex = 0;
        }
        DynamicObject obj = null;
        if (leftIndex > -1) {
            obj = model.getEntryRowEntity(treeEntryKey, leftIndex);
        }
        if (obj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5bfc\u51fa\u3002", (String)"SubsiDiaryTreeFormRpt_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> param = this.getRowEntityMap(obj);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gl_reportexportall");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("entitynumber", this.getView().getEntityId());
        showParameter.getCustomParams().put("entityname", this.getView().getFormShowParameter().getFormConfig().getCaption().toString());
        showParameter.getCustomParams().put("selectobj", SerializationUtils.serializeToBase64(param));
        showParameter.getCustomParams().put("queryparam", SerializationUtils.serializeToBase64((Object)queryParam));
        this.getView().showForm(showParameter);
    }

    public void entryRowClick(RowClickEvent evt) {
        IPageCache cache = this.getPageCache();
        Control ce = (Control)evt.getSource();
        String entryname = ce.getKey();
        if (treeEntryKey.equals(entryname)) {
            int index = evt.getRow();
            String s = index + "";
            if (s.equals(cache.get("rowindex"))) {
                return;
            }
            cache.put("rowindex", s);
            if (index < 0) {
                index = 0;
            }
            DynamicObject dyo = this.getModel().getEntryRowEntity(treeEntryKey, index);
            Map<String, Object> param = this.getRowEntityMap(dyo);
            ReportList list = (ReportList)this.getControl(REPORT);
            ReportQueryParam queryParam = this.getQueryParam();
            FilterItemInfo filterItem = queryParam.getFilter().getFilterItem("exportexcel");
            Optional.ofNullable(filterItem).ifPresent(filter -> filter.setValue((Object)"null"));
            list.submitTask(queryParam, param);
        }
    }

    private Map<String, Object> getRowEntityMap(DynamicObject dyo) {
        Map keyMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("keyMap"), Map.class);
        HashMap<String, Object> param = new HashMap<String, Object>(keyMap.size());
        String treefield = this.getPageCache().get(TREE_NAME);
        DynamicObjectCollection treeEntryEntities = (DynamicObjectCollection)this.getModel().getEntryEntity(treeEntryKey).clone();
        for (Map.Entry keyentry : keyMap.entrySet()) {
            List<Long> value;
            DataSet valuesourceObjs;
            FlexProperty flexProperty;
            QFilter idFilter;
            String key = (String)keyentry.getValue();
            if (((String)keyentry.getKey()).equals(TREE_NAME)) {
                if (dyo.getBoolean("isGroupNode")) {
                    ArrayList<Long> pids = new ArrayList<Long>();
                    pids.add(dyo.getLong("id"));
                    if (FlexUtils.isBaseDataAndMasteridProperty((String)key)) {
                        List<Long> sons = this.getAllSons(treeEntryEntities, pids, "id");
                        idFilter = new QFilter("id", "in", sons);
                        flexProperty = FlexUtils.getFlexProperty((String)key);
                        valuesourceObjs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)flexProperty.getValueSource(), (String)"masterid", (QFilter[])idFilter.toArray(), null);
                        sons.clear();
                        for (Row row : valuesourceObjs) {
                            sons.add(row.getLong("masterid"));
                        }
                        value = sons;
                    } else {
                        value = this.getAllSons(treeEntryEntities, pids, "id");
                    }
                } else {
                    Long masterid = dyo.getLong("id");
                    if (masterid > 0L && FlexUtils.isBaseDataAndMasteridProperty((String)key)) {
                        FlexProperty flexProperty2 = FlexUtils.getFlexProperty((String)key);
                        DynamicObject assitObj = BusinessDataServiceHelper.loadSingle((Object)masterid, (String)flexProperty2.getValueSource(), (String)"masterid");
                        masterid = assitObj.getLong("masterid");
                    }
                    value = masterid;
                }
            } else if (treefield != null && key.equals(treefield)) {
                if (dyo.getBoolean("isGroupNode")) {
                    ArrayList<Long> pids = new ArrayList<Long>();
                    pids.add(dyo.getLong("id"));
                    if (FlexUtils.isBaseDataAndMasteridProperty((String)key)) {
                        List<Long> sons = this.getAllSons(treeEntryEntities, pids, (String)keyentry.getKey() + "_id");
                        idFilter = new QFilter("id", "in", sons);
                        flexProperty = FlexUtils.getFlexProperty((String)key);
                        valuesourceObjs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)flexProperty.getValueSource(), (String)"masterid", (QFilter[])idFilter.toArray(), null);
                        sons.clear();
                        for (Row row : valuesourceObjs) {
                            sons.add(row.getLong("masterid"));
                        }
                        value = sons;
                    } else {
                        value = this.getAllSons(treeEntryEntities, pids, (String)keyentry.getKey() + "_id");
                    }
                } else {
                    long masterid = dyo.getLong((String)keyentry.getKey() + "_id");
                    if (masterid > 0L && FlexUtils.isBaseDataAndMasteridProperty((String)key)) {
                        FlexProperty flexProperty3 = FlexUtils.getFlexProperty((String)key);
                        DynamicObject assitObj = BusinessDataServiceHelper.loadSingle((Object)masterid, (String)flexProperty3.getValueSource(), (String)"masterid");
                        masterid = assitObj.getLong("masterid");
                    }
                    value = masterid;
                }
            } else if (((String)keyentry.getKey()).startsWith(BASEDATA)) {
                DynamicObject badataObj = dyo.getDynamicObject((String)keyentry.getKey());
                if (badataObj == null || !badataObj.containsProperty("masterid")) {
                    long baseDataId = dyo.getLong((String)keyentry.getKey() + "_id");
                    if (baseDataId > 0L && FlexUtils.isBaseDataAndMasteridProperty((String)key)) {
                        flexProperty = FlexUtils.getFlexProperty((String)key);
                        DynamicObject assitObj = BusinessDataServiceHelper.loadSingleFromCache((Object)baseDataId, (String)flexProperty.getValueSource(), (String)"masterid");
                        baseDataId = assitObj.getLong("masterid");
                    }
                    value = baseDataId;
                } else {
                    value = badataObj.getLong("masterid");
                }
            } else if (((String)keyentry.getKey()).startsWith(PREFIX_TXT)) {
                value = dyo.getString((String)keyentry.getKey());
            } else {
                if (!((String)keyentry.getKey()).startsWith(PREFIX_AD)) continue;
                value = dyo.getLong((String)keyentry.getKey() + "_id");
            }
            param.put(key, value);
        }
        return param;
    }

    private List<Long> getAllSons(DynamicObjectCollection entries, List<Long> pids, String idKey) {
        ArrayList<Long> sons = new ArrayList<Long>();
        ArrayList<Long> parents = new ArrayList<Long>();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            DynamicObject dyo = (DynamicObject)iterator.next();
            if (!pids.contains(dyo.getLong("pid"))) continue;
            if (dyo.getBoolean("isGroupNode")) {
                parents.add(dyo.getLong("id"));
                continue;
            }
            sons.add(dyo.getLong(idKey));
            iterator.remove();
        }
        if (!parents.isEmpty()) {
            sons.addAll(this.getAllSons(entries, parents, idKey));
            return sons;
        }
        return sons;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData data = e.getChangeSet()[0];
        Object newVal = data.getNewValue();
        String propName = e.getProperty().getName();
        if (showType.equals(propName)) {
            if ("2".equals(newVal) || "3".equals(newVal)) {
                int seq = data.getRowIndex();
                if (this.checkShowType(seq).booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u6838\u7b97\u7ef4\u5ea6\u4e3a\u9010\u7ea7\u6216\u8005\u6307\u5b9a\u663e\u793a\u65b9\u5f0f\u3002", (String)"AssistTotalTreeFormRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    model.setValue(showType, (Object)"1", seq);
                    return;
                }
                if (this.checkGroupStandard(seq)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u7c7b\u6807\u51c6\u3002", (String)"AssistTotalTreeFormRpt_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    model.setValue(showType, (Object)"1", seq);
                    return;
                }
                if (this.checkIsParentOrGroup(seq)) {
                    model.setValue(showType, (Object)"1", seq);
                    this.getView().setEnable(Boolean.valueOf(false), seq, new String[]{showType});
                    return;
                }
            }
        } else if (FIELD_NAME.equals(propName)) {
            int seq = data.getRowIndex();
            model.setValue(groupStandard, null, seq);
            this.setComboVal(seq);
            if (this.checkIsParentOrGroup(seq)) {
                model.setValue(showType, (Object)"1", seq);
                this.getView().setEnable(Boolean.valueOf(false), seq, new String[]{showType});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), seq, new String[]{showType});
            }
        }
    }

    private Boolean checkShowType(int seq) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(ENTRY_KEY);
        for (int i = 0; i < count; ++i) {
            String showtype;
            if (i == seq || !"2".equals(showtype = (String)model.getValue(showType, i)) && !"3".equals(showtype)) continue;
            return true;
        }
        return false;
    }

    private boolean checkGroupStandard(int i) {
        IDataModel model = this.getModel();
        DynamicObject assisType = (DynamicObject)model.getValue(FIELD_NAME, i);
        if (assisType == null) {
            return false;
        }
        DynamicObject valuesource = null;
        String entityId = null;
        String valuetype = assisType.getString("valuetype");
        if ("1".equals(valuetype)) {
            valuesource = assisType.getDynamicObject(valueSource);
            if (valuesource == null) {
                return false;
            }
            entityId = valuesource.getString("id");
            if (this.getGroupAssistKey().contains(entityId) && (Long)model.getValue(groupValue, i) <= 0L) {
                return true;
            }
        }
        return false;
    }

    private boolean checkIsParentOrGroup(int i) {
        IDataModel model = this.getModel();
        DynamicObject assisType = (DynamicObject)model.getValue(FIELD_NAME, i);
        if (assisType == null) {
            return false;
        }
        DynamicObject valuesource = null;
        String entityId = null;
        String valuetype = assisType.getString("valuetype");
        if ("1".equals(valuetype)) {
            valuesource = assisType.getDynamicObject(valueSource);
            if (valuesource == null) {
                return true;
            }
            entityId = valuesource.getString("id");
            if (this.getGroupAssistKey().contains(entityId)) {
                return false;
            }
            if (this.specialGroupTree().contains(entityId)) {
                return false;
            }
            if (this.hasParent(entityId)) {
                return false;
            }
        } else if ("2".equals(valuetype)) {
            return false;
        }
        return true;
    }

    private List<String> specialGroupTree() {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("bos_org");
        list.add("bos_adminorg");
        return list;
    }

    private boolean hasParent(String entityId) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        DynamicProperty parent = mainEntityType.getProperty("parent");
        DynamicProperty isleaf = mainEntityType.getProperty("isleaf");
        DynamicProperty level = mainEntityType.getProperty("level");
        return parent != null && !StringUtils.isBlank((CharSequence)parent.getAlias()) && isleaf != null && !StringUtils.isBlank((CharSequence)isleaf.getAlias()) && level != null && !StringUtils.isBlank((CharSequence)level.getAlias());
    }

    private void setComboVal(int selIndex) {
        MainEntityType type = this.getModel().getDataEntityType();
        EntryProp entry = (EntryProp)type.getProperty(ENTRY_KEY);
        IDataModel model = this.getModel();
        DynamicObject fieldNameDyn = (DynamicObject)model.getValue(FIELD_NAME, selIndex);
        if (fieldNameDyn == null) {
            return;
        }
        String valuetype = fieldNameDyn.getString("valuetype");
        String entityNumber = "";
        if ("1".equals(valuetype)) {
            DynamicObject valuesource = fieldNameDyn.getDynamicObject(valueSource);
            entityNumber = valuesource.getString("id");
            if (this.getGroupAssistKey().contains(entityNumber)) {
                String formId = entityNumber + groupStandard;
                BasedataProp prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(groupStandard);
                prop.setBaseEntityId(formId);
                prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)formId));
                QFilter fispreset = new QFilter("ispreset", "=", (Object)Character.valueOf('1'));
                QFilter fstatus = new QFilter("status", "=", (Object)Character.valueOf('C'));
                DataSet defaultSet = this.queryDataSet(formId, "id", new QFilter[]{fispreset, fstatus});
                long defaultId = 0L;
                if (defaultSet.hasNext()) {
                    Row row = defaultSet.next();
                    defaultId = row.getLong("id");
                }
                model.setValue(groupStandard, (Object)defaultId, selIndex);
            }
        }
    }

    public DataSet queryDataSet(String formId, String sel, QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)formId, (String)sel, (QFilter[])filters, null);
    }

    private List<String> getGroupAssistKey() {
        return Arrays.asList("bd_customer", "bd_supplier", "bd_material");
    }

    private void viewAsstledgerByCurrency(long accountid, long currencyid) {
        ReportShowParameter report = new ReportShowParameter();
        report.setFormId("gl_rpt_subsidiaryledger");
        report.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        FilterInfo filter = new FilterInfo();
        for (FilterItemInfo item : this.getQueryParam().getFilter().getFilterItems()) {
            filter.addFilterItem(item.getPropName(), item.getValue(), item.getCompareType());
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(treeEntryKey);
        int[] currRow = entryGrid.getSelectRows();
        int selectRow = 0;
        if (currRow.length != 0) {
            selectRow = currRow[0];
        }
        List flexFilter = filter.getFlexFilterItems();
        DynamicObject bd = entryGrid.getModel().getEntryRowEntity(treeEntryKey, selectRow);
        Map<String, Object> param = this.getRowEntityMap(bd);
        for (FilterItemInfo item : this.getQueryParam().getFilter().getFlexFilterItems()) {
            String propName = item.getPropName();
            HashSet<Object> vals = new HashSet<Object>();
            if (param.get(propName) instanceof Long) {
                Long id = (Long)param.get(propName);
                vals.add(id);
            } else if (param.get(propName) instanceof List) {
                List ids = (List)param.get(propName);
                vals.addAll(ids);
            } else {
                vals.add(param.get(propName));
            }
            FilterItemInfo flexItemInfo = new FilterItemInfo();
            flexItemInfo.setCompareType(item.getCompareType());
            flexItemInfo.setPropName(item.getPropName());
            flexItemInfo.setValue(vals);
            flexFilter.add(flexItemInfo);
        }
        filter.addFilterItem("account", (Object)accountid);
        filter.addFilterItem("currency", (Object)currencyid);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        report.setQueryParam(queryParam);
        this.getView().showForm((FormShowParameter)report);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        Object formatValue;
        super.packageData(packageDataEvent);
        ReportColumn col = (ReportColumn)packageDataEvent.getSource();
        String key = col.getFieldKey();
        if ("accountnumber".equals(key) && (formatValue = packageDataEvent.getFormatValue()) != null) {
            if (formatValue instanceof Object[]) {
                Object[] arr = (Object[])formatValue;
                formatValue = arr[0];
            }
            if (formatValue.equals(ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AssistTotalTreeFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]))) {
                packageDataEvent.setFormatValue((Object)("<nolink>" + formatValue));
            }
        }
    }

    private void viewAsstledger(long account) {
        ReportShowParameter report = new ReportShowParameter();
        report.setFormId("gl_rpt_subsidiaryledger");
        report.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        FilterInfo filter = new FilterInfo();
        for (FilterItemInfo item : this.getQueryParam().getFilter().getFilterItems()) {
            filter.addFilterItem(item.getPropName(), item.getValue(), item.getCompareType());
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(treeEntryKey);
        int[] currRow = entryGrid.getSelectRows();
        int selectRow = 0;
        if (currRow.length != 0) {
            selectRow = currRow[0];
        }
        List flexFilter = filter.getFlexFilterItems();
        DynamicObject bd = this.getModel().getEntryRowEntity(treeEntryKey, selectRow);
        if (Objects.isNull(bd)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u3002", (String)"AssistTotalTreeFormRpt_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> param = this.getRowEntityMap(bd);
        for (FilterItemInfo item : this.getQueryParam().getFilter().getFlexFilterItems()) {
            String propName = item.getPropName();
            HashSet<Object> vals = new HashSet<Object>();
            if (param.get(propName) instanceof Long) {
                Long id = (Long)param.get(propName);
                vals.add(id);
            } else if (param.get(propName) instanceof List) {
                List ids = (List)param.get(propName);
                vals.addAll(ids);
            } else {
                vals.add(param.get(propName));
            }
            if (vals.isEmpty()) {
                Map keyMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("keyMap"), Map.class);
                logger.error("param: " + param + "; propName: " + propName);
                logger.error("keyMap: " + keyMap);
                logger.error("dyn: " + bd);
            }
            FilterItemInfo flexItemInfo = new FilterItemInfo();
            flexItemInfo.setCompareType(item.getCompareType());
            flexItemInfo.setPropName(item.getPropName());
            flexItemInfo.setValue(vals);
            flexFilter.add(flexItemInfo);
        }
        filter.addFilterItem("account", (Object)account);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        report.setQueryParam(queryParam);
        this.getView().showForm((FormShowParameter)report);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        FilterInfo filter = event.getQueryParam().getFilter();
        String currencyId = filter.getString("currency");
        AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)filter.getLong("org"), (long)filter.getLong("booktype"));
        Long baseCurrency = book.getBaseCurrencyId();
        boolean isBaseCurrency = currencyId != null && (currencyId.equals(baseCurrency.toString()) || currencyId.equals("basecurrency"));
        this.setColumnVisible(event.getColumns(), currencyId == null || currencyId.equals("allcurrency"), isBaseCurrency, filter.getBoolean("showqty"));
    }

    private void setColumnVisible(List<AbstractReportColumn> columns, boolean showCurrencyColumn, boolean isBaseCurrency, boolean showQty) {
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                ReportColumn col = (ReportColumn)column;
                String key = col.getFieldKey();
                if ("currencyid".equals(key)) {
                    col.setHide(!showCurrencyColumn);
                    continue;
                }
                if (isBaseCurrency && key.endsWith("for")) {
                    col.setHide(isBaseCurrency);
                    continue;
                }
                if (isBaseCurrency && key.endsWith("local")) {
                    col.setCaption(AssistTotalTreeFormRpt.getTxtAmount());
                    continue;
                }
                if (showQty || !key.endsWith("qty") && !"measureunitid".equals(key) && !key.endsWith("price")) continue;
                col.setHide(true);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup colGroup = (ReportColumnGroup)column;
            this.setColumnVisible(colGroup.getChildren(), showCurrencyColumn, isBaseCurrency, showQty);
        }
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        super.setOtherEntryFilter(filterInfo);
        HashMap<String, Object> otherEntryFilter = new HashMap<String, Object>();
        otherEntryFilter.put(CUSTOMSORTENTRY, null);
        filterInfo.setOtherEntryFilter(otherEntryFilter);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Map<String, Object> rowEntityMap;
        DynamicObject dyo;
        if (queryParam == null || queryParam.getFilter() == null) {
            return false;
        }
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo.getFlexFilterItems() == null || filterInfo.getFlexFilterItems().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"AssistTotalTreeFormRpt_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        IPageCache cache = this.getPageCache();
        cache.remove(TREE_NAME);
        cache.remove("paramMap");
        cache.remove("keyMap");
        cache.remove("firstQuery");
        cache.remove("rowindex");
        this.createTreeEntryField(cache);
        this.getFlexHandler().cacheShowType();
        if (filterInfo.getOtherEntryFilter().containsKey(CUSTOMSORTENTRY)) {
            return true;
        }
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(treeEntryKey);
        if (count > 0 && (dyo = model.getEntryRowEntity(treeEntryKey, 0)) != null && !(rowEntityMap = this.getRowEntityMap(dyo)).isEmpty()) {
            IReportCache reportCache = ReportCacheManager.getInstance().getCache();
            reportCache.setReportQueryParam(this.getView().getPageId(), this.getQueryParam());
            ReportList list = (ReportList)this.getControl(REPORT);
            list.submitTask(queryParam, rowEntityMap);
            ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
            filter.setCollapse(true);
            IReportView view = this.getView();
            view.setVisible(Boolean.valueOf(true), new String[]{"splitcontainerap", "toolbarap"});
            this.setVisibleAssistEntry();
            return false;
        }
        return true;
    }

    private void setVisibleAssistEntry() {
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        int size = model.getEntryRowCount(ENTRY_KEY);
        boolean isManualAssist = false;
        boolean isMulTree = false;
        boolean isLevel = false;
        for (int i = 0; i < size; ++i) {
            DynamicObject fieldNameDyn = (DynamicObject)model.getValue(FIELD_NAME, i);
            if (fieldNameDyn == null) continue;
            if ("3".equals(fieldNameDyn.getString("valuetype"))) {
                isManualAssist = true;
                view.setEnable(Boolean.valueOf(true), i, new String[]{"textinput"});
            } else {
                DynamicObject valueSource = fieldNameDyn.getDynamicObject(valueSource);
                String sourceNumber = valueSource.getString("number");
                if ("bd_customer,bd_supplier,bd_material".contains(sourceNumber)) {
                    isMulTree = true;
                }
            }
            if (!"3".equals(model.getValue(showType, i))) continue;
            isLevel = true;
        }
        view.setVisible(Boolean.valueOf(isManualAssist), new String[]{"textinput"});
        view.setVisible(Boolean.valueOf(isMulTree), new String[]{groupStandard});
        view.setVisible(Boolean.valueOf(isLevel), new String[]{"asstlevel"});
    }

    private void createTreeEntryField(IPageCache cache) {
        MainEntityType type = this.getModel().getDataEntityType();
        EntryProp entry = (EntryProp)type.getProperty(treeEntryKey);
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(treeEntryKey);
        LeftTreeUtil.hideTreeEntryColumns(grid);
        IDataModel model = this.getModel();
        int baseDataIndex = 0;
        int assistantDataIndex = 0;
        int textDataIndex = 0;
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
        int[] selectRows = entryGrid.getSelectRows();
        HashMap<String, String> keyMap = new HashMap<String, String>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (int idx = 0; idx < selectRows.length; ++idx) {
            BasedataProp prop;
            int i = selectRows[idx];
            if (LeftTreeUtil.isOutOfIndex((IFormView)this.getView(), baseDataIndex + assistantDataIndex, textDataIndex)) break;
            DynamicObject assisType = (DynamicObject)model.getValue(FIELD_NAME, i);
            if (assisType == null) continue;
            DynamicObject valuesource = null;
            String entityId = null;
            String valuetype = assisType.getString("valuetype");
            String displayProperty = "name";
            FlexProperty flexProp = FlexEntityMetaUtils.getFlexProperty((String)assisType.getString(FLEXFIELD));
            if (flexProp != null) {
                displayProperty = flexProp.getDisplayStyle().getDisplayProperty().toString();
            }
            IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            if ("1".equals(valuetype)) {
                valuesource = assisType.getDynamicObject(valueSource);
                if (valuesource == null) continue;
                entityId = valuesource.getString("id");
            } else if ("2".equals(valuetype)) {
                valuesource = assisType.getDynamicObject("assistanttype");
                entityId = "bos_assistantdata_detail";
            }
            if ("3".equals(model.getValue(showType, i))) {
                paramMap.put("asstlevel", model.getValue("asstlevel", i));
            }
            if (!"1".equals(model.getValue(showType, i)) && this.getGroupAssistKey().contains(entityId)) {
                grid.setColumnProperty(TREE_NAME, "header", (Object)new LocaleString(assisType.getString("name")));
                grid.setColumnProperty(TREE_NAME, "vi", (Object)true);
                grid.setColumnProperty(TREE_NAME, "l", (Object)true);
                keyMap.put(TREE_NAME, assisType.getString(FLEXFIELD));
                paramMap.put("showType", model.getValue(showType, i));
                paramMap.put("entityId", entityId);
                paramMap.put("treeAlias", assisType.getString(FLEXFIELD));
                paramMap.put("standardId", model.getValue(groupValue, i));
                paramMap.put(TREE_NAME, assisType.getString(FLEXFIELD));
                paramMap.put(assisType.getString(FLEXFIELD), displayProperty);
                continue;
            }
            if (!"1".equals(model.getValue(showType, i))) {
                cache.put(TREE_NAME, assisType.getString(FLEXFIELD));
                paramMap.put("showType", model.getValue(showType, i));
                paramMap.put("entityId", entityId);
                paramMap.put("treeAlias", assisType.getString(FLEXFIELD));
                paramMap.put(TREE_NAME, assisType.getString(FLEXFIELD));
                paramMap.put(assisType.getString(FLEXFIELD), displayProperty);
            }
            if ("3".equals(valuetype)) {
                LeftTreeUtil.gridSetHVL(grid, PREFIX_TXT + textDataIndex, assisType.getString("name"), true);
                keyMap.put(PREFIX_TXT + textDataIndex, assisType.getString(FLEXFIELD));
                ++textDataIndex;
                continue;
            }
            if ("1".equals(valuetype)) {
                service.invokeControlMethod(treeEntryKey, "setColEditorProp", new Object[]{BASEDATA + baseDataIndex, "dsp", displayProperty});
                prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(BASEDATA + baseDataIndex);
                prop.setBaseEntityId(entityId);
                DynamicObjectType dataEntityType = EntityMetadataCache.getSubDataEntityType((String)entityId, (Collection)Sets.newHashSet((Object[])new String[]{"name"}));
                prop.setComplexType((IDataEntityType)dataEntityType);
                LeftTreeUtil.gridSetHVL(grid, BASEDATA + baseDataIndex, assisType.getString("name"), true);
                keyMap.put(BASEDATA + baseDataIndex, assisType.getString(FLEXFIELD));
                ++baseDataIndex;
                continue;
            }
            if (!"2".equals(valuetype)) continue;
            service.invokeControlMethod(treeEntryKey, "setColEditorProp", new Object[]{PREFIX_AD + assistantDataIndex, "dsp", displayProperty});
            prop = (AssistantProp)entry.getDynamicCollectionItemPropertyType().getProperty(PREFIX_AD + assistantDataIndex);
            if (prop == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599\u7c7b\u578b\u6838\u7b97\u7ef4\u5ea6\u9ed8\u8ba4\u4e0d\u80fd\u8d85\u8fc75\u4e2a\uff0c\u53ef\u80fd\u51fa\u73b0\u6570\u636e\u663e\u793a\u95ee\u9898\uff0c\u5efa\u8bae\u6269\u5c55\u589e\u52a0\u9884\u7f6e\u8f85\u52a9\u8d44\u6599\u5217\u4e2a\u6570\u3002", (String)"AssistTotalTreeFormRpt_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(4000));
                continue;
            }
            prop.setBaseEntityId(entityId);
            if (valuesource == null) continue;
            prop.setAsstTypeId(String.valueOf(valuesource.getPkValue()));
            LeftTreeUtil.gridSetHVL(grid, PREFIX_AD + assistantDataIndex, assisType.getString("name"), true);
            keyMap.put(PREFIX_AD + assistantDataIndex, assisType.getString(FLEXFIELD));
            ++assistantDataIndex;
        }
        this.createData(keyMap, paramMap);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        this.getFlexHandler().setRefreshTag();
        String firstQuery = this.getPageCache().get("firstQuery");
        if ("false".equals(firstQuery)) {
            this.bindBaseData();
        } else {
            firstQuery = "false";
            this.getPageCache().put("firstQuery", firstQuery);
        }
    }

    private void bindBaseData() {
        if (this.getFlexHandler().isRefresh()) {
            return;
        }
        MainEntityType type = this.getModel().getDataEntityType();
        EntryProp entry = (EntryProp)type.getProperty(treeEntryKey);
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(treeEntryKey);
        int baseDataIndex = 0;
        int assistantDataIndex = 0;
        int textDataIndex = 0;
        FlexHandler flexHandler = this.getFlexHandler();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
        int[] selectRows = entryGrid.getSelectRows();
        for (int idx = 0; idx < selectRows.length; ++idx) {
            int i = selectRows[idx];
            if (LeftTreeUtil.isOutOfIndex((IFormView)this.getView(), baseDataIndex + assistantDataIndex, textDataIndex)) break;
            FlexProperty flexProp = flexHandler.getFlexProperty(i);
            if (flexProp == null) continue;
            String entityId = null;
            String valuetype = flexProp.getValueType();
            String displayProperty = flexProp.getDisplayStyle().getDisplayProperty().toString();
            IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            String showType = flexHandler.getShowType(i);
            if ("1".equals(valuetype)) {
                entityId = flexProp.getValueSource();
            } else if ("2".equals(valuetype)) {
                entityId = "bos_assistantdata_detail";
            }
            if (!"1".equals(showType) && this.getGroupAssistKey().contains(entityId)) {
                grid.setColumnProperty(TREE_NAME, "header", (Object)flexProp.getName());
                grid.setColumnProperty(TREE_NAME, "vi", (Object)true);
                grid.setColumnProperty(TREE_NAME, "l", (Object)true);
                continue;
            }
            if (!"1".equals(showType)) {
                // empty if block
            }
            if ("3".equals(valuetype)) {
                LeftTreeUtil.gridSetHVL(grid, PREFIX_TXT + textDataIndex, flexProp.getName().toString(), true);
                ++textDataIndex;
                continue;
            }
            if ("1".equals(valuetype)) {
                service.invokeControlMethod(treeEntryKey, "setColEditorProp", new Object[]{BASEDATA + baseDataIndex, "dsp", displayProperty});
                BasedataProp prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(BASEDATA + baseDataIndex);
                prop.setBaseEntityId(entityId);
                prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId));
                LeftTreeUtil.gridSetHVL(grid, BASEDATA + baseDataIndex, flexProp.getName().toString(), true);
                ++baseDataIndex;
                continue;
            }
            if (!"2".equals(valuetype)) continue;
            service.invokeControlMethod(treeEntryKey, "setColEditorProp", new Object[]{PREFIX_AD + assistantDataIndex, "dsp", displayProperty});
            LeftTreeUtil.gridSetHVL(grid, PREFIX_AD + assistantDataIndex, flexProp.getName().toString(), true);
            ++assistantDataIndex;
        }
    }

    private void createData(Map<String, String> keyMap, Map<String, Object> paramMap) {
        IPageCache cache = this.getPageCache();
        if (keyMap.get(TREE_NAME) != null || cache.get(TREE_NAME) != null) {
            keyMap.put("id", "id");
            keyMap.put("pid", "pid");
            keyMap.put("isGroupNode", "isgroupnode");
            keyMap.put("level", "level");
        }
        cache.put("paramMap", SerializationUtils.toJsonString(paramMap));
        cache.put("keyMap", SerializationUtils.toJsonString(keyMap));
        this.refreshEntryValue(keyMap, paramMap);
    }

    private void refreshEntryValue(Map<String, String> keyMap, Map<String, Object> paramMap) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (String key : keyMap.keySet()) {
            vs.addField(key, new Object[0]);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        SubsiDiaryLeftQueryHelper leftQueryHelper = new SubsiDiaryLeftQueryHelper();
        try (DataSet ds = leftQueryHelper.getLeftSet(this.getQueryParam(), paramMap, true);){
            if (ds == null) {
                model.deleteEntryData(treeEntryKey);
                this.getView().updateView(treeEntryKey);
                return;
            }
            List dsList = GLUtil.getDataSetCols((DataSet)ds);
            if (paramMap.get("standardId") != null && (keyMap.get(TREE_NAME) != null || paramMap.get(TREE_NAME) != null)) {
                dsList.removeIf(x -> x.equals(TREE_NAME));
                String treeName = (String)paramMap.get(TREE_NAME);
                String showType = (String)paramMap.get(treeName);
                if ("name".equals(showType) || "".equals(showType)) {
                    dsList.add(TREE_NAME);
                } else if ("number".equals(showType)) {
                    dsList.add("treenumber  treename");
                } else {
                    dsList.add("treename + ',' + treenumber  treename");
                }
            }
            dsList.removeIf(x -> x.equals("treenumber"));
            DataSet result = ds.select(dsList.toArray(new String[0]));
            if (keyMap.get(TREE_NAME) != null || paramMap.get(TREE_NAME) != null) {
                int level = 0;
                if (paramMap.get("asstlevel") != null) {
                    level = (Integer)paramMap.get("asstlevel");
                }
                leftQueryHelper.createMulTreeValue(result, vs, model, keyMap, (IFormView)this.getView());
                this.collapseEntry(level);
            } else {
                this.createValue(result, vs, model, keyMap);
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    private void createValue(DataSet ds, TableValueSetter vs, AbstractFormDataModel model, Map<String, String> keyMap) {
        SplitContainer splitContainer;
        int i;
        ArrayList<Object[]> tempList = new ArrayList<Object[]>(10);
        for (Row row : ds) {
            i = 0;
            Object[] obj = new Object[vs.getFields().size()];
            for (Object field : vs.getFields()) {
                obj[i] = ((String)field).equals(TREE_NAME) ? row.get(TREE_NAME) : row.get(keyMap.get(field));
                ++i;
            }
            tempList.add(obj);
        }
        HashMap<String, Map> flexfieldToMasteridAndId = new HashMap<String, Map>(16);
        List fields = vs.getFields();
        for (i = 0; i < fields.size(); ++i) {
            String field = (String)fields.get(i);
            String fieldName = keyMap.get(field);
            if (!FlexUtils.isBaseDataAndMasteridProperty((String)fieldName)) continue;
            for (Object[] objects : tempList) {
                flexfieldToMasteridAndId.computeIfAbsent(fieldName, k -> new HashMap()).put((Long)objects[i], null);
            }
        }
        if (DebugTrace.enable()) {
            logger.info("{}_flexfieldToMasteridAndId_1:{}", (Object)((Object)((Object)this)).getClass().getName(), (Object)DebugTraceHelper.toString(flexfieldToMasteridAndId));
        }
        long orgid = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        Date enddate = ((DynamicObject)model.getValue("endperiod")).getDate("enddate");
        for (Map.Entry entry : flexfieldToMasteridAndId.entrySet()) {
            String flexfield = (String)entry.getKey();
            String valuesource = FlexUtils.getFlexProperty((String)flexfield).getValueSource();
            if (StringUtils.isEmpty((CharSequence)valuesource)) continue;
            Map value = (Map)entry.getValue();
            Set ids = value.keySet();
            ids.removeIf(x -> x == null || x == 0L);
            if (ids.size() <= 0) continue;
            for (List batchIds : Lists.partition(new ArrayList(ids), (int)1000)) {
                QFilter qFilter = new QFilter("masterid", "in", (Object)batchIds);
                DynamicObjectCollection assistObjs = BaseDataServiceHelper.queryBaseDataByDate((String)valuesource, (Long)orgid, (QFilter)qFilter, (String)"id,masterid,name", (Date)enddate);
                List assistIds = assistObjs.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                QFilter idFilter = new QFilter("id", "in", assistIds);
                DynamicObjectType dataEntityType = EntityMetadataCache.getSubDataEntityType((String)valuesource, (Collection)Sets.newHashSet((Object[])new String[]{"name"}));
                Map assistObjMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)dataEntityType, (QFilter[])idFilter.toArray());
                for (DynamicObject assistObj : assistObjs) {
                    DynamicObject assistObjTarget = (DynamicObject)assistObjMap.get(assistObj.getLong("id"));
                    assistObjTarget.set("name", (Object)new LocaleString(assistObj.getString("name")));
                    value.put(assistObj.getLong("masterid"), assistObjTarget);
                }
            }
        }
        if (DebugTrace.enable()) {
            logger.info("{}_flexfieldToMasteridAndId_2:{}", (Object)((Object)((Object)this)).getClass().getName(), (Object)DebugTraceHelper.toString(flexfieldToMasteridAndId));
        }
        for (int i2 = 0; i2 < fields.size(); ++i2) {
            String field = (String)fields.get(i2);
            String fieldName = keyMap.get(field);
            if (!FlexUtils.isBaseDataAndMasteridProperty((String)fieldName)) continue;
            Map masteridAndIds = (Map)flexfieldToMasteridAndId.get(fieldName);
            for (Object[] objects : tempList) {
                if (masteridAndIds.get(objects[i2]) == null) continue;
                objects[i2] = masteridAndIds.get(objects[i2]);
            }
        }
        model.beginInit();
        model.deleteEntryData(treeEntryKey);
        for (Object[] objects : tempList) {
            int rowIndex = model.createNewEntryRow(treeEntryKey);
            for (int j = 0; j < objects.length; ++j) {
                model.setValue((String)fields.get(j), objects[j], rowIndex);
            }
        }
        model.endInit();
        this.getView().updateView(treeEntryKey);
        int count = vs.getCount();
        if (1 == count) {
            splitContainer = (SplitContainer)this.getView().getControl("splitcontainerap");
            splitContainer.setCollapse("grouppanelap", true);
        } else {
            splitContainer = (SplitContainer)this.getView().getControl("splitcontainerap");
            splitContainer.setCollapse("grouppanelap", false);
        }
    }

    private void collapseEntry(int level) {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(treeEntryKey);
        entryGrid.setCollapse(false);
        if (level > 0) {
            IDataModel model = this.getModel();
            int count = model.getEntryRowCount(treeEntryKey);
            HashSet<Integer> rows = new HashSet<Integer>();
            String s = level + "";
            for (int i = 0; i < count; ++i) {
                String elevel = model.getValue("level", i) + "";
                if (!s.equals(elevel) || !((Boolean)model.getValue("isGroupNode", i)).booleanValue()) continue;
                rows.add(i);
            }
            if (!rows.isEmpty()) {
                int[] row = new int[rows.size()];
                int index = 0;
                Iterator iterator = rows.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    row[index++] = i;
                }
                entryGrid.collapse(row);
            }
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Long defaultOrg = queryParam.getFilter().getLong("org");
        String accountNameField = GLUtil.getAcctNameBySysParam((Long)defaultOrg);
        boolean isBaseCur = this.isBaseCurrency(queryParam.getFilter());
        boolean hasShowPrice = this.isShowPrice();
        for (DynamicObject row : rowData) {
            if (row.getDynamicObject("accountid") != null && row.getDynamicObject("accountid").getLong("id") != 0L) {
                String dc;
                DynamicObject account = row.getDynamicObject("accountid");
                BigDecimal beginAmount = row.getBigDecimal("beginlocal");
                BigDecimal endAmount = row.getBigDecimal("endlocal");
                if (beginAmount == null || GLUtil.isZero((BigDecimal)beginAmount)) {
                    row.set("begindc", (Object)"0");
                } else if (account != null) {
                    dc = account.getString("dc");
                    row.set("begindc", (Object)dc);
                    if (dc.equals("-1")) {
                        row.set("beginfor", (Object)row.getBigDecimal("beginfor").negate());
                        row.set("beginlocal", (Object)row.getBigDecimal("beginlocal").negate());
                        row.set("beginqty", (Object)row.getBigDecimal("beginqty").negate());
                    }
                }
                if (endAmount == null || GLUtil.isZero((BigDecimal)endAmount)) {
                    row.set("enddc", (Object)"0");
                } else if (account != null) {
                    dc = account.getString("dc");
                    row.set("enddc", (Object)dc);
                    if (dc.equals("-1")) {
                        row.set("endfor", (Object)row.getBigDecimal("endfor").negate());
                        row.set("endlocal", (Object)row.getBigDecimal("endlocal").negate());
                        row.set("endqty", (Object)row.getBigDecimal("endqty").negate());
                    }
                }
                if (row.getInt("rowtype") == 1 && account != null) {
                    row.set("accountnumber", (Object)account.getString("number"));
                    row.set("accountname", (Object)(account == null ? "" : account.getString(accountNameField)));
                }
                if (!hasShowPrice) continue;
                String field = "begin#,debit#,credit#,yeardebit#,yearcredit#,end#";
                this.setPrice(isBaseCur, row, field);
                continue;
            }
            row.set("accountnumber", (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AssistTotalTreeFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            row.set("accountname", (Object)"");
            row.set("measureunitid", null);
        }
        boolean showQty = filterInfo.getBoolean("showqty");
        List<String> amountTypes = this.getAmountType(rowData.getDynamicObjectType().getProperties(), showQty);
        ShowByAccountDCParam param = new ShowByAccountDCParam(defaultOrg, Long.valueOf(queryParam.getFilter().getLong("accounttable")));
        param.setMergeDebitAndCreditCol(Boolean.TRUE);
        param.setAmountTypes(amountTypes);
        param.addBalAndDCField("begin", "begindc");
        param.addBalAndDCField("end", "enddc");
        ReportUtils.showRowDataByActDC((ShowByAccountDCParam)param, (DynamicObjectCollection)rowData);
    }

    private boolean isShowPrice() {
        boolean showQty = this.getQueryParam().getFilter().getBoolean("showqty");
        if (!showQty) {
            return false;
        }
        Long orgId = this.getParentOrg();
        Boolean showPrice = (Boolean)GLUtil.getSystemParam((String)"p_showprice", (Long)orgId);
        return showPrice == null ? false : showPrice;
    }

    private Object getOrgId() {
        String orgStr = this.getPageCache().get("_parentOrg");
        Object orgId = kd.bos.util.StringUtils.isEmpty((String)orgStr) ? this.getModel().getValue("org_id") : Long.valueOf(Long.parseLong(orgStr));
        return orgId;
    }

    private boolean isBaseCurrency(FilterInfo filter) {
        AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)((Long)this.getOrgId()), (long)filter.getLong("booktype"));
        String currencyId = filter.getString("currency");
        String baseCurrencyId = String.valueOf(book.getBaseCurrencyId());
        return currencyId != null && (currencyId.equals(baseCurrencyId) || currencyId.equals("basecurrency"));
    }

    private void setPrice(boolean isBaseCur, DynamicObject row, String field) {
        String suffix = "local";
        if (!isBaseCur) {
            suffix = "for";
        }
        for (String str : field.split(",")) {
            String qty = str.replace("#", "qty");
            BigDecimal qtyBig = row.getBigDecimal(qty);
            if (qtyBig.compareTo(BigDecimal.ZERO) == 0) continue;
            String original = str.replace("#", suffix);
            String price = str.replace("#", "price");
            BigDecimal priceB = row.getBigDecimal(original).divide(qtyBig, 10, 4);
            row.set(price, (Object)priceB);
        }
    }

    private Long getParentOrg() {
        String parentOrg = this.getPageCache().get("_parentOrg");
        if (StringUtils.isBlank((CharSequence)parentOrg)) {
            return 0L;
        }
        return Long.valueOf(parentOrg);
    }

    private List<String> getAmountType(DataEntityPropertyCollection propertys, boolean showQty) {
        ArrayList<String> amountTypes = new ArrayList<String>();
        amountTypes.add("local");
        if (propertys.containsKey((Object)"beginfor")) {
            amountTypes.add("for");
        }
        if (showQty && propertys.containsKey((Object)"beginqty")) {
            amountTypes.add("qty");
        }
        return amountTypes;
    }

    FlexHandler getFlexHandler() {
        return new FlexHandler((ReportView)this.getView());
    }
}

