/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.gl.balancecarryover.AssistDifferentMsgContext;
import kd.fi.gl.balancecarryover.BalanceCarryOverContext;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;

public class BalanceCarryOverReportPlugin
extends AbstractReportFormPlugin {
    private static final String SELECT_ALL = "selectall";
    private static final String CANCLE_SELECT = "cancleselect";
    private static final String TOOLBARAP = "toolbarap";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TOOLBARAP});
        BasedataEdit period = (BasedataEdit)this.getControl("startperiod");
        period.addBeforeF7SelectListener(evt -> {
            QFilter filter;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = param.getListFilterParameter().getQFilters();
            Long orgId = (Long)this.getModel().getValue("org_id");
            Long bookType = (Long)this.getModel().getValue("booktype_id");
            if (orgId != 0L && bookType != 0L && (filter = this.getPeriodFilter(orgId, bookType)) != null) {
                qFilters.add(filter);
            }
        });
    }

    private QFilter getPeriodFilter(long orgId, long bookTypeId) {
        DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"curperiod", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("bookstype", "=", (Object)bookTypeId)});
        if (book == null) {
            return null;
        }
        long curPeriodid = book.getLong("curperiod");
        QFilter filter = new QFilter("id", ">=", (Object)curPeriodid);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org", "=", (Object)orgId);
        qfBuilder.add("booktype", "=", (Object)bookTypeId);
        ArrayList<Long> openPeriods = new ArrayList<Long>(4);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_openedperiod", (String)"period", (QFilter[])qfBuilder.toArray(), null);){
            for (Row row : ds) {
                openPeriods.add(row.getLong("period"));
            }
        }
        if (openPeriods != null && openPeriods.size() > 0) {
            filter.or(new QFilter("id", "in", openPeriods));
        }
        return filter;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("genvoucher".equals(key)) {
            ReportList reportList = (ReportList)this.getControl("reportlistap");
            if (reportList.getReportCache().getProgress(this.getView().getPageId()) < 100) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u67e5\u8be2\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"BalanceCarryOverReportPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            ReportListModel reportModel = (ReportListModel)reportList.getReportModel();
            DynamicObjectCollection selectedRowDynCol = reportModel.getRowData(0, reportModel.getRowCount(), true);
            if (selectedRowDynCol.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u751f\u6210\u51ed\u8bc1\u3002", (String)"BalanceCarryOverReportPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<BalanceCarryOverContext> balanceContexts = new ArrayList<BalanceCarryOverContext>(selectedRowDynCol.size());
            int[] accountType = new int[]{0, 0, 0};
            for (DynamicObject rowDyn : selectedRowDynCol) {
                DynamicObject account = rowDyn.getDynamicObject("accountnumber");
                if (!this.isSameAccountType(accountType, account)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u73b0\u91d1\u6d41\u91cf\u8868\u7684\u51c6\u786e\u6027\uff0c\u73b0\u91d1\u548c\u975e\u73b0\u91d1\u79d1\u76ee\u3001\u635f\u76ca\u548c\u975e\u635f\u76ca\u79d1\u76ee\u4e0d\u53ef\u4ee5\u751f\u6210\u4e00\u5f20\u4f59\u989d\u7ed3\u8f6c\u51ed\u8bc1\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u540e\u518d\u8bd5\u3002", (String)"BalanceCarryOverReportPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                balanceContexts.add(this.createBalanceContext(rowDyn));
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("gl_genvch_carryover");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("contexts", balanceContexts);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "gl_genvch_carryover"));
            this.getView().showForm(parameter);
        }
    }

    private boolean isSameAccountType(int[] accountType, DynamicObject account) {
        if (GLUtil.isCashAcct((DynamicObject)account)) {
            accountType[0] = 1;
        } else if (!"0".equals(account.getString("pltype"))) {
            accountType[1] = 1;
        } else {
            accountType[2] = 1;
        }
        return accountType[0] + accountType[1] + accountType[2] != 2;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object voucherId = closedCallBackEvent.getReturnData();
        if (voucherId != null) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId("gl_voucher");
            parameter.setPkId(voucherId);
            parameter.setBillStatus(BillOperationStatus.EDIT);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private BalanceCarryOverContext createBalanceContext(DynamicObject row) {
        this.getModel().getValue("startperiod");
        ReportQueryParam queryParam = this.getView().getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        long accountTableId = filter.getLong("accounttable");
        long startPeriodId = filter.getLong("startperiod");
        BalanceCarryOverContext balanceCarryOver = new BalanceCarryOverContext();
        balanceCarryOver.setBalanceId(row.getLong("id"));
        balanceCarryOver.setOrgId(row.getLong("orgid_id"));
        balanceCarryOver.setBookTypeId(row.getLong("booktypeid_id"));
        balanceCarryOver.setAccountTableId(accountTableId);
        balanceCarryOver.setAccountMasterId(row.getDynamicObject("accountnumber").getLong("masterid"));
        balanceCarryOver.setAssgrpId(row.getLong("flexfield_id"));
        balanceCarryOver.setCurrencyId(row.getLong("currencyid_id"));
        balanceCarryOver.setLocalCurrencyId(row.getLong("currencylocalid_id"));
        balanceCarryOver.setSearchPeriodId(startPeriodId);
        balanceCarryOver.setDebitFor(row.getBigDecimal("debitfor"));
        balanceCarryOver.setCreditFor(row.getBigDecimal("creditfor"));
        balanceCarryOver.setDebitLocal(row.getBigDecimal("debitlocal"));
        balanceCarryOver.setCreditLocal(row.getBigDecimal("creditlocal"));
        balanceCarryOver.setPeriodId(row.getLong("periodid"));
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        for (int i = 1; i <= size; ++i) {
            String property = "comassist" + i + "id";
            if (row.containsProperty(property)) {
                balanceCarryOver.addComassistId(Long.valueOf(row.getLong(property + "_id")));
                continue;
            }
            balanceCarryOver.addComassistId(Long.valueOf(0L));
        }
        String assistDif = row.getString("assistdifferentmsg");
        AssistDifferentMsgContext assDif = null;
        try {
            assDif = (AssistDifferentMsgContext)JSONUtils.cast((String)assistDif, AssistDifferentMsgContext.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        balanceCarryOver.setAssistDifferentMsg(assDif);
        return balanceCarryOver;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        List items;
        FilterInfo filterInfo = queryParam.getFilter();
        FilterItemInfo bizTypeInfo = filterInfo.getFilterItem("biztype");
        Object bizType = bizTypeInfo.getValue();
        if (bizType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"BalanceCarryOverReportPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        String[] typeArray = bizType.toString().split(",");
        List<String> bizTypes = Arrays.asList(typeArray);
        if (bizTypes.contains("3") && ((items = filterInfo.getFlexFilterItems()) == null || items.size() == 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u9009\u62e9\u201c\u6811\u5f62\u57fa\u7840\u8d44\u6599\u589e\u52a0\u4e0b\u7ea7\u201d\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u4e00\u4e2a\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u9009\u62e9\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"BalanceCarryOverReportPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.setSelectedAll(true);
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject org = (DynamicObject)filterInfo.getFilterItem("org").getValue();
        DynamicObject bookType = (DynamicObject)filterInfo.getFilterItem("booktype").getValue();
        Optional assistTable = ComAssistTable.get((Long)org.getLong("id"), (Long)bookType.getLong("id"));
        List comassist = ((ComAssistTable)assistTable.get()).getCommonAssists();
        boolean showcomassist = !comassist.isEmpty();
        this.getQueryParam().getFilter().getFilterItem("showcomassist").setValue((Object)showcomassist);
    }
}

