/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.report.AssistRptFilterPlugin;
import kd.fi.gl.report.OrgType;
import kd.fi.gl.report.ReportFormUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import org.apache.commons.collections4.MapUtils;

public class CashFlowFormRpt
extends AssistRptFilterPlugin {
    public static final String IS_FROM_HYPER = "isFromHyper";
    private static final String FSEQ = "fseq";
    private String[] s = new String[]{ResManager.loadKDString((String)"\u4e00\u3001", (String)"CashFlowFormRpt_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c\u3001", (String)"CashFlowFormRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09\u3001", (String)"CashFlowFormRpt_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db\u3001", (String)"CashFlowFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e94\u3001", (String)"CashFlowFormRpt_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516d\u3001", (String)"CashFlowFormRpt_5", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e03\u3001", (String)"CashFlowFormRpt_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516b\u3001", (String)"CashFlowFormRpt_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e5d\u3001", (String)"CashFlowFormRpt_8", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u3001", (String)"CashFlowFormRpt_9", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u4e00\u3001", (String)"CashFlowFormRpt_10", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u4e8c\u3001", (String)"CashFlowFormRpt_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u4e09\u3001", (String)"CashFlowFormRpt_12", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u56db\u3001", (String)"CashFlowFormRpt_13", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u4e94\u3001", (String)"CashFlowFormRpt_14", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u516d\u3001", (String)"CashFlowFormRpt_15", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u4e03\u3001", (String)"CashFlowFormRpt_16", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u516b\u3001", (String)"CashFlowFormRpt_17", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u4e5d\u3001", (String)"CashFlowFormRpt_18", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c\u5341\u3001", (String)"CashFlowFormRpt_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c\u5341\u4e00\u3001", (String)"CashFlowFormRpt_20", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c\u5341\u4e8c\u3001", (String)"CashFlowFormRpt_21", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c\u5341\u4e09\u3001", (String)"CashFlowFormRpt_22", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c\u5341\u56db\u3001", (String)"CashFlowFormRpt_23", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c\u5341\u4e94\u3001", (String)"CashFlowFormRpt_24", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c\u5341\u516d\u3001", (String)"CashFlowFormRpt_25", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c\u5341\u4e03\u3001", (String)"CashFlowFormRpt_26", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c\u5341\u516b\u3001", (String)"CashFlowFormRpt_27", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c\u5341\u4e5d\u3001", (String)"CashFlowFormRpt_28", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09\u5341\u3001", (String)"CashFlowFormRpt_29", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09\u5341\u4e00\u3001", (String)"CashFlowFormRpt_30", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09\u5341\u4e8c\u3001", (String)"CashFlowFormRpt_31", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09\u5341\u4e09\u3001", (String)"CashFlowFormRpt_32", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09\u5341\u56db\u3001", (String)"CashFlowFormRpt_33", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09\u5341\u4e94\u3001", (String)"CashFlowFormRpt_34", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09\u5341\u516d\u3001", (String)"CashFlowFormRpt_35", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09\u5341\u4e03\u3001", (String)"CashFlowFormRpt_36", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09\u5341\u516b\u3001", (String)"CashFlowFormRpt_37", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09\u5341\u4e5d\u3001", (String)"CashFlowFormRpt_38", (String)"fi-gl-formplugin", (Object[])new Object[0])};
    private static final Log logger = LogFactory.getLog(CashFlowFormRpt.class);
    public static final String EXPORTEXCEL = "exportexcel";
    public static final String COUNT = "count";
    public static final String EXPORT_ITEM_MAP = "exportItemMap";
    private static final String FIELD_NAME = "fieldname";
    public static final String REMOVE_VERSION_NAME = "removeVersionName";
    public static final String VERSION_ITEM = "versionItem";
    private static final String ITEM_LONGNUMBER = "cfitemid.longnumber";
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.report);

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        ReportList control = (ReportList)this.getControl("reportlistap");
        FilterInfo filter = this.getQueryParam().getFilter();
        boolean isQueryByPeriod = filter.getBoolean("isquerybyperiod");
        boolean isShowAssist = filter.getBoolean("showassist");
        boolean isUnShowInsideCf = filter.getBoolean("unshowinsidecf");
        boolean isOnlyShowInsideCf = filter.getBoolean("onlyshowinsidecf");
        control.addHyperClickListener(e -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
            IReportListModel listModel = control.getReportModel();
            DynamicObject rowData = listModel.getRowData(rowIndex);
            String name = e.getFieldName();
            String number = rowData.getString("number");
            String cfItemName = rowData.getString("name");
            long orgId = rowData.getLong("orgid_id");
            Map<String, Long> comassistVals = filter.getBoolean("showcomassist") ? this.getComassistVals(rowData) : null;
            Set<Object> assgrpSet = new HashSet(8);
            boolean isOrgAssgrp = false;
            if (isShowAssist) {
                if (rowIndex == 1 || !number.equals(listModel.getRowData(rowIndex - 1).getString("number")) || number.equals(listModel.getRowData(rowIndex - 1).getString("number")) && !listModel.getRowData(rowIndex - 1).getBoolean("isleaf") || filter.getBoolean("showorg") && number.equals(listModel.getRowData(rowIndex - 1).getString("number")) && listModel.getRowData(rowIndex - 1).getLong("orgid_id") != orgId) {
                    DynamicObject row;
                    int rowCount = listModel.getRowCount();
                    for (int i = rowIndex + 1; i < rowCount && number.equals((row = listModel.getRowData(i)).getString("number")) && orgId == row.getLong("orgid_id"); ++i) {
                        assgrpSet.add(row.getLong("assgrp_id"));
                    }
                    isOrgAssgrp = true;
                } else {
                    assgrpSet.add(rowData.getLong("assgrp_id"));
                    if (listModel.getRowData(rowIndex - 1).getLong("orgid_id") == orgId) {
                        isOrgAssgrp = true;
                    }
                }
            } else if (isUnShowInsideCf || isOnlyShowInsideCf) {
                assgrpSet = this.getIntAssgrp(filter, orgId, rowData.getLong("cfitemid_id"));
            }
            boolean isleaf = rowData.getBoolean("isleaf");
            if (cfItemName != null && rowData.getBoolean("isprefit")) {
                if (isQueryByPeriod) {
                    this.showAccountBalance(cfItemName, rowData);
                } else {
                    this.showDailyAccountBalance(cfItemName, rowData);
                }
            } else if (this.isShowAccBal(number)) {
                if (isQueryByPeriod) {
                    this.showAccountBalance(cfItemName, rowData);
                } else {
                    this.showDailyAccountBalance(cfItemName, rowData);
                }
            } else if (this.isShowCFItem(number, orgId, assgrpSet.size() == 0 ? 0L : (Long)assgrpSet.iterator().next(), isleaf, comassistVals, cfItemName)) {
                this.showCFItem(number, name, orgId, assgrpSet, rowData, filter, comassistVals, isOrgAssgrp);
            }
        });
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"labelperiod", "labeldate"});
        Optional<DynamicObject> minStartPeriodOptional = this.getMinStartPeriod();
        minStartPeriodOptional.ifPresent(minStartPeriod -> {
            long minStartPeriodId = minStartPeriod.getLong("id");
            ((BasedataEdit)this.getControl("startperiod")).addBeforeF7SelectListener(e -> e.getCustomQFilters().add(new QFilter("id", ">=", (Object)minStartPeriodId)));
            ((BasedataEdit)this.getControl("endperiod")).addBeforeF7SelectListener(e -> e.getCustomQFilters().add(new QFilter("id", ">=", (Object)minStartPeriodId)));
            ((DateRangeEdit)this.getControl("daterange")).setMinDate(minStartPeriod.getDate("begindate"));
        });
    }

    private Optional<DynamicObject> getMinStartPeriod() {
        DynamicObject orgDyn = (DynamicObject)this.getModel().getValue("org");
        DynamicObject booktypeDyn = (DynamicObject)this.getModel().getValue("booktype");
        DynamicObject periodtypeDyn = (DynamicObject)this.getModel().getValue("periodtype");
        if (orgDyn != null && booktypeDyn != null && periodtypeDyn != null) {
            long startPeriod;
            Set orgIds = BDUtil.getAllChildrenOrgIds((long)orgDyn.getLong("id"), (boolean)true);
            QFilter orgQf = new QFilter("org", "in", (Object)orgIds);
            QFilter bookTypeQf = new QFilter("bookstype", "=", (Object)booktypeDyn.getLong("id"));
            QFilter periodtypeQf = new QFilter("periodtype", "=", (Object)periodtypeDyn.getLong("id"));
            DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_accountbook", (String)"cashinitperiod,startperiod", (QFilter[])new QFilter[]{orgQf, bookTypeQf, periodtypeQf}, (String)"cashinitperiod,startperiod");
            DataSet cashinitDs = ds.copy().filter("cashinitperiod > 0");
            if (!cashinitDs.isEmpty()) {
                Row row = (Row)cashinitDs.iterator().next();
                startPeriod = row.getLong("cashinitperiod");
            } else {
                Row row = (Row)ds.iterator().next();
                startPeriod = row.getLong("startperiod");
            }
            return Optional.ofNullable(BusinessDataServiceHelper.loadSingleFromCache((Object)startPeriod, (String)"bd_period"));
        }
        return Optional.empty();
    }

    private Set<Long> getIntAssgrp(FilterInfo filter, long orgId, long cfItemId) {
        Long periodId;
        Map<String, List<String>> flexfieldMap = this.getBaseFlwxfield();
        List customerFlexfield = flexfieldMap.getOrDefault("bd_customer", new ArrayList());
        List supplierFlexfield = flexfieldMap.getOrDefault("bd_supplier", new ArrayList());
        List bizpartnerFlexfield = flexfieldMap.getOrDefault("bd_bizpartner", new ArrayList());
        List orgresultFlexfield = flexfieldMap.getOrDefault("bos_org", new ArrayList());
        ArrayList allFlexfield = new ArrayList(customerFlexfield);
        allFlexfield.addAll(supplierFlexfield);
        allFlexfield.addAll(bizpartnerFlexfield);
        allFlexfield.addAll(orgresultFlexfield);
        Set<Long> intCustomer = new HashSet<Long>(16);
        Set<Long> intSupplier = new HashSet<Long>(16);
        Set<Long> intBizpartner = new HashSet<Long>(16);
        Set<Long> intOrgresult = new HashSet<Long>(16);
        HashMap<Long, Set<Long>> baseId2AssgrpId = new HashMap<Long, Set<Long>>(16);
        ArrayList<QFilter> list = new ArrayList<QFilter>(8);
        list.add(new QFilter("org", "=", (Object)(orgId == 0L ? filter.getLong("org") : orgId)));
        list.add(new QFilter("booktype", "=", (Object)filter.getLong("booktype")));
        DynamicObject cashflow = BusinessDataServiceHelper.loadSingleFromCache((Object)cfItemId, (String)"gl_cashflowitem", (String)"masterid");
        list.add(new QFilter("cfitem", "=", (Object)cashflow.getLong("masterid")));
        list.add(new QFilter("assgrp", "!=", (Object)0L));
        list.add(new QFilter("currency", "=", (Object)filter.getLong("currency")));
        Long periodEndId = periodId = Long.valueOf(filter.getLong("startperiod"));
        if (!filter.getBoolean("isquerybyperiod")) {
            DynamicObject periodEnd;
            DynamicObject periodBegin = GLUtil.getPeriodByDate((Date)filter.getDate("datebegin"), (long)filter.getLong("periodtype"));
            if (periodBegin != null) {
                periodId = periodBegin.getLong("id");
            }
            if ((periodEnd = GLUtil.getPeriodByDate((Date)filter.getDate("dateend"), (long)filter.getLong("periodtype"))) != null) {
                periodEndId = periodEnd.getLong("id");
            }
        }
        list.add(new QFilter("endperiod", "in", (Object)PeriodUtil.getPeriodIds((String)">", (Long)periodId)));
        list.add(new QFilter("period", "<=", (Object)periodEndId));
        list.add(new QFilter("period", ">=", (Object)(periodId / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L)));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"CashFlowFormRpt", (String)"gl_cashflow", (String)"assgrp,assgrp.assvals", (QFilter[])list.toArray(new QFilter[0]), (String)"assgrp");){
            long assgrp = 0L;
            for (Row row : ds) {
                if (assgrp != 0L && assgrp == row.getLong("assgrp")) continue;
                assgrp = row.getLong("assgrp");
                Map<String, Object> assgrpValueMap = this.getAssgrpValueMap(row.getString("assgrp.assvals"));
                if (assgrpValueMap == null) continue;
                for (Map.Entry<String, Object> entry : assgrpValueMap.entrySet()) {
                    String flexfield = entry.getKey();
                    if (!allFlexfield.contains(flexfield)) continue;
                    long value = Long.parseLong(entry.getValue().toString());
                    baseId2AssgrpId.compute(value, (k, v) -> {
                        if (v == null) {
                            v = new HashSet<Long>(16);
                        }
                        v.add(row.getLong("assgrp"));
                        return v;
                    });
                    if (customerFlexfield.contains(flexfield)) {
                        intCustomer.add(value);
                        continue;
                    }
                    if (supplierFlexfield.contains(flexfield)) {
                        intSupplier.add(value);
                        continue;
                    }
                    if (bizpartnerFlexfield.contains(flexfield)) {
                        intBizpartner.add(value);
                        continue;
                    }
                    intOrgresult.add(value);
                }
            }
        }
        intCustomer = this.getIntValue("bd_customer", intCustomer);
        intSupplier = this.getIntValue("bd_supplier", intSupplier);
        intBizpartner = this.getIntValue("bd_bizpartner", intBizpartner);
        intOrgresult = this.getIntOrg(intOrgresult, filter.getLong("org"), filter.getLong("orgview"));
        return this.getIntAssgrp(intCustomer, intSupplier, intBizpartner, intOrgresult, baseId2AssgrpId);
    }

    private Map<String, List<String>> getBaseFlwxfield() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(3);
        QFilter sourceF = new QFilter("valuesource", "in", (Object)new String[]{"bd_customer", "bd_supplier", "bos_org", "bd_bizpartner"});
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bd_asstacttype", (String)"valuesource,flexfield", (QFilter[])new QFilter[]{sourceF}, (String)"valuesource");){
            for (Row row : ds) {
                map.compute(row.getString("valuesource"), (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<String>(16);
                    }
                    v.add(row.getString("flexfield"));
                    return v;
                });
            }
        }
        return map;
    }

    private Map<String, Object> getAssgrpValueMap(String assgrpValue) {
        if (assgrpValue == null || assgrpValue.trim().equals("")) {
            return null;
        }
        Map assgrpValueMap = null;
        try {
            assgrpValueMap = (Map)JSONUtils.cast((String)assgrpValue, Map.class);
        }
        catch (IOException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u89e3\u6790\u5f02\u5e38\uff1asassval:%s", (String)"CashFlowFormRpt_51", (String)"fi-gl-formplugin", (Object[])new Object[0]), assgrpValue));
        }
        return assgrpValueMap;
    }

    private Set<Long> getIntValue(String entityName, Set<Long> ids) {
        if (ids.isEmpty()) {
            return ids;
        }
        HashSet<Long> intIds = new HashSet<Long>(16);
        QFilter idf = new QFilter("id", "in", ids);
        QFilter uFilter = new QFilter("internal_company", "!=", (Object)0);
        Map intCustomers = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id", (QFilter[])new QFilter[]{idf, uFilter});
        for (Object key : intCustomers.keySet()) {
            intIds.add(Long.valueOf(key.toString()));
        }
        return intIds;
    }

    private Set<Long> getIntOrg(Set<Long> ids, Long orgId, Long orgViewId) {
        if (ids.isEmpty()) {
            return ids;
        }
        Set childOrgs = AccSysUtil.getChildOrgsByView((Long)orgId, (Long)orgViewId, (String)"gl_rpt_cashflow");
        childOrgs.retainAll(ids);
        return childOrgs;
    }

    private Set<Long> getIntAssgrp(Set<Long> intCustomer, Set<Long> intSupplier, Set<Long> intBizpartner, Set<Long> intOrgresult, Map<Long, Set<Long>> baseId2AssgrpId) {
        HashSet<Long> intAssgrps = new HashSet<Long>(16);
        for (Long id : intCustomer) {
            intAssgrps.addAll((Collection)baseId2AssgrpId.get(id));
        }
        for (Long id : intSupplier) {
            intAssgrps.addAll((Collection)baseId2AssgrpId.get(id));
        }
        for (Long id : intBizpartner) {
            intAssgrps.addAll((Collection<Long>)baseId2AssgrpId.get(id));
        }
        for (Long id : intOrgresult) {
            intAssgrps.addAll((Collection<Long>)baseId2AssgrpId.get(id));
        }
        return intAssgrps;
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        boolean isQueryByPeriod = evt.getFilter().getBoolean("isquerybyperiod");
        if (isQueryByPeriod) {
            StringBuilder sb = new StringBuilder(evt.getFormatedFilterString());
            DynamicObject startperiod = evt.getFilter().getDynamicObject("startperiod");
            if (startperiod != null) {
                String name = startperiod.getString("name");
                sb.append(ResManager.loadKDString((String)";  \u671f\u95f4\uff1a", (String)"CashFlowFormRpt_39", (String)"fi-gl-formplugin", (Object[])new Object[0])).append(name);
                evt.setFormatedFilterString(sb.toString());
            }
        } else {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            StringBuilder sb = new StringBuilder(evt.getFormatedFilterString());
            sb.append(ResManager.loadKDString((String)";  \u65e5\u671f\uff1a", (String)"CashFlowFormRpt_40", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            Date date = (Date)evt.getFilter().getFilterItem("datebegin").getValue();
            if (date != null) {
                sb.append(format.format(date));
            }
            sb.append(" ~ ");
            date = (Date)evt.getFilter().getFilterItem("dateend").getValue();
            if (date != null) {
                sb.append(format.format(date));
            }
            evt.setFormatedFilterString(sb.toString());
        }
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        ReportColumn column = (ReportColumn)packageDataEvent.getSource();
        String fieldKey = column.getFieldKey();
        if ("amount".equals(fieldKey) || "yearamount".equals(fieldKey)) {
            Object formatValue;
            DynamicObject rowData = packageDataEvent.getRowData();
            String number = rowData.getString("number");
            long orgId = rowData.getLong("orgid_id");
            FilterInfo filter = this.getQueryParam().getFilter();
            long assgrp = filter.getBoolean("showassist") ? rowData.getLong("assgrp_id") : 0L;
            boolean isleaf = rowData.getBoolean("isleaf");
            Map<String, Long> comassistVals = filter.getBoolean("showcomassist") ? this.getComassistVals(rowData) : null;
            String name = rowData.getString("name");
            if (!this.isShowAccBal(number) && !this.isShowCFItem(number, orgId, assgrp, isleaf, comassistVals, name) && (formatValue = packageDataEvent.getFormatValue()) != null) {
                if (formatValue instanceof Object[]) {
                    Object[] arr = (Object[])formatValue;
                    packageDataEvent.setFormatValue((Object)("<nolink>" + arr[0]));
                } else {
                    packageDataEvent.setFormatValue((Object)("<nolink>" + formatValue));
                }
            }
        }
    }

    private boolean isShowAccBal(String number) {
        return number != null && number.contains("{");
    }

    private boolean isShowCFItem(String number, long orgId, long assgrp, boolean isleaf, Map<String, Long> comassistVals, String name) {
        if (!isleaf || number == null || number.contains("\u3001")) {
            return false;
        }
        if (!this.getModel().getValue("orgtype").equals(OrgType.ENTITY.getValue())) {
            return orgId != 0L || assgrp != 0L || !CollectionUtils.isEmpty(comassistVals) || kd.bos.util.StringUtils.isEmpty((String)name);
        }
        return true;
    }

    private Map<String, Long> getComassistVals(DynamicObject rowData) {
        long accountTable = (Long)this.getModel().getValue(GLField.id_((String)"accounttable"));
        Map<String, Long> map = ComAssistTable.get((Long)accountTable).getAllCommonAssistKeys().stream().filter(comassist -> rowData.getLong(GLField.id_((String)(comassist + "id"))) != 0L).collect(Collectors.toMap(k -> k, v -> rowData.getLong(GLField.id_((String)(v + "id")))));
        return map;
    }

    private void showCFItem(String cfItemNumber, String name, long orgId, Set<Long> assgrps, DynamicObject rowData, FilterInfo filterInfo, Map<String, Long> comassistVals, boolean isOrgAssgrp) {
        ReportQueryParam param = this.getQueryParam();
        FilterInfo info = param.getFilter();
        boolean isQueryByPeriod = info.getBoolean("isquerybyperiod");
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("gl_cashflowlist");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<String> dateList = new ArrayList<String>();
        DynamicObject period = info.getDynamicObject("startperiod");
        if ("amount".equals(name)) {
            Date begindate = isQueryByPeriod ? period.getDate("begindate") : info.getDate("datebegin");
            dateList.add(format.format(begindate));
        } else {
            DynamicObjectCollection dync;
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            QFilter filter = new QFilter("periodtype", "=", (Object)info.getDynamicObject("periodtype").getLong("id"));
            qFilters.add(filter);
            if (isQueryByPeriod) {
                filter = new QFilter("periodyear", "=", period.get("periodyear"));
            } else {
                DynamicObject periodByDate = GLUtil.getPeriodByDate((Date)info.getDate("dateend"), (long)info.getLong("periodtype"));
                if (periodByDate != null) {
                    filter = new QFilter("periodyear", "=", periodByDate.get("periodyear"));
                }
            }
            qFilters.add(filter);
            if (isQueryByPeriod) {
                qFilters.add(new QFilter("id", "<=", period.getPkValue()));
            }
            if ((dync = QueryServiceHelper.query((String)"bd_period", (String)"id, begindate, enddate", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"begindate")) != null && dync.size() > 0) {
                Date begindate = ((DynamicObject)dync.get(0)).getDate("begindate");
                dateList.add(format.format(begindate));
                if (isQueryByPeriod) {
                    List periodIds = dync.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
                    para.setCustomParam("periods", periodIds);
                }
            }
        }
        Date enddate = isQueryByPeriod ? period.getDate("enddate") : info.getDate("dateend");
        dateList.add(format.format(enddate));
        if (orgId == 0L) {
            para.setCustomParam("org", info.getDynamicObject("org").get("id"));
        } else {
            para.setCustomParam("org", (Object)orgId);
        }
        if (!CollectionUtils.isEmpty(assgrps) && filterInfo.getBoolean("showorg") && orgId != 0L && !isOrgAssgrp) {
            assgrps = assgrps.stream().filter(e -> e != 0L).collect(Collectors.toSet());
        }
        if (!CollectionUtils.isEmpty(assgrps)) {
            if (filterInfo.getBoolean("showassist")) {
                para.setCustomParam("assgrp", assgrps);
            } else if (filterInfo.getBoolean("unshowinsidecf")) {
                para.setCustomParam("showinsidecf", (Object)false);
                para.setCustomParam("intassgrp", assgrps);
            } else if (filterInfo.getBoolean("onlyshowinsidecf")) {
                para.setCustomParam("showinsidecf", (Object)true);
                para.setCustomParam("intassgrp", assgrps);
            }
        }
        HashMultimap comassistMultimap = HashMultimap.create();
        if (MapUtils.isNotEmpty(comassistVals)) {
            comassistVals.forEach((arg_0, arg_1) -> ((Multimap)comassistMultimap).put(arg_0, arg_1));
        } else {
            comassistMultimap.putAll(this.getComassistValuesFromFilter());
        }
        para.setCustomParam("bookeddate", dateList);
        para.setCustomParam("cfitemnumber", (Object)cfItemNumber);
        para.setCustomParam("type", (Object)rowData.getString("type"));
        para.setCustomParam("booktype", (Object)(info.getDynamicObject("booktype").getLong("id") + ""));
        para.setCustomParam("comassist", (Object)comassistMultimap.asMap());
        para.setCustomParam("cfitemlongnumber", (Object)rowData.getString(ITEM_LONGNUMBER));
        Set<String> displayedSubNumbers = this.getDisplayedSubLongNumbers();
        if (!displayedSubNumbers.isEmpty()) {
            para.setCustomParam("sublongnumber", displayedSubNumbers);
        }
        this.getView().showForm((FormShowParameter)para);
    }

    private Set<String> getDisplayedSubLongNumbers() {
        String iterItemLongNumber;
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
        ReportList control = (ReportList)this.getControl("reportlistap");
        IReportListModel reportModel = control.getReportModel();
        HashSet<String> result = new HashSet<String>(1);
        String currentItemLongNumber = (String)reportModel.getValue(currentRowIndex, ITEM_LONGNUMBER);
        while ((iterItemLongNumber = (String)reportModel.getValue(++currentRowIndex, ITEM_LONGNUMBER)) != null && iterItemLongNumber.startsWith(currentItemLongNumber)) {
            if (iterItemLongNumber.equals(currentItemLongNumber)) continue;
            result.add(iterItemLongNumber);
        }
        return result;
    }

    private Multimap<String, Long> getComassistValuesFromFilter() {
        HashMultimap result = HashMultimap.create();
        ComAssistTable comAssistTable = ComAssistTable.get((Long)((Long)this.getModel().getValue(GLField.id_((String)"accounttable"))));
        for (String comassistKey : comAssistTable.getAllCommonAssistKeys()) {
            DynamicObjectCollection comassistValues = this.getModel().getDataEntity().getDynamicObjectCollection(comassistKey);
            if (comassistValues.isEmpty()) continue;
            for (DynamicObject comassistValue : comassistValues) {
                result.put((Object)comassistKey, (Object)comassistValue.getLong("fbasedataid_id"));
            }
        }
        return result;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Label) {
            String key;
            Label label = (Label)source;
            switch (key = label.getKey()) {
                case "labelperiod": {
                    this.showPeriod();
                    break;
                }
                case "labeldate": {
                    this.showDate();
                }
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "close": {
                this.getView().close();
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.showPeriod();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "exportexcel": {
                this.getPageCache().put(EXPORTEXCEL, "true");
                this.cache.put(this.getView().getPageId() + COUNT, "0");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals(EXPORTEXCEL)) {
            this.getPageCache().remove(EXPORTEXCEL);
        }
    }

    private void showDate() {
        IReportView view = this.getView();
        view.setVisible(Boolean.valueOf(false), new String[]{"startperiod"});
        view.setVisible(Boolean.valueOf(true), new String[]{"daterange"});
        this.getModel().setValue("isquerybyperiod", (Object)false);
    }

    private void showPeriod() {
        IReportView view = this.getView();
        view.setVisible(Boolean.valueOf(true), new String[]{"startperiod"});
        view.setVisible(Boolean.valueOf(false), new String[]{"daterange"});
        this.getModel().setValue("isquerybyperiod", (Object)true);
    }

    private void showDailyAccountBalance(String cfItemName, DynamicObject rowData) {
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("gl_rpt_daily");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryParam = this.getABQueryParam(cfItemName, true, rowData);
        parameter.setQueryParam(queryParam);
        parameter.setCustomParam(IS_FROM_HYPER, (Object)Boolean.TRUE);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showAccountBalance(String cfItemName, DynamicObject rowData) {
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("gl_rpt_accountbalance");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryParam = this.getABQueryParam(cfItemName, false, rowData);
        parameter.setQueryParam(queryParam);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private ReportQueryParam getABQueryParam(String cfItemName, Boolean flag, DynamicObject rowData) {
        ReportQueryParam param = this.getQueryParam();
        FilterInfo info = param.getFilter();
        QFilter isCash = new QFilter("iscash", "=", (Object)true).or(new QFilter("isbank", "=", (Object)true));
        QFilter isCashEQ = new QFilter("iscashequivalent", "=", (Object)true);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (cfItemName.contains(ResManager.loadKDString((String)"\u73b0\u91d1\u7b49\u4ef7\u7269", (String)"CashFlowFormRpt_41", (String)"fi-gl-formplugin", (Object[])new Object[0]))) {
            if (cfItemName.contains(ResManager.loadKDString((String)"\u73b0\u91d1\u53ca\u73b0\u91d1\u7b49\u4ef7\u7269", (String)"CashFlowFormRpt_42", (String)"fi-gl-formplugin", (Object[])new Object[0]))) {
                qFilters.add(isCash.or(isCashEQ));
            } else {
                qFilters.add(isCashEQ);
            }
        } else if (cfItemName.contains(ResManager.loadKDString((String)"\u73b0\u91d1", (String)"CashFlowFormRpt_43", (String)"fi-gl-formplugin", (Object[])new Object[0]))) {
            qFilters.add(isCash);
        } else if (rowData.getBoolean("isprefit")) {
            qFilters.add(new QFilter("pltype", "!=", (Object)Character.valueOf('0')));
            qFilters.add(new QFilter("accounttype.accounttype", "not in", Arrays.asList("A", "B", "C")));
        }
        long accountTableId = info.getLong("accounttable");
        long orgId = info.getLong("org");
        long bookTypeId = info.getLong("booktype");
        Set accountIds = AccountUtils.queryAccountIds((long)orgId, (long)accountTableId, qFilters);
        int accountLevel = BusinessDataServiceHelper.loadSingle((Object)accountTableId, (String)"bd_accounttable").getInt("maxlevel");
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("orgview", (Object)info.getLong("orgview"));
        filter.addFilterItem("booktype", (Object)bookTypeId);
        filter.addFilterItem("periodtype", (Object)info.getLong("periodtype"));
        filter.addFilterItem("startperiod", (Object)info.getLong("startperiod"));
        filter.addFilterItem("endperiod", (Object)info.getLong("endperiod"));
        filter.addFilterItem("currency", (Object)"basecurrency");
        filter.addFilterItem("accounttable", (Object)accountTableId);
        filter.addFilterItem("accountlevel", (Object)accountLevel);
        filter.addFilterItem("account", (Object)accountIds);
        filter.addFilterItem("issubstractpl", (Object)true);
        if (flag.booleanValue()) {
            filter.addFilterItem("org", (Object)orgId);
            filter.addFilterItem("datebegin", (Object)info.getDate("datebegin"));
            filter.addFilterItem("dateend", (Object)info.getDate("dateend"));
        } else {
            filter.addFilterItem("orgs", (Object)orgId);
        }
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        return queryParam;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.setItemLevel(this.getModel().getValue("org_id"));
        this.resetStartPeriod();
        this.setComassistFilds();
        this.setVisibleAssistEntry();
    }

    private void setItemLevel(Object orgId) {
        int max = GLUtil.getCFItemMaxLevel((Object)orgId);
        List com = ReportFormUtil.createItemList((int)max);
        if (com != null && !com.isEmpty()) {
            ComboEdit levelEdit = (ComboEdit)this.getControl("itemlevel");
            levelEdit.setComboItems(com);
            this.getModel().setValue("itemlevel", (Object)((ComboItem)com.get(max - 1)).getValue());
        }
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        IReportView view = this.getView();
        if (queryParam == null || queryParam.getFilter() == null) {
            return false;
        }
        FilterInfo filterInfo = queryParam.getFilter();
        GlFormUtil.setSelectedFlexItems(this.getModel(), (EntryGrid)this.getControl("entryentity"), filterInfo);
        String itemlevel = filterInfo.getString("itemlevel");
        if (itemlevel == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9879\u76ee\u7ea7\u6b21\u3002", (String)"CashFlowFormRpt_45", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (OrgType.VIRTUAL_M.getValue().equals(filterInfo.getString("orgtype"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u865a\u4f53\u4e0b\u7684\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u4e0d\u540c\uff0c\u65e0\u6cd5\u67e5\u8be2\u3002", (String)"CashFlowFormRpt_46", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean isQueryByPeriod = queryParam.getFilter().getBoolean("isquerybyperiod");
        if (isQueryByPeriod) {
            DynamicObject period = filterInfo.getDynamicObject("startperiod");
            if (period == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u671f\u95f4\u3002", (String)"CashFlowFormRpt_47", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (filterInfo.getDate("datebegin") == null || filterInfo.getDate("dateend") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65e5\u671f\u3002", (String)"CashFlowFormRpt_48", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.beforeQuerySetParam(queryParam);
        this.cache.remove(this.getView().getPageId() + COUNT);
        this.cache.remove(this.getView().getPageId() + EXPORT_ITEM_MAP);
        return true;
    }

    @Override
    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        this.setItemLevel(scheme.getLong("org_id"));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        if (value == null) {
            return;
        }
        IDataModel model = this.getModel();
        if ("startperiod".equals(propertyName)) {
            DynamicObject period = (DynamicObject)value;
            model.setValue("endperiod", value);
            this.setDate(period);
        } else if ("org".equals(propertyName)) {
            DynamicObject org = (DynamicObject)value;
            this.setItemLevel(org.getPkValue());
            this.resetStartPeriod();
        } else if ("booktype".equals(propertyName)) {
            this.resetStartPeriod();
        } else if ("datebegin".equals(propertyName)) {
            Date dateBegin = (Date)value;
            Date dateEnd = (Date)this.getModel().getValue("dateend");
            if (dateEnd == null || dateEnd.before(dateBegin)) {
                this.getModel().setValue("dateend", (Object)dateBegin);
            }
        } else if ("dateend".equals(propertyName)) {
            Date dateEnd = (Date)value;
            Date dateBegin = (Date)this.getModel().getValue("datebegin");
            if (dateBegin == null || dateBegin.after(dateEnd)) {
                this.getModel().setValue("datebegin", (Object)dateEnd);
            }
        } else if ("unshowinsidecf".equals(propertyName)) {
            model.beginInit();
            model.setValue("onlyshowinsidecf", (Object)false);
            model.endInit();
            this.getView().updateView("onlyshowinsidecf");
        } else if ("onlyshowinsidecf".equals(propertyName)) {
            model.beginInit();
            model.setValue("unshowinsidecf", (Object)false);
            model.endInit();
            this.getView().updateView("unshowinsidecf");
        } else if ("accounttable".equals(propertyName)) {
            this.setComassistFilds();
        } else if (FIELD_NAME.equals(propertyName)) {
            model.setValue("textinput", null, e.getChangeSet()[0].getRowIndex());
            this.setVisibleAssistEntry();
        }
    }

    private void resetStartPeriod() {
        DynamicObject period = (DynamicObject)this.getModel().getValue("startperiod");
        Optional<DynamicObject> minStartPeriodDynOptional = this.getMinStartPeriod();
        if (minStartPeriodDynOptional.isPresent() && period != null && minStartPeriodDynOptional.get().getLong("id") > period.getLong("id")) {
            this.getModel().setValue("startperiod", (Object)minStartPeriodDynOptional.get().getLong("id"));
            period = (DynamicObject)this.getModel().getValue("startperiod");
        }
        this.setDate(period);
    }

    protected void cleanComAssistValue() {
        Set<String> comAssistFields = this.getModel().getDataEntityType().getAllFields().keySet().stream().filter(field -> field.startsWith("comassist")).collect(Collectors.toSet());
        comAssistFields.forEach(comAssistField -> {
            Object value = this.getModel().getValue(comAssistField);
            if (Objects.nonNull(value)) {
                this.getModel().setValue(comAssistField, null);
            }
        });
    }

    private void setDate(DynamicObject period) {
        if (period == null) {
            return;
        }
        Date begindate = (Date)period.get("begindate");
        Date enddate = (Date)period.get("enddate");
        this.getModel().setValue("datebegin", (Object)begindate);
        this.getModel().setValue("dateend", (Object)enddate);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        long endPeriodId;
        long orgId;
        String pageId;
        logger.info("processRowData----start--rowData:" + rowData.size() + "gridPK:" + gridPK);
        FilterInfo filter = queryParam.getFilter();
        if (this.getView() != null) {
            pageId = this.getView().getPageId();
            orgId = (Long)this.getModel().getValue("org_id");
            endPeriodId = this.getEndPeriod(filter);
        } else {
            pageId = (String)queryParam.getCustomParam().get("pageId");
            orgId = (Long)queryParam.getCustomParam().get("orgId");
            endPeriodId = (Long)queryParam.getCustomParam().get("endPeriodId");
        }
        HashMap<String, String> accMap = new HashMap<String, String>();
        accMap.put("number", "");
        if (CashFlowFormRpt.existOrg(filter)) {
            accMap.put("orgid_id", "");
        }
        List exportCfitemNames = (List)this.getCache(EXPORT_ITEM_MAP, pageId, new ArrayList());
        String cacheCount = this.cache.get(pageId + COUNT);
        boolean isFirstPageRows = !rowData.isEmpty() && ((DynamicObject)rowData.get(0)).getInt(FSEQ) == 1;
        int count = cacheCount == null || isFirstPageRows ? 0 : Integer.parseInt(cacheCount);
        for (DynamicObject obj : rowData) {
            Map<String, Long> comassistVals;
            this.setStyle(obj);
            count = this.setPrefixNumber(count, obj, exportCfitemNames);
            obj.set("rownumber", (Object)obj.getInt(FSEQ));
            Map<String, Long> map = comassistVals = filter.getBoolean("showcomassist") ? this.getComassistVals(obj) : null;
            if (this.getPageCache() != null && this.getPageCache().get(EXPORTEXCEL) != null) continue;
            for (Map.Entry entry : accMap.entrySet()) {
                String newValue;
                String key = (String)entry.getKey();
                if ("orgid_id".equals(key)) {
                    newValue = String.valueOf(obj.get(key));
                    if (((String)entry.getValue()).equals(newValue)) {
                        obj.set(key.replace("_id", ""), null);
                    }
                } else {
                    if (obj.get("cfitemid") == null) continue;
                    newValue = String.valueOf(obj.get("name"));
                    if (((String)entry.getValue()).equals(newValue)) {
                        if (key.endsWith("_id")) {
                            obj.set(key.replace("_id", ""), null);
                        } else {
                            obj.set("name", (Object)"");
                        }
                    }
                }
                accMap.put(key, newValue);
            }
            if (this.getView() == null || obj.getBigDecimal("yearamount") == null && obj.getBigDecimal("amount") == null) continue;
            String number = obj.getString("number");
            long assgrp = filter.getBoolean("showassist") ? obj.getLong("assgrp_id") : 0L;
            boolean isleaf = obj.getBoolean("isleaf");
            if (this.isShowAccBal(obj.getString("number")) || this.isShowCFItem(number, obj.getLong("orgid_id"), assgrp, isleaf, comassistVals, obj.getString("name"))) continue;
            obj.set("isleaf", (Object)false);
        }
        this.cache.put(pageId + COUNT, count + "");
        if (this.getPageCache() != null && this.getPageCache().get(EXPORTEXCEL) != null) {
            this.putCache(EXPORT_ITEM_MAP, pageId, exportCfitemNames);
        }
        logger.info("processRowData----end");
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        queryParam.getCustomParam().put("flexorgidfield", "flexorgid");
    }

    @Override
    protected String[] getAssistValueType() {
        return new String[]{"1", "2", "3"};
    }

    @Override
    protected void setAssistTxtValue(IDataModel model, int i, FilterItemInfo item) {
        String value = (String)model.getValue("textinput", i);
        if (StringUtils.isEmpty((CharSequence)value.trim())) {
            item.setValue(new HashSet(0));
            return;
        }
        HashSet<String> idList = new HashSet<String>();
        idList.add(value.trim());
        item.setValue(idList);
    }

    private int setPrefixNumber(int count, DynamicObject obj, List<String> exportCfitemNames) {
        String oldName = obj.getString("name");
        if (obj.getInt("level") == 1) {
            int length;
            String newPrefix;
            if (exportCfitemNames.contains(oldName)) {
                return count;
            }
            if (!oldName.contains((newPrefix = this.getNumber(count++)).substring(0, (length = newPrefix.length()) - 1))) {
                obj.set("name", (Object)(newPrefix + oldName));
                exportCfitemNames.add(oldName);
            }
        }
        return count;
    }

    private static boolean existOrg(FilterInfo filter) {
        return filter.getBoolean("showorg");
    }

    private void setStyle(DynamicObject obj) {
        int level = obj.getInt("level");
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < level; ++i) {
            sb.append("\t");
        }
        sb.append(obj.getString("name"));
        obj.set("name", (Object)sb.toString());
    }

    private String getNumber(int i) {
        return this.s[i % this.s.length];
    }

    private void setComassistFilds() {
        long accountTable = (Long)this.getModel().getValue(GLField.id_((String)"accounttable"));
        if (accountTable > 0L) {
            ComAssistTable comAssistTable = ComAssistTable.get((Long)accountTable);
            ComAssistTableService.modifyCommonAssistFields((ComAssistTable)comAssistTable, (IFormView)this.getView());
            this.cleanComAssistValue();
        }
    }

    private Object getCache(String cacheKey, String pageId, Object result) {
        String cacheValue = this.cache.get(pageId + cacheKey);
        if (kd.bos.util.StringUtils.isNotEmpty((String)cacheValue)) {
            result = SerializationUtils.fromJsonString((String)cacheValue, result.getClass());
        }
        return result;
    }

    private void putCache(String cacheKey, String pageId, Object value) {
        if (!ObjectUtils.isEmpty((Object)value)) {
            this.cache.put(pageId + cacheKey, SerializationUtils.toJsonString((Object)value));
        }
    }

    private long getEndPeriod(FilterInfo filter) {
        long period = 0L;
        if (filter.getBoolean("isquerybyperiod")) {
            period = filter.getLong("endperiod");
        } else {
            Long periodTypeId = filter.getLong("periodtype");
            Date endDate = filter.getDate("dateend");
            DynamicObject dyn = GLUtil.getPeriodByDate((Date)endDate, (long)periodTypeId);
            if (dyn != null) {
                period = dyn.getLong("id");
            }
        }
        return period;
    }

    private void setVisibleAssistEntry() {
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        int size = model.getEntryRowCount("entryentity");
        boolean isManualAssist = false;
        for (int i = 0; i < size; ++i) {
            DynamicObject fieldNameDyn = (DynamicObject)model.getValue(FIELD_NAME, i);
            if (fieldNameDyn == null) continue;
            if (AssistValueType.isManualTxt((String)fieldNameDyn.getString("valuetype"))) {
                isManualAssist = true;
                view.setEnable(Boolean.valueOf(true), i, new String[]{"textinput"});
                view.setEnable(Boolean.valueOf(false), i, new String[]{"value"});
                continue;
            }
            view.setEnable(Boolean.valueOf(true), i, new String[]{"value"});
        }
        view.setVisible(Boolean.valueOf(isManualAssist), new String[]{"textinput"});
    }

    private Set<String> getAllSubLongNumber(String longNumber) {
        ReportQueryParam param = this.getQueryParam();
        FilterInfo filterInfo = param.getFilter();
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)filterInfo.getLong("org"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"longnumber", (QFilter[])new QFilter[]{baseDataFilter, new QFilter("longnumber", "like", (Object)(longNumber + "@%"))});
        return coll.stream().map(m -> m.getString("longnumber")).collect(Collectors.toSet());
    }
}

