/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.text.Format;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.util.DateUtil;

public class CashFlowFormRptPrint
extends AbstractPrintServicePlugin {
    private static final String CURRENCYID = "currencyid";
    private static final String YEARAMOUNT = "yearamount";
    private static final String AMOUNT = "amount";
    private static final String ORG = "org";
    private static final String ROWNUMBER = "rownumber";
    private static final String ASSGRP = "assgrp";
    private static final String SIGN = "sign";
    private FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        String dataSource;
        super.customPrintDataEntities(e);
        List dyns = e.getDataEntities();
        String pageId = e.getPageId();
        ReportListModel listModel = this.getListModel(pageId);
        if (listModel == null) {
            return;
        }
        ReportQueryParam param = listModel.getReportQueryParam();
        FilterInfo filterInfo = param.getFilter();
        switch (dataSource = e.getDataSourceName()) {
            case "gl_rpt_cashflow": {
                DynamicObjectType customDt = new DynamicObjectType("dt");
                customDt.registerProperty("name", String.class, (Object)"", false);
                DynamicObject customD = new DynamicObject(customDt);
                dyns.add(customD);
                e.setDataEntities(dyns);
                break;
            }
            case "head": {
                this.handleHeadDataSource(e, dyns, filterInfo);
                break;
            }
            case "gl_rpt_cashflow_prt": {
                try {
                    int count = listModel.getRowCount();
                    DynamicObjectCollection ds = listModel.getRowData(0, count);
                    if (ds == null || ds.isEmpty()) {
                        return;
                    }
                    this.handleRowDataSource(dyns, filterInfo, ds);
                    e.setDataEntities(dyns);
                    break;
                }
                catch (Exception exp) {
                    throw new BOSException((Throwable)exp);
                }
            }
        }
    }

    private void handleRowDataSource(List<DynamicObject> dyns, FilterInfo filterInfo, DynamicObjectCollection ds) {
        DynamicObjectType customDt = new DynamicObjectType("gl_rpt_cashflow_prt");
        customDt.registerProperty("name", String.class, (Object)"", false);
        customDt.registerProperty(ORG, String.class, (Object)"", false);
        customDt.registerProperty(ASSGRP, String.class, (Object)"", false);
        customDt.registerProperty(ROWNUMBER, String.class, (Object)"", false);
        customDt.registerProperty(AMOUNT, String.class, (Object)"", false);
        customDt.registerProperty(YEARAMOUNT, String.class, (Object)"", false);
        boolean isShowAssgrp = filterInfo.getBoolean("showassist");
        boolean isShowOrg = filterInfo.getBoolean("showorg");
        for (DynamicObject d : ds) {
            DynamicObject assgrpDyn;
            DynamicObject roworg;
            DynamicObject printRow = new DynamicObject(customDt);
            int rowNo = dyns.size() + 1;
            printRow.set(ROWNUMBER, (Object)rowNo);
            this.handelRow(d, printRow);
            if (isShowOrg && (roworg = d.getDynamicObject("orgid")) != null || (assgrpDyn = d.getDynamicObject(ASSGRP)) != null && isShowAssgrp) continue;
            dyns.add(printRow);
        }
    }

    private void handleHeadDataSource(CustomPrintDataEntitiesArgs e, List<DynamicObject> dyns, FilterInfo filterInfo) {
        try {
            String orgName = "";
            Object orgID = filterInfo.getCommFilter("parentOrg").getValue();
            DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter("id", "=", orgID).toArray());
            if (orgDyn != null) {
                orgName = orgDyn.getString("name");
            }
            DynamicObjectType customDt = null;
            customDt = e.getDynamicObjectType();
            DynamicObject customD = new DynamicObject(customDt);
            customD.set(ORG, (Object)orgName);
            customD.set("booktype", (Object)filterInfo.getDynamicObject("booktype").getString("name"));
            Boolean isQueryByPeriod = filterInfo.getBoolean("isquerybyperiod");
            if (isQueryByPeriod.booleanValue()) {
                DynamicObject beginperiodDyn = filterInfo.getDynamicObject("startperiod");
                if (beginperiodDyn != null) {
                    String beginperiod = beginperiodDyn.getString("name");
                    customD.set("period", (Object)beginperiod);
                }
            } else {
                Date dateBegin = filterInfo.getDate("datebegin");
                Date dateEnd = filterInfo.getDate("dateend");
                dateEnd = this.parseDate(dateEnd, false);
                if (dateBegin != null && dateEnd != null) {
                    customD.set("begindate", (Object)TimeServiceHelper.formatDate((Date)dateBegin));
                    customD.set("enddate", (Object)TimeServiceHelper.formatDate((Date)dateEnd));
                    customD.set(SIGN, (Object)"~");
                }
            }
            dyns.add(customD);
        }
        catch (Exception exp) {
            throw new BOSException((Throwable)exp);
        }
        e.setDataEntities(dyns);
    }

    private Date parseDate(Date date, boolean isBeginDay) {
        if (date == null) {
            return null;
        }
        if (isBeginDay) {
            return DateUtil.makeDateOnDayStrart((Date)date);
        }
        return DateUtil.makeDateOnDayEnd((Date)date);
    }

    private void handelRow(DynamicObject d, DynamicObject printRow) {
        if (d == null) {
            return;
        }
        try {
            String cashFlowItem = d.getString("name");
            if (cashFlowItem != null) {
                printRow.set("name", (Object)cashFlowItem.replace("\t", "   "));
            }
            this.handleMoney(d, printRow);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void handleMoney(DynamicObject d, DynamicObject printRow) {
        DynamicObject curDynFor = d.getDynamicObject(CURRENCYID);
        if (curDynFor != null) {
            this.handleMoneyWithCur(d, printRow, curDynFor);
        }
    }

    private void handleMoneyWithCur(DynamicObject d, DynamicObject printRow, DynamicObject curDyn) {
        BigDecimal yearAmount;
        int amtprecision = curDyn.getInt("amtprecision");
        String signStr = curDyn.getString(SIGN) == null ? "" : curDyn.getString(SIGN);
        this.fobj.getCurrencyFormat().setCurrencySymbols(signStr);
        this.fobj.getCurrencyFormat().setMinimumFractionDigits(amtprecision);
        Format format = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(this.fobj);
        BigDecimal amount = d.getBigDecimal(AMOUNT);
        if (amount != BigDecimal.ZERO) {
            printRow.set(AMOUNT, (Object)format.format(amount));
        }
        if ((yearAmount = d.getBigDecimal(YEARAMOUNT)) != BigDecimal.ZERO) {
            printRow.set(YEARAMOUNT, (Object)format.format(yearAmount));
        }
    }

    private ReportListModel getListModel(String pageId) {
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return null;
        }
        ReportList list = view.getReportList();
        ReportListModel listModel = (ReportListModel)list.getReportModel();
        return listModel;
    }
}

