/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportList;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.report.GLRptTemplatePlugin;
import kd.fi.gl.report.NavToAssRpt;
import kd.fi.gl.report.NavToSubLedgerRpt;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;

public class DailyFormRpt
extends GLRptTemplatePlugin
implements ClickListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(evt -> {
            String name = evt.getFieldName();
            int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
            DynamicObject rowData = control.getReportModel().getRowData(rowIndex);
            FilterInfo filter = this.getQueryParam().getFilter();
            Date beginDate = filter.getDate("datebegin");
            Date endDate = filter.getDate("dateend");
            switch (name) {
                case "number": {
                    Long accId = rowData.getLong("number_id");
                    new NavToSubLedgerRpt.SLBuilder(this.getQueryParam(), (IFormView)this.getView()).date(beginDate, endDate).accountId(accId).build().apply();
                    break;
                }
                case "assgrp": {
                    boolean showOrg;
                    Long accId = rowData.getLong("number_id");
                    Long curId = rowData.getLong("currencyid_id");
                    Long assgrp = rowData.getLong("assgrp_id");
                    Long orgId = rowData.getLong("flexorgid_id");
                    Long measureunit = null;
                    if (filter.getBoolean("showqty")) {
                        measureunit = rowData.getLong("measureunit_id");
                    }
                    if (showOrg = filter.getBoolean("showorg")) {
                        ArrayList<QFilter> accountFilterList = new ArrayList<QFilter>(8);
                        accountFilterList.add(new QFilter("startdate", "<=", (Object)endDate));
                        accountFilterList.add(new QFilter("enddate", ">=", (Object)endDate));
                        accountFilterList.add(new QFilter("isassist", "=", (Object)"1"));
                        Map leafAcctIdMap = AccountUtils.getLeafAcctIdById((long)orgId, (long)filter.getLong("accounttable"), Collections.singleton(accId), accountFilterList);
                        if (!CollectionUtils.isEmpty((Map)leafAcctIdMap)) {
                            accId = (Long)((Set)leafAcctIdMap.get(accId)).iterator().next();
                        }
                    }
                    new NavToAssRpt.Builder(this.getQueryParam(), (IFormView)this.getView()).accountId(accId).currencyId(curId).orgId(orgId).measureunitId(measureunit).assgrpId(assgrp).build().apply();
                    break;
                }
                case "orgid": {
                    Long orgId = rowData.getLong("orgid_id");
                    Long accId = rowData.getLong("number_id");
                    Long curId = rowData.getLong("currencyid_id");
                    new NavToSubLedgerRpt.SLBuilder(this.getQueryParam(), (IFormView)this.getView()).accountId(accId).orgId(orgId).date(beginDate, endDate).currencyId(curId).build().apply();
                    break;
                }
                case "currencyid": {
                    Long accId = rowData.getLong("number_id");
                    Long curId = rowData.getLong("currencyid_id");
                    new NavToSubLedgerRpt.SLBuilder(this.getQueryParam(), (IFormView)this.getView()).accountId(accId).currencyId(curId).date(beginDate, endDate).build().apply();
                    break;
                }
            }
        });
    }

    private Date getToday() {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Date today = this.getToday();
        model.setValue("datebegin", (Object)today);
        model.setValue("dateend", (Object)today);
        this.setDateFilter();
    }

    @Override
    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        this.setDateFilter();
        this.dateEndChanged();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        if (value == null) {
            return;
        }
        switch (propertyName) {
            case "org": {
                this.setDateFilter();
                break;
            }
            case "booktype": {
                this.setDateFilter();
                break;
            }
            case "datebegin": {
                Date dateBegin = (Date)value;
                Date dateEnd = (Date)this.getModel().getValue("dateend");
                if (dateEnd != null && !dateEnd.before(dateBegin)) break;
                this.getModel().setValue("dateend", (Object)dateBegin);
                break;
            }
            case "dateend": {
                Date dateEnd = (Date)value;
                Date dateBegin = (Date)this.getModel().getValue("datebegin");
                if (dateBegin == null || dateBegin.after(dateEnd)) {
                    this.getModel().setValue("datebegin", (Object)dateEnd);
                }
                this.dateEndChanged();
                break;
            }
        }
    }

    @Override
    protected Date getEnddate() {
        return (Date)this.getModel().getValue("dateend");
    }

    private void setDateFilter() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("isFromHyper")) {
            return;
        }
        List spFilters = ((BasedataEdit)this.getControl("startperiod")).getQFilters();
        Object stPeriodId = null;
        if (spFilters != null) {
            for (QFilter spFilter : spFilters) {
                if (!"id".equals(spFilter.getProperty())) continue;
                stPeriodId = spFilter.getValue();
                break;
            }
        }
        if (stPeriodId == null) {
            return;
        }
        QFilter qFilter = new QFilter("id", "=", stPeriodId);
        DynamicObject startPeriod = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,begindate", (QFilter[])new QFilter[]{qFilter});
        if (startPeriod == null) {
            return;
        }
        Date minDate = startPeriod.getDate("begindate");
        Date dateBegin = (Date)this.getModel().getValue("datebegin");
        Date dateEnd = (Date)this.getModel().getValue("dateend");
        if (dateBegin.before(minDate)) {
            this.getModel().setValue("datebegin", (Object)minDate);
        }
        if (dateEnd.before(minDate)) {
            this.getModel().setValue("dateend", (Object)minDate);
        }
        DateRangeEdit daterange = (DateRangeEdit)this.getControl("daterange");
        daterange.setMinDate(minDate);
    }

    private void dateEndChanged() {
        long orgId = (Long)this.getModel().getValue("org_id");
        long bookTypeId = (Long)this.getModel().getValue("booktype_id");
        Date endDate = (Date)this.getModel().getValue("dateend");
        long typeId = (Long)this.getModel().getValue("periodtype_id");
        List tableIds = ReportUtils.getVerAcctTable((long)orgId, (long)bookTypeId, (long)typeId, (Date)endDate);
        if (!tableIds.isEmpty()) {
            this.getModel().setValue("accounttable", tableIds.get(0));
            BasedataEdit accountTableEdit = (BasedataEdit)this.getControl("accounttable");
            GlFormUtil.setF7ClickFilter(accountTableEdit, new QFilter("id", "in", (Object)tableIds));
        }
        QFilter fs = new QFilter("begindate", "<=", (Object)endDate);
        QFilter fe = new QFilter("enddate", ">=", (Object)endDate);
        QFilter ftype = new QFilter("periodtype", "=", (Object)typeId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter[]{fs, fe, ftype});
        if (Objects.isNull(period)) {
            DynamicObject periodTypeDynObj = (DynamicObject)this.getModel().getValue("periodtype");
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b[%s] \u4e0d\u5b58\u5728\u67e5\u8be2\u65e5\u671f\u6240\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\uff0c\u8bf7\u5148\u7ef4\u62a4\u671f\u95f4\u57fa\u7840\u8d44\u6599\u3002", (String)"DailyFormRpt_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), periodTypeDynObj.getString("name")));
            return;
        }
        QFilter fsDate = new QFilter("startdate", "<=", (Object)period.getDate("enddate"));
        QFilter feDate = new QFilter("enddate", ">=", (Object)period.getDate("enddate"));
        GlFormUtil.setF7ClickFilter((BasedataEdit)this.getControl("account"), fsDate.and(feDate));
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (!super.verifyQuery(queryParam)) {
            return false;
        }
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo != null) {
            if (filterInfo.getDate("datebegin") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u65e5\u671f\u3002", (String)"DailyFormRpt_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (filterInfo.getDate("dateend") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u675f\u65e5\u671f\u3002", (String)"DailyFormRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (filterInfo.getDate("datebegin").getTime() > filterInfo.getDate("dateend").getTime()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u8be5\u2264\u7ed3\u675f\u65e5\u671f\u3002", (String)"DailyFormRpt_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return false;
            }
            String period = ReportUtils.isOverAcctVer((Date)filterInfo.getDate("datebegin"), (Date)filterInfo.getDate("dateend"), (long)filterInfo.getLong("periodtype"), (long)filterInfo.getLong("org"), (long)filterInfo.getLong("booktype"));
            if (Objects.nonNull(period)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u6240\u67e5\u65e5\u671f\u5bf9\u5e94\u201c%s\u201d\u8fdb\u884c\u4e86\u79d1\u76ee\u8868\u7248\u672c\u5316\u64cd\u4f5c\uff0c\u4e0d\u652f\u6301\u8de8\u7248\u672c\u5316\u67e5\u8be2\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DailyFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), period));
                return false;
            }
            String str = this.getPageCache().get("_childOrgSet");
            if (str != null) {
                Set childOrgSet = (Set)GLUtil.fromSerializedString((String)str);
                Tuple tup = ReportUtils.overAcctVer((Date)filterInfo.getDate("datebegin"), (Date)filterInfo.getDate("dateend"), (long)filterInfo.getLong("periodtype"), new ArrayList(childOrgSet), (long)filterInfo.getLong("booktype"));
                if (Objects.nonNull(tup)) {
                    String msg = ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7ec4\u7ec7\u8303\u56f4\u4e2d%1$s\u5728%2$s\u8fdb\u884c\u4e86\u79d1\u76ee\u8868\u7248\u672c\u5316\u64cd\u4f5c\uff0c\u4e0d\u652f\u6301\u8de8\u7248\u672c\u5316\u67e5\u8be2\uff0c\u8bf7\u8c03\u6574\u671f\u95f4\u3002", (String)"GLRptTemplatePlugin_23", (String)"fi-gl-formplugin", (Object[])new Object[]{tup.item2, tup.item1});
                    this.getView().showTipNotification(msg);
                    return false;
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"DailyFormRpt_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.report);
        if (cache.get("dailyQuery-chartMap") == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"imagediv"});
        } else {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("gl_rpt_dailychart");
            para.getOpenStyle().setTargetKey("imagediv");
            para.getOpenStyle().setShowType(ShowType.InContainer);
            this.getView().showForm(para);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"imagediv"});
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        boolean showPrice = super.isShowPrice();
        HashSet<Long> accountIdSet = new HashSet<Long>(rowData.size());
        for (DynamicObject obj2 : rowData) {
            DynamicObject acct = obj2.getDynamicObject("number");
            if (acct == null) continue;
            accountIdSet.add(acct.getLong("id"));
        }
        String accountNameField = GLUtil.getAcctNameBySysParam((Long)this.getParentOrg());
        Map<Long, String> idAndNames = this.getAccountNames(accountIdSet, accountNameField);
        boolean baseCurrency = this.isBaseCurrency(queryParam.getFilter());
        DailyFormRpt.processData(Maps.newHashMap(), rowData, queryParam, obj -> {
            String name;
            DynamicObject acctId;
            if (showPrice) {
                String field = "predebit#,precredit#,debit#,credit#,todebit#,tocredit#";
                this.setPrice(baseCurrency, (DynamicObject)obj, field);
            }
            if ((acctId = obj.getDynamicObject("number")) != null && (name = (String)idAndNames.get(acctId.getLong("id"))) != null) {
                obj.set("name", (Object)name);
            }
        });
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        queryParam.getCustomParam().put("flexorgidfield", "flexorgid");
    }

    private Map<Long, String> getAccountNames(Set<Long> accountIdSet, String accountNameField) {
        HashMap<Long, String> idAndNameMap = new HashMap<Long, String>();
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_accountview", (String)("id," + accountNameField + " name"), (QFilter[])new QFilter("id", "in", accountIdSet).toArray());
        for (DynamicObject obj : coll) {
            idAndNameMap.put(obj.getLong("id"), obj.getString("name"));
        }
        return idAndNameMap;
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        String dateformatStr = InteServiceHelper.getDateFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
        SimpleDateFormat format = new SimpleDateFormat(dateformatStr);
        String dateStr = String.format(ResManager.loadKDString((String)"\u65e5\u671f\uff1a%1$s ~ %2$s", (String)"DailyFormRpt_5", (String)"fi-gl-formplugin", (Object[])new Object[0]), format.format(evt.getFilter().getDate("datebegin")), format.format(evt.getFilter().getDate("dateend")));
        String formatStr = evt.getFormatedFilterString();
        String[] split = formatStr.split("; ", 2);
        String result = dateStr;
        if (split.length == 2) {
            result = split[0] + "; " + dateStr + "; " + split[1];
        } else if (split.length == 1) {
            result = split[0] + "; " + dateStr;
        }
        evt.setFormatedFilterString(result);
    }
}

