/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.form.IPageCache;
import kd.bos.mvc.report.ReportView;
import kd.fi.gl.util.FlexUtils;

public class FlexHandler {
    private final ReportView view;
    private static final String IS_REFRESH = "is_refresh";
    private static final String FIELD_NAME = "fieldname";
    private List<String> cachedShowTypes;

    public FlexHandler(ReportView view) {
        this.view = view;
    }

    void setRefresh(Boolean isRefresh) {
        this.getPageCache().put(IS_REFRESH, isRefresh.toString());
    }

    boolean isRefresh() {
        return Boolean.TRUE.toString().equals(this.getPageCache().get(IS_REFRESH));
    }

    int getFlexSize() {
        if (this.isRefresh()) {
            return this.view.getQueryParam().getFilter().getFlexFilterItems().size();
        }
        return this.view.getModel().getEntryRowCount("entryentity");
    }

    FlexProperty getFlexProperty(int flexIndex) {
        DynamicObject value = (DynamicObject)this.view.getModel().getValue(FIELD_NAME, flexIndex);
        if (value == null) {
            return null;
        }
        String flexField = value.getString("flexfield");
        return FlexUtils.getFlexProperty((String)flexField);
    }

    void cacheShowType() {
        List showTypes = IntStream.range(0, this.getFlexSize()).mapToObj(i -> {
            Object showType = this.view.getModel().getValue("showtype", i);
            return showType == null ? "1" : showType.toString();
        }).collect(Collectors.toList());
        this.getPageCache().put("showtypes", SerializationUtils.toJsonString(showTypes));
    }

    String getShowType(int flexIndex) {
        if (this.isRefresh()) {
            if (this.cachedShowTypes == null) {
                this.cachedShowTypes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("showtypes"), List.class);
            }
            return this.cachedShowTypes.get(flexIndex);
        }
        return this.view.getModel().getValue("showtype", flexIndex).toString();
    }

    void setRefreshTag() {
        String queryString = RequestContext.get().getQueryString();
        if (queryString != null) {
            if (queryString.contains("refresh")) {
                this.setRefresh(Boolean.TRUE);
            } else if (queryString.contains("search")) {
                this.setRefresh(Boolean.FALSE);
            }
        }
    }

    private IPageCache getPageCache() {
        return this.view.getPageCache();
    }
}

