/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.report.AssistRptFilterPlugin;
import kd.fi.gl.util.GlFormUtil;

public class GLRptRecilogPlugin
extends AssistRptFilterPlugin {
    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (queryParam == null || queryParam.getFilter() == null) {
            return false;
        }
        FilterInfo filterInfo = queryParam.getFilter();
        GlFormUtil.setSelectedFlexItems(this.getModel(), (EntryGrid)this.getControl("entryentity"), filterInfo);
        if (filterInfo.getDynamicObjectCollection("account") == null || filterInfo.getDynamicObjectCollection("account").isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u3002", (String)"GLRptRecilogPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        Object acccurrentId = this.getView().getFormShowParameter().getCustomParam("acccurrent");
        if (this.getPageCache().get("acccurrent") == null && acccurrentId != null) {
            this.getPageCache().put("acccurrent", String.valueOf(acccurrentId));
            queryParam.getFilter().getCommFilter().put("acccurrent", new QFilter("buyerentry", "=", acccurrentId).or(new QFilter("writeoffentry", "=", acccurrentId)));
        }
        this.beforeQuerySetParam(queryParam);
        return true;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        if (value == null) {
            return;
        }
        switch (propertyName) {
            case "account": {
                DynamicObjectCollection accCols = (DynamicObjectCollection)value;
                if (accCols.size() == 0) {
                    return;
                }
                this.setFlexField(accCols);
            }
        }
    }

    @Override
    protected void setFlexField(DynamicObjectCollection accounts) {
        ArrayList<Set<Long>> assList = new ArrayList<Set<Long>>();
        for (DynamicObject account : accounts) {
            long id = account.getLong("fbasedataid_id");
            Set<Long> assistIds = this.getAssistByAcc(id);
            assList.add(assistIds);
        }
        Set<Long> assCom = this.getUnion(assList);
        this.setEntryEntity(assCom);
    }

    @Override
    protected Set<Long> getAssistByAcc(long accId) {
        LinkedHashSet<Long> result = new LinkedHashSet<Long>(8);
        QFilter accFilter = new QFilter("id", "=", (Object)accId);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bd_accountview", (String)"checkitementry.asstactitem assist,checkitementry.enaccheck enaccheck", (QFilter[])new QFilter[]{accFilter});
        for (DynamicObject col : cols) {
            if (!col.getBoolean("enaccheck")) continue;
            result.add(col.getLong("assist"));
        }
        return result;
    }
}

