/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.form.field.BasedataEdit;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.report.GLRptTemplatePlugin;

public class MulOrgFormRpt
extends GLRptTemplatePlugin {
    @Override
    protected BasedataEdit getOrgEdit() {
        return (BasedataEdit)this.getControl("orgs");
    }

    @Override
    protected List<Long> getOrgValue() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
        return orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    @Override
    protected void setDefaultOrg(Long orgId) {
        if (orgId == null || orgId == 0L) {
            this.getModel().setValue("orgs", null);
        } else {
            this.getModel().setValue("orgs", (Object)new Long[]{orgId});
        }
    }

    @Override
    protected List<Long> getFilterOrg(FilterInfo filterInfo) {
        List value;
        ArrayList<Long> result = new ArrayList<Long>();
        FilterItemInfo itemInfo = filterInfo.getFilterItem("orgs");
        if (itemInfo != null && (value = (List)itemInfo.getValue()) != null) {
            for (DynamicObject dyn : value) {
                result.add(dyn.getLong("id"));
            }
        }
        return result;
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        String formatedFilterString = evt.getFormatedFilterString();
        Long parentOrg = this.getParentOrg();
        String name = "";
        if (parentOrg != null && parentOrg != 0L) {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)parentOrg, (String)"bos_org");
            name = org.getString("name");
        }
        String result = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a%1$s%2$s%3$s", (String)"MulOrgFormRpt_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), name, "; ", formatedFilterString);
        evt.setFormatedFilterString(result);
    }
}

