/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.report.NavToAssRpt;
import kd.fi.gl.report.NavToSubLedgerRpt;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.VoucherUtil;

public class ReciprocalAcctFormRpt
extends AbstractReportFormPlugin {
    private static final String GL_ASSIST_BD = "gl_assist_bd";
    private static final String GL_ASSIST_TXT = "gl_assist_txt";
    private static final String ORG = "org";
    protected static final String ID = "id";
    protected static final String ACCOUNTTABLE = "accounttable";
    protected static final String _ID = "_id";
    private static final String VCH_SELECT_FIELDS = "id, vouchertype.name vouchertype, billno voucherno, entries.id entryid, entries.account.masterid acctmasterid,entries.account.id accountid, entries.account.number accountnumber, %s accountname";
    private static final String INIT_RECORD_SELECT_FIELDS = "id, account.masterid acctmasterid";
    private static final String INIT_STATUS_SELECT_FIELDS = "account.masterid account, account.id accountid, account.number accountnumber, %s accountname";

    public void initialize() {
        super.initialize();
        FilterGrid filterGrid = (FilterGrid)this.getControl("voucherfiltergridap");
        filterGrid.setEntityNumber("gl_voucher");
        this.setVoucherFilterFields(filterGrid);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit account = (BasedataEdit)this.getControl("account");
        account.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            IDataModel model = this.getModel();
            List qFilters = param.getListFilterParameter().getQFilters();
            Long orgId = (Long)model.getValue("org_id");
            Long bookTypeId = (Long)model.getValue("booktype_id");
            qFilters.add(ReciprocalUtils.queryEndInitActFilter(Collections.singleton(orgId), (Long)bookTypeId));
            QFilter qf = new QFilter("isleaf", "=", (Object)true).and(new QFilter("accheck", "=", (Object)true));
            qFilters.add(qf);
        });
        BasedataEdit assgrp = (BasedataEdit)this.getControl("fieldname");
        assgrp.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            DynamicObjectCollection accts = (DynamicObjectCollection)this.getModel().getValue("account");
            ArrayList<Object> assgrpIds = new ArrayList<Object>();
            for (DynamicObject dyo : accts) {
                DynamicObject acct = dyo.getDynamicObject("fbasedataid");
                DynamicObjectCollection entry = acct.getDynamicObjectCollection("checkitementry");
                for (DynamicObject item : entry) {
                    boolean isAccheck = item.getBoolean("enaccheck");
                    if (!isAccheck) continue;
                    DynamicObject asstactitem = item.getDynamicObject("asstactitem");
                    assgrpIds.add(asstactitem.getPkValue());
                }
            }
            if (!assgrpIds.isEmpty()) {
                QFilter qf = new QFilter(ID, "in", assgrpIds);
                param.getListFilterParameter().getQFilters().add(qf);
                param.getListFilterParameter().getQFilters();
            }
        });
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(evt -> {
            block43: {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
                DynamicObject rowData = control.getReportModel().getRowData(rowIndex);
                String name = evt.getFieldName();
                DynamicObject acct = rowData.getDynamicObject("accountno");
                DynamicObject item = rowData.getDynamicObject("assgrp");
                ReportQueryParam queryParam = this.getQueryParam();
                if ("voucherno".equals(name)) {
                    long vid = rowData.getLong("voucherid");
                    if (vid != 0L) {
                        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
                        VoucherUtil.hyperVoucher(org.getLong(ID), vid, (IFormView)this.getView());
                    }
                } else if ("accountno".equals(name)) {
                    Long accId = acct.getLong(ID);
                    DynamicObject org = queryParam.getFilter().getDynamicObject(ORG);
                    if (org == null) {
                        return;
                    }
                    long orgId = org.getLong(ID);
                    new NavToSubLedgerRpt.SLBuilder(queryParam, (IFormView)this.getView()).orgId(Long.valueOf(orgId)).accountId(accId).build().apply();
                } else if ("assgrp".equals(name)) {
                    Long acctMasterId = acct.getLong("masterid");
                    Long assgrpId = item.getLong(ID);
                    FilterInfo filter = queryParam.getFilter();
                    long orgId = Optional.ofNullable(filter.getDynamicObject(ORG)).map(x -> x.getLong(ID)).orElse(0L);
                    long accountTableID = Optional.ofNullable(filter.getDynamicObject(ACCOUNTTABLE)).map(x -> x.getLong(ID)).orElse(0L);
                    long periodId = Optional.ofNullable(filter.getDynamicObject("endperiod")).map(x -> x.getLong(ID)).orElse(0L);
                    if (orgId == 0L || accountTableID == 0L || periodId == 0L) {
                        return;
                    }
                    QFilter acctMf = new QFilter("masterid", "=", (Object)acctMasterId);
                    Set curPeriodAcctIds = AccountUtils.getAccountIdSet((long)orgId, (long)accountTableID, (long)periodId, (boolean)true, (QFilter)acctMf);
                    if (curPeriodAcctIds.size() > 0) {
                        Long acctId = (Long)curPeriodAcctIds.iterator().next();
                        new NavToAssRpt.Builder(queryParam, (IFormView)this.getView()).accountId(acctId).orgId(Long.valueOf(orgId)).assgrpId(assgrpId).build().apply();
                    }
                } else if ("writeoffvoucherno".equals(name)) {
                    long acccurrentId = rowData.getLong("entryid");
                    BigDecimal amountfor = rowData.getBigDecimal("amountfor");
                    BigDecimal amountbalfor = rowData.getBigDecimal("amountbalfor");
                    BigDecimal amount = rowData.getBigDecimal("amount");
                    BigDecimal amountbal = rowData.getBigDecimal("amountbal");
                    if (amountfor.compareTo(amountbalfor) == 0 && amount.compareTo(amountbal) == 0) {
                        return;
                    }
                    String selectField = "writeoffentry,buyerentry";
                    long id = rowData.getLong("entryid");
                    QFilter entryFilter = new QFilter("writeoffentry", "=", (Object)id).or("buyerentry", "=", (Object)id);
                    try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ReciprocalAccount_LinkVoucher", (String)"gl_reciprocal_log", (String)selectField, (QFilter[])new QFilter[]{entryFilter}, null);){
                        HashSet<Long> acccurrentIds = new HashSet<Long>(1);
                        for (Row row : ds) {
                            long writeOffEntryId = row.getLong("writeoffentry");
                            long buyerEntryId = row.getLong("buyerentry");
                            if (writeOffEntryId != 0L && writeOffEntryId != acccurrentId) {
                                acccurrentIds.add(writeOffEntryId);
                            }
                            if (buyerEntryId == 0L || buyerEntryId == acccurrentId) continue;
                            acccurrentIds.add(buyerEntryId);
                        }
                        if (!CollectionUtils.isNotEmpty(acccurrentIds)) break block43;
                        QFilter idF = new QFilter(ID, "in", acccurrentIds);
                        try (DataSet recDs = QueryServiceHelper.queryDataSet((String)"ReciprocalAccount_LinkVoucher", (String)"gl_acccurrent", (String)"voucherid", (QFilter[])new QFilter[]{idF}, null);){
                            HashSet<Long> voucherIds = new HashSet<Long>(1);
                            for (Row row : recDs) {
                                long voucherid = row.getLong("voucherid");
                                if (voucherid == 0L) continue;
                                voucherIds.add(voucherid);
                            }
                            if (CollectionUtils.isNotEmpty(voucherIds)) {
                                if (voucherIds.size() == 1) {
                                    DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
                                    VoucherUtil.hyperVoucher(org.getLong(ID), (Long)voucherIds.iterator().next(), (IFormView)this.getView());
                                } else {
                                    ListShowParameter showParameter = new ListShowParameter();
                                    showParameter.setBillFormId("gl_voucher");
                                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                                    showParameter.setShowFilter(false);
                                    showParameter.setShowQuickFilter(false);
                                    Iterator iterator = voucherIds.iterator();
                                    while (iterator.hasNext()) {
                                        long linkVoucherId = (Long)iterator.next();
                                        showParameter.addLinkQueryPkId((Object)linkVoucherId);
                                    }
                                    this.getView().showForm((FormShowParameter)showParameter);
                                }
                            }
                        }
                    }
                }
            }
        });
        BasedataEdit speriod = (BasedataEdit)this.getControl("startperiod");
        speriod.addBeforeF7SelectListener(evt -> {
            IDataModel model = this.getModel();
            DynamicObject org = (DynamicObject)model.getValue(ORG);
            DynamicObject booktype = (DynamicObject)model.getValue("booktype");
            long mpid = this.getMinInitPeriod(org, booktype);
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            if (mpid != 0L) {
                QFilter qf = new QFilter(ID, ">=", (Object)mpid);
                param.getListFilterParameter().getQFilters().add(qf);
            } else {
                QFilter qf = new QFilter(ID, "<", (Object)0);
                param.getListFilterParameter().getQFilters().add(qf);
            }
        });
        BasedataEdit eperiod = (BasedataEdit)this.getControl("endperiod");
        eperiod.addBeforeF7SelectListener(evt -> {
            IDataModel model = this.getModel();
            DynamicObject org = (DynamicObject)model.getValue(ORG);
            DynamicObject booktype = (DynamicObject)model.getValue("booktype");
            long mpid = this.getMinInitPeriod(org, booktype);
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            if (mpid != 0L) {
                QFilter qf = new QFilter(ID, ">=", (Object)mpid);
                param.getListFilterParameter().getQFilters().add(qf);
            } else {
                QFilter qf = new QFilter(ID, "<", (Object)0);
                param.getListFilterParameter().getQFilters().add(qf);
            }
        });
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        queryParam.getCustomParam().put("flexorgidfield", "flexorgid");
    }

    private FilterInfo getFilterInfo(String key, DynamicObject record) {
        FilterInfo curinfo = this.getQueryParam().getFilter();
        ArrayList<FilterItemInfo> flexfilters = new ArrayList<FilterItemInfo>();
        long masterid = record.getLong("account");
        if (Objects.nonNull(curinfo.getDynamicObject("endperiod"))) {
            Date endDate = curinfo.getDynamicObject("endperiod").getDate("enddate");
            DynamicObject acctId = GLUtil.getAccIdByMasterId((long)record.getLong(ORG), (long)masterid, (Date)endDate);
            curinfo.getFilterItem("account").setValue(acctId.getPkValue());
        }
        long acctTblId = record.getLong(ACCOUNTTABLE);
        curinfo.getFilterItem(ACCOUNTTABLE).setValue((Object)acctTblId);
        DynamicObject bookVersion = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_book_version", (QFilter[])new QFilter[]{new QFilter(ORG, "=", (Object)record.getLong(ORG)), new QFilter("booktype", "=", (Object)record.getLong("booktype")), new QFilter(ACCOUNTTABLE, "=", (Object)acctTblId)});
        if (bookVersion != null) {
            Long period = bookVersion.getLong("enableperiod.id");
            Long endPeriod = curinfo.getLong("endperiod");
            if (endPeriod.compareTo(period) < 0) {
                curinfo.getFilterItem("endperiod").setValue((Object)period);
            }
        }
        if ("assgrp".equals(key)) {
            Long assgrp = record.getLong("assgrp");
            try (DataSet assistSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".handle"), (String)GL_ASSIST_BD, (String)"hg, asstype, assval", (QFilter[])new QFilter[]{new QFilter("hg", "in", (Object)assgrp)}, null);){
                for (Row row : assistSet) {
                    flexfilters.add(new FilterItemInfo(row.getString("asstype"), Collections.singleton(row.get("assval")), "in"));
                }
            }
            assistSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".handle"), (String)GL_ASSIST_TXT, (String)"hg, asstype, assval", (QFilter[])new QFilter[]{new QFilter("hg", "in", (Object)assgrp)}, null);
            var12_12 = null;
            try {
                for (Row row : assistSet) {
                    flexfilters.add(new FilterItemInfo(row.getString("asstype"), Collections.singleton(row.get("assval")), "in"));
                }
            }
            catch (Throwable throwable) {
                var12_12 = throwable;
                throw throwable;
            }
            finally {
                if (assistSet != null) {
                    if (var12_12 != null) {
                        try {
                            assistSet.close();
                        }
                        catch (Throwable throwable) {
                            var12_12.addSuppressed(throwable);
                        }
                    } else {
                        assistSet.close();
                    }
                }
            }
        }
        curinfo.setFlexFilterItems(flexfilters);
        return curinfo;
    }

    private void navToRecipLog(FilterInfo curinfo, long id) {
        ReportShowParameter report = new ReportShowParameter();
        report.setFormId("gl_rpt_reciprocal_log");
        report.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(curinfo);
        report.setQueryParam(queryParam);
        report.setCustomParam("acccurrent", (Object)id);
        this.getView().showForm((FormShowParameter)report);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "navlog": {
                ReportList control = (ReportList)this.getControl("reportlistap");
                int[] selectRows = control.getEntryState().getSelectedRows();
                if (selectRows.length != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8054\u67e5\u6838\u9500\u65e5\u5fd7\u3002", (String)"ReciprocalAcctFormRpt_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject rowData = control.getReportModel().getRowData(selectRows[0]);
                Long entryId = rowData.getLong("entryid");
                DynamicObject record = QueryServiceHelper.queryOne((String)"gl_acccurrent", (String)"org,booktype,account,assgrp,accounttable", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)entryId)});
                if (record == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u884c\u8054\u67e5\u6838\u9500\u65e5\u5fd7\u3002", (String)"ReciprocalAcctFormRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                FilterInfo curinfo = this.getFilterInfo("assgrp", record);
                this.navToRecipLog(curinfo, entryId);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "org": 
            case "booktype": {
                if (e.getChangeSet()[0].getNewValue() == null) {
                    return;
                }
                this.initPeriod();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initCurrency();
        this.initPeriod();
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        this.setVoucherInfo(rowData, queryParam);
        this.setWriteOffVoucherno(rowData);
    }

    private void setVoucherInfo(DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Long orgId = (Long)filterInfo.getDynamicObject(ORG).getPkValue();
        Long bookTypeId = (Long)filterInfo.getDynamicObject("booktype").getPkValue();
        HashSet<Long> voucherIds = new HashSet<Long>(64);
        HashSet<Long> voucherEntryIds = new HashSet<Long>(64);
        HashSet<Long> accIds = new HashSet<Long>(8);
        HashSet<Long> initRecordIds = new HashSet<Long>(8);
        for (DynamicObject row : rowData) {
            long voucherId = row.getLong("voucherid");
            voucherIds.add(voucherId);
            voucherEntryIds.add(row.getLong("voucherentry"));
            accIds.add(row.getLong("accountno.id"));
            if (voucherId != 0L) continue;
            initRecordIds.add(row.getLong("entryid"));
        }
        if (voucherEntryIds.isEmpty() && accIds.isEmpty()) {
            return;
        }
        boolean showfullname = (Boolean)GLUtil.getSystemParam((String)"showfullname", (Long)orgId);
        HashMap<Long, DynamicObject> accountDynMap = new HashMap<Long, DynamicObject>(8);
        QFilter initRecordFilter = new QFilter(ID, "in", initRecordIds);
        DataSet initRecordDataSet = QueryServiceHelper.queryDataSet((String)"gl_reciprocal_queryrecord", (String)"gl_acccurrent", (String)INIT_RECORD_SELECT_FIELDS, (QFilter[])new QFilter[]{initRecordFilter}, null);
        List initRecordCols = GLUtil.getDataSetCols((DataSet)initRecordDataSet);
        QFilter initStatusfilter = new QFilter(ORG, "=", (Object)orgId);
        initStatusfilter.and(new QFilter("booktype", "=", (Object)bookTypeId));
        initStatusfilter.and(new QFilter("isendinit", "=", (Object)true));
        String initStatusSelectField = String.format(INIT_STATUS_SELECT_FIELDS, showfullname ? "account.fullname" : "account.name");
        DataSet endInitStatusDs = QueryServiceHelper.queryDataSet((String)"ReciprocalInitUtil.queryIsEndInitReciprocalInit", (String)"gl_reci_init_state", (String)initStatusSelectField, (QFilter[])new QFilter[]{initStatusfilter}, null);
        List endInitStatusCols = GLUtil.getDataSetCols((DataSet)endInitStatusDs);
        DataSet resultDt = initRecordDataSet.leftJoin(endInitStatusDs).on("acctmasterid", "account").select(initRecordCols.toArray(new String[0]), endInitStatusCols.toArray(new String[0])).finish();
        HashMap<Long, Tuple2> recordAndAccountMap = new HashMap<Long, Tuple2>(8);
        for (Row row : resultDt) {
            Long accountId = row.getLong("accountid");
            DynamicObject acctDynamicObject = accountDynMap.computeIfAbsent(accountId, k -> BusinessDataServiceHelper.newDynamicObject((String)"bd_accountview"));
            acctDynamicObject.set(ID, (Object)accountId);
            acctDynamicObject.set("number", (Object)row.getString("accountnumber"));
            acctDynamicObject.set("masterid", (Object)row.getString("acctmasterid"));
            recordAndAccountMap.put(row.getLong(ID), new Tuple2(accountDynMap.get(accountId), (Object)row.getString("accountname")));
        }
        QFilter vchEntryFilter = new QFilter("entries.id", "in", voucherEntryIds);
        QFilter vchIdsFilter = new QFilter(ID, "in", voucherIds);
        String vchSelectField = String.format(VCH_SELECT_FIELDS, showfullname ? "entries.account.fullname" : "entries.account.name");
        DynamicObjectCollection vchDyn = QueryServiceHelper.query((String)"ReciprocalAcctFormRpt_setVoucherInfo_queryVocher", (String)"gl_voucher", (String)vchSelectField, (QFilter[])new QFilter[]{vchIdsFilter, vchEntryFilter}, null);
        HashMap<Long, Tuple2> vchEntryMap = new HashMap<Long, Tuple2>(vchDyn.size());
        HashMap<Long, Tuple2> acctMap = new HashMap<Long, Tuple2>(vchDyn.size());
        for (DynamicObject vchRow : vchDyn) {
            Long accountId = vchRow.getLong("accountid");
            DynamicObject acctDynamicObject = accountDynMap.computeIfAbsent(accountId, k -> BusinessDataServiceHelper.newDynamicObject((String)"bd_accountview"));
            acctDynamicObject.set(ID, (Object)accountId);
            acctDynamicObject.set("number", (Object)vchRow.getString("accountnumber"));
            acctDynamicObject.set("masterid", (Object)vchRow.getString("acctmasterid"));
            vchEntryMap.put(vchRow.getLong("entryid"), new Tuple2((Object)vchRow.getString("vouchertype"), (Object)vchRow.getString("voucherno")));
            acctMap.put(vchRow.getLong("entryid"), new Tuple2(accountDynMap.get(accountId), (Object)vchRow.getString("accountname")));
        }
        for (DynamicObject row : rowData) {
            Tuple2 vchEntryTuple;
            Long vchEntryId = row.getLong("voucherentry");
            if (vchEntryId == 0L) {
                Long entryId = row.getLong("entryid");
                Tuple2 accountTuple = (Tuple2)recordAndAccountMap.get(entryId);
                if (accountTuple == null) continue;
                row.set("accountno", accountTuple.t1);
                row.set("accountname", accountTuple.t2);
                continue;
            }
            Tuple2 accountTuple = (Tuple2)acctMap.get(vchEntryId);
            if (accountTuple != null) {
                row.set("accountno", accountTuple.t1);
                row.set("accountname", accountTuple.t2);
            }
            if ((vchEntryTuple = (Tuple2)vchEntryMap.get(vchEntryId)) == null) continue;
            row.set("vouchertype", vchEntryTuple.t1);
            row.set("voucherno", vchEntryTuple.t2);
        }
    }

    private void setWriteOffVoucherno(DynamicObjectCollection rowData) {
        HashMap<Long, String> reciIdVchNoMap = new HashMap<Long, String>();
        HashSet<Long> acccurrentIds = new HashSet<Long>(16);
        for (DynamicObject row : rowData) {
            Long acccurrentId = row.getLong("entryid");
            acccurrentIds.add(acccurrentId);
        }
        if (acccurrentIds.isEmpty()) {
            return;
        }
        String logSelectFields = "id entryid,buyerentry buyerentryid,writeoffentry writeoffentry";
        QFilter[] logFilters = new QFilter[]{new QFilter("buyerentry", "in", acccurrentIds).or(new QFilter("writeoffentry", "in", acccurrentIds))};
        DataSet logDataSet = QueryServiceHelper.queryDataSet((String)"gl_reciprocal_querylog", (String)"gl_reciprocal_log", (String)logSelectFields, (QFilter[])logFilters, null);
        HashMap<Long, List> writeOffMap = new HashMap<Long, List>(16);
        for (Row row : logDataSet) {
            Long buyerEntryId = row.getLong("buyerentryid");
            Long writeOffEntryId = row.getLong("writeoffentry");
            writeOffMap.computeIfAbsent(buyerEntryId, v -> new ArrayList(16)).add(writeOffEntryId);
            writeOffMap.computeIfAbsent(writeOffEntryId, v -> new ArrayList(16)).add(buyerEntryId);
            acccurrentIds.add(buyerEntryId);
            acccurrentIds.add(writeOffEntryId);
        }
        String byAndWroffentryField = "voucherid byAndWroffentryVoucherid,id";
        QFilter byAndWroffentryFilter = new QFilter(ID, "in", acccurrentIds);
        DataSet byAndWroffentryDataSet = QueryServiceHelper.queryDataSet((String)"gl_reciprocal_queryrecord", (String)"gl_acccurrent", (String)byAndWroffentryField, (QFilter[])new QFilter[]{byAndWroffentryFilter}, null);
        ArrayList<Long> byAndWroffVoucherIds = new ArrayList<Long>();
        for (Row row : byAndWroffentryDataSet.copy()) {
            Long voucherid = row.getLong("byAndWroffentryVoucherid");
            if (voucherid == 0L) continue;
            byAndWroffVoucherIds.add(voucherid);
        }
        QFilter byAndWroffVoucherQFilter = new QFilter(ID, "in", byAndWroffVoucherIds);
        String byAndWroffVoucherField = "id vchid,billno voucherno";
        DataSet byAndWroffVoucherDt = VoucherQueryUtils.queryDataSet((String)byAndWroffVoucherField, (QFilter[])new QFilter[]{byAndWroffVoucherQFilter}, null, (int)-1);
        DataSet byAndWroffVoucherJoinDt = byAndWroffentryDataSet.join(byAndWroffVoucherDt, JoinType.INNER).on("byAndWroffentryVoucherid", "vchid").select(new String[]{ID, "voucherno"}).finish();
        for (Row row : byAndWroffVoucherJoinDt) {
            reciIdVchNoMap.put(row.getLong(ID), row.getString("voucherno"));
        }
        String unWriteoffStr = ResManager.loadKDString((String)"\u672a\u6838\u9500", (String)"ReciprocalAcctFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        String partWriteoffStr = ResManager.loadKDString((String)"\u672a\u5b8c\u5168\u6838\u9500", (String)"ReciprocalAcctFormRpt_4", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        String hadWriteoffStr = ResManager.loadKDString((String)"\u5df2\u6838\u9500", (String)"ReciprocalAcctFormRpt_5", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        for (DynamicObject row : rowData) {
            String status = row.getString("status");
            String statusText = "";
            if ("0".equals(status)) {
                statusText = unWriteoffStr;
            } else if ("1".equals(status)) {
                statusText = partWriteoffStr;
            } else if ("2".equals(status)) {
                statusText = hadWriteoffStr;
            }
            row.set("status", (Object)statusText);
            Long accuId = row.getLong("entryid");
            List writeOffAccuIds = (List)writeOffMap.get(accuId);
            if (writeOffAccuIds == null) continue;
            String voucherNo = "";
            for (Long writeOffAccuId : writeOffAccuIds) {
                voucherNo = StringUtils.isNotEmpty((String)voucherNo) ? voucherNo + "," + (String)reciIdVchNoMap.get(writeOffAccuId) : (String)reciIdVchNoMap.get(writeOffAccuId);
            }
            row.set("writeoffvoucherno", (Object)voucherNo);
        }
    }

    private void initCurrency() {
        ComboEdit currency = (ComboEdit)this.getControl("currency");
        currency.setComboItems(ReportUtils.getCurrencyItems((boolean)false, (boolean)true));
    }

    private void initPeriod() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue(ORG);
        DynamicObject booktype = (DynamicObject)model.getValue("booktype");
        if (org == null || booktype == null) {
            model.setValue("startperiod", null);
            model.setValue("endperiod", null);
            return;
        }
        long minitPid = this.getMinInitPeriod(org, booktype);
        long cpid = this.getCurPerod(Long.parseLong(String.valueOf(org.getPkValue())), Long.parseLong(String.valueOf(booktype.getPkValue())));
        if (cpid != 0L && minitPid != 0L && minitPid <= cpid) {
            model.setValue("startperiod", (Object)cpid);
            model.setValue("endperiod", (Object)cpid);
            this.getPageCache().put(String.format("%s+%s+init", String.valueOf(org.getPkValue()), String.valueOf(booktype.getPkValue())), String.valueOf(cpid));
        } else if (minitPid != 0L) {
            model.setValue("startperiod", (Object)minitPid);
            model.setValue("endperiod", (Object)minitPid);
            this.getPageCache().put(String.format("%s+%s+init", String.valueOf(org.getPkValue()), String.valueOf(booktype.getPkValue())), String.valueOf(cpid));
        } else {
            model.setValue("startperiod", null);
            model.setValue("endperiod", null);
        }
    }

    private long getCurPerod(long orgId, long booktypeId) {
        QFilter qorg = new QFilter(ORG, "=", (Object)orgId);
        QFilter qbooktype = new QFilter("bookstype", "=", (Object)booktypeId);
        long cpid = 0L;
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_accountbook", (String)"curperiod", (QFilter[])new QFilter[]{qorg, qbooktype}, null);){
            while (dt.hasNext()) {
                cpid = dt.next().getLong("curperiod");
            }
        }
        return cpid;
    }

    private long getMinInitPeriod(DynamicObject org, DynamicObject booktype) {
        if (org != null && booktype != null) {
            String sql = String.format("select min(fendinitperiod) mpid from t_gl_reci_init_state where forgid = %s and fbooktypeid = %s and fisendinit='1'", String.valueOf(org.getPkValue()), String.valueOf(booktype.getPkValue()));
            try (DataSet initState = DB.queryDataSet((String)"fi.gl.ReciprocalAcctQueryRpt.initstate", (DBRoute)DBRoute.of((String)"gl"), (String)sql);){
                if (initState.hasNext()) {
                    long mpid;
                    Row row = initState.next();
                    if (row.get("mpid") == null) {
                        long l = 0L;
                        return l;
                    }
                    long l = mpid = row.getLong("mpid").longValue();
                    return l;
                }
            }
        }
        return 0L;
    }

    private void setVoucherFilterFields(FilterGrid filterGrid) {
        ArrayList<String> filterFileds = new ArrayList<String>(19);
        filterFileds.add("billno");
        filterFileds.add("edescription");
        filterFileds.add("vouchertype.number");
        filterFileds.add("bizdate");
        filterFileds.add("bookeddate");
        filterFileds.add("description");
        filterFileds.add("billstatus");
        filterFileds.add("ispost");
        filterFileds.add("creator.number");
        filterFileds.add("auditor.number");
        filterFileds.add("cashier.number");
        filterFileds.add("poster.number");
        filterFileds.add("debitori");
        filterFileds.add("creditori");
        filterFileds.add("debitlocal");
        filterFileds.add("creditlocal");
        filterFileds.add("debitrpt");
        filterFileds.add("creditrpt");
        filterFileds.add("businessnum");
        filterGrid.setFilterFieldKeys(filterFileds);
    }
}

