/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterOutputWidgetEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.print.core.plugin.event.EndExportEvent;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.report.ReportPrintHelper;
import kd.fi.gl.report.subledger.print.SLPrintPageKey;

public class SubLedgerCataloguePlugin
extends AbstractPrintPlugin {
    private static final Log LOGGER = LogFactory.getLog(SubLedgerCataloguePlugin.class);
    private final Map<String, Integer> startPageMap = new LinkedHashMap<String, Integer>(6);
    private static final String ACCOUNT = "Text5";
    private static final String[] headBaseDataFieldKeys = new String[]{"org", "booktype"};
    private static final String EMPTY = "";
    private List<CommonAssist> comAssistForGroup;
    private String org = "";
    private boolean isLoadCustomData = false;
    private SLPrintPageKey curPageKey;

    public void loadCustomData(CustomDataLoadEvent evt) {
        CustomDataSource dataSource = evt.getDataSource();
        String pageId = dataSource.getPageId();
        ReportListModel model = ReportPrintHelper.getListModel(pageId);
        if (model == null) {
            return;
        }
        if ("reporthead".equals(dataSource.getDsName())) {
            List field = dataSource.getQueryField();
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(field, headBaseDataFieldKeys);
            DataRowSet dsRow = new DataRowSet();
            ReportQueryParam param = model.getReportQueryParam();
            FilterInfo filter = param.getFilter();
            this.comAssistForGroup = ComAssistTable.get((Long)filter.getLong("accounttable")).getComAssistForGroup(filter.getBoolean("showsumcomassist"));
            ReportPrintHelper.handleAccountBaseDataFilterInfo(filter, dsRow, headBaseDataFields);
            this.org = String.valueOf(dsRow.getField("org"));
            this.isLoadCustomData = true;
        }
    }

    public void afterOutputWidget(AfterOutputWidgetEvent evt) {
        String curPageKeyStr;
        if (!this.isLoadCustomData) {
            return;
        }
        String widgetKey = evt.getWidgetKey();
        int pageIndex = evt.getPageIndex();
        SLPrintPageKey curPageKey = this.getCurPageKey();
        if (ACCOUNT.equals(widgetKey)) {
            curPageKey.setAccount((String)((TextField)evt.getOutputValue()).getValue());
        } else if (widgetKey.startsWith("comassist")) {
            int comAssistIndex = Integer.parseInt(widgetKey.replace("comassist", EMPTY));
            String value = (String)((TextField)evt.getOutputValue()).getValue();
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                curPageKey.setComAssistValue(comAssistIndex - 1, value);
            }
        }
        SLPrintPageKey.FillStatus fillStatus = curPageKey.getFillStatus();
        if (fillStatus == SLPrintPageKey.FillStatus.FULL && !this.startPageMap.containsKey(curPageKeyStr = curPageKey.toString())) {
            this.curPageKey = null;
            this.startPageMap.put(curPageKeyStr, pageIndex + 1);
        }
    }

    private SLPrintPageKey getCurPageKey() {
        if (this.curPageKey == null) {
            this.curPageKey = new SLPrintPageKey(this.comAssistForGroup);
        }
        return this.curPageKey;
    }

    public void endExport(EndExportEvent evt) {
        String entity = evt.getPrtAttach().getFormId();
        String cacheKey = entity + "_" + this.org;
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.report);
        cache.put(cacheKey, SerializationUtils.toJsonString(this.startPageMap));
        if (DebugTrace.enable()) {
            LOGGER.info("This is SubLedgerCataloguePlugin cacheValue:" + SerializationUtils.toJsonString(this.startPageMap));
        }
    }
}

