/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.alibaba.fastjson.JSONObject;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.bd.model.JsonObjectAdapter;
import kd.fi.gl.report.FlexPrintFormatter;
import kd.fi.gl.report.ReportPrintHelper;
import kd.fi.gl.report.SubsiDiaryRptPrint;
import kd.fi.gl.util.GLUtil;

public class SubLedgerRptPrint
extends AbstractPrintServicePlugin {
    private static final Log log = LogFactory.getLog(SubsiDiaryRptPrint.class);
    private static final String dataCacheKey = "SubLedgerRptPrint";
    private static final String rowDataCacheKey = "SubLedgerRptPrint_RowDatas";
    private static final String[] rowDataStringFieldKeys = new String[]{"voucherno", "desc", "measureunit.name", "currencycolumn.name", "currencyrptid.name", "basecurrency.name"};
    private static final String[] rowDataFlexFieldKeys = new String[]{"assgrp", "opassgrp"};
    private static final String[] opAccountStringJointFields = new String[]{"opaccount.number", "opaccount.name"};
    private static final String[] rowDataDateFieldKeys = new String[]{"bizdate", "bookeddate"};
    private static final String[] rowDataAmountLocalFieldKeys = new String[]{"debitlocal", "creditlocal", "endlocal"};
    private static final String[] rowDataAmountForFieldKeys = new String[]{"debitfor", "creditfor", "endfor", "debitprice", "creditprice", "endprice"};
    private static final String[] rowDataAmountRptFieldKeys = new String[]{"debitrpt", "creditrpt", "endrpt"};
    private static final String[] rowDataQtyFieldKeys = new String[]{"debitqty", "creditqty", "endqty"};
    private static final String[] rowDataDecimalFieldKeys = new String[]{"localrate"};
    private static final String[] headFieldKeys = new String[]{"org", "orgview", "booktype", "periodtype", "startperiod", "endperiod", "accounttable", "currencyrpt"};
    private static final String[] headDateFieldKeys = new String[]{"datebegin", "dateend"};
    private static final String DC = "dc";
    private static final String SEQ = "fseq";
    private static final String CURRENCY_LOCAL = "basecurrency";
    private static final String CURRENCY_FOR = "currencycolumn";
    private static final String CURRENCY_RPT = "currencyrptid";
    private FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
    private Format timeFormat = FormatFactory.get((FormatTypes)FormatTypes.Date).getFormat(this.fobj);
    private FlexPrintFormatter flexPrintFormatter = null;
    private final Boolean enableBOSFormatter = Boolean.parseBoolean(System.getProperty("fi.gl.report.print.enablebosflexformatter", Boolean.TRUE.toString()));

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        try {
            ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>();
            ReportListModel model = null;
            model = ReportPrintHelper.getListModel(e.getPageId());
            if (model == null) {
                return;
            }
            IPageCache pageCache = model.getView().getPageCache();
            String extParamStr = pageCache.get("extParam");
            if (extParamStr != null) {
                JSONObject extParam = JsonObjectAdapter.fromJson((String)extParamStr).getSource();
                if (extParam.containsKey((Object)"printAll")) {
                    String pageIDForPrint = extParam.get((Object)"pageIDForPrint").toString();
                    model.setReportTaskResult(model.getReportCache().getReportTaskResult(extParam.get((Object)"pageIDForPrint").toString(), "reportlistap"));
                    model.setPageId(pageIDForPrint);
                }
                pageCache.remove("extParam");
                pageCache.saveChanges();
            }
            int count = model.getRowCount();
            ReportQueryParam param = model.getReportQueryParam();
            String dataSourceName = e.getDataSourceName();
            FilterInfo filterInfo = param.getFilter();
            if (e.isMainDs()) {
                DynamicObjectType customDT = new DynamicObjectType();
                customDT.registerProperty("id", String.class, (Object)"", false);
                customDT.registerProperty("account", String.class, (Object)"", false);
                String tempAcct = "";
                DynamicObjectCollection ds = model.getRowData(0, count);
                if (this.enableBOSFormatter.booleanValue()) {
                    this.flexPrintFormatter = new FlexPrintFormatter(model, ds);
                }
                HashMap rowDatas = new HashMap();
                int key = 1;
                for (DynamicObject dyo : ds) {
                    DynamicObject d = new DynamicObject(customDT);
                    DynamicObject tempD = dyo.getDynamicObject("accountcolumn");
                    if (tempD == null) continue;
                    String acctNumber = tempD.getString("number");
                    String acctName = dyo.getString("accountname");
                    StringBuilder sb = new StringBuilder(acctNumber).append(acctName);
                    String acct = sb.toString();
                    int rowNo = dyo.getInt(SEQ);
                    if (!acct.equalsIgnoreCase(tempAcct)) {
                        tempAcct = acct;
                        key = rowNo;
                        d.set("account", (Object)acct);
                        d.set("id", (Object)rowNo);
                        dyns.add(d);
                    }
                    if (rowDatas.get(key) == null) {
                        ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
                        datas.add(dyo);
                        rowDatas.put(key, datas);
                        continue;
                    }
                    ((List)rowDatas.get(key)).add(dyo);
                }
                ThreadCache.put((Object)rowDataCacheKey, rowDatas);
                e.setDataEntities(dyns);
            } else if ("reporthead".equals(dataSourceName)) {
                DynamicObjectType customDT = new DynamicObjectType();
                String[] headFields = ReportPrintHelper.getExistFileds(e, headFieldKeys);
                String[] headDateFields = ReportPrintHelper.getExistFileds(e, headDateFieldKeys);
                ReportPrintHelper.registerStringProperty(customDT, new String[][]{headFields, headDateFields});
                ReportPrintHelper.registerStringProperty(customDT, "currency");
                DynamicObject printDyn = new DynamicObject(customDT);
                ReportPrintHelper.handleBaseDataFilterInfo(filterInfo, printDyn, headFields);
                ReportPrintHelper.handleDateFilterInfo(filterInfo, printDyn, this.timeFormat, headDateFields);
                ReportPrintHelper.handleCurrencyNameById(filterInfo, printDyn, "currency");
                dyns.add(printDyn);
                e.setDataEntities(dyns);
            } else {
                Map rowDatas = (Map)ThreadCache.get((Object)rowDataCacheKey);
                int index = Integer.parseInt(e.getFilter().getValue().toString());
                List datas = (List)rowDatas.get(index);
                String[] rowDataStringFields = ReportPrintHelper.getExistFileds(e, rowDataStringFieldKeys);
                String[] rowDataFlexFields = ReportPrintHelper.getExistFileds(e, rowDataFlexFieldKeys);
                String[] rowDataAmountForFields = ReportPrintHelper.getExistFileds(e, rowDataAmountForFieldKeys);
                String[] rowDataAmountLocalFields = ReportPrintHelper.getExistFileds(e, rowDataAmountLocalFieldKeys);
                String[] rowDataAmountRptFields = ReportPrintHelper.getExistFileds(e, rowDataAmountRptFieldKeys);
                String[] rowDataQtyFields = ReportPrintHelper.getExistFileds(e, rowDataQtyFieldKeys);
                String[] rowDataDateFields = ReportPrintHelper.getExistFileds(e, rowDataDateFieldKeys);
                String[] rowDataDecimalFields = ReportPrintHelper.getExistFileds(e, rowDataDecimalFieldKeys);
                DynamicObjectType customDT = new DynamicObjectType();
                ReportPrintHelper.registerStringProperty(customDT, new String[][]{rowDataStringFields, rowDataFlexFields, rowDataAmountForFields, rowDataAmountLocalFields, rowDataAmountRptFields, rowDataQtyFields, rowDataDateFields, rowDataDecimalFields});
                ReportPrintHelper.registerStringProperty(customDT, DC, SEQ, "opaccount");
                boolean showrpt = filterInfo.getBoolean("showrpt");
                boolean showqty = filterInfo.getBoolean("showqty") || filterInfo.getBoolean("showsumqty");
                boolean showopaccount = filterInfo.getBoolean("showopaccount");
                HashSet<String> hgValueSet = new HashSet<String>(datas.size() * 2);
                int tempSeq = 1;
                for (DynamicObject rowData : datas) {
                    DynamicObject printRow = new DynamicObject(customDT);
                    printRow.set(SEQ, (Object)tempSeq++);
                    ReportPrintHelper.handleStringFields(rowData, printRow, rowDataStringFields);
                    ReportPrintHelper.handleDateFields(rowData, printRow, this.timeFormat, rowDataDateFields);
                    ReportPrintHelper.handleFlexFields(rowData, printRow, hgValueSet, rowDataFlexFields);
                    ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_LOCAL, (boolean)Boolean.FALSE, rowDataAmountLocalFields);
                    ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_FOR, (boolean)Boolean.FALSE, rowDataAmountForFields);
                    ReportPrintHelper.handleDecimalFields(rowData, printRow, this.fobj, (boolean)Boolean.FALSE, rowDataDecimalFields);
                    ReportPrintHelper.handleDcFields(rowData, printRow, DC);
                    if (showopaccount) {
                        ReportPrintHelper.handleStringJointField(rowData, printRow, "opaccount", " ", opAccountStringJointFields);
                    }
                    if (showrpt) {
                        ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_RPT, (boolean)Boolean.FALSE, rowDataAmountRptFields);
                    }
                    if (showqty) {
                        ReportPrintHelper.handleQtyFields(rowData, printRow, (boolean)Boolean.FALSE, "measureunit", this.fobj, rowDataQtyFields);
                    }
                    if (this.flexPrintFormatter != null && customDT.getProperty("assgrp") != null) {
                        printRow.set("assgrp", (Object)this.flexPrintFormatter.getFlexString(rowData));
                    }
                    dyns.add(printRow);
                }
                if (!this.enableBOSFormatter.booleanValue()) {
                    ReportPrintHelper.handleFlexIntoToStr(dyns, hgValueSet, rowDataFlexFields);
                }
                e.setDataEntities(dyns);
            }
        }
        catch (Exception exp) {
            log.error(GLUtil.printError((Throwable)exp));
            throw exp;
        }
    }
}

