/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.util.Tuple2;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportTaskResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.BeforeLoadDataEvent;
import kd.bos.print.core.plugin.event.BeforeOutputGridEvent;
import kd.bos.print.core.plugin.event.BeforeOutputWidgetEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.print.core.plugin.event.bo.PWGridCellBo;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.configuration.ReportConfiguration;
import kd.fi.gl.constant.PrintFieldTypeEnum;
import kd.fi.gl.report.ReportPrintHelper;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.ReportFieldSettingUtil;

public class SubsiDiaryRptPrintNew
extends AbstractPrintPlugin {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SubsiDiaryRptPrintNew.class);
    private static final String dataCacheKey = "SubsiDiaryRptPrint";
    private static final String rowDataCacheKey = "SubsiDiaryRptPrint_RowDatas";
    private static final String pageHeadCacheKey = "SubsiDiaryRptPrint_pageHead";
    private static final String[] headFieldKeys = new String[]{"id", "account", "showassist"};
    private static final String[] rowDataStringFieldKeys = new String[]{"accountnumber", "accountname", "vouchernumber", "desc", "measureunit.name", "currencycolumn.name", "bookcolumn.name", "basecurrency.name"};
    private static final String[] rowDataDateFieldKeys = new String[]{"datefield", "bizdate"};
    private static final String[] rowDataQtyFieldKeys = new String[]{"debitqty", "creditqty", "endqty"};
    private static final String[] rowDataDcFieldKeys = new String[]{"accountdc", "dc"};
    private static final String[] rowDataAmountLocalFieldKeys = new String[]{"debitlocal", "creditlocal", "endlocal"};
    private static final String[] rowDataAmountForFieldKeys = new String[]{"debitprice", "debitfor", "creditprice", "creditfor", "endprice", "endfor"};
    private static final String[] rowDataDecimalFieldKeys = new String[]{"localrate"};
    private static final String SEQ = "fseq";
    private static final String[] headBaseDataFieldKeys = new String[]{"org", "orgview", "booktype", "periodtype", "startperiod", "endperiod", "accounttable", "currencyrpt"};
    private static final String[] headMulBaseDataFieldKeys = new String[]{"measureunits"};
    private static final String CURRENCY_HEAD = "currency";
    private static final String CURRENCY_LOCAL = "basecurrency";
    private static final String CURRENCY_FOR = "currencycolumn";
    private static final String MEASUREUNITFIELD = "measureunit";
    private FormatObject fobj;
    private Format timeFormat;
    private static final String ACCOUNTBALANCE_PRINT_PAGEID_CACHE = "subsiDiaryRptPrintPageIdCache";
    private boolean showcomassist = false;
    private List<String> comAssistColFields;
    private Map<String, String> assgrpFieldNameProp = new HashMap<String, String>(8);

    public void loadCustomData(CustomDataLoadEvent evt) {
        CustomDataSource dataSource = evt.getDataSource();
        String pageId = dataSource.getPageId();
        ReportListModel model = this.getListModel(pageId);
        if (model == null) {
            return;
        }
        if ("reporthead".equals(dataSource.getDsName())) {
            DataRowSet dsRow = new DataRowSet();
            Map pageHeadAccAndAss = (Map)ThreadCache.get((Object)pageHeadCacheKey);
            String pkId = dataSource.getPkId().toString();
            if (Objects.isNull(pageHeadAccAndAss) || pageHeadAccAndAss.isEmpty() || StringUtils.isEmpty((CharSequence)pkId)) {
                return;
            }
            String[] accAndAss = (String[])pageHeadAccAndAss.get(Integer.parseInt(dataSource.getPkId().toString()));
            dsRow.add(headFieldKeys[1], (Field)new TextField(accAndAss[0]));
            dsRow.add(headFieldKeys[2], (Field)new TextField(accAndAss[1]));
            List field = dataSource.getQueryField();
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(field, headBaseDataFieldKeys);
            String[] headMulBaseDataFields = ReportPrintHelper.getExistFileds(field, headMulBaseDataFieldKeys);
            ReportQueryParam param = model.getReportQueryParam();
            FilterInfo filter = param.getFilter();
            ReportPrintHelper.handleBaseDataFilterInfo(filter, dsRow, headBaseDataFields);
            ReportPrintHelper.handleMulBaseDataFilterInfo(filter, dsRow, headMulBaseDataFields);
            ReportPrintHelper.handleCurrencyNameById(filter, dsRow, CURRENCY_HEAD);
            ReportPrintHelper.handleMulCur(filter, dsRow, field);
            List customDataRows = evt.getCustomDataRows();
            customDataRows.add(dsRow);
        } else if ("reportlist".equals(dataSource.getDsName())) {
            Map rowDatasMap = (Map)ThreadCache.get((Object)rowDataCacheKey);
            String pkId = dataSource.getPkId().toString();
            if (Objects.isNull(rowDatasMap) || rowDatasMap.isEmpty() || StringUtils.isEmpty((CharSequence)pkId)) {
                return;
            }
            int index = Integer.parseInt(dataSource.getPkId().toString());
            String dataIndexs = (String)rowDatasMap.get(index);
            String[] indexStr = dataIndexs.split("-");
            int startIndex = Integer.parseInt(indexStr[0]);
            int length = Integer.parseInt(indexStr[1]) - startIndex;
            DynamicObjectCollection ds = model.getRowData(startIndex, length);
            ReportQueryParam param = model.getReportQueryParam();
            FilterInfo filter = param.getFilter();
            List field = dataSource.getQueryField();
            if (Objects.nonNull(this.comAssistColFields)) {
                field.addAll(this.comAssistColFields);
            }
            String[] rowDataStringFields = ReportPrintHelper.getExistFileds(field, SubsiDiaryRptPrintNew.getFieldByTpye(PrintFieldTypeEnum.STRING.getValue()).toArray(rowDataStringFieldKeys));
            String[] rowDataAmountForFields = ReportPrintHelper.getExistFileds(field, SubsiDiaryRptPrintNew.getFieldByTpye(PrintFieldTypeEnum.AMOUNT.getValue()).toArray(rowDataAmountForFieldKeys));
            String[] rowDataAmountLocalFields = ReportPrintHelper.getExistFileds(field, rowDataAmountLocalFieldKeys);
            String[] rowDataQtyFields = ReportPrintHelper.getExistFileds(field, rowDataQtyFieldKeys);
            String[] rowDataDcFields = ReportPrintHelper.getExistFileds(field, rowDataDcFieldKeys);
            String[] rowDataDateFields = ReportPrintHelper.getExistFileds(field, SubsiDiaryRptPrintNew.getFieldByTpye(PrintFieldTypeEnum.DATE.getValue()).toArray(rowDataDateFieldKeys));
            String[] rowDataDecimalFields = ReportPrintHelper.getExistFileds(field, rowDataDecimalFieldKeys);
            this.fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
            this.timeFormat = FormatFactory.get((FormatTypes)FormatTypes.Date).getFormat(this.fobj);
            boolean showqty = filter.getBoolean("showqty");
            String basecurrency = filter.getString(CURRENCY_HEAD);
            boolean noForAmount = CURRENCY_LOCAL.equals(basecurrency);
            int temp = 1;
            HashMap<String, Tuple2<String, String>> comAssistProp = new HashMap<String, Tuple2<String, String>>(2);
            List customDataRows = evt.getCustomDataRows();
            for (DynamicObject rowData : ds) {
                DataRowSet printRow = new DataRowSet();
                printRow.add(SEQ, (Field)new TextField(String.valueOf(temp)));
                ++temp;
                ReportPrintHelper.handleStringFields(rowData, printRow, rowDataStringFields);
                ReportPrintHelper.handleComboFields(rowData, printRow, rowDataStringFields);
                ReportPrintHelper.handleDateFields(rowData, printRow, this.timeFormat, rowDataDateFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_LOCAL, false, rowDataAmountLocalFields);
                if (noForAmount) {
                    if (field.contains("currencycolumn.name")) {
                        printRow.add("currencycolumn.name", (Field)new TextField(""));
                    }
                } else {
                    ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_FOR, false, rowDataAmountForFields);
                }
                ReportPrintHelper.handleDecimalFields(rowData, printRow, this.fobj, false, rowDataDecimalFields);
                ReportPrintHelper.handleDcFields(rowData, printRow, rowDataDcFields);
                if (showqty) {
                    ReportPrintHelper.handleQtyFields(rowData, printRow, false, MEASUREUNITFIELD, this.fobj, rowDataQtyFields);
                }
                this.comAssistFieldHandler(printRow, rowData, comAssistProp);
                customDataRows.add(printRow);
            }
        }
    }

    private void comAssistFieldHandler(DataRowSet printRow, DynamicObject row, Map<String, Tuple2<String, String>> flexProp) {
        if (this.comAssistColFields != null) {
            for (String field : this.comAssistColFields) {
                DynamicObject assgrp = row.getDynamicObject(field);
                if (assgrp == null) continue;
                Tuple2 tuple2 = flexProp.get(field);
                if (tuple2 == null) {
                    BasedataEntityType entityType = (BasedataEntityType)assgrp.getDataEntityType();
                    String name = entityType.getNameProperty();
                    String number = entityType.getNumberProperty();
                    tuple2 = new Tuple2((Object)name, (Object)number);
                    flexProp.put(field, (Tuple2<String, String>)tuple2);
                }
                printRow.add(field, (Field)new TextField(assgrp.getString((String)tuple2.t1)));
            }
        }
    }

    public void beforeLoadData(BeforeLoadDataEvent evt) {
        super.beforeLoadData(evt);
        PrtDataSource dataSource = evt.getDataSource();
        if (dataSource instanceof MainDataSource) {
            String pageId = ((MainDataSource)dataSource).getPageId();
            if (Objects.isNull(pageId)) {
                return;
            }
            ThreadCache.put((Object)ACCOUNTBALANCE_PRINT_PAGEID_CACHE, (Object)pageId);
            FilterInfo filterInfo = this.getListModel(pageId).getReportQueryParam().getFilter();
            this.showcomassist = filterInfo.getBoolean("showcomassist");
            List filterItemInfos = filterInfo.getFlexFilterItems();
            List<String> flexFields = filterItemInfos.stream().map(FilterItemInfo::getPropName).collect(Collectors.toList());
            Map flexInfoMap = FlexUtils.batchGetFlexProperty((String[])flexFields.toArray(new String[0]));
            for (int i = 0; i < filterItemInfos.size(); ++i) {
                String flexName = ((FilterItemInfo)filterItemInfos.get(i)).getPropName();
                String valueSource = ((FlexProperty)flexInfoMap.get(flexName)).getValueSource();
                String nameProp = "name";
                if (StringUtils.isNotEmpty((CharSequence)valueSource)) {
                    BasedataEntityType entity = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)((FlexProperty)flexInfoMap.get(flexName)).getValueSource());
                    nameProp = entity.getNameProperty();
                }
                this.assgrpFieldNameProp.put(flexName, nameProp);
            }
        }
    }

    public void beforeOutputWidget(BeforeOutputWidgetEvent e) {
        super.beforeOutputWidget(e);
        if (e.getWidgetKey().equals("DataGrid")) {
            String pageId = (String)ThreadCache.get((Object)ACCOUNTBALANCE_PRINT_PAGEID_CACHE);
            if (this.showcomassist) {
                this.createComAssistColumns((BeforeOutputGridEvent)e, pageId);
            }
        }
    }

    private void createComAssistColumns(BeforeOutputGridEvent e, String pageId) {
        ReportListModel model = this.getListModel(pageId);
        int rowCount = model.getRowCount();
        DynamicObjectCollection rows = model.getRowData(0, rowCount);
        this.addComAssistFieldPropertys(rows);
        List columns = model.getColumns();
        HashMap<String, String> colFieldAndNameMap = new HashMap<String, String>(1);
        ArrayList<String> assgrpFields = new ArrayList<String>(2);
        for (AbstractReportColumn column : columns) {
            ReportColumn reportColumn;
            if (!(column instanceof ReportColumn) || !(reportColumn = (ReportColumn)column).getFieldKey().startsWith("comassist") || !"basedata".equals(reportColumn.getFieldType())) continue;
            assgrpFields.add(reportColumn.getFieldKey());
            colFieldAndNameMap.put(reportColumn.getFieldKey(), reportColumn.getCaption().getLocaleValue());
        }
        int curColIndex = 5;
        int totalWidth = e.getRightSpace();
        int width = totalWidth / assgrpFields.size();
        for (String assgrpField : assgrpFields) {
            String itemName = (String)colFieldAndNameMap.get(assgrpField);
            this.createDynamicColumn(e, curColIndex, assgrpField, itemName, width);
            ++curColIndex;
        }
    }

    private void createDynamicColumn(BeforeOutputGridEvent e, int colIndex, String assgrpField, String colTitle, int width) {
        List pwGridCellBos = e.insertColumn(colIndex, width);
        int i = 0;
        for (PWGridCellBo po : pwGridCellBos) {
            if (i == 0) {
                po.setCellValue(colTitle);
            }
            if (i == 2) {
                po.setCellValue("reportlist", assgrpField);
            }
            ++i;
        }
        MergeBlock mb = MergeBlock.create((int)colIndex, (int)colIndex, (int)0, (int)1);
        e.addMerge(mb);
    }

    private void addComAssistFieldPropertys(DynamicObjectCollection ds) {
        this.comAssistColFields = new ArrayList<String>(2);
        DataEntityPropertyCollection propertyCollection = ds.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : propertyCollection) {
            String fieldKey = property.getName();
            if (!fieldKey.startsWith("comassist") || !(property instanceof BasedataProp)) continue;
            this.comAssistColFields.add(fieldKey);
        }
    }

    public void afterLoadData(AfterLoadDataEvent e) {
        super.afterLoadData(e);
        PrtDataSource dataSource = e.getDataSource();
        if (dataSource instanceof MainDataSource) {
            String pageId = ((MainDataSource)dataSource).getPageId();
            ReportListModel model = this.getListModel(pageId);
            if (model == null) {
                return;
            }
            Map<String, String> keyToCaption = this.getKeyToCaption(model);
            DynamicObjectCollection rowDatas = model.getRowData(0, ReportConfiguration.SUBSIDIARY_PRINT_LIMIT.getInt());
            HashMap<Integer, String> rowIndexsByPage = new HashMap<Integer, String>(1);
            HashMap<Integer, String[]> pageToaccAndass = new HashMap<Integer, String[]>(1);
            String tempStr = "";
            int key = 1;
            ArrayList<DataRowSet> dataRows = new ArrayList<DataRowSet>(1);
            for (DynamicObject rowData : rowDatas) {
                String assistVal;
                String acctName = rowData.getString("accountname");
                String acctNumber = rowData.getString("accountnumber");
                String str = String.join((CharSequence)"", acctNumber, acctName, assistVal = this.getAssistVal(keyToCaption, rowData));
                if (StringUtils.isBlank((CharSequence)str)) continue;
                int rowNo = rowData.getInt(SEQ);
                if (str.equalsIgnoreCase(tempStr)) continue;
                if (rowIndexsByPage.get(key) == null && key != rowNo) {
                    rowIndexsByPage.put(key, key - 1 + "-" + (rowNo - 1));
                }
                DataRowSet dsRow = new DataRowSet();
                tempStr = str;
                key = rowNo;
                pageToaccAndass.put(key, new String[]{acctNumber + acctName, assistVal});
                dsRow.add(headFieldKeys[0], (Field)new TextField(rowNo + ""));
                dataRows.add(dsRow);
            }
            e.setDataRowSets(dataRows);
            if (rowDatas.size() > 0) {
                rowIndexsByPage.put(key, key - 1 + "-" + rowDatas.size());
            }
            ThreadCache.put((Object)rowDataCacheKey, rowIndexsByPage);
            ThreadCache.put((Object)pageHeadCacheKey, pageToaccAndass);
        }
    }

    private ReportListModel getListModel(String pageId) {
        Map map;
        String printPageId;
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u89c6\u56fe\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\u3002", (String)"SubsiDiaryRptPrintNew_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        ReportQueryParam queryParam = view.getQueryParam();
        ReportList list = view.getReportList();
        ReportListModel listModel = (ReportListModel)list.getReportModel();
        IReportCache reportCache = ReportCacheManager.getInstance().getCache();
        ReportTaskResult reportTaskResult = reportCache.getReportTaskResult(printPageId = (String)(map = queryParam.getCustomParam()).computeIfAbsent("printPageId", k -> Uuid16.create().toString()), "reportlistap");
        if (reportTaskResult == null) {
            Object selectObj = map.get("selectObj");
            if (Objects.nonNull(selectObj)) {
                selectObj = SerializationUtils.deSerializeFromBase64((String)((String)selectObj));
            }
            String exportFlag = map.getOrDefault("exportFlag", "all");
            FilterInfo filter = queryParam.getFilter();
            List filterItems = filter.getFilterItems("exportexcel");
            if (Objects.isNull(filterItems)) {
                filter.addFilterItem("exportexcel", (Object)exportFlag, "=");
            } else {
                filterItems.clear();
                queryParam.getFilter().getFilterItems().removeIf(filterItemInfo -> "exportexcel".equals(filterItemInfo.getPropName()));
                filter.addFilterItem("exportexcel", (Object)exportFlag, "=");
            }
            reportCache.setReportQueryParam(printPageId, queryParam);
            AbstractReportListModel reportModel = (AbstractReportListModel)list.getReportModel();
            reportModel.setPageId(printPageId);
            list.setAsynQuery(true);
            list.submitTask(queryParam, selectObj);
        } else {
            listModel.setPageId(printPageId);
            listModel.setReportTaskResult(reportTaskResult);
        }
        return listModel;
    }

    private String getAssistVal(Map<String, String> keyToCaption, DynamicObject rowData) {
        ArrayList<String> allAssistVal = new ArrayList<String>(keyToCaption.size());
        for (Map.Entry<String, String> entry : keyToCaption.entrySet()) {
            StringBuilder sb = new StringBuilder(entry.getValue()).append("\uff1a");
            Object assistObj = rowData.get(entry.getKey());
            if (null != assistObj && assistObj instanceof DynamicObject) {
                DynamicObject assistDyn = (DynamicObject)assistObj;
                String flexField = entry.getKey();
                if (flexField.contains(".")) {
                    flexField = flexField.split("\\.")[0];
                }
                String displayType = FlexUtils.getFlexProperty((String)flexField).getDisplayStyle().getDisplayProperty().getValue();
                String displayFields = this.assgrpFieldNameProp.get(flexField);
                if ("4".equals(displayType)) {
                    displayFields = "longNumber";
                } else if ("5".equals(displayType)) {
                    displayFields = "fullName";
                }
                sb.append(assistDyn.getString(displayFields));
                allAssistVal.add(sb.toString());
                continue;
            }
            if (null == assistObj || "".equals(assistObj)) continue;
            sb.append(assistObj);
            allAssistVal.add(sb.toString());
        }
        return String.join((CharSequence)"\uff1b", allAssistVal);
    }

    private Map<String, String> getKeyToCaption(ReportListModel listModel) {
        List listColumns = listModel.getColumns();
        HashMap<String, String> keyToCaption = new HashMap<String, String>(listColumns.size());
        for (int i = 1; i < listColumns.size(); ++i) {
            ReportColumn column = (ReportColumn)listColumns.get(i);
            String key = column.getFieldKey();
            if (column.isHide()) continue;
            if ("accountnumber".equals(key)) break;
            String caption = column.getCaption().getLocaleValue();
            keyToCaption.put(key, caption);
        }
        return keyToCaption.entrySet().stream().sorted((o1, o2) -> ((String)o2.getKey()).compareTo((String)o1.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> newValue, LinkedHashMap::new));
    }

    private static List<String> getFieldByTpye(String type) {
        String[] arr = PrintFieldTypeEnum.DATE.getValue().equals(type) ? rowDataDateFieldKeys : (PrintFieldTypeEnum.AMOUNT.getValue().equals(type) ? rowDataAmountForFieldKeys : rowDataStringFieldKeys);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(arr));
        List fieldConfigs = ReportFieldSettingUtil.getDisplayFieldConfigs((String)"gl_rpt_subsidiaryledger");
        ArrayList dateList = new ArrayList();
        ArrayList amountList = new ArrayList();
        ArrayList stringList = new ArrayList();
        MainEntityType voucherEntity = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
        for (String field : fieldConfigs) {
            voucherEntity.getAllFields().entrySet().forEach(stringIDataEntityPropertyEntry -> {
                if (field.equals(stringIDataEntityPropertyEntry.getKey())) {
                    if (stringIDataEntityPropertyEntry.getValue() instanceof DateTimeProp) {
                        dateList.add(field);
                    } else if (stringIDataEntityPropertyEntry.getValue() instanceof AmountProp) {
                        amountList.add(field);
                    } else {
                        stringList.add(field);
                    }
                }
            });
        }
        if (PrintFieldTypeEnum.DATE.getValue().equals(type)) {
            list.addAll(dateList);
        } else if (PrintFieldTypeEnum.AMOUNT.getValue().equals(type)) {
            list.addAll(amountList);
        } else {
            list.addAll(stringList);
        }
        return list;
    }
}

