/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.accbalance.v2;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.IReportBatchQueryInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.configuration.ReportConfiguration;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.QueryParamFactory;
import kd.fi.gl.report.ReportMulLang;
import kd.fi.gl.report.accbalance.v2.model.RowType;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;

public class AccBalProcessRowDataHelper {
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    public static void processRowData(DynamicObjectCollection rowData, IReportView view, ReportQueryParam rptQueryParam) {
        MulOrgQPRpt param = (MulOrgQPRpt)QueryParamFactory.createOrGetWithThreadCache((ReportQueryParam)rptQueryParam, (String)"gl_rpt_accountbalance", (boolean)false);
        String accountNameField = GLUtil.getAcctNameBySysParam((Long)param.getPorg());
        boolean isShowPrice = param.isShowQty() && param.isShowPrice();
        boolean foreignCurr = param.isQueryCurrency();
        BasedataProp localCurrProp = (BasedataProp)view.getModel().getDataEntityType().getProperty("currencylocalid");
        DynamicObjectType currencyType = (DynamicObjectType)localCurrProp.getComplexType();
        long curLocal = param.getCurLocal();
        DynamicObject localCur = curLocal <= 0L ? null : BusinessDataServiceHelper.loadSingle((Object)curLocal, (DynamicObjectType)currencyType);
        boolean showOrgTree = param.isShowOrgTree();
        boolean isExport = AccBalProcessRowDataHelper.isExport((IFormView)view);
        for (DynamicObject row : rowData) {
            boolean isNotTotal;
            String orgName = row.getString("orgid.name");
            AccBalProcessRowDataHelper.setIfContains(row, "org", row.get("orgid"));
            AccBalProcessRowDataHelper.setIfContains(row, "curfor", row.get("currencyid"));
            AccBalProcessRowDataHelper.setIfContains(row, "accountnumber", row.get("number"));
            RowType rowType = RowType.valueOf((String)row.getString("rowtype"));
            switch (rowType) {
                case ACCT_SUMMARY: {
                    AccBalProcessRowDataHelper.setIfContains(row, "name", row.getLocaleString("number." + accountNameField).getLocaleValue());
                    if (!showOrgTree) break;
                    AccBalProcessRowDataHelper.setIfContains(row, "orgname", orgName);
                    break;
                }
                case CURR_SUMMARY: {
                    if (!isExport) {
                        AccBalProcessRowDataHelper.setIfContains(row, "number", null);
                        AccBalProcessRowDataHelper.setIfContains(row, "orgid", null);
                        break;
                    }
                    if (showOrgTree) break;
                    AccBalProcessRowDataHelper.setIfContains(row, "orgid", null);
                    break;
                }
                case ORG_SUMMARY: {
                    if (!showOrgTree) {
                        if (!isExport) {
                            AccBalProcessRowDataHelper.setIfContains(row, "number", null);
                            AccBalProcessRowDataHelper.setIfContains(row, "currencyid", null);
                        }
                    } else {
                        AccBalProcessRowDataHelper.setIfContains(row, "name", row.getLocaleString("number." + accountNameField).getLocaleValue());
                    }
                    AccBalProcessRowDataHelper.setIfContains(row, "orgname", orgName);
                    break;
                }
                case DETAIL_SUMMARY: {
                    if (!showOrgTree) {
                        if (isExport) break;
                        AccBalProcessRowDataHelper.setIfContains(row, "number", null);
                        AccBalProcessRowDataHelper.setIfContains(row, "currencyid", null);
                        AccBalProcessRowDataHelper.setIfContains(row, "orgid", null);
                        break;
                    }
                    AccBalProcessRowDataHelper.setIfContains(row, "name", row.getLocaleString("number." + accountNameField).getLocaleValue());
                    AccBalProcessRowDataHelper.setIfContains(row, "orgname", orgName);
                    break;
                }
                case TOTAL: {
                    AccBalProcessRowDataHelper.setIfContains(row, "name", ReportMulLang.getHeJi());
                    AccBalProcessRowDataHelper.checkIsOutOfLimit(view);
                }
            }
            boolean bl = isNotTotal = rowType != RowType.TOTAL;
            if (isExport && isNotTotal) {
                AccBalProcessRowDataHelper.setIfContains(row, "name", row.getLocaleString("number." + accountNameField).getLocaleValue());
            }
            if (isExport && showOrgTree && isNotTotal) {
                int level = row.getInt("orglevel");
                if (rowType == RowType.DETAIL_SUMMARY) {
                    ++level;
                }
                String exportOrgName = AccBalProcessRowDataHelper.getTreeOrgPrefix(level) + orgName;
                AccBalProcessRowDataHelper.setIfContains(row, "orgname", exportOrgName);
            }
            if (showOrgTree && !row.getBoolean("islink") && !isExport) {
                AccBalProcessRowDataHelper.setIfContains(row, "orgname", "<nolink>" + row.getString("orgname"));
            }
            row.set("currencylocalid", (Object)localCur);
            if (!isShowPrice) continue;
            String field = "yearbdebit#,yearbcredit#,begindebit#,begincredit#,debit#,credit#,enddebit#,endcredit#,yeardebit#,yearcredit#";
            AccBalProcessRowDataHelper.setPrice(foreignCurr, row, field);
        }
    }

    private static String getTreeOrgPrefix(int orgLevel) {
        StringBuilder sb = new StringBuilder();
        while (orgLevel-- > 0) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private static boolean isExport(IFormView view) {
        return Objects.nonNull(view.getPageCache().get("exportexcel"));
    }

    private static void setIfContains(DynamicObject row, String key, Object val) {
        if (row.containsProperty(key)) {
            row.set(key, val);
        }
    }

    protected static void setPrice(boolean foreignCurr, DynamicObject row, String field) {
        String suffix = foreignCurr ? "for" : "local";
        for (String str : field.split(",")) {
            String qty = str.replace("#", "qty");
            BigDecimal qtyBig = row.getBigDecimal(qty);
            if (qtyBig.compareTo(BigDecimal.ZERO) == 0) continue;
            String original = str.replace("#", suffix);
            String price = str.replace("#", "price");
            BigDecimal priceB = row.getBigDecimal(original).divide(qtyBig, 10, RoundingMode.HALF_UP);
            row.set(price, (Object)priceB);
        }
    }

    private static void checkIsOutOfLimit(IReportView view) {
        String queryId;
        ReportQueryParam queryParam = ((ReportList)view.getControl("reportlistap")).getReportCache().getReportQueryParam(view.getPageId());
        IReportBatchQueryInfo batchInfo = queryParam.byBatchInfo();
        if (batchInfo != null && (queryId = batchInfo.getBatchBy().getCacheId()) != null && Boolean.parseBoolean((String)CACHE.get(queryId + "#outoflimit"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u7684\u663e\u793a\u884c\u6570\u8d85\u51fa\u9650\u5236\uff0c\u4ec5\u5c55\u793a\u524d%s\u884c\u6570\u636e\u3002\u5982\u9700\u663e\u793a\u5168\u90e8\u6570\u636e\uff0c\u8bf7\u4f7f\u7528\u5f15\u51fa\u529f\u80fd\u3002", (String)"SubsiDiaryTreeFormRpt_100", (String)GLApp.instance.formpluginModule(), (Object[])new Object[]{ReportConfiguration.ACCBAL_DISPLAY_LIMIT.getInt()}));
        }
    }
}

