/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.closeperiod;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.closeperiod.ClosePeriodUtils;
import kd.fi.gl.closing.ClosingErrorCode;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.constant.AccountBook;
import kd.fi.gl.constant.closeperiod.ClosePeriodInfo;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLClosePeriodUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.QFBuilder;

public class ClosePeriodFormRpt
extends AbstractReportFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(ClosePeriodFormRpt.class);
    private static final String PARAM_APPID = "appid";
    private static final String ORG_ID = "org.id";
    private static final String BTN_SELECTALL = "selectall";
    private static final String BTN_CANCELSELECT = "cancelselect";
    private static final String BTN_CLOSE = "periodclose";
    private static final String BTN_ANTI_CLOSE = "reperiodclose";
    private static final String BTN_CLOSE_CHECK = "closecheck";
    private static final String BTN_CHECK_BREAK_NUMBER = "isconsistent";
    private static final String BTN_BROKEN_NUM_LOG = "brokennumberlogbtn";
    private static final String BTN_EXPORT = "exportexcel";
    private static final String APP_GL = "gl";
    private static final String APP_FIBD = "fibd";
    private static final String APP_FA = "fa";
    private static final String APP_AR = "ar";
    private static final String APP_AP = "ap";
    private static final String PERM_VIEW = "47150e89000000ac";
    private static final String PERM_EXPORT = "4730fc9f000004ae";
    private static final String LAB_FORMNAME = "formnamelabe";
    private static final String HISTORY_USER = "user";
    private static final String HISTORY_APP = "orgtype";
    private static final String BD_CLOSEDPERIODORGS = "bd_closedperiodorgs";
    private static final String CACHE_BOOK_TYPE_NAME = "bookTypeName";
    public static final String FBASEDATAID_ID = "fbasedataid_id";
    public static final String GL_CLOSEDPERIOD = "gl_closedperiod";
    private static final String closeStatus = "bd_closecheckitem";
    private static final String CUSTOM_PARAMS_KEY_MODEL = "model";
    public static final String EXPORTEXCEL = "exportexcel";
    public static final String EXPORTEXCEL_DATA = "exportexceldata";
    private static final String VIEWALL = "viewall";
    private static final String SHOWTREE = "showtree";
    private static final String AI_RECONCILIATION_RST_FST = "ai_reconciliation_rst_fst";
    private static final String FMR_RECONCILIATION_RST_FST = "frm_reconciliation_rst_fst";
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.periodClose);
    private OrgBookInfo bookCache;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        MulBasedataEdit mulOrgEdit = (MulBasedataEdit)this.getControl("periodcloseorg");
        if (mulOrgEdit != null) {
            mulOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (!APP_GL.equals(this.getAppId())) {
            BasedataEdit periodEdit = (BasedataEdit)this.getControl("periodedit");
            periodEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE));
            });
        }
        final ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                int rowIndex = evt.getRowIndex();
                DynamicObject rowData = reportList.getReportModel().getRowData(rowIndex);
                DynamicObject bookTypeDyn = rowData.getDynamicObject("booktype");
                Long periodId = bookTypeDyn.getLong("curperiod.id");
                String formNumber = rowData.getString("formnumber");
                String queryContitions = rowData.getString("formquery");
                String key = rowData.getString("dealfail");
                if (key.equals(ResManager.loadKDString((String)"\u5904\u7406", (String)"ClosePeriodFormRpt_0", (String)"fi-gl-formplugin", (Object[])new Object[0]))) {
                    if ("gl_voucherbreakpoint".equals(formNumber)) {
                        Long bookTypeId = bookTypeDyn.getLong("id");
                        Long org = bookTypeDyn.getLong(ClosePeriodFormRpt.ORG_ID);
                        ClosePeriodUtils.createVoucherBreakPoingOnCloseDetail((Long)bookTypeId, (Long)org, (Long)periodId, (IFormView)ClosePeriodFormRpt.this.getView());
                    } else if (ClosePeriodFormRpt.AI_RECONCILIATION_RST_FST.equals(formNumber) || ClosePeriodFormRpt.FMR_RECONCILIATION_RST_FST.equals(formNumber)) {
                        HashMap<String, String> customParams = new HashMap<String, String>(1);
                        customParams.put(ClosePeriodFormRpt.CUSTOM_PARAMS_KEY_MODEL, queryContitions);
                        ClosePeriodUtils.createFormOnCloseDetail((String)formNumber, customParams, (IFormView)ClosePeriodFormRpt.this.getView());
                    } else if ("gl_voucher".equals(formNumber)) {
                        QFilter filter = null;
                        try {
                            filter = QFilter.fromSerializedString((String)queryContitions);
                        }
                        catch (Exception e) {
                            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8df3\u8f6c\u51ed\u8bc1\u5217\u8868\u7684\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"ClosePeriodFormRpt_5", (String)"fi-gl-formplugin", (Object[])new Object[0])});
                        }
                        ClosePeriodUtils.createVoucherListOnCloseDetail((QFilter)filter, (Long)periodId, (IFormView)ClosePeriodFormRpt.this.getView());
                    } else {
                        ClosePeriodUtils.createJumpInterfaceOnCloseDetail((String)formNumber, (String)queryContitions, (IFormView)ClosePeriodFormRpt.this.getView());
                    }
                } else if (key.equals(ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"ClosePeriodFormRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]))) {
                    if (ClosePeriodFormRpt.AI_RECONCILIATION_RST_FST.equals(formNumber) || ClosePeriodFormRpt.FMR_RECONCILIATION_RST_FST.equals(formNumber)) {
                        HashMap<String, String> customParams = new HashMap<String, String>(1);
                        customParams.put(ClosePeriodFormRpt.CUSTOM_PARAMS_KEY_MODEL, queryContitions);
                        ClosePeriodUtils.createFormOnCloseDetail((String)formNumber, customParams, (IFormView)ClosePeriodFormRpt.this.getView());
                    } else {
                        ClosePeriodFormRpt.this.getView().showMessage(rowData.getString("message"));
                    }
                }
            }
        });
        Object periodType = this.getModel().getValue("periodtype");
        if (periodType != null) {
            BasedataEdit period;
            BasedataEdit periodEdit = (BasedataEdit)this.getControl("periodedit");
            long periodTypeId = ((DynamicObject)periodType).getLong("id");
            if (periodEdit != null) {
                periodEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                    beforeF7SelectEvent.getCustomQFilters().add(new QFilter("periodtype", "=", (Object)periodTypeId));
                    ListShowParameter showParam = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    DynamicObject period = (DynamicObject)this.getModel().getValue("periodedit");
                    if (period != null) {
                        showParam.setSelectedRow(period.getPkValue());
                    }
                });
            }
            if ((period = (BasedataEdit)this.getView().getControl("period")) != null) {
                period.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                    beforeF7SelectEvent.getCustomQFilters().add(new QFilter("periodtype", "=", (Object)periodTypeId));
                    ListShowParameter showParam = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    DynamicObject periodObj = (DynamicObject)this.getModel().getValue("period");
                    if (periodObj != null) {
                        showParam.setSelectedRow(periodObj.getPkValue());
                    }
                });
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo.getLong("periodtype") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u7c7b\u578b\u3002", (String)"ClosePeriodFormRpt_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("periodedit") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u8d26\u81f3\u3002", (String)"ClosePeriodFormRpt_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.getPageCache().get(VIEWALL))) {
            this.removeCache();
        }
        queryParam.getCustomParam().put("pageid", this.getView().getPageId());
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<Long> allCLoseableOrgs = this.getHasViewPermOrgIds();
        this.orgManage(Boolean.TRUE);
        this.checkExportPerm();
    }

    public void afterQuery(ReportQueryParam queryParam) {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(VIEWALL))) {
            ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
            ReportQueryParam reportQueryParam = reportlistap.getReportCache().getReportQueryParam(this.getView().getPageId());
            reportQueryParam.getCustomParam().put("pageid", this.getView().getPageId());
            reportlistap.getReportCache().setReportQueryParam(this.getView().getPageId(), reportQueryParam);
            this.getPageCache().remove(VIEWALL);
        }
    }

    private void orgManage(boolean createNewData) {
        ClosePeriodInfo closeInfo = this.getCloseInfo();
        List<Object> allOrgIds = Objects.isNull(this.bookCache) ? new ArrayList(8) : this.bookCache.getAllOrgIds();
        allOrgIds.remove(0L);
        if (allOrgIds.isEmpty()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"periodcloseorg", "periodedit", "bookscombo"});
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u542f\u7528\u7684%s\u3002", (String)"ClosePeriodFormRpt_8", (String)"fi-gl-formplugin", (Object[])new Object[0]), closeInfo.getOrgFieldName()));
            return;
        }
        HashSet<Long> closeOrgIds = new HashSet<Long>();
        if (createNewData) {
            Long currentOrgId = RequestContext.get().getOrgId();
            if (allOrgIds.contains(currentOrgId)) {
                closeOrgIds.add(currentOrgId);
            } else {
                Set<Long> historyCloseOrgs = this.getHistoryCloseOrgs();
                historyCloseOrgs.retainAll(allOrgIds);
                if (!historyCloseOrgs.isEmpty()) {
                    closeOrgIds.addAll(historyCloseOrgs);
                } else {
                    long defaultOrgId = AccSysUtil.getDefaultOrgId((String)this.getView().getEntityId(), (boolean)false, (PermissonType)PermissonType.VIEW);
                    if (allOrgIds.contains(defaultOrgId)) {
                        closeOrgIds.add(defaultOrgId);
                    } else {
                        closeOrgIds.add((Long)allOrgIds.get(0));
                    }
                }
            }
            this.getModel().setValue("periodcloseorg", (Object)closeOrgIds.toArray());
        } else {
            closeOrgIds.addAll(allOrgIds);
        }
        this.putHistoryCloseOrgs(closeOrgIds);
        this.bookTypeEditInit();
        this.periodManage(false);
    }

    private Set<Long> getHistoryCloseOrgs() {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(HISTORY_USER, "=", (Object)ContextUtil.getUserId());
        qfBuilder.add(HISTORY_APP, "=", (Object)this.getAppId());
        return QueryServiceHelper.query((String)BD_CLOSEDPERIODORGS, (String)"org", (QFilter[])qfBuilder.toArray()).stream().map(x -> x.getLong("org")).collect(Collectors.toSet());
    }

    private void putHistoryCloseOrgs(Set<Long> orgIds) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(HISTORY_USER, "=", (Object)ContextUtil.getUserId());
        qfBuilder.add(HISTORY_APP, "=", (Object)this.getAppId());
        DeleteServiceHelper.delete((String)BD_CLOSEDPERIODORGS, (QFilter[])qfBuilder.toArray());
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])orgIds.stream().map(x -> {
            DynamicObject historyDO = BusinessDataServiceHelper.newDynamicObject((String)BD_CLOSEDPERIODORGS);
            historyDO.set(HISTORY_USER, (Object)ContextUtil.getUserId());
            historyDO.set("org", x);
            historyDO.set(HISTORY_APP, (Object)this.getAppId());
            return historyDO;
        }).toArray(DynamicObject[]::new)));
    }

    private void bookTypeEditInit() {
        ClosePeriodInfo closeInfo = this.getCloseInfo();
        String typeFieldName = closeInfo.getTypeFieldName();
        if (StringUtils.isNotBlank((CharSequence)typeFieldName)) {
            DynamicObjectCollection orgDOs = (DynamicObjectCollection)this.getModel().getValue("periodcloseorg");
            List orgIds = orgDOs.stream().map(x -> x.getLong(FBASEDATAID_ID)).collect(Collectors.toList());
            List allBooks = orgIds.stream().flatMap(x -> this.bookCache.getBooks((long)x).stream()).collect(Collectors.toList());
            Map<Object, String> allBookTypes = allBooks.stream().collect(Collectors.toMap(x -> x.getDynamicObject(typeFieldName).getPkValue(), x -> x.getDynamicObject(typeFieldName).getString("name"), (oldVal, newVal) -> newVal));
            if (allBookTypes.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bookscombo"});
                this.getView().setVisible(Boolean.FALSE, new String[]{LAB_FORMNAME});
            } else {
                this.putBookTypeName(EntityMetadataCache.getDataEntityType((String)closeInfo.getFormId()).getProperty(typeFieldName).getDisplayName().getLocaleValue());
                List comboItems = allBookTypes.entrySet().stream().map(x -> {
                    ComboItem comboItem = new ComboItem();
                    comboItem.setCaption(new LocaleString((String)x.getValue()));
                    comboItem.setValue(x.getKey().toString());
                    return comboItem;
                }).collect(Collectors.toList());
                ComboEdit comboEdit = (ComboEdit)this.getControl("bookscombo");
                comboEdit.setComboItems(comboItems);
                Long bookTypeId = Long.valueOf(((ComboItem)comboItems.get(0)).getValue());
                if (closeInfo.getBizapp().equals(APP_GL)) {
                    DynamicObject bookType;
                    if (orgIds.size() == 1) {
                        QFilter orgQF = new QFilter("company", "in", orgIds);
                        QFilter subsysFormNumQF = new QFilter("subsysformnum", "=", (Object)closeInfo.getFormId());
                        DynamicObjectCollection allState = QueryServiceHelper.query((String)"gl_closestate", (String)"closedate, accountbooks", (QFilter[])new QFilter[]{orgQF, subsysFormNumQF}, (String)"closedate desc", (int)1);
                        if (allState.size() > 0) {
                            Long accountBookId = ((DynamicObject)allState.get(0)).getLong("accountbooks");
                            for (DynamicObject accountBook : allBooks) {
                                if (!accountBookId.equals(accountBook.getPkValue())) continue;
                                bookTypeId = (Long)accountBook.getDynamicObject(closeInfo.getTypeFieldName()).getPkValue();
                            }
                        }
                    } else if (orgIds.size() > 1 && (bookType = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{new QFilter("accounttype", "=", (Object)"1")})) != null && comboItems.stream().anyMatch(comboItem -> bookType.getLong("id") == Long.parseLong(comboItem.getValue()))) {
                        bookTypeId = bookType.getLong("id");
                    }
                }
                this.getModel().setValue("bookscombo", (Object)bookTypeId);
                if (comboItems.size() == 1) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bookscombo"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{LAB_FORMNAME});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bookscombo"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{LAB_FORMNAME});
                }
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bookscombo"});
            this.getView().setVisible(Boolean.FALSE, new String[]{LAB_FORMNAME});
        }
    }

    private void periodManage(boolean isNull) {
        QFBuilder qfBuilder = new QFBuilder();
        DynamicObjectCollection orgDOs = (DynamicObjectCollection)this.getModel().getValue("periodcloseorg");
        if (!orgDOs.isEmpty()) {
            List orgIds = orgDOs.stream().map(x -> x.getLong(FBASEDATAID_ID)).collect(Collectors.toList());
            qfBuilder.add("org", "in", orgIds);
        }
        String bookTypeStr = (String)this.getModel().getValue("bookscombo");
        ClosePeriodInfo closeInfo = this.getCloseInfo();
        if (StringUtils.isNotBlank((CharSequence)closeInfo.getTypeFieldName()) && StringUtils.isNotBlank((CharSequence)bookTypeStr)) {
            qfBuilder.add(closeInfo.getTypeFieldName(), "=", (Object)Long.parseLong(bookTypeStr));
        }
        DynamicObject[] allBooks = BusinessDataServiceHelper.load((String)closeInfo.getFormId(), (String)String.join((CharSequence)",", "curperiod", "periodtype", "org", "bookstype"), (QFilter[])qfBuilder.toArray());
        boolean gl = APP_GL.equals(this.getAppId());
        HashMap<String, Long> periodNumbers = new HashMap<String, Long>(allBooks.length);
        for (DynamicObject bookDO : allBooks) {
            DynamicObject periodDO;
            List openPeriods;
            Long periodType;
            if (isNull && !(periodType = Long.valueOf(((DynamicObject)this.getModel().getValue("periodtype")).getLong("id"))).equals(bookDO.getLong(AccountBook.id_((String)"periodtype")))) continue;
            String periodNumber = "";
            DynamicObject curPeriodDO = bookDO.getDynamicObject("curperiod");
            if (!Objects.isNull(curPeriodDO)) {
                periodNumber = curPeriodDO.getString("number");
            }
            if (gl && !(openPeriods = GLUtil.getOpenPeriod((long)bookDO.getLong(ORG_ID), (long)bookDO.getLong(AccountBook.id_((String)"bookstype")))).isEmpty() && (periodDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"number", (QFilter[])new QFBuilder("id", "=", openPeriods.get(0)).toArray())) != null) {
                periodNumber = periodDO.getString("number");
            }
            if (!StringUtils.isNotBlank((CharSequence)periodNumber)) continue;
            periodNumbers.put(periodNumber, bookDO.getLong(AccountBook.id_((String)"periodtype")));
        }
        if (!periodNumbers.isEmpty()) {
            ArrayList nums = new ArrayList(periodNumbers.keySet());
            Collections.sort(nums);
            String maxPeriodNumber = (String)nums.get(nums.size() - 1);
            long periodTypeId = (Long)periodNumbers.get(maxPeriodNumber);
            qfBuilder.clear();
            qfBuilder.add("periodtype", "=", (Object)periodTypeId);
            qfBuilder.add("number", "=", (Object)maxPeriodNumber);
            DynamicObjectCollection periodDOs = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])qfBuilder.toArray(), (String)String.join((CharSequence)",", "periodyear desc", "periodnumber desc"));
            if (periodDOs.isEmpty()) {
                return;
            }
            DynamicObject maxPeriodDO = (DynamicObject)periodDOs.get(0);
            DynamicObject nextPeriodDO = GLUtil.getNextPeriod((Object)maxPeriodDO.getLong("id"), (boolean)APP_GL.equalsIgnoreCase(this.getAppId()));
            if (nextPeriodDO == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u4e00\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4\u4e0b\u4e00\u671f\u95f4\u3002", (String)"ClosePeriodFormRpt_9", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("periodedit", (Object)maxPeriodDO.getLong("id"));
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_CLOSE});
            } else {
                this.getModel().setValue("periodedit", nextPeriodDO.get("id"));
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_CLOSE, BTN_ANTI_CLOSE});
                this.getModel().setValue("periodtype", nextPeriodDO.get(AccountBook.id_((String)"periodtype")));
            }
        }
        if (allBooks.length > 0) {
            Set allBookDyns = Arrays.stream(allBooks).collect(Collectors.toSet());
            String bookValue = (String)this.getModel().getValue("bookscombo");
            if (StringUtils.isNotEmpty((CharSequence)bookValue)) {
                allBookDyns = allBookDyns.stream().filter(e -> bookValue.equals(e.getString(AccountBook.id_((String)"bookstype")))).collect(Collectors.toSet());
            }
            Set periodTypeIds = allBookDyns.stream().map(e -> e.getLong(AccountBook.id_((String)"periodtype"))).collect(Collectors.toSet());
            BasedataEdit periodEdit = (BasedataEdit)this.getView().getControl("periodtype");
            periodEdit.setQFilter(new QFilter("id", "in", periodTypeIds));
            this.getModel().setValue("periodtype", periodTypeIds.iterator().next());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u8d26\u7c3f\u3002", (String)"ClosePeriodFormRpt_25", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    private void putBookTypeName(String bookTypeName) {
        this.getPageCache().put(CACHE_BOOK_TYPE_NAME, bookTypeName);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        this.mulOrgEditBeforeF7Select(e);
    }

    private void mulOrgEditBeforeF7Select(BeforeF7SelectEvent e) {
        FormShowParameter param = e.getFormShowParameter();
        ListFilterParameter listFilterParameter = ((ListShowParameter)param).getListFilterParameter();
        listFilterParameter.getQFilters().add(new QFilter("id", "in", this.getHasViewPermOrgIds()));
    }

    private List<Long> getHasViewPermOrgIds() {
        ClosePeriodInfo closeInfo = this.getCloseInfo();
        String appId = AppMetadataCache.getAppInfo((String)closeInfo.getBizapp()).getId();
        HasPermOrgResult viewPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)this.getView().getEntityId(), (String)PERM_VIEW);
        List hasViewOrgIdList = null;
        if (!viewPermOrgResult.hasAllOrgPerm()) {
            hasViewOrgIdList = viewPermOrgResult.getHasPermOrgs();
        }
        if (null != hasViewOrgIdList && hasViewOrgIdList.isEmpty()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"periodcloseorg", "periodedit", "bookscombo"});
            String fromId = closeInfo.getBizapp().equals(APP_GL) ? "gl_autocloseperiod" : closeInfo.getFormId();
            String message = MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728{0}\u67e5\u8be2\u6743\u9650\u3002", (String)"ClosePeriodFormRpt_10", (String)"fi-gl-formplugin", (Object[])new Object[0]), MetadataServiceHelper.getDataEntityType((String)fromId).getDisplayName());
            this.getView().showTipNotification(message);
        }
        this.getAndCacheBookInfo(hasViewOrgIdList);
        return this.bookCache.getAllOrgIds();
    }

    private ClosePeriodInfo getCloseInfo() {
        String cacheVal = this.getPageCache().get("closeInfo");
        if (StringUtils.isNotBlank((CharSequence)cacheVal)) {
            return (ClosePeriodInfo)SerializationUtils.fromJsonString((String)cacheVal, ClosePeriodInfo.class);
        }
        ClosePeriodInfo closeInfo = new ClosePeriodInfo();
        closeInfo.setBizapp(this.getAppId());
        DynamicObject registerInfo = QueryServiceHelper.queryOne((String)"bd_accountbookregister", (String)String.join((CharSequence)",", "formid", "booktypefieldid"), (QFilter[])new QFilter("bizapp", "=", (Object)closeInfo.getBizapp()).toArray());
        if (registerInfo == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"periodcloseorg", "periodedit", "bookscombo"});
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8be5\u9886\u57df\u672a\u6ce8\u518c\u7ed3\u8d26\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u652f\u6301\u534f\u52a9\u6ce8\u518c\u540e\u518d\u4f7f\u7528\u3002", (String)"ClosePeriodFormRpt_11", (String)"fi-gl-formplugin", (Object[])new Object[0])});
        }
        closeInfo.setTypeFieldName(registerInfo.getString("booktypefieldid"));
        closeInfo.setFormId(registerInfo.getString("formid"));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)closeInfo.getFormId());
        LocaleString orgDisplayName = dataEntityType.getProperty("org").getDisplayName();
        closeInfo.setOrgFieldName(orgDisplayName.getLocaleValue());
        this.getPageCache().put("closeInfo", SerializationUtils.toJsonString((Object)closeInfo));
        return closeInfo;
    }

    private void getAndCacheBookInfo(List<Long> orgIds) {
        ClosePeriodInfo closeInfo = (ClosePeriodInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get("closeInfo"), ClosePeriodInfo.class);
        QFBuilder qfBuilder = new QFBuilder();
        if (!Objects.isNull(orgIds)) {
            qfBuilder.add("org", "in", orgIds);
        }
        switch (closeInfo.getBizapp()) {
            case "gl": {
                qfBuilder.add("isbizunit", "=", (Object)Boolean.TRUE);
                qfBuilder.add("isendinit", "=", (Object)Boolean.TRUE);
                List bootTypeIds = AccSysUtil.getBookTypeDataPermission(orgIds);
                if (bootTypeIds == null) break;
                qfBuilder.add("bookstype", "in", (Object)bootTypeIds);
                break;
            }
            case "fa": {
                String faBookStatusKey = "status";
                String faBookStatusValue = "C";
                qfBuilder.add(faBookStatusKey, "in", (Object)faBookStatusValue);
                break;
            }
            case "ar": 
            case "ap": {
                String arBookInitKey = "isfinishinit";
                String arBookInitValue = "1";
                qfBuilder.add(arBookInitKey, "=", (Object)arBookInitValue);
            }
        }
        DynamicObject[] bookDOs = BusinessDataServiceHelper.load((String)closeInfo.getFormId(), (String)String.join((CharSequence)",", "curperiod", "startperiod", "org", closeInfo.getTypeFieldName(), "periodtype"), (QFilter[])qfBuilder.toArray());
        this.bookCache = new OrgBookInfo();
        if (bookDOs != null && bookDOs.length > 0) {
            for (DynamicObject bookDO : bookDOs) {
                this.bookCache.putOrgBook(bookDO.getLong(ORG_ID), bookDO);
            }
        }
        if (this.bookCache.getAllOrgIds().isEmpty()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"periodcloseorg", "periodedit", "bookscombo"});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u516c\u53f8\u65e0\u7ed3\u8d26\u6743\u9650\u3002", (String)"ClosePeriodFormRpt_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        IDataModel m = this.getModel();
        if ("periodcloseorg".equals(propertyName)) {
            DynamicObjectCollection coll = (DynamicObjectCollection)m.getValue("periodcloseorg");
            int size = coll.size();
            if (size > 0) {
                ArrayList<Long> ids = new ArrayList<Long>(size);
                for (DynamicObject dynamicObject : coll) {
                    ids.add(dynamicObject.getLong(2));
                }
                this.getAndCacheBookInfo(ids);
            } else {
                this.getHasViewPermOrgIds();
            }
            this.orgManage(Boolean.FALSE);
        } else if ("bookscombo".equals(propertyName)) {
            boolean isNull = ObjectUtils.isEmpty((Object)e.getChangeSet()[0].getNewValue());
            this.periodManage(isNull);
        } else if ("periodtype".equals(propertyName)) {
            this.getModel().setValue("period", null);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "exportexcel": {
                this.getPageCache().put("exportexcel", "true");
                break;
            }
        }
    }

    public void afterSetModelValue(DynamicObject scheme) {
        super.afterSetModelValue(scheme);
        IDataModel model = this.getModel();
        ArrayList newOrgs = new ArrayList();
        HashSet<Long> allPermOrg = new HashSet<Long>(this.getHasViewPermOrgIds());
        if (model.getProperty("periodcloseorg") != null) {
            DynamicObjectCollection periodCloseOrg = (DynamicObjectCollection)this.getModel().getValue("periodcloseorg");
            if (CollectionUtils.isEmpty((Collection)periodCloseOrg)) {
                return;
            }
            periodCloseOrg.stream().map(org -> org.getLong("fbasedataid.id")).forEach(newOrgs::add);
            boolean allLegalOrg = allPermOrg.containsAll(newOrgs);
            if (!allLegalOrg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u65b9\u6848\u7ec4\u7ec7\u7684\u67e5\u8be2\u6743\u9650\uff0c\u65e0\u6cd5\u52a0\u8f7d\u65b9\u6848\u3002", (String)"GLRptTemplatePlugin_100", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                model.setValue("periodcloseorg", null);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("refresh".equals(key) || "close".equals(key)) {
            return;
        }
        ReportList control = (ReportList)this.getControl("reportlistap");
        int[] rowIdxs = control.getEntryState().getSelectedRows();
        if (!(BTN_SELECTALL.equals(key) || BTN_CANCELSELECT.equals(key) || "exportexcel".equals(key) || VIEWALL.equals(key) || SHOWTREE.equals(key) || rowIdxs.length != 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"ClosePeriodFormRpt_22", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "periodclose": {
                String msgTemplate;
                DynamicObject periodDO = (DynamicObject)this.getModel().getValue("periodedit");
                if (periodDO == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7ed3\u8d26\u7684\u671f\u95f4\u3002", (String)"ClosePeriodFormRpt_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<Long, Set> orgAndBookTypeMap = new HashMap<Long, Set>(8);
                HashMap<Long, String> orgIdToNameMap = new HashMap<Long, String>(rowIdxs.length);
                for (int i2 = 0; i2 < rowIdxs.length; ++i2) {
                    DynamicObject book = control.getReportModel().getRowData(rowIdxs[i2]).getDynamicObject("booktype");
                    long orgId2 = book.getLong(ORG_ID);
                    String orgName2 = book.getLocaleString("org.name").getLocaleValue();
                    orgIdToNameMap.put(orgId2, orgName2);
                    Set orgAndBookTypeSet = orgAndBookTypeMap.computeIfAbsent(orgId2, k -> new HashSet(8));
                    orgAndBookTypeSet.add(orgName2 + "_" + book.getLocaleString("bookstype.name").getLocaleValue());
                }
                if (CollectionUtils.isEmpty(orgAndBookTypeMap)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u7ec4\u7ec7\u8d26\u7c3f\u3002", (String)"ClosePeriodFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                Optional hasClosePermOrgIdsOptional = ClosePeriodUtils.getHasClosePermOrgIds((ClosePeriodInfo)this.getCloseInfo());
                HashSet unableCloseOrgIdSet = new HashSet(orgIdToNameMap.keySet());
                HashSet ableCloseOrgIdSet = new HashSet(orgIdToNameMap.keySet());
                String noClosePermMsg = "";
                if (hasClosePermOrgIdsOptional.isPresent()) {
                    List hasClosePermOrgIds = (List)hasClosePermOrgIdsOptional.get();
                    hasClosePermOrgIds.forEach(unableCloseOrgIdSet::remove);
                    if (!CollectionUtils.isEmpty(unableCloseOrgIdSet)) {
                        ableCloseOrgIdSet.removeAll(unableCloseOrgIdSet);
                        if (ableCloseOrgIdSet.isEmpty()) {
                            String formName = MetadataServiceHelper.getDataEntityType((String)"gl_autocloseperiod").getDisplayName().getLocaleValue();
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u7ed3\u8d26\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PeriodcloseHomePlugin_23", (String)"fi-gl-formplugin", (Object[])new Object[]{formName}));
                            return;
                        }
                        msgTemplate = ResManager.loadKDString((String)"%s\u65e0\u201c\u7ed3\u8d26\u201d\u6743\u9650\uff1b", (String)"ClosePeriodFormRpt_24", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                        noClosePermMsg = unableCloseOrgIdSet.stream().map(orgId -> orgIdToNameMap.getOrDefault(orgId, "")).map(orgName -> String.format(msgTemplate, orgName)).collect(Collectors.joining("\r\n"));
                    }
                }
                String headMsg = ResManager.loadKDString((String)"\u4e0b\u5217\u8d26\u7c3f\u5c06\u8fdb\u884c\u7ed3\u8d26\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ClosePeriodFormRpt_14", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                msgTemplate = ResManager.loadKDString((String)"%1$s%2$s\u5c06\u7ed3\u8d26\u5230%3$s\uff1b", (String)"ClosePeriodFormRpt_15", (String)"fi-gl-formplugin", (Object[])new Object[0]);
                ArrayList allOrgAndBookTypeList = new ArrayList(8);
                orgAndBookTypeMap.entrySet().stream().filter(entry -> ableCloseOrgIdSet.contains(entry.getKey())).forEach(entry -> allOrgAndBookTypeList.addAll((Collection)entry.getValue()));
                String confirmMsg = allOrgAndBookTypeList.stream().map(e -> String.format(msgTemplate, e.split("_")[0], e.split("_")[1], periodDO.getString("name"))).collect(Collectors.joining("\r\n"));
                this.getView().showConfirm(headMsg, confirmMsg + "\r\n" + noClosePermMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(BTN_CLOSE));
                break;
            }
            case "reperiodclose": {
                FormShowParameter parame = new FormShowParameter();
                parame.setFormId("gl_reperiodclosepopup");
                parame.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
                parame.setCloseCallBack(closeCallBack);
                DynamicObject coll = (DynamicObject)this.getModel().getValue("periodedit");
                if (coll == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u8d26\u81f3\u3002", (String)"ClosePeriodFormRpt_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashSet<Long> orgList = new HashSet<Long>(rowIdxs.length);
                Long booksType = 0L;
                for (int i3 = 0; i3 < rowIdxs.length; ++i3) {
                    DynamicObject book = control.getReportModel().getRowData(rowIdxs[i3]).getDynamicObject("booktype");
                    orgList.add(book.getLong("org_id"));
                    if (booksType != 0L && !booksType.equals(book.getLong("bookstype_id"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u4e0d\u540c\uff0c\u65e0\u6cd5\u540c\u65f6\u53cd\u7ed3\u8d26\u3002", (String)"ClosePeriodFormRpt_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    booksType = book.getLong("bookstype_id");
                }
                if (CollectionUtils.isEmpty(orgList)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u7ec4\u7ec7\u8d26\u7c3f\u3002", (String)"ClosePeriodFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                ClosePeriodInfo closeInfo = this.getCloseInfo();
                parame.setCustomParam("orglist", (Object)SerializationUtils.toJsonString(orgList));
                parame.setCustomParam("entityname", (Object)closeInfo.getFormId());
                parame.setCustomParam("periodtype", coll.getDynamicObject("periodtype").getPkValue());
                parame.setCustomParam(PARAM_APPID, (Object)closeInfo.getBizapp());
                parame.setCustomParam("booktype", (Object)booksType);
                parame.setCustomParam("booktypefield", (Object)closeInfo.getTypeFieldName());
                parame.setCustomParam("rowIndxs", (Object)SerializationUtils.toJsonString((Object)CollectionUtils.arrayToList((Object)rowIdxs)));
                parame.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_ANTI_CLOSE));
                this.getView().showForm(parame);
                break;
            }
            case "closecheck": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7ed3\u8d26\u68c0\u67e5", (String)"ClosePeriodFormRpt_21", (String)"fi-gl-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u8d26\u68c0\u67e5\u53ea\u68c0\u67e5\u5f53\u524d\u671f\u95f4,\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ClosePeriodFormRpt_20", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(BTN_CLOSE_CHECK));
                break;
            }
            case "isconsistent": {
                boolean hasPermission = this.checkQueryPermission();
                if (!hasPermission) {
                    return;
                }
                new GLClosePeriodUtil().beforeCheckBreakPoint((AbstractFormPlugin)this);
                break;
            }
            case "brokennumberlogbtn": {
                boolean hasPermission1 = this.checkQueryPermission();
                if (!hasPermission1) {
                    return;
                }
                boolean flag = new GLClosePeriodUtil().brokenNumberLogBtnCheck((AbstractFormPlugin)this);
                if (!flag) break;
                this.showVoucherBPLogForm();
                break;
            }
            case "selectall": 
            case "cancelselect": {
                int rowCount = control.getReportModel().getRowCount();
                ArrayList<Integer> list = new ArrayList<Integer>(rowCount);
                for (int i4 = 1; i4 <= rowCount; ++i4) {
                    list.add(i4);
                }
                control.selectRows(BTN_SELECTALL.equals(key) ? list.stream().mapToInt(i -> i).toArray() : new int[]{}, 0);
                break;
            }
            case "viewall": {
                this.cache.put(this.getView().getPageId() + VIEWALL, "true");
                this.getView().refresh();
                break;
            }
            case "showtree": {
                this.getView().refresh();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (BTN_CLOSE.equals(e.getActionId())) {
            TaskInfo taskInfo;
            String taskInfoStr;
            Map result = (Map)returnData;
            if (result.containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                String data = taskInfo.getData();
                try {
                    Map map = (Map)JSONUtils.cast((String)data, HashMap.class);
                    this.cache.put(this.getView().getPageId() + "closeresult", map.get("closeresult").toString());
                    this.refresh();
                }
                catch (IOException exception) {
                    log.error((Throwable)exception);
                }
            }
        } else if (BTN_ANTI_CLOSE.equalsIgnoreCase(e.getActionId())) {
            List mulSelectPeriodIds = null;
            List rowIndexs = null;
            if (returnData instanceof Map) {
                Map map = (Map)returnData;
                mulSelectPeriodIds = (List)map.get("periodIds");
                rowIndexs = (List)map.get("rowIndxs");
            }
            if (Objects.isNull(mulSelectPeriodIds) || Objects.isNull(rowIndexs)) {
                return;
            }
            if (mulSelectPeriodIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53cd\u7ed3\u8d26\u7684\u671f\u95f4\u3002", (String)"ClosePeriodFormRpt_16", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            this.removeCache();
            boolean result = ClosePeriodUtils.doReverseClosing((IFormPlugin)this, (IFormView)this.getView(), (List)mulSelectPeriodIds, (boolean)false, (boolean)true);
            if (result) {
                ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
                reportlistap.refresh();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("submit".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.showVoucherBPForm();
            }
        } else if (BTN_CLOSE.equals(callBackId)) {
            if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
                this.removeCache();
                this.executeClose();
            }
        } else if (ClosingErrorCode.UNINITIALIZE_CURRENT_ACCOUNT_WARN.getCode().equals(callBackId)) {
            if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
                this.removeCache();
                String selectedPeriodIdsJson = this.getPageCache().get("doReverseClosing.selectedPeriodIds");
                List selectedPeriodIds = SerializationUtils.fromJsonStringToList((String)selectedPeriodIdsJson, Long.class);
                boolean result = ClosePeriodUtils.doReverseClosing((IFormPlugin)this, (IFormView)this.getView(), (List)selectedPeriodIds, (boolean)true, (boolean)true);
                if (result) {
                    ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
                    reportlistap.refresh();
                }
            }
        } else if (BTN_CLOSE_CHECK.equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            this.removeCache();
            ReportList control = (ReportList)this.getControl("reportlistap");
            int[] rowIdxs = control.getEntryState().getSelectedRows();
            HashMap<String, Tuple> checkperiod = new HashMap<String, Tuple>(rowIdxs.length);
            ArrayList<String> checkedDatas = new ArrayList<String>(rowIdxs.length);
            for (int index : rowIdxs) {
                String org2booktype;
                DynamicObject book;
                DynamicObject rowData = control.getReportModel().getRowData(index);
                if (rowData == null || (book = rowData.getDynamicObject("booktype")) == null || checkedDatas.contains(org2booktype = book.getLong("org_id") + "_" + book.getLong("bookstype_id"))) continue;
                checkedDatas.add(org2booktype);
                DynamicObject period = (DynamicObject)this.getModel().getValue("periodedit");
                long org = book.getDynamicObject("org").getLong("id");
                long booktype = book.getDynamicObject("bookstype").getLong("id");
                long previousPeriod = ClosePeriodUtils.getSelfPreviousPeriodIdByPeriodId((long)period.getLong("id"), (long)booktype, (long)org);
                DynamicObjectCollection entryentity = BusinessDataServiceHelper.newDynamicObject((String)closeStatus).getDynamicObjectCollection("entryentity");
                boolean result = ClosePeriodUtils.closeCheck((DynamicObject)book, (DynamicObjectCollection)entryentity, (long)org, (long)book.getLong(AccountBook.id_((String)"curperiod")), (long)previousPeriod, (long)booktype);
                checkperiod.put(org + "_" + booktype, new Tuple((Object)result, (Object)(result ? "" : SerializationUtils.serializeToBase64((Object)entryentity))));
            }
            this.cache.put(this.getView().getPageId() + "checkperiod", SerializationUtils.serializeToBase64(checkperiod));
            this.refresh();
        }
    }

    private void executeClose() {
        ReportList control = (ReportList)this.getControl("reportlistap");
        int[] rowIdxs = control.getEntryState().getSelectedRows();
        if (rowIdxs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"ClosePeriodFormRpt_23", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject periodDO = (DynamicObject)this.getModel().getValue("periodedit");
        HashSet<String> orgAndBookType = new HashSet<String>(rowIdxs.length);
        Optional hasClosePermOrgIdsOptional = ClosePeriodUtils.getHasClosePermOrgIds((ClosePeriodInfo)this.getCloseInfo());
        for (int i = 0; i < rowIdxs.length; ++i) {
            DynamicObject book = control.getReportModel().getRowData(rowIdxs[i]).getDynamicObject("booktype");
            long orgId = book.getLong("org_id");
            if (hasClosePermOrgIdsOptional.isPresent() && !((List)hasClosePermOrgIdsOptional.get()).contains(orgId)) continue;
            orgAndBookType.add(orgId + "_" + book.getLong("bookstype_id"));
        }
        ClosePeriodInfo closeInfo = this.getCloseInfo();
        closeInfo.setAwaitPeriodId(periodDO.getPkValue());
        closeInfo.setPageId(this.getView().getPageId());
        closeInfo.setPageFormId(this.getView().getEntityId());
        closeInfo.setOrgAndBookType(new ArrayList(orgAndBookType));
        closeInfo.setPageId(this.getView().getPageId());
        closeInfo.setRequestId(RequestContext.get().getRequestId());
        closeInfo.setRequestContextStr(SerializationUtils.serializeToBase64((Object)RequestContext.get()));
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(APP_GL);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u671f\u672b\u7ed3\u8d26", (String)"ClosePeriodFormRpt_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setTaskClassname("kd.fi.gl.report.closeperiod.ClosePeriodTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            params.put("closeInfo", JSONUtils.toString((Object)closeInfo));
            params.put(HISTORY_USER, RequestContext.get().getCurrUserId());
            params.put("clientType", RequestContext.get().getClient());
            params.put("clientIP", RequestContext.get().getLoginIP());
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_CLOSE);
        JobForm.dispatch((JobInfo)jobInfo, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        queryParam.getCustomParam().put("pageid", this.getView().getPageId());
        FilterItemInfo filterItem = queryParam.getFilter().getFilterItem("periodcloseorg");
        if (Objects.nonNull(filterItem) && Objects.isNull(filterItem.getValue())) {
            queryParam.getCustomParam().put("hasViewPermOrgs", this.getHasViewPermOrgIds());
        }
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent event : allColumns) {
            if (!"status".equals(event.getColumnName()) && !"checkitem".equals(event.getColumnName()) && !"dealfail".equals(event.getColumnName())) continue;
            event.setFilter(true);
        }
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        if (!"true".equals(this.getPageCache().get(VIEWALL))) {
            event.setTreeReportList(true);
        }
        event.setTreeExpandColId("checkitem");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if (key.equals(VIEWALL)) {
            this.getPageCache().put(VIEWALL, "true");
        } else if (key.equals(SHOWTREE)) {
            this.getPageCache().put(VIEWALL, "false");
            this.cache.remove(this.getView().getPageId() + VIEWALL);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("exportexcel")) {
            this.getPageCache().remove("exportexcel");
            this.getPageCache().remove(EXPORTEXCEL_DATA);
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        if (this.getPageCache().get("exportexcel") != null) {
            Map<String, String> pidAndStatus = new HashMap(16);
            String data = this.getPageCache().get(EXPORTEXCEL_DATA);
            if (StringUtils.isNotEmpty((CharSequence)data)) {
                pidAndStatus = (Map)SerializationUtils.deSerializeFromBase64((String)data);
            }
            for (DynamicObject row : rowData) {
                DynamicObject booktype;
                if (row.getLong("isgroupnode") == 1L) {
                    pidAndStatus.put(row.getString("rowid"), row.getString("status"));
                } else if (pidAndStatus.containsKey(row.getString("pid"))) {
                    row.set("status", pidAndStatus.get(row.getString("pid")));
                }
                if (!Objects.nonNull(booktype = row.getDynamicObject("booktype"))) continue;
                row.set("org", (Object)booktype.getDynamicObject("org"));
                row.set("bookstype", (Object)booktype.getDynamicObject("bookstype"));
                row.set("curperiod", (Object)booktype.getDynamicObject("curperiod"));
            }
            this.getPageCache().put(EXPORTEXCEL_DATA, SerializationUtils.serializeToBase64(pidAndStatus));
        }
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        Object formatValue;
        ReportColumn column = (ReportColumn)packageDataEvent.getSource();
        String fieldKey = column.getFieldKey();
        if ("dealfail".equals(fieldKey) && (formatValue = packageDataEvent.getFormatValue()) != null && ResManager.loadKDString((String)"\u68c0\u67e5\u901a\u8fc7", (String)"ClosePeriodQueryRpt_1", (String)"fi-gl-report", (Object[])new Object[0]).equals(formatValue)) {
            packageDataEvent.setFormatValue((Object)("<nolink>" + formatValue));
        }
    }

    private void showVoucherBPForm() {
        ListShowParameter parame = new ListShowParameter();
        parame.setBillFormId("gl_vouchernoadjust_layout");
        parame.setFormId("gl_vouchernolist");
        parame.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "adjustBreakPoint"));
        parame.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        long lastPeriod = GLUtil.getPreviousPeriod((Object)this.getModel().getValue("periodedit_id")).getLong("id");
        ReportList control = (ReportList)this.getControl("reportlistap");
        int[] rowIdxs = control.getEntryState().getSelectedRows();
        Long booksType = control.getReportModel().getRowData(rowIdxs[0]).getLong("bookstype_id");
        List<String> orgIds = this.getOrgIds();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orgIds", JSON.toJSONString(orgIds));
        map.put("booktypeCombo", booksType.toString());
        map.put("lastPeriod", String.valueOf(lastPeriod));
        map.put("orgBookTypePeriodList", this.getPageCache().get("orgBookTypePeriodList"));
        map.put("orgAndBooksForPointList", this.getPageCache().get("orgAndBooksForPointList"));
        parame.setCustomParams(map);
        this.getView().showForm((FormShowParameter)parame);
    }

    private void showVoucherBPLogForm() {
        ListShowParameter parame = new ListShowParameter();
        parame.setBillFormId("gl_voucherbreakpoint");
        parame.setFormId("gl_vouchernolist");
        parame.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "breakPointLog"));
        parame.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        long lastPeriod = GLUtil.getPreviousPeriod((Object)this.getModel().getValue("periodedit_id")).getLong("id");
        ReportList control = (ReportList)this.getControl("reportlistap");
        int[] rowIdxs = control.getEntryState().getSelectedRows();
        Long booksType = control.getReportModel().getRowData(rowIdxs[0]).getDynamicObject("booktype").getLong("bookstype_id");
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> orgIds = this.getOrgIds();
        map.put("orgIds", JSON.toJSONString(orgIds));
        map.put("booktypeCombo", booksType.toString());
        map.put("lastPeriod", String.valueOf(lastPeriod));
        map.put("orgAndBooksForPointList", this.getPageCache().get("orgAndBooksForPointList"));
        parame.setCustomParams(map);
        this.getView().showForm((FormShowParameter)parame);
    }

    private List<String> getOrgIds() {
        ReportList control = (ReportList)this.getControl("reportlistap");
        int[] rowIdxs = control.getEntryState().getSelectedRows();
        ArrayList<String> orgIds = new ArrayList<String>(rowIdxs.length);
        for (int i = 0; i < rowIdxs.length; ++i) {
            DynamicObject rowData = control.getReportModel().getRowData(rowIdxs[i]).getDynamicObject("booktype");
            orgIds.add(rowData.getString("org_id"));
        }
        return orgIds;
    }

    private String getAppId() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String appId = (String)parameter.getCustomParam("closePeriodApp");
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = parameter.getAppId();
        }
        return appId == null ? "" : appId;
    }

    private boolean checkQueryPermission() {
        int permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)Long.parseLong("0"), (String)APP_GL, (String)"gl_voucherbreakpoint", (String)PERM_VIEW);
        if (permission == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u51ed\u8bc1\u65ad\u53f7\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ClosePeriodFormRpt_19", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void refresh() {
        ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
        ReportQueryParam reportQueryParam = reportlistap.getReportCache().getReportQueryParam(this.getView().getPageId());
        reportQueryParam.getCustomParam().put("pageid", this.getView().getPageId());
        reportlistap.getReportCache().setReportQueryParam(this.getView().getPageId(), reportQueryParam);
        reportlistap.refresh();
    }

    private void removeCache() {
        this.cache.remove(this.getView().getPageId() + "closeresult");
        this.cache.remove(this.getView().getPageId() + "checkperiod");
        this.cache.remove(this.getView().getPageId() + VIEWALL);
    }

    private void checkExportPerm() {
        ClosePeriodInfo closeInfo = this.getCloseInfo();
        String appId = AppMetadataCache.getAppInfo((String)closeInfo.getBizapp()).getId();
        HasPermOrgResult exportPermResult = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)this.getView().getEntityId(), (String)PERM_EXPORT);
        if (!exportPermResult.hasAllOrgPerm() && exportPermResult.getHasPermOrgs().isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"exportexcel"});
        }
    }

    private static class OrgBookInfo {
        private transient Map<Long, List<DynamicObject>> orgBookDOs = new HashMap<Long, List<DynamicObject>>(16);

        private OrgBookInfo() {
        }

        public void putOrgBook(long org, DynamicObject book) {
            if (this.orgBookDOs == null) {
                this.orgBookDOs = new HashMap<Long, List<DynamicObject>>();
            }
            if (this.orgBookDOs.get(org) == null) {
                this.orgBookDOs.put(org, new ArrayList<DynamicObject>(Collections.singletonList(book)));
            } else {
                this.orgBookDOs.get(org).add(book);
            }
        }

        public List<DynamicObject> getBooks(long org) {
            return this.orgBookDOs.get(org);
        }

        public List<DynamicObject> getAllBooks() {
            return this.orgBookDOs.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        }

        public List<Long> getAllOrgIds() {
            return new ArrayList<Long>(this.orgBookDOs.keySet());
        }
    }
}

