/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.exportall;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.export.ExportProgress;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.ReportList;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.model.Context;
import kd.fi.bd.model.JsonObjectAdapter;
import kd.fi.gl.report.export.ExportOption;
import kd.fi.gl.report.export.ReportExporter;
import kd.fi.gl.report.exportall.SubsiExportProgressImpl;

public class SubsidiaryReportExportAllTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SubsidiaryReportExportAllTask.class);
    protected static final String REPORT_LIST_AP = "reportlistap";
    private ExportProgress exportProgress;

    public ExportProgress getExportProgress() {
        if (this.exportProgress == null) {
            this.exportProgress = new SubsiExportProgressImpl(this.taskId);
        }
        return this.exportProgress;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String queyrparam = (String)map.get("queryparam");
        String pageId = (String)map.get("parentpageid");
        ReportQueryParam queryParam = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)queyrparam);
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId).getParentView();
        ReportList list = (ReportList)view.getControl(REPORT_LIST_AP);
        Object param = map.get("selectobj");
        if (Objects.nonNull(param)) {
            param = SerializationUtils.deSerializeFromBase64((String)((String)param));
        }
        view.setExportProgress(this.getExportProgress());
        try {
            boolean splitByOrg;
            list.setAsynQuery(true);
            if (Objects.isNull(param)) {
                return;
            }
            Map selectObj = (Map)param;
            String filefilter = (String)selectObj.get("filefilter");
            String orderfilter = (String)selectObj.get("orderfilter");
            Integer sheetlimit = (Integer)selectObj.get("sheetlimit");
            List orgIdList = (List)selectObj.get("orgIdList");
            ExportOption exportOption = new ExportOption();
            exportOption.setExportProgress(this.exportProgress);
            boolean bl = splitByOrg = Objects.equals(filefilter, "2");
            if (orgIdList.size() == 1) {
                splitByOrg = false;
            }
            exportOption.setSplitByOrg(splitByOrg);
            exportOption.setOrderfilter(orderfilter);
            if (Objects.nonNull(sheetlimit) && sheetlimit != 0) {
                exportOption.setSheetLimit(sheetlimit.intValue());
            }
            Context context = ReportExporter.exportSubsidiary((FilterInfo)queryParam.getFilter(), (ReportList)list, (Long[])orgIdList.toArray(new Long[0]), (ExportOption)exportOption);
            int total = (Integer)context.query("totalCount");
            this.exportProgress.feedbackProgress(total, total);
            List urls = (List)context.query("downloadUrl");
            if (CollectionUtils.isNotEmpty((Collection)urls)) {
                HashMap<String, List> data = new HashMap<String, List>();
                data.put("downloadurl", urls);
                this.exportProgress.feedbackCustData(data);
            } else {
                this.exportProgress.feedbackCustData((Map)JsonObjectAdapter.getEmpty().registerContext("failReason", (Object)ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5bfc\u51fa\u3002", (String)"ReportExportAllTask_2", (String)"fi-gl-formplugin", (Object[])new Object[0])).getSource());
            }
        }
        catch (Exception e) {
            logger.error("multipleorgexport failed on:" + e.getMessage(), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"ReportExportAllTask_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        finally {
            this.getExportProgress().complete();
        }
    }
}

