/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.exportall.multiorg;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.fi.bd.model.JsonObjectAdapter;
import kd.fi.gl.model.schema.JobExecuteFormSchema;
import kd.fi.gl.report.exportall.multiorg.JobExecuteListener;
import kd.fi.gl.report.exportall.multiorg.JobExecuteProxy;
import kd.fi.gl.report.exportall.multiorg.info.JobExecuteInfo;
import kd.fi.gl.report.exportall.multiorg.info.JobFormMetaData;
import kd.fi.gl.report.exportall.multiorg.joblistener.DefaultJobExecuteListener;
import kd.fi.gl.report.exportall.multiorg.joblistener.ExecuteProgressEvent;
import kd.fi.gl.report.exportall.multiorg.joblistener.JobExecuteEvent;
import kd.fi.gl.util.GLApp;

public class JobExecuteEdit
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(JobExecuteEdit.class);
    private static final JobExecuteFormSchema schema = JobExecuteFormSchema.INSTANCE;
    private JobExecuteProxy proxy;
    private JobExecuteInfo jobExecuteInfo;
    private JobFormInfo jobFormInfo;

    public void registerListener(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl(JobExecuteEdit.schema.progressBar.toString());
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{JobExecuteFormSchema.INSTANCE.Button_Cancel.toString(), JobExecuteFormSchema.INSTANCE.Button_ToBackGround.toString()});
    }

    public void initialize() {
        super.initialize();
        this.jobExecuteInfo = this.jobExecuteInfo();
        this.proxy = this.jobExecuteProxy();
        this.jobFormInfo = this.jobFormInfo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        JobExecuteEvent jobExecuteEvent = new JobExecuteEvent((Object)this, null);
        this.changeJobStatus(JobStatus.init);
        this.proxy.beforeExecuted(jobExecuteEvent);
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)this.jobFormInfo().getJobInfo());
        this.getView().getParentView().getPageCache().put(JobExecuteFormSchema.INSTANCE.Param_TaskID.toTypeName(), taskId);
        this.changeJobStatus(JobStatus.executing);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.getTaskId());
        this.proxy.afterExecuted(new JobExecuteEvent((Object)this, taskInfo));
    }

    public void onProgress(ProgressEvent e) {
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.getTaskId());
        e.setProgress(taskInfo.getProgress());
        this.proxy.onExecuteProgress(new ExecuteProgressEvent((Object)this, taskInfo, e));
        JobExecuteEvent jobExecuteEvent = new JobExecuteEvent((Object)this, taskInfo);
        if (taskInfo.isTaskEnd()) {
            this.changeJobStatus(JobStatus.ended);
            this.proxy.afterCompleted(jobExecuteEvent);
            if (taskInfo.isFailure()) {
                this.proxy.afterFailed(jobExecuteEvent);
            } else {
                this.proxy.afterSuccess(jobExecuteEvent);
            }
        }
    }

    public void click(EventObject evt) {
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.getTaskId());
        JobExecuteEvent jobExecuteEvent = new JobExecuteEvent((Object)this, taskInfo);
        JobStatus status = this.jobStatus();
        String controlKey = ((Control)evt.getSource()).getKey();
        if (JobExecuteFormSchema.INSTANCE.Button_Cancel.toString().equals(controlKey)) {
            if (status == JobStatus.executing || status == JobStatus.init) {
                this.stopJob(jobExecuteEvent);
            } else {
                this.getView().close();
            }
        } else if (JobExecuteFormSchema.INSTANCE.Button_ToBackGround.toString().equals(controlKey)) {
            this.showConfirmOnBackground();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        switch (this.jobStatus()) {
            case init: 
            case executing: {
                e.setCancel(true);
                this.showConfirmOnBackground();
                break;
            }
            case stopping: {
                e.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (JobExecuteEdit.schema.CallBack_Background.toString().equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.getTaskId());
            JobExecuteEvent jobExecuteEvent = new JobExecuteEvent((Object)this, taskInfo);
            this.proxy.beforeBackgrounded(jobExecuteEvent);
            this.toBackground(taskInfo);
            this.changeJobStatus(JobStatus.backgrounded);
            this.proxy.afterBackgrounded(jobExecuteEvent);
            this.getView().close();
        }
    }

    public JobFormMetaData jobMetaData() {
        return this.jobExecuteInfo.jobMetaData();
    }

    public JobFormInfo jobFormInfo() {
        if (this.jobFormInfo == null) {
            JobInfo jobInfo = new JobInfo();
            jobInfo.setRunByLang(RequestContext.get().getLang());
            jobInfo.setName(this.jobMetaData().jobName());
            jobInfo.setJobType(JobType.BIZ);
            jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
            jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
            jobInfo.setTaskClassname(this.jobExecuteInfo().taskClazz().getTypeName());
            jobInfo.setParams((Map)((JSONObject)this.formShowParam().query(JobExecuteFormSchema.INSTANCE.Param_ContextForTaskExecute)));
            JobFormInfo info = new JobFormInfo();
            info.setCanBackground(true);
            info.setParentPageId(this.getView().getParentView().getPageId());
            info.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
            info.setJobInfo(jobInfo);
            return info;
        }
        return this.jobFormInfo;
    }

    public JsonObjectAdapter formShowParam() {
        return JsonObjectAdapter.fromMap((Map)this.getView().getFormShowParameter().getCustomParams());
    }

    public JobExecuteInfo jobExecuteInfo() {
        if (this.jobExecuteInfo == null) {
            String jobExecuteInfoTypeName = this.formShowParam().query(JobExecuteFormSchema.INSTANCE.Param_JobExecuteInfo).toString();
            try {
                Class<?> jobExecuteInfoClazz = Class.forName(jobExecuteInfoTypeName);
                return (JobExecuteInfo)TypesContainer.createInstance(jobExecuteInfoClazz);
            }
            catch (ClassCastException | ClassNotFoundException e) {
                logger.error("job execute info instance create error.", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u521d\u59cb\u5316\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u67e5\u770b\u3002", (String)"JobExecuteEdit_5", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            }
        }
        return this.jobExecuteInfo;
    }

    private void stopJob(JobExecuteEvent jobExecuteEvent) {
        this.changeJobStatus(JobStatus.stopping);
        this.proxy.beforeSuspended(jobExecuteEvent);
        ScheduleServiceHelper.stopTask((String)this.getTaskId());
        this.changeJobStatus(JobStatus.ended);
        this.proxy.afterSuspended(jobExecuteEvent);
    }

    private void toBackground(TaskInfo taskInfo) {
        JobFormInfo jobFormInfo = this.jobFormInfo();
        TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
        BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskInfo.getId());
        ThreadService.execute((Runnable)subscriber, (TaskType)TaskType.GL_JOB_EXECUTOR_BACKGROUND_MONITOR);
    }

    private void showConfirmOnBackground() {
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u628a%s\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f", (String)"JobExecuteEdit_0", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), this.jobMetaData().jobName()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(JobExecuteEdit.schema.CallBack_Background.toString(), (IFormPlugin)this));
    }

    private JobExecuteProxy jobExecuteProxy() {
        if (this.proxy == null) {
            JobExecuteProxy jobExecuteProxy = new JobExecuteProxy();
            jobExecuteProxy.registerListener(new DefaultJobExecuteListener());
            JSONArray listeners = (JSONArray)this.formShowParam().query(JobExecuteFormSchema.INSTANCE.Param_JobExecuteListener);
            listeners.forEach(listener -> {
                try {
                    Class<?> listenerClazz = Class.forName(listener.toString());
                    jobExecuteProxy.registerListener((JobExecuteListener)TypesContainer.createInstance(listenerClazz));
                }
                catch (ClassCastException | ClassNotFoundException e) {
                    logger.error("job execute info instance create error.", (Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u521d\u59cb\u5316\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u67e5\u770b\u3002", (String)"JobExecuteEdit_5", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                }
            });
            return jobExecuteProxy;
        }
        return this.proxy;
    }

    public String getTaskId() {
        return this.getView().getParentView().getPageCache().get(JobExecuteFormSchema.INSTANCE.Param_TaskID.toTypeName());
    }

    public JobStatus jobStatus() {
        return JobStatus.jobStatus(this.getView().getParentView().getPageCache());
    }

    private void changeJobStatus(JobStatus status) {
        JobStatus.changeJobStatus(this.getView().getParentView().getPageCache(), status);
    }

    public static enum JobStatus {
        init,
        executing,
        backgrounded,
        stopping,
        ended;


        public static void changeJobStatus(IPageCache cache, JobStatus jobStatus) {
            cache.put(JobExecuteFormSchema.INSTANCE.Flag_JobStatus.toTypeName(), jobStatus.name());
        }

        public static JobStatus jobStatus(IPageCache cache) {
            String jobStatus = cache.get(JobExecuteFormSchema.INSTANCE.Flag_JobStatus.toTypeName());
            return jobStatus == null ? init : JobStatus.valueOf(jobStatus);
        }
    }
}

