/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.init;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.assign.OpLogHelper;
import kd.fi.bd.business.service.PeriodService;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistService;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.constant.InitCashFlow;
import kd.fi.gl.util.CommonAssistUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class InitCashFlowAssgrpInfo
extends AbstractFormPlugin {
    private static final String KEY_BTNOK = "btnok";
    private static final String cfitem_cache = "cfitem_cache";
    private static final String assgrp_cahe = "assgrp_cahe";
    private static final String comassist_cahe = "comassist_cahe";
    private static final Log logger = LogFactory.getLog(InitCashFlowAssgrpInfo.class);
    private static final String SELECT_PROPERTIES = String.join((CharSequence)",", "id", "org", "booktype", "cfitem", "currency", "yearamount", "assgrp", "tabdelete");
    private static final String UN_DELETE = "0";
    private static final String DELETED = "1";
    private static final Long NON_ASSGRP = 0L;
    private static final List<String> DELETED_VALUE = Arrays.asList("true", "1");
    private static final List<String> UN_DELETED_VALUE = Arrays.asList("false", "0");

    public void registerListener(EventObject e) {
        BasedataEdit comAssistControl;
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNOK});
        BasedataEdit cfitem = (BasedataEdit)this.getView().getControl("cfitem");
        cfitem.addBeforeF7SelectListener(listener -> {
            ListShowParameter param = (ListShowParameter)listener.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            long cashinitPeriodId = this.getAccountBook().getCashinitPeriodId();
            Date periodEndDate = PeriodService.loadSingle((Long)cashinitPeriodId).getEndDate();
            QFilterBuilder qFilterBuilder = new QFilterBuilder().add("isleaf", "=", (Object)Boolean.TRUE).add("isprefit", "=", (Object)false).add(new QFilter("direction", "!=", (Object)"b").or(new QFilter("type", "=", (Object)"3"))).add("startdate", "<=", (Object)periodEndDate).add("enddate", ">", (Object)periodEndDate);
            filters.addAll(qFilterBuilder.getFilters());
        });
        long orgId = (Long)this.getModel().getValue(GLField.id_((String)"org"));
        long booktypeId = (Long)this.getModel().getValue(GLField.id_((String)"booktype"));
        int index = 0;
        while ((comAssistControl = (BasedataEdit)this.getControl(CommonAssistUtil.getComassistField((int)(++index)))) != null) {
            int finalIndex = index;
            comAssistControl.addBeforeF7SelectListener(listener -> ComAssistTable.get((Long)orgId, (Long)booktypeId).ifPresent(commonAssistTable -> commonAssistTable.getCommonAssists().forEach(commonAssist -> {
                if (commonAssist.key.equals(CommonAssistUtil.getComassistField((int)finalIndex))) {
                    listener.getCustomQFilters().addAll(ComAssistService.generateQFilterWithDataPerm((CommonAssist)commonAssist, Collections.singletonList(orgId)));
                }
            })));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        FormShowParameter formParam = this.getView().getFormShowParameter();
        String opKey = (String)formParam.getCustomParam("opkey");
        model.setValue("org", formParam.getCustomParam("org"));
        model.setValue("booktype", formParam.getCustomParam("booktype"));
        model.setValue("currency", formParam.getCustomParam("currency"));
        Long cfitemId = (Long)formParam.getCustomParam("cfitem");
        model.setValue("cfitem", (Object)cfitemId);
        this.getPageCache().put(cfitem_cache, cfitemId == null ? "" : cfitemId.toString());
        List<String> comassistList = this.getComassist();
        if (formParam.getCustomParam("rowData") != null) {
            Map rowData = (Map)SerializationUtils.fromJsonString((String)((String)formParam.getCustomParam("rowData")), Map.class);
            if (rowData.get("assgrp") != null) {
                Long assgrp = Long.valueOf(rowData.get("assgrp").toString());
                model.setValue("assgrp", (Object)assgrp);
                this.getPageCache().put(assgrp_cahe, assgrp.toString());
            } else if (this.validateAssgrp(false)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"assgrp"});
            }
            model.setValue("yearamount", rowData.get("yearamount"));
        }
        for (int i = 1; i <= comassistList.size(); ++i) {
            String comassist = "comassist" + i;
            model.setValue(comassist, formParam.getCustomParam(comassist));
        }
        this.assgrpHandle(opKey);
    }

    private void assgrpHandle(String opKey) {
        List<Tuple2<String, Boolean>> assgrps = this.getAssgrp();
        this.getView().setVisible(Boolean.valueOf(!CollectionUtils.isEmpty(assgrps)), new String[]{"assgrp"});
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        long booktype;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long org = Long.parseLong(formShowParameter.getCustomParam("org").toString());
        List comassistList = CommonAssistUtil.getComAssistValSource((long)org, (long)(booktype = Long.parseLong(formShowParameter.getCustomParam("booktype").toString())));
        if (!CollectionUtils.isEmpty((Collection)comassistList)) {
            this.getPageCache().put(comassist_cahe, StringUtils.join((Object[])comassistList.toArray(), (String)","));
        }
        ComAssistTable.get((Long)org, (Long)booktype).ifPresent(comAssistTable -> e.setNewEntityType((MainEntityType)ComAssistTableService.modifyEntityType((ComAssistTable)comAssistTable, (EntityType)e.getOriginalEntityType())));
        this.getModel().updateCache();
    }

    public void beforeBindData(EventObject e) {
        IDataModel model = this.getModel();
        long orgId = (Long)model.getValue(GLField.id_((String)"org"));
        long booktypeId = (Long)model.getValue(GLField.id_((String)"booktype"));
        List comassist = CommonAssistUtil.getComAssistValSource((long)orgId, (long)booktypeId);
        for (int i = 0; i < comassist.size(); ++i) {
            if (StringUtil.isBlank((CharSequence)((CharSequence)comassist.get(i)))) continue;
            BasedataEdit baseProp = (BasedataEdit)this.getView().getControl(CommonAssistUtil.getComassistField((int)(i + 1)));
            baseProp.setCaption(new LocaleString(CommonAssistUtil.getComAssistEntityName((long)orgId, (long)booktypeId, (String)((String)comassist.get(i)))));
        }
        ComAssistTable.get((Long)orgId, (Long)booktypeId).ifPresent(commonAssistTable -> ComAssistTableService.modifyCommonAssistFields((ComAssistTable)commonAssistTable, (IFormView)this.getView()));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_BTNOK.equals(key)) {
            Object cfitem = this.getModel().getValue("cfitem");
            List<String> comassists = this.getComassist();
            boolean checkResult = true;
            for (int i = 0; i < comassists.size(); ++i) {
                Object comassist = this.getModel().getValue("comassist" + (i + 1));
                if (comassist != null) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165%1$s\u3002", (String)"InitCashFlowAssgrpInfo_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), EntityMetadataCache.getDataEntityType((String)comassists.get(i)).getDisplayName().getLocaleValue()));
                checkResult = false;
            }
            if (cfitem == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u3002", (String)"InitCashFlowAssgrpInfo_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                checkResult = false;
            }
            if (!this.isEnable()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u5df2\u7981\u7528\u3002", (String)"InitCashFlowAssgrpInfo_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                checkResult = false;
            }
            if (this.validateAssgrp(true) && checkResult) {
                this.updateAssgrpAndAmount();
            }
        }
    }

    private List<Tuple2<String, Boolean>> getAssgrp() {
        List<Tuple2<String, Boolean>> assgrpLst = new ArrayList<Tuple2<String, Boolean>>(0);
        DynamicObject cfitem = (DynamicObject)this.getModel().getValue("cfitem");
        if (cfitem != null) {
            long maincfId = cfitem.getLong("id");
            assgrpLst = this.getMustInput_Maincf(maincfId);
        }
        return assgrpLst;
    }

    private boolean validateAssgrp(boolean isTip) {
        DynamicObject assgrpObj = (DynamicObject)this.getModel().getValue("assgrp");
        List<Tuple2<String, Boolean>> assgrpLst = this.getAssgrp();
        for (Tuple2<String, Boolean> assgrp : assgrpLst) {
            String value;
            if (!((Boolean)assgrp.t2).booleanValue()) continue;
            String string = value = Objects.nonNull(assgrpObj) ? assgrpObj.getString("value") : "";
            if (!Objects.isNull(assgrpObj) && value.contains((CharSequence)assgrp.t1)) continue;
            if (isTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u5b58\u5728\u5fc5\u5f55\u9879\u3002", (String)"InitCashFlowAssgrpInfo_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("cfitem".equals(propertyName)) {
            this.assgrpHandle("new");
            return;
        }
    }

    private List<Tuple2<String, Boolean>> getMustInput_Maincf(long maincfId) {
        DynamicObject maincf = BusinessDataServiceHelper.loadSingleFromCache((Object)maincfId, (String)"gl_cashflowitem");
        DynamicObjectCollection assistenty = maincf.getDynamicObjectCollection("assistentry");
        ArrayList<Tuple2<String, Boolean>> assList = new ArrayList<Tuple2<String, Boolean>>();
        for (DynamicObject obj : assistenty) {
            String flexField = obj.getString("asstypeid.flexfield");
            assList.add((Tuple2<String, Boolean>)new Tuple2((Object)flexField, (Object)obj.getBoolean("isrequire")));
        }
        return assList;
    }

    private void updateAssgrpAndAmount() {
        IDataModel model = this.getModel();
        long assgrpId = this.getAssgrpId(model);
        DynamicObject repeatData = this.loadSingleByModel(model, assgrpId);
        DynamicObject dataToSave = null;
        if (repeatData != null) {
            if (this.isDataUnDeleted(repeatData)) {
                String msg = String.format(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u201c%s\u201d\u5df2\u5b58\u5728\u503c\uff0c\u662f\u5426\u8986\u76d6\uff1f", (String)"InitCashFlowAssgrpInfo_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), ((DynamicObject)model.getValue("cfitem")).get("name"));
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener("cover", (IFormPlugin)this));
                return;
            }
            dataToSave = repeatData;
        }
        if (dataToSave == null) {
            dataToSave = BusinessDataServiceHelper.newDynamicObject((String)"gl_initcashflow");
        }
        this.fillData(dataToSave, model, assgrpId);
        this.saveAndDeleteOldIfPossible(dataToSave);
        String opkey = (String)this.getView().getFormShowParameter().getCustomParam("opkey");
        MultiLangEnumBridge opDescBridge = null;
        opDescBridge = "edit".equals(opkey) ? new MultiLangEnumBridge("\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u8c03\u6574\u6210\u529f\u3002", "InitCashFlowAssgrpInfo_5", "fi-gl-formplugin") : new MultiLangEnumBridge("\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u65b0\u589e\u6210\u529f\u3002", "InitCashFlowAssgrpInfo_6", "fi-gl-formplugin");
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316", "InitCashFlowAssgrpInfo_7", "fi-gl-formplugin");
        String[] descParams = new String[]{};
        new OpLogHelper().addOperateLog(this.getView(), ((Long)model.getValue(InitCashFlow.id_((String)"org"))).longValue(), "", "initCashFlow", opNameBridge, opDescBridge, descParams);
        this.getView().close();
    }

    private void saveAndDeleteOldIfPossible(DynamicObject dataToSave) {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataToSave});
        Long cfItemId = (Long)this.getView().getFormShowParameter().getCustomParam("cfitem");
        String assgrpCacheVal = this.getPageCache().get(assgrp_cahe);
        Long assgrpId = StringUtils.isBlank((CharSequence)assgrpCacheVal) ? NON_ASSGRP : Long.parseLong(assgrpCacheVal);
        String opkey = (String)this.getView().getFormShowParameter().getCustomParam("opkey");
        if ("edit".equals(opkey) && this.isNeedDeleteOld(cfItemId, assgrpId, dataToSave)) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
            FormShowParameter formParam = this.getView().getFormShowParameter();
            List<String> comassistList = this.getComassist();
            for (int i = 1; i <= comassistList.size(); ++i) {
                String comassist = "comassist" + i;
                qFilters.add(new QFilter(comassist, "=", (Object)Long.parseLong(formParam.getCustomParam(comassist).toString())));
            }
            qFilters.add(new QFilter("org", "=", dataToSave.get(InitCashFlow.id_((String)"org"))));
            qFilters.add(new QFilter("booktype", "=", dataToSave.get(InitCashFlow.id_((String)"booktype"))));
            qFilters.add(new QFilter("cfitem", "=", dataToSave.get(InitCashFlow.id_((String)"cfitem"))));
            qFilters.add(new QFilter("assgrp", "=", (Object)assgrpId));
            DynamicObject[] oldData = BusinessDataServiceHelper.load((String)"gl_initcashflow", (String)"id,yearamount,tabdelete", (QFilter[])qFilters.toArray(new QFilter[0]));
            DynamicObject dataOfDeleted = null;
            DynamicObject dataOfUnDeleted = null;
            for (DynamicObject data : oldData) {
                if (this.isDataDeleted(data)) {
                    dataOfDeleted = data;
                    continue;
                }
                if (!this.isDataUnDeleted(data)) continue;
                dataOfUnDeleted = data;
            }
            if (dataOfDeleted != null && dataOfUnDeleted != null) {
                logger.warn("\u8c03\u6574\u521d\u59cb\u5316\u6570\u636e\u6838\u7b97\u7ef4\u5ea6\u65f6,\u8001\u6838\u7b97\u7ef4\u5ea6\u540c\u65f6\u5b58\u5728\u903b\u8f91\u5220\u9664\u4e0e\u903b\u8f91\u672a\u5220\u9664\u6570\u636e,\u907f\u514d\u552f\u4e00\u952e\u51b2\u7a81!\u7269\u7406\u5220\u9664\u903b\u8f91\u672a\u5220\u9664\u6570\u636e!yearAmount={}", (Object)dataOfUnDeleted.getBigDecimal("yearamount"));
                DeleteServiceHelper.delete((IDataEntityType)dataToSave.getDataEntityType(), (Object[])new Long[]{dataOfUnDeleted.getLong("id")});
                dataOfDeleted.set("yearamount", (Object)BigDecimal.ZERO);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataOfDeleted});
            } else {
                DynamicObject dataToUpdateAmount;
                DynamicObject dynamicObject = dataToUpdateAmount = dataOfDeleted == null ? dataOfUnDeleted : dataOfDeleted;
                if (dataToUpdateAmount != null) {
                    dataToUpdateAmount.set("tabdelete", (Object)DELETED);
                    dataToUpdateAmount.set("yearamount", (Object)BigDecimal.ZERO);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataToUpdateAmount});
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataToSave});
    }

    private boolean isNeedDeleteOld(Long cfItemId, Long assgrpId, DynamicObject dataToSave) {
        boolean comassistDelete = false;
        FormShowParameter formParam = this.getView().getFormShowParameter();
        List<String> comassistList = this.getComassist();
        for (int i = 1; i <= comassistList.size(); ++i) {
            String comassist = "comassist" + i;
            Object oldValue = formParam.getCustomParam(comassist);
            if (!ObjectUtils.isNotEmpty((Object)oldValue) || oldValue.equals(dataToSave.get(InitCashFlow.id_((String)comassist)))) continue;
            comassistDelete = true;
        }
        return cfItemId != null && (!cfItemId.equals(dataToSave.getLong("cfitem")) || !assgrpId.equals(dataToSave.getLong("assgrp")) || comassistDelete);
    }

    private void fillData(DynamicObject dataToSave, IDataModel model, long assgrpId) {
        dataToSave.set("org", model.getValue(InitCashFlow.id_((String)"org")));
        dataToSave.set("booktype", model.getValue(InitCashFlow.id_((String)"booktype")));
        dataToSave.set("cfitem", model.getValue(InitCashFlow.id_((String)"cfitem")));
        dataToSave.set("currency", model.getValue(InitCashFlow.id_((String)"currency")));
        dataToSave.set("yearamount", model.getValue("yearamount"));
        dataToSave.set("assgrp", (Object)assgrpId);
        dataToSave.set("tabdelete", (Object)UN_DELETE);
        List<String> comassistList = this.getComassist();
        for (int i = 1; i <= comassistList.size(); ++i) {
            String comassist = "comassist" + i;
            dataToSave.set(comassist, model.getValue(comassist));
        }
    }

    private long getAssgrpId(IDataModel model) {
        DynamicObject cfitem = (DynamicObject)model.getValue("cfitem");
        if (cfitem == null) {
            return NON_ASSGRP;
        }
        long maincfId = cfitem.getLong("id");
        DynamicObject mainCF = BusinessDataServiceHelper.loadSingleFromCache((Object)maincfId, (String)"gl_cashflowitem");
        return mainCF.getDynamicObjectCollection("assistentry").isEmpty() ? NON_ASSGRP : Long.parseLong(model.getValue(InitCashFlow.id_((String)"assgrp")).toString());
    }

    private DynamicObject loadSingleByModel(IDataModel model, long assgrpId) {
        ArrayList<String> comassistFields = new ArrayList<String>(2);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        List<String> comassistList = this.getComassist();
        for (int i2 = 1; i2 <= comassistList.size(); ++i2) {
            String comassist = "comassist" + i2;
            qFilters.add(new QFilter(comassist, "=", model.getValue(InitCashFlow.id_((String)comassist))));
            comassistFields.add(comassist);
        }
        qFilters.add(new QFilter("org", "=", model.getValue(InitCashFlow.id_((String)"org"))));
        qFilters.add(new QFilter("booktype", "=", model.getValue(InitCashFlow.id_((String)"booktype"))));
        qFilters.add(new QFilter("cfitem", "=", model.getValue(InitCashFlow.id_((String)"cfitem"))));
        qFilters.add(new QFilter("assgrp", "=", (Object)assgrpId));
        DynamicObject[] data = BusinessDataServiceHelper.load((String)"gl_initcashflow", (String)(SELECT_PROPERTIES + "," + StringUtils.join(comassistFields, (String)",")), (QFilter[])qFilters.toArray(new QFilter[0]));
        if (data.length == 0) {
            return null;
        }
        for (DynamicObject item : data) {
            if (!this.isDataUnDeleted(item)) continue;
            return item;
        }
        if (data.length > 1) {
            logger.warn("\u5b58\u5728\u91cd\u590d\u7684\u5df2\u5220\u9664\u6570\u636e!id={}", Arrays.stream(data).map(i -> i.getString("id")).collect(Collectors.toSet()));
        }
        return data[0];
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && "cover".equals(e.getCallBackId())) {
            long assgrpId;
            IDataModel model = this.getModel();
            DynamicObject dataToSave = this.loadSingleByModel(model, assgrpId = this.getAssgrpId(model));
            if (dataToSave == null || this.isDataDeleted(dataToSave)) {
                logger.error("\u521d\u59cb\u5316\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664!orgId={},bookTypeId={},cfItemId={}", new Object[]{model.getValue(InitCashFlow.id_((String)"org")), model.getValue(InitCashFlow.id_((String)"booktype")), model.getValue(InitCashFlow.id_((String)"cfitem"))});
                this.getView().close();
                return;
            }
            this.fillData(dataToSave, model, assgrpId);
            this.saveAndDeleteOldIfPossible(dataToSave);
        }
        this.getView().close();
    }

    private boolean isDataDeleted(DynamicObject data) {
        return DELETED_VALUE.contains(data.getString("tabdelete"));
    }

    private boolean isDataUnDeleted(DynamicObject data) {
        return UN_DELETED_VALUE.contains(data.getString("tabdelete"));
    }

    private boolean isEnable() {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"gl_cashflowitem", (String)"enable", (QFilter[])new QFilter[]{new QFilter("id", "=", this.getModel().getValue(InitCashFlow.id_((String)"cfitem")))});
        if (dynamicObject != null) {
            return dynamicObject.getBoolean("enable");
        }
        return true;
    }

    private List<String> getComassist() {
        String s = this.getPageCache().get(comassist_cahe);
        return StringUtils.isNotBlank((CharSequence)s) ? Arrays.asList(s.split(",")) : new ArrayList();
    }

    private AccountBookInfo getAccountBook() {
        Long orgId = (Long)this.getModel().getValue(GLField.id_((String)"org"));
        Long bookTypeId = (Long)this.getModel().getValue(GLField.id_((String)"booktype"));
        return AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
    }
}

