/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.notice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportRowSet;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.report.notice.NoticeRptFormHelper;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.SystemParamHelper;
import kd.sdk.fi.gl.extpoint.notice.INoticeCheck;

public class ACNoticeFormRpt
extends AbstractReportFormPlugin
implements RowClickEventListener,
SelectRowsEventListener {
    private BeforeF7SelectListener ORG_F7_SELECT_LISTENER = e -> {
        List orgPkList = AccSysUtil.getAcctOrgPkList((String)"gl_acnotice", (boolean)false, (PermissonType)PermissonType.VIEW);
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgPkList));
    };

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        DynamicObject orgDO = (DynamicObject)this.getModel().getValue("org");
        long orgId = orgDO == null ? 0L : orgDO.getLong("id");
        Object result = SystemParamHelper.getObjectParam((String)"showgenvoucher", (long)orgId);
        if (result != null) {
            boolean visiable = !Objects.equals(result, "1");
            this.getView().setVisible(Boolean.valueOf(visiable), new String[]{"checkstatus", "cancelcheck", "autocheck"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"checkstatus", "cancelcheck", "autocheck"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List orgPkList = AccSysUtil.getAcctOrgPkList((String)"gl_acnotice", (boolean)false, (PermissonType)PermissonType.VIEW);
        long orgId = AccSysUtil.getDefaultOrgId((String)"gl_acnotice", (boolean)false, (PermissonType)PermissonType.VIEW);
        if (!orgPkList.isEmpty()) {
            if (!orgPkList.contains(orgId)) {
                orgId = (Long)orgPkList.get(0);
            }
            this.getModel().setValue("org", (Object)orgId);
            this.getModel().setValue("currencyfield", (Object)NoticeRptFormHelper.getLocalCurrencyId(orgId));
        }
        Date date = new Date();
        this.getModel().setValue("startdate", (Object)NoticeRptFormHelper.getMonthStartDate(date));
        this.getModel().setValue("enddate", (Object)NoticeRptFormHelper.getMonthEndDate(date));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object org = this.getModel().getValue("org");
        this.setCheckTypeVisiable((DynamicObject)org);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("org".equals(name)) {
            DynamicObject orgDO = (DynamicObject)newValue;
            this.setCheckTypeVisiable(orgDO);
            if (!Objects.isNull(orgDO)) {
                this.getModel().setValue("currencyfield", (Object)NoticeRptFormHelper.getLocalCurrencyId(orgDO.getLong("id")));
            }
        }
    }

    private void setCheckTypeVisiable(DynamicObject orgDO) {
        long orgId = orgDO == null ? 0L : orgDO.getLong("id");
        boolean locEnable = SystemParamHelper.getBooleanParam((String)"acnloccurenbale", (long)orgId, (boolean)false);
        this.getView().setVisible(Boolean.valueOf(locEnable), new String[]{"checktype"});
        if (!locEnable) {
            this.getModel().setValue("checktype", (Object)"0");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener(this.ORG_F7_SELECT_LISTENER);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        long orgId = 0L;
        DynamicObject orgDyn = this.getQueryParam().getFilter().getDynamicObject("org");
        if (null != orgDyn) {
            orgId = orgDyn.getLong("id");
        }
        boolean opResult = false;
        switch (operateKey) {
            case "checkstatus": {
                PluginProxy pluginProxy;
                List extCheckList;
                Optional<Boolean> checkOptional;
                if (!e.getOperationResult().isSuccess() || (checkOptional = (extCheckList = (pluginProxy = PluginProxy.create(null, INoticeCheck.class, (String)"kd.sdk.fi.gl.extpoint.notice.INoticeCheck.extCheck", null)).callReplace(p -> p.extCheck((ReportList)this.getControl("send"), (ReportList)this.getControl("receive")))).stream().filter(x -> x == false).findAny()).isPresent()) break;
                opResult = NoticeRptFormHelper.manualCheckNoticeOnRptForm((ReportList)this.getControl("send"), (ReportList)this.getControl("receive"), "gl_acnotice", orgId);
                break;
            }
            case "cancelcheck": {
                if (!e.getOperationResult().isSuccess()) break;
                opResult = NoticeRptFormHelper.cancelCheckNoticeOnRptForm((ReportList)this.getControl("send"), (ReportList)this.getControl("receive"), "gl_acnotice");
                break;
            }
            case "autocheck": {
                if (!e.getOperationResult().isSuccess()) break;
                opResult = NoticeRptFormHelper.autoCheckNoticeOnRptForm((ReportList)this.getControl("send"), (ReportList)this.getControl("receive"), "gl_acnotice", orgId);
                break;
            }
            case "selectall": {
                int rowCount;
                List reportList = Stream.of("send", "receive").map(arg_0 -> ((ACNoticeFormRpt)this).getControl(arg_0)).map(ReportList.class::cast).collect(Collectors.toList());
                for (ReportList list : reportList) {
                    rowCount = list.getReportModel().getRowCount();
                    ArrayList<Integer> selectRows = new ArrayList<Integer>(rowCount);
                    for (int i2 = 1; i2 < rowCount; ++i2) {
                        selectRows.add(i2);
                    }
                    list.selectRows(selectRows.stream().mapToInt(i -> i).toArray(), 0);
                }
                for (ReportList list : reportList) {
                    rowCount = list.getReportModel().getRowCount();
                    AbstractReportListModel listModel = (AbstractReportListModel)list.getReportModel();
                    ReportRowSet rowSet = listModel.getReportTaskResult().getData(0, rowCount - 1);
                    BigDecimal total = BigDecimal.ZERO;
                    while (rowSet.next()) {
                        if ("2".equals(rowSet.getObject("rowtype").toString())) continue;
                        String dc = (String)rowSet.getObject("entrydc");
                        if ("1".equals(dc) || "i".equals(dc)) {
                            total = total.add((BigDecimal)rowSet.getObject("amount"));
                            continue;
                        }
                        total = total.add(((BigDecimal)rowSet.getObject("amount")).negate());
                    }
                    this.getModel().setValue(list.getKey() + "total", (Object)total);
                }
                break;
            }
            case "selectnone": {
                List reports = Stream.of("send", "receive").map(arg_0 -> ((ACNoticeFormRpt)this).getControl(arg_0)).map(ReportList.class::cast).collect(Collectors.toList());
                for (ReportList list : reports) {
                    list.selectRows(-1);
                    this.getModel().setValue(list.getKey() + "total", (Object)BigDecimal.ZERO);
                }
                break;
            }
        }
        if (opResult) {
            this.getView().refresh();
        }
    }
}

