/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.notice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportRowSet;
import kd.bos.form.IFormView;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.gl.constant.AccountBook;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.enums.AccountBooksType;
import kd.fi.gl.report.notice.NoticeRptConstant;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.VoucherUtil;

public class NoticeRptFormHelper {
    private NoticeRptFormHelper() {
    }

    protected static Date getMonthStartDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    protected static Date getMonthEndDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    protected static long getLocalCurrencyId(long orgId) {
        QFBuilder qfBuilder = new QFBuilder("org", "=", (Object)orgId);
        qfBuilder.add("bookstype.accounttype", "=", (Object)AccountBooksType.MAIN_BOOK.getValue());
        DynamicObject book = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)"basecurrency", (QFilter[])qfBuilder.toArray());
        return Objects.isNull(book) ? 0L : book.getLong(AccountBook.id_((String)"basecurrency"));
    }

    protected static boolean manualCheckNoticeOnRptForm(ReportList sendList, ReportList receiveList, String entityNumber, Long orgId) {
        BigDecimal sendTotal;
        if (null == sendList || null == receiveList) {
            return false;
        }
        IFormView view = sendList.getView();
        int[] sendSelectedRows = sendList.getEntryState().getSelectedRows();
        int[] receiveSelectedRows = receiveList.getEntryState().getSelectedRows();
        IReportListModel sendModel = sendList.getReportModel();
        IReportListModel receiveModel = receiveList.getReportModel();
        HashSet<Long> orgIds = new HashSet<Long>(sendSelectedRows.length + receiveSelectedRows.length);
        for (int i : sendSelectedRows) {
            if ("2".equals(sendModel.getRowData(i).getString(NoticeRptConstant.send("rowtype")))) continue;
            orgIds.add(sendModel.getRowData(i).getLong(GLField.id_((String)NoticeRptConstant.receive("org"))));
        }
        for (int i : receiveSelectedRows) {
            if ("2".equals(receiveModel.getRowData(i).getString(NoticeRptConstant.receive("rowtype")))) continue;
            orgIds.add(receiveModel.getRowData(i).getLong(GLField.id_((String)NoticeRptConstant.send("org"))));
        }
        if (orgIds.size() != 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u7684\u63a5\u6536\u3001\u53d1\u9001\u7ec4\u7ec7\u3002", (String)"NoticeRptFormHelper_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        IDataModel model = view.getModel();
        BigDecimal receiveTotal = (BigDecimal)model.getValue(NoticeRptConstant.RECEIVE_TOTAL);
        if (receiveTotal.add(sendTotal = (BigDecimal)model.getValue(NoticeRptConstant.SEND_TOTAL)).signum() != 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u53d1\u9001\u901a\u77e5\u5355\u7684\u91d1\u989d\u4e0d\u7b49\u4e8e\u63a5\u6536\u901a\u77e5\u5355\u7684\u91d1\u989d\u3002", (String)"NoticeRptFormHelper_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("checktype", "checktype_manual");
        option.setVariableValue("check_org", orgId.toString());
        return NoticeRptFormHelper.excuteSelectedNoticeOpOnRptForm(sendList, receiveList, entityNumber, "checkstatus", option);
    }

    protected static boolean cancelCheckNoticeOnRptForm(ReportList sendList, ReportList receiveList, String entityNumber) {
        OperateOption option = OperateOption.create();
        return NoticeRptFormHelper.excuteSelectedNoticeOpOnRptForm(sendList, receiveList, entityNumber, "cancelcheck", option);
    }

    protected static boolean excuteSelectedNoticeOpOnRptForm(ReportList sendList, ReportList receiveList, String entityNumber, String operationKey, OperateOption option) {
        if (null == sendList || null == receiveList) {
            return false;
        }
        int[] sendSelectedRows = sendList.getEntryState().getSelectedRows();
        int[] receiveSelectedRows = receiveList.getEntryState().getSelectedRows();
        if (0 == sendSelectedRows.length && 0 == receiveSelectedRows.length) {
            sendList.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"NoticeRptFormHelper_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        IReportListModel sendModel = sendList.getReportModel();
        IReportListModel receiveModel = receiveList.getReportModel();
        ArrayList<Long> noticeIds = new ArrayList<Long>(sendSelectedRows.length + receiveSelectedRows.length);
        for (int i : sendSelectedRows) {
            noticeIds.add(sendModel.getRowData(i).getLong("sendid"));
        }
        for (int i : receiveSelectedRows) {
            noticeIds.add(receiveModel.getRowData(i).getLong("receiveid"));
        }
        OperationResult result = NoticeRptFormHelper.excuteNoticeOpRptForm(noticeIds, entityNumber, operationKey, option);
        sendList.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f%d\u6761\u901a\u77e5\u5355\u3002", (String)"NoticeRptFormHelper_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), result.getSuccessPkIds().size()));
        return true;
    }

    protected static BigDecimal getSumResult(ReportList list) {
        if (null == list) {
            return BigDecimal.ZERO;
        }
        IReportListModel reportModel = list.getReportModel();
        if (null == reportModel) {
            return BigDecimal.ZERO;
        }
        int rowCount = reportModel.getRowCount();
        if (rowCount == 1) {
            return BigDecimal.ZERO;
        }
        DynamicObject sumRow = reportModel.getRowData(rowCount);
        if (null == sumRow) {
            return BigDecimal.ZERO;
        }
        return sumRow.getBigDecimal(list.getKey() + "amount");
    }

    protected static boolean autoCheckNoticeOnRptForm(ReportList sendList, ReportList receiveList, String entityNumber, Long orgId) {
        if (null == sendList || null == receiveList) {
            return false;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("checktype", "checktype_auto");
        option.setVariableValue("check_org", orgId.toString());
        int[] sendSelectedRows = sendList.getEntryState().getSelectedRows();
        int[] receiveSelectedRows = receiveList.getEntryState().getSelectedRows();
        if (0 != sendSelectedRows.length || 0 != receiveSelectedRows.length) {
            return NoticeRptFormHelper.excuteSelectedNoticeOpOnRptForm(sendList, receiveList, entityNumber, "checkstatus", option);
        }
        ReportListModel sendModel = (ReportListModel)sendList.getReportModel();
        ReportListModel receiveModel = (ReportListModel)receiveList.getReportModel();
        DynamicObjectCollection sends = sendModel.getRowData(0, sendModel.getRowCount());
        DynamicObjectCollection receives = receiveModel.getRowData(0, receiveModel.getRowCount());
        if (sends.isEmpty() || receives.isEmpty()) {
            return false;
        }
        ArrayList<Long> noticeIds = new ArrayList<Long>(sends.size() + receives.size());
        noticeIds.addAll(sends.stream().filter(x -> x.getString("sendrowtype").equals("1")).map(x -> x.getLong("sendid")).collect(Collectors.toList()));
        noticeIds.addAll(receives.stream().filter(x -> x.getString("receiverowtype").equals("1")).map(x -> x.getLong("receiveid")).collect(Collectors.toList()));
        OperationResult result = NoticeRptFormHelper.excuteNoticeOpRptForm(noticeIds, entityNumber, "checkstatus", option);
        sendList.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f%d\u6761\u901a\u77e5\u5355\u3002", (String)"NoticeRptFormHelper_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), result.getSuccessPkIds().size()));
        return true;
    }

    private static OperationResult excuteNoticeOpRptForm(List<Long> noticeIds, String entityNumber, String operationKey, OperateOption option) {
        return OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])noticeIds.toArray(), (OperateOption)option);
    }

    protected static BigDecimal getTotalAmount(ReportList list, List<Integer> selectedRows) {
        BigDecimal total = BigDecimal.ZERO;
        if (list == null) {
            return total;
        }
        if (selectedRows.isEmpty()) {
            return total;
        }
        AbstractReportListModel listModel = (AbstractReportListModel)list.getReportModel();
        ReportRowSet rowSet = listModel.getReportTaskResult().getData(selectedRows.get(0) - 1, selectedRows.get(selectedRows.size() - 1).intValue());
        int i = selectedRows.get(0);
        while (rowSet.next()) {
            if (selectedRows.contains(i) && !"2".equals(rowSet.getObject("rowtype").toString())) {
                String dc = (String)rowSet.getObject("entrydc");
                total = "1".equals(dc) || "i".equals(dc) ? total.add((BigDecimal)rowSet.getObject("amount")) : total.add(((BigDecimal)rowSet.getObject("amount")).negate());
            }
            ++i;
        }
        return total;
    }

    protected static void hyperToVoucher(ReportList list, HyperLinkClickEvent e) {
        if (null == list || null == e || !e.getFieldName().endsWith("voucherno")) {
            return;
        }
        IFormView view = list.getView();
        IDataModel model = view.getModel();
        long orgId = (Long)model.getValue(GLField.id_((String)"org"));
        long voucherId = list.getReportModel().getRowData(e.getRowIndex()).getLong(list.getKey() + "voucherid");
        DynamicObject voucher = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_voucher", (String)"id", (QFilter[])new QFilter("id", "=", (Object)voucherId).toArray());
        if (null != voucher) {
            VoucherUtil.hyperVoucher(orgId, voucherId, view);
        }
    }
}

