/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subledger.print;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.util.GLApp;

public class SLPrintPageKey {
    private String accountNum;
    private String accountName;
    private final List<Tuple<String, String>> comAssistValues;
    private static final String INIT_VALUE = "";

    private SLPrintPageKey(String accountNum, String accountName, List<Tuple<String, String>> comAssistValues) {
        this.accountNum = accountNum;
        this.accountName = accountName;
        this.comAssistValues = comAssistValues;
    }

    public SLPrintPageKey(List<CommonAssist> commonAssists) {
        this.accountNum = INIT_VALUE;
        this.accountName = INIT_VALUE;
        this.comAssistValues = commonAssists.stream().map(commonAssist -> new Tuple((Object)commonAssist.name, (Object)INIT_VALUE)).collect(Collectors.toList());
    }

    public static Optional<SLPrintPageKey> createPK(DynamicObject row, List<CommonAssist> commonAssists) {
        return Optional.ofNullable(row.getDynamicObject("accountcolumn")).map(account -> {
            String acctNumber = account.getString("number");
            String acctName = row.getString("accountname");
            List<Tuple<String, String>> comAssists = commonAssists.stream().map(commonAssist -> new Tuple((Object)commonAssist.name, (Object)row.getLocaleString(commonAssist.key + "id.name").getLocaleValue())).collect(Collectors.toList());
            return new SLPrintPageKey(acctNumber, acctName, comAssists);
        });
    }

    public String toString() {
        String typeDelimiter = SLPrintPageKey.typeDelimiter();
        String valueDelimiter = SLPrintPageKey.valueDelimiter();
        StringBuilder sb = new StringBuilder(this.accountNum).append(" ").append(this.accountName);
        this.comAssistValues.stream().filter(t -> !INIT_VALUE.equals(t.item2)).forEach(tuple -> sb.append(typeDelimiter).append((String)tuple.item1).append(valueDelimiter).append((String)tuple.item2));
        return sb.toString();
    }

    public static String valueDelimiter() {
        return ResManager.loadKDString((String)"\uff1a", (String)"SLPrintPageKey_0", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]);
    }

    public static String typeDelimiter() {
        return ResManager.loadKDString((String)"\uff1b", (String)"SLPrintPageKey_1", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]);
    }

    public static SLPrintPageKey fromStr(String str) {
        String typeDelimiter = SLPrintPageKey.typeDelimiter();
        String valueDelimiter = SLPrintPageKey.valueDelimiter();
        String[] split = str.split(typeDelimiter);
        String[] account = split[0].split(" ");
        List<Tuple<String, String>> comAssists = IntStream.range(1, split.length).mapToObj(i -> {
            String[] comAssist = split[i].split(valueDelimiter);
            return new Tuple((Object)comAssist[0], (Object)comAssist[1]);
        }).collect(Collectors.toList());
        return new SLPrintPageKey(account[0], account[1], comAssists);
    }

    public void addPageField(BiConsumer<String, String> valueSetter) {
        valueSetter.accept("account", this.accountNum + " " + this.accountName);
        Iterator comAssistKeyItr = ComAssistTable.getMaxCommonAssistKeys().iterator();
        for (Tuple<String, String> comAssistValue : this.comAssistValues) {
            valueSetter.accept((String)comAssistKeyItr.next(), (String)comAssistValue.item2);
        }
    }

    public void setAccount(String accountStr) {
        String[] accountArr = accountStr.split(" ");
        this.accountNum = accountArr[0];
        this.accountName = accountArr[1];
    }

    public void setComAssistValue(int comAssistIndex, String comAssistValue) {
        this.comAssistValues.add(comAssistIndex + 1, (Tuple<String, String>)new Tuple(this.comAssistValues.get((int)comAssistIndex).item1, (Object)comAssistValue));
        this.comAssistValues.remove(comAssistIndex);
    }

    public FillStatus getFillStatus() {
        FillStatus status = FillStatus.INIT;
        if (!INIT_VALUE.equals(this.accountName) && !INIT_VALUE.equals(this.accountNum)) {
            if (!this.comAssistValues.isEmpty()) {
                status = FillStatus.UP_HALF;
                boolean notExistInitValue = this.comAssistValues.stream().noneMatch(tuple -> ((String)tuple.item2).equals(INIT_VALUE));
                if (notExistInitValue) {
                    status = FillStatus.FULL;
                }
            } else {
                status = FillStatus.FULL;
            }
        }
        return status;
    }

    public static enum FillStatus {
        INIT,
        HALF,
        UP_HALF,
        FULL;

    }
}

