/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.util.GlFormUtil;

public class AutoTransUtil {
    private static final String ENTITY_DATAEXP = "gl_autotransexpression";
    private static final Set<String> needReloadEntityIdSet = new HashSet<String>(Collections.singletonList("gl_autotransexpression"));

    public static void clearCache(IPageCache cache, String ... cacheKeys) {
        for (String cacheKey : cacheKeys) {
            cache.remove(cacheKey);
        }
    }

    private static void expCachePut(IPageCache cache, String cacheKey, String val, boolean flag) {
        cache.put(cacheKey, val);
    }

    public static List<Object> getDelRowidsFromCache(IPageCache cache, String cacheKey) {
        String jsonStr = cache.get(cacheKey);
        List cacheRowids = null;
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            cacheRowids = (List)SerializationUtils.fromJsonString((String)jsonStr, List.class);
        }
        return cacheRowids;
    }

    public static void cacheDelRowids(IPageCache cache, String cacheKey, List<Object> rowids) {
        List<Object> cacheRowids = AutoTransUtil.getDelRowidsFromCache(cache, cacheKey);
        if (cacheRowids == null) {
            cacheRowids = new ArrayList<Object>();
        }
        cacheRowids.addAll(rowids);
        AutoTransUtil.expCachePut(cache, cacheKey, SerializationUtils.toJsonString(cacheRowids), Boolean.TRUE);
    }

    public static void updatePageCache(IPageCache cache, String cacheKey, String autoRowid, Object newVal, String rowIdKey, String entity) {
        Map<String, Object> rowToVal = AutoTransUtil.getAllExpFromCache(cache, cacheKey);
        if (StringUtils.isNotBlank((Object)newVal)) {
            DynamicObject newObj = GlFormUtil.fromDynamicString(newVal.toString(), EntityMetadataCache.getDataEntityType((String)entity));
            newObj.set(rowIdKey, (Object)autoRowid);
            newVal = GlFormUtil.toDynamicObjectJson(newObj);
            rowToVal.put(autoRowid, newVal);
            AutoTransUtil.expCachePut(cache, cacheKey, SerializationUtils.toJsonString(rowToVal), Boolean.TRUE);
        }
    }

    public static void removePageCache(IPageCache cache, String cacheKey, String autoRowid) {
        Map<String, Object> rowToVal = AutoTransUtil.getAllExpFromCache(cache, cacheKey);
        if (!rowToVal.isEmpty()) {
            rowToVal.remove(autoRowid);
            AutoTransUtil.expCachePut(cache, cacheKey, SerializationUtils.toJsonString(rowToVal), Boolean.TRUE);
        }
    }

    public static Object getValueFromCache(IPageCache cache, String cacheKey, String autoRowid, String entity, QFilter[] filters, String rowIdKey, String delExpRowidsKey, DynamicObjectType type) {
        List<Object> delRowidsFromCache;
        Map<String, Object> rowToVal = AutoTransUtil.getAllExpFromCache(cache, cacheKey);
        Object result = rowToVal.get(autoRowid);
        if (!(result != null || (delRowidsFromCache = AutoTransUtil.getDelRowidsFromCache(cache, delExpRowidsKey)) != null && delRowidsFromCache.contains(autoRowid))) {
            DynamicObject queryVal = null;
            if ("gl_finalprocess_assgrp".equals(entity)) {
                queryVal = BusinessDataServiceHelper.loadSingle((String)entity, (String)"org,assgrprow,entryentity.fieldname,entryentity.value,entryentity.txtval, periodrange", (QFilter[])filters);
            } else {
                queryVal = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (QFilter[])filters);
                if (queryVal != null && type != null && needReloadEntityIdSet.contains(entity)) {
                    queryVal = BusinessDataServiceHelper.loadSingleFromCache((Object)queryVal.getPkValue(), (DynamicObjectType)type);
                }
            }
            if (queryVal != null) {
                result = GlFormUtil.toDynamicObjectJson(queryVal);
            }
        }
        return result;
    }

    public static Map<String, Object> getAllExpFromCache(IPageCache cache, String cacheKey) {
        String jsonStr = cache.get(cacheKey);
        Map<String, Object> rowToVal = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            rowToVal = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
        }
        return rowToVal;
    }
}

