/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.util.QFBuilder;

public class BcmRptHelper {
    public static Long findModelIDByNumber(String modelNumber) {
        QFilter reportTypeFilter = new QFilter("ReportType", "in", (Object)new String[]{"1", "2", "5"});
        QFilter numberFilter = new QFilter("shownumber", "=", (Object)modelNumber);
        DynamicObject modelDyo = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id", (QFilter[])new QFilter[]{reportTypeFilter, numberFilter});
        return modelDyo == null ? Long.valueOf(0L) : (Long)modelDyo.getPkValue();
    }

    public static Map<Long, String> findModelNumberByID(Set<Long> modelID) {
        return BcmRptHelper.findEntityNumberByID("bcm_model", modelID);
    }

    public static Map<Long, String> findTemplateNumberByID(Set<Long> modelID) {
        return BcmRptHelper.findEntityNumberByID("bcm_templateentity", modelID);
    }

    public static Map<Long, String> findScenarioNumberByID(Set<Long> modelID) {
        return BcmRptHelper.findEntityNumberByID("bcm_scenemembertree", modelID);
    }

    public static Map<Long, String> findEntityNumberByID(String entity, Set<Long> pks) {
        return BusinessDataServiceHelper.loadFromCache((String)entity, (String)(entity.equals("bcm_model") ? "shownumber" : "number"), (QFilter[])new QFilter("id", "in", pks).toArray()).entrySet().stream().collect(Collectors.toMap(entry -> (Long)entry.getKey(), entry -> ((DynamicObject)entry.getValue()).getString(entity.equals("bcm_model") ? "shownumber" : "number")));
    }

    public static Long findScenarioIDByModelNumber(Long modelID, String sceneNumber) {
        if (modelID.equals(0L)) {
            return 0L;
        }
        QFilter numberFilter = new QFilter("number", "=", (Object)sceneNumber);
        QFilter modelFilter = new QFilter("model", "=", (Object)modelID);
        QFilter isLeafFilter = new QFilter("isleaf", "=", (Object)"1");
        DynamicObject modelDyo = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_scenemembertree", (String)"id", (QFilter[])new QFilter[]{numberFilter, modelFilter, isLeafFilter});
        return modelDyo == null ? Long.valueOf(0L) : (Long)modelDyo.getPkValue();
    }

    public static Long findTemplateID(Long modelID, String modelNumber, Date curAcctDate) {
        if (modelID.equals(0L)) {
            return 0L;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)modelID);
        qfBuilder.add("number", "=", (Object)modelNumber);
        Map templateLoadRes = BusinessDataServiceHelper.loadFromCache((String)"bcm_templateentity", (String)"id, effectivedate", (QFilter[])qfBuilder.toArray(), (String)"effectivedate desc");
        Iterator templatePKIterator = templateLoadRes.keySet().iterator();
        return templatePKIterator.hasNext() ? (Long)templatePKIterator.next() : Long.valueOf(0L);
    }
}

