/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ControlFilterUtil {
    private static final String K_LIKE = "59";
    private static final String K_EQUALS = "110";
    private static final String K_IN = "111";
    private static final String PC_FILTERVALUES = "filtercontainerap_cachedFilterValues";

    public static FilterContainerFilterValues getFilterValue(FilterContainer filterContainer) {
        IPageCache pageCache = (IPageCache)filterContainer.getView().getService(IPageCache.class);
        String filterValueStr = pageCache.get(PC_FILTERVALUES);
        if (filterValueStr == null) {
            return null;
        }
        return FilterContainerFilterValues.deSerialize((String)filterValueStr);
    }

    public static Long getCustomFilterId(String fieldName, FilterContainer filterContainer) {
        Long result = null;
        FilterContainerFilterValues filterValues = ControlFilterUtil.getFilterValue(filterContainer);
        if (filterValues == null) {
            return result;
        }
        FilterKeyValueCollections otherFilterValues = filterValues.getOtherFilterValues();
        if (otherFilterValues != null && otherFilterValues.getFilterKey().equalsIgnoreCase("customfilter")) {
            List filterValuesList = otherFilterValues.createFilterValuesList();
            for (Map map : filterValuesList) {
                List values;
                List name = (List)map.get("FieldName");
                if (!name.get(0).equals(fieldName) || (values = (List)map.get("Value")).isEmpty()) continue;
                String value = (String)values.get(0);
                if (StringUtils.isBlank((CharSequence)value)) {
                    return null;
                }
                result = Long.valueOf(value);
            }
        }
        return result;
    }

    public static QFilter getAccountFilterByOrgAndBookType(ControlFilters cfs) {
        DynamicObject acctbook = ControlFilterUtil.getAcctBookByOrgAndBookType(cfs);
        if (null != acctbook) {
            QFilter faccttable = new QFilter("accounttable", "=", (Object)acctbook.getLong("accounttable_id"));
            return faccttable;
        }
        return null;
    }

    public static DynamicObject getAcctBookByOrgAndBookType(ControlFilters cfs) {
        Map map = cfs.getFilters();
        ControlFilter orgCf = (ControlFilter)map.get("org.name");
        ControlFilter bookTpyeCf = (ControlFilter)map.get("org.name");
        if (orgCf == null || bookTpyeCf == null) {
            return null;
        }
        List orgVals = orgCf.getValue();
        List bkVals = bookTpyeCf.getValue();
        QFilter qorg = new QFilter("name", ControlFilterUtil.parseCompareTypeToQCP(orgCf.getCompareType()), orgVals.get(0));
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{qorg});
        QFilter bf = new QFilter("booktype.name", ControlFilterUtil.parseCompareTypeToQCP(bookTpyeCf.getCompareType()), bkVals.get(0));
        if (null != org) {
            QFilter orgId = new QFilter("org", "=", (Object)org.getLong("id"));
            DynamicObject acctbook = BusinessDataServiceHelper.loadSingle((String)"gl_accountbook", (String)"accounttable,startperiod", (QFilter[])new QFilter[]{bf, orgId});
            return acctbook;
        }
        return null;
    }

    private static String parseCompareTypeToQCP(String compareType) {
        String filterFormula = "";
        switch (compareType) {
            case "59": {
                filterFormula = "like";
                break;
            }
            case "110": {
                filterFormula = "=";
                break;
            }
            case "111": {
                filterFormula = "in";
                break;
            }
        }
        return filterFormula;
    }
}

