/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.TaxReportFormHelper;

public class FinancialKpiGetValueHelp {
    private static final Log logger = LogFactory.getLog(FinancialKpiGetValueHelp.class);
    private static final String GL_BALANCESHEET = "gl_balancesheet";
    private static final String GL_CASHFLOWSTAT = "gl_cashflowstat";
    private static final String GL_SHOWINCOME = "gl_showincome";
    private static final String Default_BalSheet_Asset_Query_Fields = "org.id orgid, assetentryentity.seq seq, accounttable, booktype,  assetentryentity.asset asset, assetentryentity.asset.masterid assetmasterid";
    private static final String Default_BalSheet_Equity_Query_Fields = "org.id orgid, equityentryentity.seq seq, accounttable, booktype,  equityentryentity.equity equity, equityentryentity.equity.masterid equitymasterid";

    public static Map<String, BigDecimal> getBalanceValue(List<Long> orgIds, Set<Long> childOrgSet, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, int amtprecision) {
        Map<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        List assetResultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)periodId, (String)"balancesheet", (String)"assetentryentity", (int)amtprecision, (boolean)true);
        List equityResultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)periodId, (String)"balancesheet", (String)"equityentryentity", (int)amtprecision, (boolean)true);
        if (!assetResultList.isEmpty()) {
            map = FinancialKpiGetValueHelp.dealBalance(assetResultList, map, orgIds, accTableId, bookTypeId, "assetentryentity");
        }
        if (!equityResultList.isEmpty()) {
            map = FinancialKpiGetValueHelp.dealBalance(equityResultList, map, orgIds, accTableId, bookTypeId, "equityentryentity");
        }
        return map;
    }

    private static Map<String, BigDecimal> dealBalance(List<List<BigDecimal>> resultList, Map<String, BigDecimal> map, List<Long> orgIds, Long accTableId, long bookTypeId, String entityType) {
        Long orgId = TaxReportFormHelper.getParentOrg(orgIds);
        if ("assetentryentity".equals(entityType)) {
            DynamicObjectCollection collection = TaxReportFormHelper.getBalSheetsByEntityType(Collections.singleton(orgId), (long)accTableId, (QFilter[])new QFilter("booktype", "=", (Object)bookTypeId).toArray(), (String)Default_BalSheet_Asset_Query_Fields, (String)"assetentryentity.seq asc");
            if (collection.isEmpty()) {
                return map;
            }
            ArrayList<String> itemList1 = new ArrayList<String>();
            for (DynamicObject dyn : collection) {
                itemList1.add(dyn.getString("asset"));
            }
            for (int i = 0; i < resultList.size(); ++i) {
                map.put((String)itemList1.get(i) + "1", resultList.get(i).get(0));
                map.put((String)itemList1.get(i) + "2", resultList.get(i).get(1));
            }
            return map;
        }
        DynamicObjectCollection collection = TaxReportFormHelper.getBalSheetsByEntityType(Collections.singleton(orgId), (long)accTableId, (QFilter[])new QFilter("booktype", "=", (Object)bookTypeId).toArray(), (String)Default_BalSheet_Equity_Query_Fields, (String)"equityentryentity.seq asc");
        if (collection.isEmpty()) {
            return map;
        }
        ArrayList<String> itemList1 = new ArrayList<String>();
        for (DynamicObject dyn : collection) {
            itemList1.add(dyn.getString("equity"));
        }
        for (int i = 0; i < resultList.size(); ++i) {
            map.put((String)itemList1.get(i) + "1", resultList.get(i).get(0));
            map.put((String)itemList1.get(i) + "2", resultList.get(i).get(1));
        }
        return map;
    }

    public static Map<String, BigDecimal> getIncomeValue(List<Long> orgIds, Set<Long> childOrgSet, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, int amtprecision, boolean isNeedPreYear) {
        Map<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        List resultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)periodId, (String)"income", (int)2, (int)amtprecision);
        Long orgId = TaxReportFormHelper.getParentOrg(orgIds);
        DynamicObjectCollection collection = TaxReportFormHelper.getIncomeEdit(Collections.singleton(orgId), (long)accTableId, (String)"income", (QFilter[])new QFilter("booktype", "=", (Object)bookTypeId).toArray());
        if (!resultList.isEmpty()) {
            map = FinancialKpiGetValueHelp.dealShowincome(resultList, map, 1, collection);
            if (isNeedPreYear) {
                DynamicObject preYearPeriodDyn = GlFormUtil.getSamePeriodOfYear(periodId, 1);
                long preYearPeriodId = preYearPeriodDyn == null ? 0L : preYearPeriodDyn.getLong("id");
                resultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)preYearPeriodId, (String)"income", (int)2, (int)amtprecision);
                if (!resultList.isEmpty()) {
                    map = FinancialKpiGetValueHelp.dealShowincome(resultList, map, 3, collection);
                }
            }
        }
        return map;
    }

    private static Map<String, BigDecimal> dealShowincome(List<List<BigDecimal>> list, Map<String, BigDecimal> map, int able, DynamicObjectCollection collection) {
        ArrayList<Long> ids = new ArrayList<Long>();
        HashMap<Integer, Long> indexMap = new HashMap<Integer, Long>();
        for (DynamicObject dyn : collection) {
            ids.add(dyn.getLong("project"));
            indexMap.put(dyn.getInt("balrowid"), dyn.getLong("project"));
        }
        DynamicObjectCollection items = QueryServiceHelper.query((String)"gl_manage_rptitem", (String)"id,number", (QFilter[])new QFilter("id", "in", ids).toArray());
        HashMap<Long, String> itemNumbers = new HashMap<Long, String>();
        for (DynamicObject item : items) {
            itemNumbers.put(item.getLong("id"), item.getString("number"));
        }
        for (int i = 0; i < list.size(); ++i) {
            map.put((String)itemNumbers.get(indexMap.get(i)) + able, list.get(i).get(0));
            map.put((String)itemNumbers.get(indexMap.get(i)) + (able + 1), list.get(i).get(1));
        }
        return map;
    }

    public static Map<String, BigDecimal> getTaxShowValue(List<Long> orgIds, Set<Long> childOrgSet, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, int amtprecision) {
        DynamicObject preYearPeriodDyn;
        long preYearPeriodId;
        DynamicObject prePeriodDyn;
        long prePeriodId;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        ArrayList<String> itemlist = new ArrayList<String>();
        Long orgId = TaxReportFormHelper.getParentOrg(orgIds);
        DynamicObjectCollection collection = TaxReportFormHelper.getIncomeEdits(Collections.singleton(orgId), (long)accTableId, (String)"taxshow", (QFilter[])new QFilter("booktype", "=", (Object)bookTypeId).toArray());
        for (DynamicObject dyn : collection) {
            itemlist.add(dyn.getString("number"));
        }
        List resultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)periodId, (String)"taxshow", (int)2, (int)amtprecision);
        if (!resultList.isEmpty()) {
            for (int i = 0; i < itemlist.size(); ++i) {
                map.put((String)itemlist.get(i) + "1", (BigDecimal)((List)resultList.get(i)).get(0));
                map.put((String)itemlist.get(i) + "2", (BigDecimal)((List)resultList.get(i)).get(1));
            }
        }
        long l = prePeriodId = (prePeriodDyn = GLUtil.getPreviousPeriod((Object)periodId)) == null ? 0L : prePeriodDyn.getLong("id");
        if (prePeriodDyn != null && !(resultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)prePeriodId, (String)"taxshow", (int)2, (int)amtprecision)).isEmpty()) {
            for (int i = 0; i < itemlist.size(); ++i) {
                map.put((String)itemlist.get(i) + "3", (BigDecimal)((List)resultList.get(i)).get(0));
                map.put((String)itemlist.get(i) + "4", (BigDecimal)((List)resultList.get(i)).get(1));
            }
        }
        long l2 = preYearPeriodId = (preYearPeriodDyn = GlFormUtil.getSamePeriodOfYear(periodId, 1)) == null ? 0L : preYearPeriodDyn.getLong("id");
        if (preYearPeriodDyn != null && !(resultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)preYearPeriodId, (String)"taxshow", (int)2, (int)amtprecision)).isEmpty()) {
            for (int i = 0; i < itemlist.size(); ++i) {
                map.put((String)itemlist.get(i) + "5", (BigDecimal)((List)resultList.get(i)).get(0));
                map.put((String)itemlist.get(i) + "6", (BigDecimal)((List)resultList.get(i)).get(1));
            }
        }
        return map;
    }

    public static Map<String, BigDecimal> getCashFlowStatValue(List<Long> orgIds, Set<Long> childOrgSet, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, int amtprecision) {
        DynamicObject preYearPeriodDyn;
        long preYearPeriodId;
        Map<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        List resultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)periodId, (String)"cashflow", (int)2, (int)amtprecision);
        if (DebugTrace.enable()) {
            logger.info("getCashFlowStatValue resultList : " + resultList);
        }
        Long orgId = TaxReportFormHelper.getParentOrg(orgIds);
        DynamicObjectCollection collection = TaxReportFormHelper.getIncomeEdits(Collections.singleton(orgId), (long)accTableId, (String)"cashflow", (QFilter[])new QFilter("booktype", "=", (Object)bookTypeId).toArray());
        if (!resultList.isEmpty()) {
            map = FinancialKpiGetValueHelp.dealCashFlowStat(resultList, map, collection, 1);
        }
        long l = preYearPeriodId = (preYearPeriodDyn = GlFormUtil.getSamePeriodOfYear(periodId, 1)) == null ? 0L : preYearPeriodDyn.getLong("id");
        if (preYearPeriodDyn != null && !(resultList = TaxReportFormHelper.collectBal(orgIds, childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)preYearPeriodId, (String)"cashflow", (int)2, (int)amtprecision)).isEmpty()) {
            map = FinancialKpiGetValueHelp.dealCashFlowStat(resultList, map, collection, 2);
        }
        if (DebugTrace.enable()) {
            logger.info("getCashFlowStatValue map : " + map);
        }
        return map;
    }

    private static Map<String, BigDecimal> dealCashFlowStat(List<List<BigDecimal>> list, Map<String, BigDecimal> map, DynamicObjectCollection collection, int able) {
        ArrayList<String> itemlist = new ArrayList<String>();
        for (DynamicObject dyn : collection) {
            itemlist.add(dyn.getString("number"));
        }
        for (int i = 0; i < itemlist.size(); ++i) {
            map.put((String)itemlist.get(i) + able, list.get(i).get(0));
        }
        BigDecimal cashIn1 = FinancialKpiGetValueHelp.getSum(list, 2, 4, able);
        map.put("100205" + able, cashIn1);
        BigDecimal cashOut1 = FinancialKpiGetValueHelp.getSum(list, 6, 9, able);
        map.put("100210" + able, cashOut1);
        BigDecimal cashNet1 = cashIn1.subtract(cashOut1);
        map.put("100211" + able, cashNet1);
        BigDecimal cashIn2 = FinancialKpiGetValueHelp.getSum(list, 13, 17, able);
        map.put("100218" + able, cashIn2);
        BigDecimal cashOut2 = FinancialKpiGetValueHelp.getSum(list, 19, 22, able);
        map.put("100223" + able, cashOut2);
        BigDecimal cashNet2 = cashIn2.subtract(cashOut2);
        map.put("100224" + able, cashNet2);
        BigDecimal cashIn3 = FinancialKpiGetValueHelp.getSum(list, 26, 28, able);
        map.put("100229" + able, cashIn3);
        BigDecimal cashOut3 = FinancialKpiGetValueHelp.getSum(list, 30, 32, able);
        map.put("100233" + able, cashOut3);
        BigDecimal cashNet3 = cashIn3.subtract(cashOut3);
        map.put("100234" + able, cashNet3);
        BigDecimal cashNet = cashNet1.add(cashNet2).add(cashNet3).add(list.get(34).get(able - 1));
        map.put("100236" + able, cashNet);
        BigDecimal cashBalance = cashNet.add(list.get(36).get(able - 1));
        map.put("100238" + able, cashBalance);
        BigDecimal suppCashNet = FinancialKpiGetValueHelp.getSum(list, 41, 56, able);
        map.put("100257" + able, suppCashNet);
        BigDecimal suppCashInc = list.get(62).get(able - 1).subtract(list.get(63).get(able - 1)).add(list.get(64).get(able - 1)).subtract(list.get(65).get(able - 1));
        map.put("100267" + able, suppCashInc);
        return map;
    }

    public static String translateDesc(String desp, Long orgId) {
        HashSet<String> desps = new HashSet<String>();
        Pattern p = Pattern.compile("\\d{7}");
        Matcher m = p.matcher(desp);
        while (m.find()) {
            desps.add(m.group());
        }
        Map<String, String> map = FinancialKpiGetValueHelp.dealDesp(desps, orgId);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            desp = desp.replace(key, entry.getValue());
        }
        return desp;
    }

    private static Map<String, String> dealDesp(Set<String> desps, Long orgId) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> codeValueMap = new HashMap<String, String>();
        ArrayList<String> names = new ArrayList<String>();
        for (String item : desps) {
            String key = item.substring(0, 6);
            if (!codeValueMap.containsKey(key)) {
                codeValueMap.put(item.substring(0, 6), item.substring(6));
                names.add(item.substring(0, 6));
                continue;
            }
            codeValueMap.put(item.substring(0, 6), (String)codeValueMap.get(key) + "," + item.substring(6));
        }
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_manage_rptitem", (Long)orgId);
        QFilter numberFilter = new QFilter("number", "in", names);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"gl_manage_rptitem", (String)"name,number,rptunit", (QFilter[])new QFilter[]{orgFilter, numberFilter});
        for (DynamicObject dyn : dyns) {
            String[] suffixs;
            String number = dyn.getString("number");
            String name = dyn.getString("name");
            String rptunit = dyn.getString("rptunit");
            String suffixStr = (String)codeValueMap.get(number);
            for (String suffix : suffixs = suffixStr.split(",")) {
                if (GL_BALANCESHEET.equals(rptunit)) {
                    if ("1".equals(suffix)) {
                        map.put(number + suffix, ResManager.loadKDString((String)"%s.\u671f\u521d\u4f59\u989d", (String)"FinancialKpiGetValueHelp_0", (String)"fi-gl-formplugin", (Object[])new Object[]{name}));
                        continue;
                    }
                    map.put(number + suffix, ResManager.loadKDString((String)"%s.\u671f\u672b\u4f59\u989d", (String)"FinancialKpiGetValueHelp_1", (String)"fi-gl-formplugin", (Object[])new Object[]{name}));
                    continue;
                }
                if (GL_CASHFLOWSTAT.equals(rptunit)) {
                    if ("1".equals(suffix)) {
                        map.put(number + suffix, ResManager.loadKDString((String)"%s.\u91d1\u989d", (String)"FinancialKpiGetValueHelp_2", (String)"fi-gl-formplugin", (Object[])new Object[]{name}));
                        continue;
                    }
                    map.put(number + suffix, ResManager.loadKDString((String)"%s.\u4e0a\u5e74\u540c\u671f\u91d1\u989d", (String)"FinancialKpiGetValueHelp_3", (String)"fi-gl-formplugin", (Object[])new Object[]{name}));
                    continue;
                }
                if (GL_SHOWINCOME.equals(rptunit)) {
                    if ("1".equals(suffix)) {
                        map.put(number + suffix, ResManager.loadKDString((String)"%s.\u672c\u671f\u91d1\u989d", (String)"FinancialKpiGetValueHelp_4", (String)"fi-gl-formplugin", (Object[])new Object[]{name}));
                        continue;
                    }
                    if ("2".equals(suffix)) {
                        map.put(number + suffix, ResManager.loadKDString((String)"%s.\u672c\u671f\u7d2f\u8ba1", (String)"FinancialKpiGetValueHelp_5", (String)"fi-gl-formplugin", (Object[])new Object[]{name}));
                        continue;
                    }
                    if ("3".equals(suffix)) {
                        map.put(number + suffix, ResManager.loadKDString((String)"%s.\u4e0a\u5e74\u540c\u671f\u91d1\u989d", (String)"FinancialKpiGetValueHelp_3", (String)"fi-gl-formplugin", (Object[])new Object[]{name}));
                        continue;
                    }
                    map.put(number + suffix, ResManager.loadKDString((String)"%s.\u4e0a\u5e74\u540c\u671f\u7d2f\u8ba1", (String)"FinancialKpiGetValueHelp_6", (String)"fi-gl-formplugin", (Object[])new Object[]{name}));
                    continue;
                }
                if ("1".equals(suffix)) {
                    map.put(number + suffix, ResManager.loadKDString((String)"%s.\u672c\u671f\u91d1\u989d", (String)"FinancialKpiGetValueHelp_4", (String)"fi-gl-formplugin", (Object[])new Object[]{name}));
                    continue;
                }
                if ("2".equals(suffix)) {
                    map.put(number + suffix, ResManager.loadKDString((String)"%s.\u672c\u671f\u7d2f\u8ba1", (String)"FinancialKpiGetValueHelp_5", (String)"fi-gl-formplugin", (Object[])new Object[]{name}));
                    continue;
                }
                if ("3".equals(suffix)) {
                    map.put(number + suffix, ResManager.loadKDString((String)"%s.\u4e0a\u671f\u91d1\u989d", (String)"FinancialKpiGetValueHelp_7", (String)"fi-gl-formplugin", (Object[])new Object[]{name}));
                    continue;
                }
                if ("4".equals(suffix)) {
                    map.put(number + suffix, ResManager.loadKDString((String)"%s.\u4e0a\u671f\u7d2f\u8ba1", (String)"FinancialKpiGetValueHelp_8", (String)"fi-gl-formplugin", (Object[])new Object[]{name}));
                    continue;
                }
                if ("5".equals(suffix)) {
                    map.put(number + suffix, ResManager.loadKDString((String)"%s.\u4e0a\u5e74\u540c\u671f\u91d1\u989d", (String)"FinancialKpiGetValueHelp_3", (String)"fi-gl-formplugin", (Object[])new Object[]{name}));
                    continue;
                }
                if (!"6".equals(suffix)) continue;
                map.put(number + suffix, ResManager.loadKDString((String)"%s.\u4e0a\u5e74\u540c\u671f\u91d1\u989d", (String)"FinancialKpiGetValueHelp_3", (String)"fi-gl-formplugin", (Object[])new Object[]{name}));
            }
        }
        return map;
    }

    public static Boolean isDigit(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void setTotalAmount(List<BigDecimal> list) {
    }

    private static BigDecimal getSum(List<List<BigDecimal>> list, int begin, int end, int able) {
        BigDecimal result = BigDecimal.ZERO;
        --end;
        for (int i = --begin; i <= end; ++i) {
            result = result.add(list.get(i).get(able - 1));
        }
        return result;
    }
}

