/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.util.GlFormUtil;

public class ReportClearUtil {
    private String formKey;
    private int changedProjectAt;
    private int changedColumnAt;
    private String projectType = "";
    private static final String ENTITY_CASHFLOW_EDIT = "gl_cashflowedit";
    private static final String ENTITY_INCOME_EDIT = "gl_incomeedit";
    private static final String ENTITY_BALANCESHEET_EDIT = "gl_balancesheetedit";
    private static final String KEY_RPTITEM = "rptitem";
    private static final String KEY_ISTOTALROW = "isTotalRow";
    private static final String KEY_balrowId = "balrowid";
    private static final String KEY_COLUMN_KEY = "columnkey";
    private static final String KEY_org = "org";
    private static final String KEY_accTable = "accounttable";
    private static final String KEY_bookType = "booktype";
    private static final String KEY_REPORT_TYPE = "type";
    private static final String KEY_ORG_VIEW = "orgview";
    private static HashMap<String, ReportClearInfo> relatedColumnMap = new HashMap(12);
    private static HashMap<String, String> specialKey = new HashMap(12);

    public ReportClearUtil(String formKey) {
        this.formKey = formKey;
        this.changedProjectAt = -1;
    }

    private ReportClearInfo getReportClearInfo() {
        return relatedColumnMap.get(this.formKey);
    }

    public void expressionCacheClear(PropertyChangedArgs e, AbstractFormPlugin p, String balrowid) {
        String propertyName = e.getProperty().getName();
        int columnKey = this.getReportClearInfo().columnAt(this, propertyName);
        this.projectType = (String)p.getView().getFormShowParameter().getCustomParam(KEY_REPORT_TYPE);
        if (e == null || columnKey < 0) {
            return;
        }
        ChangeData changeData = e.getChangeSet()[0];
        int changedRow = changeData.getRowIndex();
        if (propertyName != null && (null == changeData.getNewValue() || "".equals(changeData.getNewValue()))) {
            IDataModel m = p.getView().getModel();
            String balRowID = String.valueOf(m.getValue(balrowid, changedRow));
            this.doCacheClear(changeData.getRowIndex(), this.getCachedValueKey(balRowID, columnKey), p, balrowid);
        }
    }

    public void doCacheClear(int changedRow, String cachedValueKey, AbstractFormPlugin p, String balrowid) {
        DynamicObject expressionDyo;
        String expressionDyoStr = p.getView().getPageCache().get(cachedValueKey);
        DynamicObject dynamicObject = expressionDyo = StringUtils.isEmpty((CharSequence)expressionDyoStr) ? this.loadExpressionFromDB(p.getView().getModel(), changedRow, balrowid) : GlFormUtil.fromDynamicString(expressionDyoStr, EntityMetadataCache.getDataEntityType((String)this.getReportClearInfo().expressionMainEntity));
        if (expressionDyo == null) {
            return;
        }
        expressionDyo.set(this.getReportClearInfo().entryEntity, null);
        p.getView().getPageCache().put(cachedValueKey, GlFormUtil.toDynamicObjectJson(expressionDyo));
    }

    public static void clearAllExpressionCache(IPageCache c) {
        HashSet cacheToRemove = new HashSet(12);
        c.getAll().entrySet().stream().filter(entry -> ((String)entry.getKey()).matches(".*&.*")).forEach(entry -> cacheToRemove.add(entry.getKey()));
        cacheToRemove.forEach(key -> c.remove(key));
    }

    private DynamicObject loadExpressionFromDB(IDataModel m, int changedRow, String balrowid) {
        String columnKey = this.changedColumnAt + "";
        String balRowID = String.valueOf(m.getValue(balrowid, changedRow));
        QFilter qFilter = this.buildBaseDataQFilterFromModel(m, null).and(new QFilter(this.getPropertyKey(KEY_COLUMN_KEY), "=", (Object)columnKey)).and(new QFilter(this.getPropertyKey(KEY_balrowId), "=", (Object)balRowID)).and(this.buildBaseDataQFilterFromModel(m, KEY_accTable)).and(this.buildBaseDataQFilterFromModel(m, KEY_org)).and(this.buildBaseDataQFilterFromModel(m, KEY_bookType));
        QFilter totalRowFilter = this.getTotalRowFilter(m, changedRow);
        if (null == totalRowFilter) {
            return null;
        }
        qFilter.and(totalRowFilter);
        DynamicObject dyo = BusinessDataServiceHelper.loadSingleFromCache((String)this.getReportClearInfo().expressionMainEntity, (String)"id", (QFilter[])this.putReportTypeFilter(qFilter, m).toArray());
        if (dyo == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)dyo.getPkValue(), (String)this.getReportClearInfo().expressionMainEntity);
    }

    private QFilter getTotalRowFilter(IDataModel m, int changedRow) {
        DynamicObject projectItem = (DynamicObject)m.getValue(this.getReportClearInfo().doubleColumnsList.get((int)this.changedProjectAt).projectRelated, changedRow);
        if (null == projectItem) {
            return null;
        }
        if (ENTITY_CASHFLOW_EDIT.equalsIgnoreCase(m.getDataEntityType().getName())) {
            return QFilter.isNotNull((String)KEY_ISTOTALROW);
        }
        return new QFilter(KEY_ISTOTALROW, "=", projectItem.get(KEY_ISTOTALROW));
    }

    private QFilter buildBaseDataQFilterFromModel(IDataModel m, String propertyKey) {
        if (propertyKey == null) {
            return new QFilter("id", "is not null", null);
        }
        String key = this.getPropertyKey(propertyKey);
        return new QFilter(key, "=", m.getValue(key + "_id"));
    }

    private String getCachedValueKey(String balRowID, int columnKey) {
        return balRowID + "&" + columnKey;
    }

    private String getPropertyKey(String property) {
        return specialKey.getOrDefault(this.formKey + "_" + property, property);
    }

    private QFilter putReportTypeFilter(QFilter curFilter, IDataModel m) {
        String entityName = m.getDataEntityType().getName();
        String projectType = this.projectType;
        QFilter res = curFilter;
        if (!ENTITY_BALANCESHEET_EDIT.equalsIgnoreCase(m.getDataEntityType().getName())) {
            res = curFilter.and(KEY_REPORT_TYPE, "=", (Object)projectType);
        }
        return res;
    }

    static {
        relatedColumnMap.put(ENTITY_BALANCESHEET_EDIT, new ReportClearInfo("gl_balancesheetexpression", "entryentity", new DoubleColumns("assetbegin", "assetclose", "asset"), new DoubleColumns("equitybegin", "equityclose", "equity")));
        ReportClearInfo incomeClearInfo = new ReportClearInfo("gl_incomeexpression", "entryentity", new DoubleColumns("currentperiod", "yearcount", "project"));
        relatedColumnMap.put(ENTITY_INCOME_EDIT, incomeClearInfo);
        relatedColumnMap.put(ENTITY_CASHFLOW_EDIT, incomeClearInfo);
    }

    private static class DoubleColumns {
        protected String columnLeft;
        protected String columnRight;
        protected String projectRelated;

        public DoubleColumns(String columnLeft, String columnRight, String projectRelated) {
            this.columnLeft = columnLeft;
            this.columnRight = columnRight;
            this.projectRelated = projectRelated;
        }
    }

    private static class ReportClearInfo {
        protected String expressionMainEntity;
        protected String entryEntity;
        protected List<DoubleColumns> doubleColumnsList;

        public ReportClearInfo(String expressionMainEntity, String entryEntity, DoubleColumns ... doubleColumns) {
            this.expressionMainEntity = expressionMainEntity;
            this.entryEntity = entryEntity;
            this.doubleColumnsList = new ArrayList<DoubleColumns>(2);
            Arrays.stream(doubleColumns).forEach(c -> this.doubleColumnsList.add((DoubleColumns)c));
        }

        public int columnAt(ReportClearUtil util, String column) {
            if (column == null) {
                return -1;
            }
            int columnKey = 1;
            for (DoubleColumns columns : this.doubleColumnsList) {
                util.changedProjectAt = this.doubleColumnsList.indexOf(columns);
                if (columns.columnLeft.equals(column)) {
                    return util.changedColumnAt = columnKey;
                }
                if (columns.columnRight.equals(column)) {
                    return util.changedColumnAt = ++columnKey;
                }
                columnKey += 2;
            }
            return 0;
        }
    }
}

