/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.PermissonType;

public class TaxReportTemplatePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String REFRESH = "refresh";
    private static final String REPORTEDIT = "reportedit";
    private static final String EXPORT = "export";
    private static final String ASSGIN = "tblassign";
    private static final String ASSGINSEARCH = "tblassign_search";
    private static final String PERIOD = "period";
    private static final String ORGVIEW = "orgview";
    private static final String ACCTABLE = "accounttable";
    private static final String PERIODTYPE = "periodtype";
    protected static final String BASE_CURRENCY = "basecurrency";
    protected static final String ORGS = "orgs";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{REFRESH, REPORTEDIT, EXPORT, PERIOD, ASSGIN, ASSGINSEARCH});
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit orgViewEdit = (BasedataEdit)this.getControl(ORGVIEW);
        orgViewEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            param.setFormId("bos_listf7");
        });
        BasedataEdit periodEdit = (BasedataEdit)this.getControl(PERIOD);
        periodEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject periodType = (DynamicObject)this.getModel().getValue(PERIODTYPE);
            if (periodType != null) {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                param.getListFilterParameter().getQFilters().add(new QFilter(PERIODTYPE, "=", (Object)periodType.getLong("id")));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        Set orgSet = AccSysUtil.getAcctOrgPkList2((String)this.getView().getEntityId(), (boolean)true, (PermissonType)PermissonType.VIEW);
        this.getPageCache().put("_permOrgList", GLUtil.toSerializedString((Object)orgSet));
        Set orgPkSet = AccSysUtil.getAcctOrgPkList2((String)this.getView().getEntityId(), (boolean)true, (PermissonType)PermissonType.VIEW);
        BasedataEdit orgBd = (BasedataEdit)this.getControl(ORGS);
        orgBd.setQFilter(new QFilter("id", "in", (Object)orgPkSet));
        String paramOrg = (String)this.getView().getFormShowParameter().getCustomParam("org");
        if (paramOrg != null) {
            long paramOrgId = Long.parseLong(paramOrg);
            this.setDefaultOrg(paramOrgId);
        } else {
            long defaultOrgId = AccSysUtil.getDefaultOrgId((String)this.getView().getEntityId(), (boolean)true, (PermissonType)PermissonType.VIEW);
            if (orgPkSet.contains(defaultOrgId)) {
                this.setDefaultOrg(defaultOrgId);
            } else {
                this.setDefaultOrg(GlFormUtil.getDefaultAcctOrg(new ArrayList<Long>(orgPkSet)));
            }
        }
        this.setBookInfo();
    }

    private List<Long> getOrgValue() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(ORGS);
        return orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    private void setDefaultOrg(Long orgId) {
        if (orgId == null || orgId == 0L) {
            this.getModel().setValue(ORGS, null);
        } else {
            this.getModel().setValue(ORGS, (Object)new Long[]{orgId});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object newObj = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "orgs": {
                if (newObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TaxReportTemplatePlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.setBookInfo();
                break;
            }
            case "orgview": {
                if (newObj == null) {
                    return;
                }
                Long orgViewId = ((DynamicObject)newObj).getLong("id");
                this.setBookType(orgViewId);
                break;
            }
            case "booktype": {
                if (newObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"TaxReportTemplatePlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long bookTypeId = ((DynamicObject)newObj).getLong("id");
                this.setBook(bookTypeId);
                break;
            }
            case "accounttable": {
                if (newObj != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u8868\u3002", (String)"TaxReportTemplatePlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                break;
            }
            case "periodtype": {
                if (newObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u7c7b\u578b\u3002", (String)"TaxReportTemplatePlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                String str = this.getPageCache().get("ptSpMap");
                Map ptSpMap = (Map)GLUtil.fromSerializedString((String)str);
                long periodType = ((DynamicObject)newObj).getLong("id");
                this.setPeriodFilter(periodType, ptSpMap);
                break;
            }
            case "period": {
                long btId;
                if (newObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"TaxReportTemplatePlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                long period = ((DynamicObject)newObj).getLong("id");
                List<Long> orgIds = this.getOrgValue();
                List<Long> tableIds = this.getVerAcctTable(orgIds, btId = ((Long)this.getModel().getValue("booktype_id")).longValue(), period);
                if (tableIds.isEmpty()) break;
                BasedataEdit accountTableEdit = (BasedataEdit)this.getControl(ACCTABLE);
                this.setF7ClickFilter(accountTableEdit, new QFilter("id", "in", tableIds));
                this.getModel().setValue(ACCTABLE, (Object)tableIds.get(0));
            }
        }
    }

    private List<Long> getVerAcctTable(List<Long> orgIds, long bookTypeId, long endPeriodId) {
        QFilter forg = new QFilter("org", "in", orgIds);
        QFilter fbt = new QFilter("booktype", "=", (Object)bookTypeId);
        String selfield = StringUtils.join((Object[])new String[]{"org", "enableperiod", "oldaccttab", ACCTABLE}, (String)",");
        DynamicObjectCollection col = QueryServiceHelper.query((String)"gl_book_version", (String)selfield, (QFilter[])new QFilter[]{forg, fbt}, (String)"org, enableperiod desc");
        ArrayList<Long> orgs = new ArrayList<Long>(orgIds.size());
        ArrayList<Long> acctTableIds = new ArrayList<Long>(orgIds.size());
        if (!col.isEmpty()) {
            if (col.size() == 1) {
                DynamicObject obj = (DynamicObject)col.get(0);
                if (endPeriodId > obj.getLong("enableperiod")) {
                    acctTableIds.add(obj.getLong(ACCTABLE));
                } else if (endPeriodId == obj.getLong("enableperiod")) {
                    acctTableIds.add(obj.getLong(ACCTABLE));
                    acctTableIds.add(obj.getLong("oldaccttab"));
                } else {
                    acctTableIds.add(obj.getLong("oldaccttab"));
                }
            } else {
                long org = 0L;
                int size = col.size();
                long acctTableId = 0L;
                int i = 0;
                for (DynamicObject rec : col) {
                    ++i;
                    if (!orgs.contains(org)) {
                        if (endPeriodId >= rec.getLong("enableperiod")) {
                            acctTableIds.add(rec.getLong(ACCTABLE));
                            orgs.add(rec.getLong("org"));
                        } else if (org != 0L && org != rec.getLong("org")) {
                            acctTableIds.add(acctTableId);
                            orgs.add(rec.getLong("org"));
                        }
                        if (size == i) {
                            acctTableIds.add(rec.getLong("oldaccttab"));
                        }
                    }
                    org = rec.getLong("org");
                    acctTableId = rec.getLong("oldaccttab");
                }
            }
        }
        orgIds.removeAll(orgs);
        if (orgs.size() != 0 && !orgIds.isEmpty()) {
            try (DataSet ds = BatchProcessUtil.batchQueryDataSet(orgIds, batchData -> QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_accountbook", (String)ACCTABLE, (QFilter[])new QFilter[]{new QFilter("org", "in", batchData), new QFilter("bookstype", "=", (Object)bookTypeId)}, null));){
                for (Row row : ds) {
                    acctTableIds.add(row.getLong(ACCTABLE));
                }
            }
        }
        return acctTableIds;
    }

    protected void setBookInfo() {
        List<Long> orgIds = this.getOrgValue();
        if (orgIds.size() == 1) {
            this.setMainView(orgIds.get(0));
        } else {
            this.setMulBookType(orgIds);
        }
    }

    private void setMulBookType(List<Long> orgList) {
        this.getModel().setValue(ORGVIEW, null);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{ORGVIEW});
        Long defaultBookType = null;
        LinkedHashSet<Long> bookTypes = new LinkedHashSet<Long>();
        QFilter orgFiler = new QFilter("org", "in", orgList);
        List ids = AccSysUtil.getBookTypeDataPermission(orgList);
        if (ids != null) {
            orgFiler = orgFiler.and(new QFilter("bookstype", "in", (Object)ids));
        }
        QFilter entityFilter = new QFilter("isbizunit", "=", (Object)true);
        DynamicObjectCollection btCol = QueryServiceHelper.query((String)"gl_accountbook", (String)"org,bookstype id, bookstype.accounttype type", (QFilter[])new QFilter[]{orgFiler, entityFilter});
        HashSet<Long> childOrg = new HashSet<Long>();
        for (DynamicObject bt : btCol) {
            bookTypes.add(bt.getLong("id"));
            if ("1".equals(bt.getString("type"))) {
                defaultBookType = bt.getLong("id");
            }
            childOrg.add(bt.getLong("org"));
        }
        this.getPageCache().put("childOrgSet", GLUtil.toSerializedString(childOrg));
        if (defaultBookType == null && bookTypes.size() > 0) {
            defaultBookType = (Long)bookTypes.iterator().next();
        }
        if (defaultBookType == null) {
            return;
        }
        this.setBT(bookTypes, defaultBookType);
    }

    private void setMainView(Long orgId) {
        Set mainViewIds = AccSysUtil.getViewByOrg((Long)orgId);
        Long defaultViewId = 0L;
        if (mainViewIds.size() > 0) {
            defaultViewId = (Long)mainViewIds.iterator().next();
        }
        BasedataEdit orgViewEdit = (BasedataEdit)this.getControl(ORGVIEW);
        this.setF7ClickFilter(orgViewEdit, new QFilter("id", "in", (Object)mainViewIds));
        this.getView().setVisible(Boolean.valueOf(mainViewIds.size() != 1), new String[]{ORGVIEW});
        this.getModel().setValue(ORGVIEW, (Object)defaultViewId);
        this.setBookType(defaultViewId);
    }

    protected void setBookType(Long orgViewId) {
        List<Long> orgList = this.getOrgValue();
        HashSet<Long> orgParent = new HashSet<Long>();
        if (orgList.size() != 0) {
            orgParent.addAll(orgList);
        }
        Set childOrgSet = AccSysUtil.getChildOrgId((String)"10", (Long)orgViewId, orgParent, (boolean)true);
        Set permOrg = new HashSet();
        String str = this.getPageCache().get("_permOrgList");
        if (str != null) {
            permOrg = (Set)GLUtil.fromSerializedString((String)str);
        }
        childOrgSet.retainAll(permOrg);
        Map viewOrgBTMap = AccSysUtil.getViewOrgBTMap();
        HashSet<Long> bookTypes = new HashSet<Long>();
        Map orgBTMap = (Map)viewOrgBTMap.get(orgViewId);
        if (orgBTMap != null) {
            childOrgSet.retainAll(orgBTMap.keySet());
            this.getPageCache().put("childOrgSet", GLUtil.toSerializedString((Object)childOrgSet));
            for (Map.Entry listEntry : orgBTMap.entrySet()) {
                Long org = (Long)listEntry.getKey();
                if (!childOrgSet.contains(org)) continue;
                bookTypes.addAll((Collection)listEntry.getValue());
            }
        }
        long defaultBookType = 0L;
        ArrayList orgIds = new ArrayList();
        orgIds.addAll(childOrgSet);
        List btIds = AccSysUtil.getBookTypeDataPermission(orgIds);
        if (btIds != null) {
            bookTypes.retainAll(btIds);
        }
        QFilter fbt = new QFilter("id", "in", bookTypes);
        DynamicObjectCollection btDyn = QueryServiceHelper.query((String)"bd_accountbookstype", (String)"id,accounttype", (QFilter[])new QFilter[]{fbt});
        for (DynamicObject bt : btDyn) {
            defaultBookType = bt.getLong("id");
            if (!"1".equals(bt.getString("accounttype"))) continue;
            defaultBookType = bt.getLong("id");
            break;
        }
        this.setBT(bookTypes, defaultBookType);
    }

    private void setBT(Collection<Long> bookTypes, long defaultBookType) {
        IDataModel model = this.getModel();
        BasedataEdit bookTypeEdit = (BasedataEdit)this.getControl("booktype");
        this.setF7ClickFilter(bookTypeEdit, new QFilter("id", "in", bookTypes));
        this.getView().setVisible(Boolean.valueOf(bookTypes.size() > 1), new String[]{"booktype"});
        model.setValue("booktype", (Object)defaultBookType);
        this.setBook(defaultBookType);
    }

    protected void setBook(Long bookTypeId) {
        BasedataEdit accountTableEdit;
        IDataModel model = this.getModel();
        Set childOrgSet = new HashSet();
        String str = this.getPageCache().get("childOrgSet");
        if (str != null) {
            childOrgSet = (Set)GLUtil.fromSerializedString((String)str);
        }
        List bookInfoList = AccSysUtil.getBookFromAccSys(childOrgSet, (long)bookTypeId);
        HashSet<Long> accountTables = new HashSet<Long>(bookInfoList.size());
        HashSet<Long> periodTypes = new HashSet<Long>(bookInfoList.size());
        Long defaultAccountTable = 0L;
        long defaultPeriodType = 0L;
        long defaultBaseCur = 0L;
        long defaultCurPeriod = 0L;
        HashMap<Long, Set<Long>> ptSpMap = new HashMap<Long, Set<Long>>();
        for (int i = 0; i < bookInfoList.size(); ++i) {
            AccountBookInfo book = (AccountBookInfo)bookInfoList.get(i);
            long periodtype = book.getPeriodTypeId();
            long startperiod = book.getStartPeriodId();
            long accountTableId = book.getAccountTableId();
            long baseCurrencyId = book.getBaseCurrencyId();
            GlFormUtil.putMap(ptSpMap, periodtype, startperiod);
            periodTypes.add(periodtype);
            accountTables.add(accountTableId);
            if (i != 0) continue;
            defaultAccountTable = accountTableId;
            defaultPeriodType = periodtype;
            defaultCurPeriod = book.getCurPeriodId();
            defaultBaseCur = baseCurrencyId;
        }
        this.getPageCache().put("ptSpMap", GLUtil.toSerializedString(ptSpMap));
        this.setPeriodFilter(defaultPeriodType, ptSpMap);
        List<Long> orgIds = this.getOrgValue();
        long btId = (Long)model.getValue("booktype_id");
        List<Long> tableIds = this.getVerAcctTable(orgIds, btId, defaultCurPeriod);
        if (!tableIds.isEmpty()) {
            accountTableEdit = (BasedataEdit)this.getControl(ACCTABLE);
            this.setF7ClickFilter(accountTableEdit, new QFilter("id", "in", tableIds));
            if (tableIds.contains(defaultAccountTable)) {
                model.setValue(ACCTABLE, (Object)defaultAccountTable);
            } else {
                model.setValue(ACCTABLE, (Object)tableIds.get(0));
            }
        } else {
            model.setValue(ACCTABLE, (Object)defaultAccountTable);
            accountTableEdit = (BasedataEdit)this.getControl(ACCTABLE);
            this.setF7ClickFilter(accountTableEdit, new QFilter("id", "in", accountTables));
        }
        BasedataEdit periodTypeEdit = (BasedataEdit)this.getControl(PERIODTYPE);
        this.setF7ClickFilter(periodTypeEdit, new QFilter("id", "in", periodTypes));
        model.setValue(PERIODTYPE, (Object)defaultPeriodType);
        model.setValue(PERIOD, (Object)defaultCurPeriod);
        model.setValue(BASE_CURRENCY, (Object)defaultBaseCur);
    }

    private void setPeriodFilter(long periodType, Map<Long, Set<Long>> ptSpMap) {
        BasedataEdit period = (BasedataEdit)this.getControl(PERIOD);
        Set<Long> spSet = ptSpMap.get(periodType);
        Long minPeriod = spSet == null || spSet.size() == 0 ? null : Collections.min(spSet);
        this.setF7ClickFilter(period, new QFilter("id", ">=", (Object)minPeriod));
    }

    private void setF7ClickFilter(BasedataEdit edit, QFilter qFilter) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(qFilter);
        edit.setQFilters(list);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (ASSGIN.equals(key)) {
            this.taxAssgin(ASSGIN);
        } else if (ASSGINSEARCH.equals(key)) {
            this.taxAssgin(ASSGINSEARCH);
        }
    }

    public void taxAssgin(String flag) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        List<Long> orgIds = this.getOrgValue();
        if (orgIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"TaxReportTemplatePlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        if (orgIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u7ec4\u7ec7\u8fdb\u884c\u5206\u914d\u3002", (String)"TaxReportTemplatePlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        Long orgId = orgIds.get(0);
        Long orgViewId = (Long)model.getValue("orgview_id");
        Long bookTypeId = (Long)model.getValue("booktype_id");
        Long accTableId = (Long)model.getValue("accounttable_id");
        if (orgId == null || orgId == 0L || orgViewId == null || orgViewId == 0L || bookTypeId == null || bookTypeId == 0L || accTableId == null || accTableId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3001\u89c6\u56fe\u3001\u8d26\u7c3f\u7c7b\u578b\u3001\u79d1\u76ee\u8868\u4e3a\u5fc5\u5f55\u9879\uff0c\u586b\u5199\u540e\u624d\u53ef\u5206\u914d\u3002", (String)"TaxReportTemplatePlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        String formId = "";
        if (ASSGIN.equals(flag)) {
            formId = "gl_taxassign";
        } else if (ASSGINSEARCH.equals(flag)) {
            formId = "gl_taxassignquery";
        }
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(false);
        String entityNumber = view.getFormShowParameter().getFormId();
        String type = "";
        if ("gl_balancesheet".equals(entityNumber)) {
            type = "balancesheet";
        } else if ("gl_showincome".equals(entityNumber)) {
            type = "income";
        } else if ("gl_taxshow".equals(entityNumber)) {
            type = "taxshow";
        } else if ("gl_cashflowstat".equals(entityNumber)) {
            type = "cashflow";
        }
        showParameter.setCustomParam("entityNumber", (Object)view.getEntityId());
        showParameter.setCustomParam("type", (Object)type);
        showParameter.setCustomParam("orgId", (Object)orgId);
        showParameter.setCustomParam("orgViewId", (Object)orgViewId);
        showParameter.setCustomParam("bookTypeId", (Object)bookTypeId);
        showParameter.setCustomParam("accTableId", (Object)accTableId);
        String isLeafOrg = this.getPageCache().get("isLeafOrg");
        showParameter.setCustomParam("isLeafOrg", (Object)isLeafOrg);
        view.showForm(showParameter);
    }
}

