/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.operate;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.voucher.relation.VoucherRelationHelper;

public class VoucherElecreceiptView {
    private static final Log logger = LogFactory.getLog(VoucherElecreceiptView.class);
    private final IFormView view;
    private static final String CAS_APPID = "cas";

    public VoucherElecreceiptView(IFormView view) {
        this.view = view;
    }

    public void showElecReceipt(long voucherID) {
        Map directRelationBillMap = VoucherRelationHelper.getDirectRelationBill((long)voucherID);
        logger.info("[viewElec]relationMap:{}", (Object)directRelationBillMap);
        if (directRelationBillMap.isEmpty()) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u51ed\u8bc1\u65e0\u5173\u8054\u4e0a\u6e38\u5355\u636e\u3002", (String)"VoucherElecreceiptView_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        List receiptIds = directRelationBillMap.entrySet().stream().filter(e -> CAS_APPID.equals(EntityMetadataCache.getDataEntityType((String)((String)e.getKey())).getAppId())).flatMap(e -> this.fetchReceiptIds((String)e.getKey(), (Set)e.getValue()).stream()).collect(Collectors.toList());
        if (receiptIds.isEmpty()) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u51ed\u8bc1\u7684\u4e0a\u6e38\u5355\u636e\u6ca1\u6709\u5173\u8054\u7684\u7535\u5b50\u56de\u5355\u3002", (String)"VoucherElecreceiptView_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        this.viewReceipts(receiptIds.toArray());
    }

    public List<Long> fetchReceiptIds(String entityId, Set<Long> billIds) {
        logger.info("[viewElec]:invoke getReceiptIdByIds mservice, params, params:entityId={},billIds={}", (Object)entityId, billIds);
        Map billIdReceiptIdsMap = (Map)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"viewreceipt", (String)"getReceiptIdByIds", (Object[])new Object[]{entityId, billIds});
        logger.info("[viewElec]:invoke getReceiptIdByIds mservice, result:billIdReceiptIdsMap={}", (Object)billIdReceiptIdsMap);
        return billIdReceiptIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void viewReceipts(Object[] receiptIds) {
        logger.info("[viewElec]:invoke getReceiptPdfUrl mservice, params:receiptIds={}", (Object)Arrays.toString(receiptIds));
        String url = (String)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"viewreceipt", (String)"getReceiptPdfUrl", (Object[])new Object[]{this.view.getPageId(), receiptIds});
        logger.info("[viewElec]:invoke getReceiptPdfUrl mservice, result:url={}", (Object)url);
        this.openForm(url);
    }

    private void showErrorResult(List<String> result) {
        if (result.size() == 1) {
            this.view.showTipNotification(result.get(0));
            return;
        }
        if (result.size() > 1) {
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u8be5\u51ed\u8bc1\u7684\u4e0a\u6e38\u5355\u636e\u8054\u67e5\u4e0d\u5230\u7684\u56de\u5355\u6570\u636e\u5171\u6709:%s\u6761", (String)"VoucherElecreceiptView_2", (String)"fi-gl-formplugin", (Object[])new Object[]{result.size()}));
            StringBuilder errorSb = new StringBuilder();
            for (String msg : result) {
                errorSb.append(msg);
                errorSb.append('\n');
            }
            this.view.showMessage(sb.toString(), errorSb.toString(), MessageTypes.Default);
        }
    }

    private void dealReceiptResult(JSONObject resultRpc, List<String> result) {
        if (resultRpc != null) {
            int openType = resultRpc.getInteger("openType");
            switch (openType) {
                case 1: {
                    this.openFormWithFormParam((FormShowParameter)resultRpc.getObject("spStr", FormShowParameter.class));
                    break;
                }
                case 2: {
                    result.add(resultRpc.getString("msg"));
                    break;
                }
                case 0: {
                    this.openForm(resultRpc.getString("url"));
                    break;
                }
                default: {
                    this.view.showErrorNotification(ResManager.loadKDString((String)"\u51fa\u7eb3\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u83b7\u53d6\u7535\u5b50\u56de\u6863\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"VoucherElecreceiptView_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void openForm(String url) {
        FormShowParameter parameter = this.buildParameter(url);
        this.view.showForm(parameter);
    }

    private void openFormWithFormParam(FormShowParameter param) {
    }

    private FormShowParameter buildParameter(String pdfUrl) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bos_printpreview");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.setCustomParam("src", (Object)pdfUrl);
        para.setCaption(ResManager.loadKDString((String)"\u8054\u67e5\u56de\u5355", (String)"VoucherElecreceiptView_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        return para;
    }

    @Deprecated
    public static boolean isTheVoucherComeFromSomeSystem(Long voucherID, Set<String> sysKeySet) {
        ArrayList<Long> voucherIds = new ArrayList<Long>();
        voucherIds.add(voucherID);
        Map sourceInfos = GLUtil.getVoucherLinkUpBillsInFast(voucherIds);
        if (sourceInfos.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : sourceInfos.entrySet()) {
            Long id = (Long)entry.getKey();
            String sourceBillType = (String)sourceInfos.get(id);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)sourceBillType);
            if (type == null || !sysKeySet.contains(type.getAppId())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isTheVoucherComeFromTheSystem(Long voucherID, String sysKey) {
        HashSet<String> set = new HashSet<String>();
        set.add(sysKey);
        return VoucherElecreceiptView.isTheVoucherComeFromSomeSystem(voucherID, set);
    }

    static class ElecReceiptParamOfRPC {
        protected static final String MESSAGE = "msg";
        protected static final String RESULT_CODE = "openType";
        protected static final String URL = "url";
        protected static final String FORM_SHOW_PARAMETER = "spStr";

        ElecReceiptParamOfRPC() {
        }
    }
}

