/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.checkstatus;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.checkstatus.service.AbstractNoticeCheckService;
import kd.fi.gl.checkstatus.service.NoticeCheckServiceFactory;

public class CheckStatusOpService
extends EntityOperateService {
    private static final String[] SELECTFIELDS = new String[]{"org", "voucher", "voucherentry", "sendorg", "receiveorg", "amount", "currency", "entrydc", "bookeddate", "checkstatus"};

    protected void preparePropertys(List<String> fieldKeys) {
        Collections.addAll(fieldKeys, SELECTFIELDS);
        List<String> cusFieldKeys = NoticeCheckServiceFactory.getFieldKeys(this.getBillEntityType().getName());
        fieldKeys.addAll(cusFieldKeys);
    }

    protected void executeOperate(DynamicObject[] allNotices) {
        AbstractNoticeCheckService checkService;
        OperateOption option = this.getOption();
        boolean isIntellexecSchemaForAcnotice = false;
        String taskId = null;
        if (option != null && option.containsVariable("gl_intellexecschema") && Long.valueOf(option.getVariableValue("gl_intellexecschema")) != null && ("gl_acnotice".equals(this.getBillEntityType().getName()) || "gl_cfnotice".equals(this.getBillEntityType().getName()))) {
            String billEntityType = this.getBillEntityType().getName();
            taskId = option.getVariableValue("taskid");
            isIntellexecSchemaForAcnotice = true;
            allNotices = this.getUnionNotices(billEntityType, allNotices, taskId);
        }
        if (null != (checkService = NoticeCheckServiceFactory.getCheckService(this.getBillEntityType().getName()))) {
            String checkType = this.getOption().getVariableValue("checktype", "checktype_auto");
            long excuteOrg = Long.parseLong(this.getOption().getVariableValue("check_org", "0"));
            List<DynamicObject> excuteResult = checkService.excute(allNotices, checkType, excuteOrg);
            this.cacheUncheckAcnotices(allNotices, isIntellexecSchemaForAcnotice, taskId, excuteResult);
            this.setDataEntities(excuteResult.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject[] getUnionNotices(String billEntityType, DynamicObject[] allNotices, String taskId) {
        try (DLock lock = DLock.create((String)taskId).fastMode();){
            DistributeCache distributeCache;
            String cacheNoticesStr;
            if (lock.tryLock() && StringUtils.isNotEmpty((String)(cacheNoticesStr = (distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.acnotice)).get(taskId)))) {
                List acnoticeIds = SerializationUtils.fromJsonStringToList((String)cacheNoticesStr, Long.class);
                String dataEntityType = billEntityType.equals("gl_acnotice") ? "gl_acnotice" : "gl_cfnotice";
                Object[] acnoticesFromCache = BusinessDataServiceHelper.load((Object[])acnoticeIds.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dataEntityType));
                allNotices = (DynamicObject[])ArrayUtils.addAll((Object[])acnoticesFromCache, (Object[])allNotices);
                distributeCache.remove(taskId);
            }
        }
        return allNotices;
    }

    private void cacheUncheckAcnotices(DynamicObject[] allNotices, boolean isIntellexecSchemaForAcnotice, String taskId, List<DynamicObject> excuteResult) {
        if (isIntellexecSchemaForAcnotice) {
            try (DLock lock = DLock.create((String)taskId).fastMode();){
                if (lock.tryLock()) {
                    List excuteResultIds = excuteResult.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                    List allNoticeIds = Stream.of(allNotices).filter(x -> "0".equals(x.getString("checkstatus"))).map(x -> x.getLong("id")).collect(Collectors.toList());
                    allNoticeIds.removeAll(excuteResultIds);
                    DistributeCache distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.acnotice);
                    String cacheNoticesStr = distributeCache.get(taskId);
                    if (StringUtils.isNotEmpty((String)cacheNoticesStr)) {
                        List cacheNotices = SerializationUtils.fromJsonStringToList((String)cacheNoticesStr, Long.class);
                        allNoticeIds.addAll(cacheNotices);
                    }
                    distributeCache.put(taskId, SerializationUtils.toJsonString(allNoticeIds));
                }
            }
        }
    }
}

