/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.checkstatus.checkinfo;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.checkstatus.checkinfo.AbstractNotice;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.util.SystemParamHelper;

public class ACNoticeEntity
extends AbstractNotice {
    public ACNoticeEntity(DynamicObject notice) {
        super.setNotice(notice);
    }

    @Override
    public boolean compareOriAmount(Object obj) {
        if (!(obj instanceof ACNoticeEntity)) {
            return false;
        }
        if (this.equals(obj)) {
            return true;
        }
        ACNoticeEntity op = (ACNoticeEntity)obj;
        if (!this.getOriCurrencyId().equals(op.getOriCurrencyId())) {
            return false;
        }
        return this.getOriAmount().compareTo(op.getOriAmount()) == 0 && !this.getDc().equals(op.getDc()) || this.getOriAmount().compareTo(op.getOriAmount().negate()) == 0 && this.getDc().equals(op.getDc());
    }

    @Override
    public boolean compareLocAmount(Object obj) {
        if (!(obj instanceof ACNoticeEntity)) {
            return false;
        }
        if (this.equals(obj)) {
            return true;
        }
        ACNoticeEntity op = (ACNoticeEntity)obj;
        if (!this.getLocCurrencyId().equals(op.getLocCurrencyId())) {
            return false;
        }
        return this.getLocAmount().compareTo(op.getLocAmount()) == 0 && !this.getDc().equals(op.getDc()) || this.getLocAmount().compareTo(op.getLocAmount().negate()) == 0 && this.getDc().equals(op.getDc());
    }

    @Override
    public BigDecimal getLocAmount() {
        return this.getNotice().getBigDecimal("locamount");
    }

    @Override
    public Long getLocCurrencyId() {
        return this.getNotice().getLong(GLField.id_((String)"localcur"));
    }

    @Override
    public Long getMainDataId() {
        return this.getNotice().getLong(GLField.id_((String)"account"));
    }

    @Override
    public boolean isLocCheckEnable() {
        return SystemParamHelper.getBooleanParam((String)"acnloccurenbale", (long)this.getOrgId(), (boolean)false);
    }

    @Override
    public String getLocAmountDc() {
        BigDecimal dcDecimalVal = this.getNotice().getBigDecimal("entrydc");
        int compareToZero = this.getLocAmount().multiply(dcDecimalVal).compareTo(BigDecimal.ZERO);
        return compareToZero >= 0 ? "1" : "-1";
    }

    @Override
    public String getOriAmountDc() {
        BigDecimal dcDecimalVal = this.getNotice().getBigDecimal("entrydc");
        int compareToZero = this.getOriAmount().multiply(dcDecimalVal).compareTo(BigDecimal.ZERO);
        return compareToZero >= 0 ? "1" : "-1";
    }
}

