/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.checkstatus.checkinfo;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.fi.gl.checkstatus.checkinfo.AbstractNotice;
import kd.fi.gl.checkstatus.checkinfo.NoticeCheckLog;

public class NoticeCheckContext {
    private final String entityName;
    private final List<AbstractNotice> readyCheckDatas;
    private final Set<NoticeCheckLog> logs;
    private final Set<Long> completedEntryIds;
    private final boolean mulCheckEnable;
    private boolean localCurrencyCheckEnable;
    private String checkType;

    public NoticeCheckContext(List<AbstractNotice> readyCheckDatas, boolean mulCheckEnable, String entityName, String checkType) {
        this.readyCheckDatas = readyCheckDatas;
        this.logs = new HashSet<NoticeCheckLog>(readyCheckDatas.size());
        this.completedEntryIds = new HashSet<Long>(readyCheckDatas.size());
        this.mulCheckEnable = mulCheckEnable;
        this.localCurrencyCheckEnable = false;
        this.entityName = entityName;
        this.checkType = checkType;
    }

    public final List<AbstractNotice> getReadyCheckDatas() {
        return this.readyCheckDatas;
    }

    public final Set<NoticeCheckLog> getCheckLogs() {
        return this.logs;
    }

    public final Set<Long> getCompletedEntryIds() {
        return this.completedEntryIds;
    }

    public final boolean isMulCheckEnable() {
        return this.mulCheckEnable;
    }

    public final boolean isLocalCurrencyCheckEnable() {
        return this.localCurrencyCheckEnable;
    }

    public final void setLocalCurrencyCheckEnable(boolean localCurrencyCheckEnable) {
        this.localCurrencyCheckEnable = localCurrencyCheckEnable;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public boolean isManualCheck() {
        return "checktype_manual".equals(this.checkType);
    }

    public String getCheckType() {
        return this.checkType;
    }

    public final void update(Set<NoticeCheckLog> logs) {
        if (logs == null || logs.isEmpty()) {
            return;
        }
        this.logs.addAll(logs);
        for (NoticeCheckLog log : logs) {
            this.completedEntryIds.addAll(log.getAllEntryIds());
        }
        this.readyCheckDatas.removeIf(x -> this.completedEntryIds.contains(x.getEntryId()));
    }
}

