/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.checkstatus.checkinfo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.checkstatus.checkinfo.AbstractNotice;

public class NoticeCheckLog {
    private final Set<Long> allEntryIds;
    private final Map<Long, Long> entryId2voucherId;
    private final Map<Long, Long> opEntryId2opVoucherId;
    private final Boolean isLocCurrency;

    public NoticeCheckLog(List<AbstractNotice> notices, List<AbstractNotice> opNotices, Boolean isLocCurrency) {
        int size = notices.size();
        int opSize = opNotices.size();
        this.allEntryIds = new HashSet<Long>(size + opSize);
        this.entryId2voucherId = new HashMap<Long, Long>(size);
        this.opEntryId2opVoucherId = new HashMap<Long, Long>(opSize);
        for (AbstractNotice notice : notices) {
            this.allEntryIds.add(notice.getEntryId());
            this.entryId2voucherId.put(notice.getEntryId(), notice.getVoucherId());
        }
        for (AbstractNotice opNotice : opNotices) {
            this.allEntryIds.add(opNotice.getEntryId());
            this.opEntryId2opVoucherId.put(opNotice.getEntryId(), opNotice.getVoucherId());
        }
        this.isLocCurrency = isLocCurrency;
    }

    public Set<Long> getAllEntryIds() {
        return this.allEntryIds;
    }

    public final DynamicObject getLogDynObj(String logEntityName) {
        DynamicObject logDynObj = BusinessDataServiceHelper.newDynamicObject((String)logEntityName);
        DynamicObjectCollection logEntries = logDynObj.getDynamicObjectCollection("logentry");
        this.entryId2voucherId.forEach((key, value) -> {
            DynamicObject newRow = logEntries.addNew();
            newRow.set("vchentryid", key);
            newRow.set("voucherid", value);
        });
        DynamicObjectCollection opLogEntries = logDynObj.getDynamicObjectCollection("oplogentry");
        this.opEntryId2opVoucherId.forEach((key, value) -> {
            DynamicObject newRow = opLogEntries.addNew();
            newRow.set("opvchentryid", key);
            newRow.set("opvoucherid", value);
        });
        logDynObj.set("loccheck", (Object)this.isLocCurrency);
        return logDynObj;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoticeCheckLog that = (NoticeCheckLog)o;
        return Objects.equals(this.allEntryIds, that.allEntryIds);
    }

    public int hashCode() {
        return Objects.hash(this.allEntryIds);
    }

    public Map<Long, Long> getEntryId2voucherId() {
        return this.entryId2voucherId;
    }

    public Map<Long, Long> getOpEntryId2opVoucherId() {
        return this.opEntryId2opVoucherId;
    }
}

