/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.checkstatus.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.checkstatus.checkinfo.AbstractNotice;
import kd.fi.gl.checkstatus.checkinfo.NoticeCheckContext;
import kd.fi.gl.checkstatus.checkinfo.NoticeCheckLog;
import kd.fi.gl.checkstatus.unit.AbstractNoticeCheckLogicUnit;
import kd.fi.gl.notice.NoticeUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;

public abstract class AbstractNoticeCheckService {
    private static final Log LOGGER = LogFactory.getLog(AbstractNoticeCheckService.class);

    public List<DynamicObject> excute(DynamicObject[] allNotices, String checkType, long excuteOrgId) {
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            List<AbstractNotice> readyCheckDatas = this.convertToAbstractNoticeWithOutChecked(allNotices);
            if (readyCheckDatas.isEmpty()) {
                List<DynamicObject> list = Collections.emptyList();
                return list;
            }
            List<AbstractNoticeCheckLogicUnit> logicUnits = this.getLogicUnits(checkType);
            if (logicUnits.isEmpty()) {
                LOGGER.error(String.format(ResManager.loadKDString((String)"\u52fe\u7a3d\u65b9\u5f0f%s\u6ca1\u6709\u9700\u8981\u6267\u884c\u7684\u52fe\u7a3d\u903b\u8f91\u3002", (String)"AbstractNoticeCheckService_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), checkType));
                List<DynamicObject> list = Collections.emptyList();
                return list;
            }
            NoticeCheckContext noticeCheckContext = new NoticeCheckContext(readyCheckDatas, this.getMulCheckEnable(checkType), this.getEntityName(), checkType);
            noticeCheckContext.setLocalCurrencyCheckEnable(this.getInitLocCurrencyCheckEnable(excuteOrgId));
            this.excuteCheck(logicUnits, noticeCheckContext);
            this.updateData(noticeCheckContext);
            List<DynamicObject> list = Stream.of(allNotices).filter(x -> noticeCheckContext.getCompletedEntryIds().contains(x.getLong("voucherentry"))).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            try {
                handle.markRollback();
                LOGGER.error(ResManager.loadKDString((String)"\u672c\u6279\u6b21\u901a\u77e5\u5355\u52fe\u7a3d\u51fa\u9519/n", (String)"AbstractNoticeCheckService_2", (String)"fi-gl-opplugin", (Object[])new Object[0]) + GLUtil.printError((Throwable)e));
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void excuteCheck(List<AbstractNoticeCheckLogicUnit> logicUnits, NoticeCheckContext checkContext) {
        for (AbstractNoticeCheckLogicUnit logicUnit : logicUnits) {
            logicUnit.doAction(checkContext);
        }
    }

    private void updateData(NoticeCheckContext checkContext) {
        Set<NoticeCheckLog> checkLogs;
        block34: {
            Set<Long> completedEntryIds = checkContext.getCompletedEntryIds();
            if (completedEntryIds.isEmpty()) {
                return;
            }
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("voucherentry", "in", completedEntryIds);
            qfBuilder.add("checkstatus", "=", (Object)"1");
            HashSet<Long> checkedEntryIds = new HashSet<Long>(completedEntryIds.size());
            try (DataSet noticeDs = QueryServiceHelper.queryDataSet((String)AbstractNoticeCheckService.class.getName(), (String)checkContext.getEntityName(), (String)"voucherentry", (QFilter[])qfBuilder.toArray(), null).groupBy(new String[]{"voucherentry"}).finish();){
                for (Row row : noticeDs) {
                    checkedEntryIds.add(row.getLong("voucherentry"));
                }
            }
            checkLogs = checkContext.getCheckLogs();
            if (!checkedEntryIds.isEmpty()) {
                Iterator<NoticeCheckLog> iterator = checkLogs.iterator();
                while (iterator.hasNext()) {
                    NoticeCheckLog log2 = iterator.next();
                    Set<Long> allEntryIds = log2.getAllEntryIds();
                    if (!checkedEntryIds.removeAll(allEntryIds)) continue;
                    completedEntryIds.removeAll(allEntryIds);
                    iterator.remove();
                }
            }
            if (completedEntryIds.isEmpty()) {
                return;
            }
            String tableName = this.getEntityDbTableName();
            if ("t_gl_acnotice".equals(tableName)) {
                HashMap entryId2Des = new HashMap();
                ArrayList params = new ArrayList();
                String query = String.format("select fentryid,fdescription from t_gl_voucherentry where fentryid in (%s)", StringUtils.join((Object[])completedEntryIds.toArray(), (char)','));
                DB.query((DBRoute)new DBRoute("fi"), (String)query, null, resultSet -> {
                    while (resultSet.next()) {
                        entryId2Des.put(resultSet.getLong("fentryid"), resultSet.getString("fdescription"));
                    }
                    return null;
                });
                checkLogs.forEach(log -> {
                    ArrayList<Long> entryIds = new ArrayList<Long>(log.getEntryId2voucherId().keySet());
                    ArrayList<Long> opEntryIds = new ArrayList<Long>(log.getOpEntryId2opVoucherId().keySet());
                    String desc = entryIds.stream().map(entryId2Des::get).reduce((x, y) -> x + ";" + y).orElseThrow(() -> new IllegalStateException("fail to get desc"));
                    desc = NoticeUtils.getChineseStrLen((String)desc) > 666 ? desc.substring(0, 666) : desc;
                    String opDesc = opEntryIds.stream().map(entryId2Des::get).reduce((x, y) -> x + ";" + y).orElseThrow(() -> new IllegalStateException("fail to get desc"));
                    opDesc = NoticeUtils.getChineseStrLen((String)opDesc) > 666 ? opDesc.substring(0, 666) : opDesc;
                    params.add(new Object[]{"1", opDesc, entryIds});
                    params.add(new Object[]{"1", desc, opEntryIds});
                });
                try (TXHandle txHandle = TX.requiresNew();){
                    try {
                        params.forEach(param -> {
                            SqlBuilder sql = new SqlBuilder();
                            sql.append("update t_gl_acnotice set fcheckstatus=?, fpeerdesc=? where", new Object[]{param[0], param[1]}).appendIn("fvoucherentryid", (List)param[2]);
                            DB.execute((DBRoute)new DBRoute("fi"), (SqlBuilder)sql);
                        });
                        break block34;
                    }
                    catch (Exception e) {
                        txHandle.markRollback();
                        LOGGER.error(GLUtil.printError((Throwable)e));
                        throw e;
                    }
                }
            }
            if ("t_gl_cfnotice".equals(tableName)) {
                String sql = "update " + tableName + " set fcheckstatus = '" + "1" + "' where fvoucherentryid in (" + StringUtils.join((Object[])completedEntryIds.toArray(), (String)",") + ")";
                DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql);
            }
        }
        BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)checkContext.getEntityName()));
        String logEntityName = this.getLogEntityName();
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])checkLogs.stream().map(x -> x.getLogDynObj(logEntityName)).toArray(DynamicObject[]::new)));
    }

    protected abstract List<AbstractNotice> convertToAbstractNoticeWithOutChecked(DynamicObject[] var1);

    protected abstract List<AbstractNoticeCheckLogicUnit> getLogicUnits(String var1);

    protected abstract String getEntityDbTableName();

    protected abstract String getLogEntityName();

    protected abstract boolean getMulCheckEnable(String var1);

    protected abstract boolean getInitLocCurrencyCheckEnable(long var1);

    protected abstract String getEntityName();
}

