/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.operateservice;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.util.Tuple2;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.ext.fi.accountref.AccountVersionReplaceParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.VoucherEntryCollection;
import kd.fi.gl.common.VoucherEntryInfo;
import kd.fi.gl.common.VoucherInfo;
import kd.fi.gl.constant.Constant;
import kd.fi.gl.finalprocess.constant.EndingProcessConstant;
import kd.fi.gl.finalprocess.info.scheme.PropertyKey;
import kd.fi.gl.util.FinalProcessUtil;

public abstract class AbstractFinalProcessingOperateService
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(AbstractFinalProcessingOperateService.class);
    protected Long specifiedPeriodId = 0L;
    protected final Set<PropertyKey> propToPrepare = new HashSet<PropertyKey>(8);
    protected final HashMap<PropertyKey, List<PropertyKey>> newPropToPrepare = new HashMap(8);
    private DistributeSessionlessCache progressCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CacheKeyUtil.getAcctId() + ":" + "FPCreateVoucher");

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        long genstart = System.currentTimeMillis();
        String openedPeriod = this.operateOption.getVariableValue("openedperiod", "0");
        this.specifiedPeriodId = Long.parseLong(openedPeriod);
        logger.info(String.format("ending process begin for period %s", this.specifiedPeriodId));
        DynamicObject[] localDataEntities = this.loadFullDynamicObjects(args.getDataEntities());
        if (localDataEntities.length == 0) {
            return;
        }
        this.cacheSchemeProgressBegin(localDataEntities.length);
        int completeScheme = 0;
        HashMap<DynamicObject, List<VoucherInfo>> scheme2vouchers = new HashMap<DynamicObject, List<VoucherInfo>>(localDataEntities.length);
        for (DynamicObject schemeDyn : localDataEntities) {
            try {
                this.beforeGenVoucher(schemeDyn);
                List<VoucherInfo> voucherInfo = this.produceVoucher(schemeDyn);
                this.afterGenVoucher(schemeDyn, voucherInfo);
                scheme2vouchers.put(schemeDyn, voucherInfo);
                this.logVchGeneratedOnScheme(schemeDyn, voucherInfo);
            }
            catch (KDBizException e) {
                this.toOperateErrorInfo(schemeDyn, e.getMessage());
            }
            this.cacheSchemeProgressRuuning(++completeScheme);
        }
        this.cacheSchemeProgressEnd();
        Set errorPks = this.operationResult.getAllErrorInfo().stream().map(OperateInfo::getPkValue).collect(Collectors.toSet());
        scheme2vouchers.keySet().removeIf(x -> errorPks.contains(x.getPkValue()));
        ArrayList<DynamicObject> successDb = new ArrayList<DynamicObject>();
        try (TXHandle tx = TX.required();){
            try {
                HashMap<Long, OperationResult> operationResult = this.saveVoucher(scheme2vouchers, successDb);
                this.afterSaveVoucher(operationResult);
                this.addVchResultToOption(operationResult);
            }
            catch (Exception e) {
                logger.error("createvoucher: voucher saving failure", (Object)e.getMessage(), (Object)e);
                args.setDataEntities(new DynamicObject[0]);
                for (DynamicObject dataEntity : localDataEntities) {
                    this.toOperateErrorInfo(dataEntity, e.getMessage());
                }
                tx.markRollback();
                throw e;
            }
        }
        args.setDataEntities(successDb.toArray(new DynamicObject[0]));
        long genEnd = System.currentTimeMillis();
        logger.info("[trans_pl_huge_rows][gen_voucher_cost]\u751f\u6210\u51ed\u8bc1\u8017\u65f6: {} ms", (Object)(genEnd - genstart));
    }

    protected void cacheSchemeProgressBegin(int totalScheme) {
    }

    protected void cacheSchemeProgressRuuning(int completeScheme) {
    }

    protected void cacheSchemeProgressEnd() {
    }

    protected void setProgressCache(String key, String value) {
        this.progressCache.put(key, (Object)value);
    }

    protected String getProgressCache(String key) {
        return (String)this.progressCache.get(key);
    }

    protected void deleteDirtyEntryRows() {
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        this.deleteDirtyEntryRows();
    }

    private void afterGenVoucher(DynamicObject schemeDyn, List<VoucherInfo> voucherInfo) {
        if (voucherInfo != null && voucherInfo.size() != 0) {
            ArrayList<Long> accountIds = new ArrayList<Long>(voucherInfo.size() * 2);
            for (VoucherInfo voucher : voucherInfo) {
                for (VoucherEntryInfo entry : voucher.getEntries()) {
                    accountIds.add(entry.getAccount());
                }
            }
            Map<Long, DynamicObject> accountMap = this.getAccountMap(accountIds);
            for (VoucherInfo info : voucherInfo) {
                this.setExpireDate(info, accountMap);
                info.loadRefence();
            }
        }
    }

    protected Map<Long, DynamicObject> getAccountMap(List<Long> accountIds) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(accountIds.size());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)"id,masterid,number,accounttable,enddate,startdate", (QFilter[])new QFilter("id", "in", accountIds).toArray());
        for (Map.Entry entry : map.entrySet()) {
            result.put(Long.parseLong(entry.getKey().toString()), (DynamicObject)entry.getValue());
        }
        return result;
    }

    private void beforeGenVoucher(DynamicObject schemeDyn) {
        this.initField(schemeDyn);
    }

    private void logVchGeneratedOnScheme(DynamicObject schemeDyn, List<VoucherInfo> voucherInfos) {
        if (voucherInfos == null) {
            return;
        }
        if (!DebugTrace.enable()) {
            return;
        }
        BillEntityType entityType = (BillEntityType)MetadataServiceHelper.getDataEntityType((String)this.getEndingProcessType());
        String numProp = entityType.getBillNo();
        long logStart = System.currentTimeMillis();
        voucherInfos.forEach(voucher -> {
            if (DebugTrace.enable()) {
                logger.info(String.format("scheme \"%s\" will generate the voucher before save:\n" + voucher.toString(), schemeDyn.get(numProp)));
            }
        });
        long logEnd = System.currentTimeMillis();
        logger.info("[trans_pl_huge_rows][log_voucher_time]\u51ed\u8bc1\u65e5\u5fd7\u6253\u5370\u8017\u65f6: {} ms", (Object)(logEnd - logStart));
    }

    private void addVchResultToOption(HashMap<Long, OperationResult> operationResult) {
        Map<Long, List> scheme2vouchers = operationResult.entrySet().stream().filter(x -> x.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, x -> new ArrayList(((OperationResult)x.getValue()).getSuccessPkIds())));
        this.getOption().setVariableValue("finialProcessResult", SerializationUtils.serializeToBase64(scheme2vouchers));
        List<Object> allVoucherIds = new LinkedList();
        for (List vouchers : scheme2vouchers.values()) {
            allVoucherIds.addAll(vouchers);
        }
        if (!allVoucherIds.isEmpty()) {
            allVoucherIds = allVoucherIds.stream().distinct().collect(Collectors.toList());
            this.getOption().setVariableValue("FinalProcessingVouchers", SerializationUtils.serializeToBase64(allVoucherIds));
        }
    }

    protected DynamicObject getAccountOnCurPeriod(DynamicObject accountDyo, long orgID, long bookTypeID, DynamicObject periodDyo) {
        String accountNumber = accountDyo.getString("number");
        try {
            return AccountRefUtils.getCurVersionAccount((AccountVersionReplaceParam)new AccountVersionReplaceParam(orgID, accountDyo.getLong("masterid"), 0L, 0L, accountNumber, periodDyo, bookTypeID, accountDyo, 0L));
        }
        catch (KDBizException e) {
            String locate = (String)ThreadCache.get((Object)accountDyo.getLong("id"));
            if (e.getErrorCode().getCode().equals("acct")) {
                throw new KDBizException(ResManager.loadKDString((String)"%1$s\u79d1\u76ee%2$s%3$s\uff0c\u8bf7\u5728\u65b9\u6848\u4e2d\u91cd\u65b0\u9009\u62e9\u4e00\u4e0b\u79d1\u76ee\u3002", (String)"AbstractFinalProcessingOperateService_4", (String)"fi-gl-opplugin", (Object[])new Object[]{Strings.nullToEmpty((String)locate), accountNumber, e.getMessage()}));
            }
            throw e;
        }
    }

    protected void setExpireDate(VoucherInfo voucherInfo, Map<Long, DynamicObject> accountMap) {
        DynamicObject accountPeriodDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)voucherInfo.getPeriod(), (String)"bd_period");
        long orgID = voucherInfo.getOrg();
        long bookTypeID = voucherInfo.getBookType();
        QFilter acCheckF = new QFilter("accheck", "=", (Object)true);
        Long acctTableID = AccountRefUtils.getCurPeriodAccountTableId((long)orgID, (long)bookTypeID, (long)((Long)accountPeriodDyo.getPkValue()));
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(acCheckF);
        Set allACAccountIDs = AccountUtils.queryAccountIds((long)orgID, (long)acctTableID, filters);
        StringBuilder errorMsg = new StringBuilder();
        for (VoucherEntryInfo entry : voucherInfo.getEntries()) {
            Long accountId = entry.getAccount();
            try {
                DynamicObject accountDyo = accountMap.get(accountId);
                if (!allACAccountIDs.contains(accountDyo.getLong("id"))) continue;
                entry.setExpireDate(accountPeriodDyo.getDate("enddate"));
            }
            catch (KDBizException e) {
                errorMsg.append(e.getMessage());
            }
        }
        if (errorMsg.toString().contains(";")) {
            throw new KDBizException(errorMsg.toString());
        }
    }

    public void afterSaveVoucher(HashMap<Long, OperationResult> operationResult) {
    }

    private DynamicObject[] loadFullDynamicObjects(DynamicObject[] dataEntities) {
        List pks = Stream.of(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter pkFilter = new QFilter("id", "in", pks);
        String entityName = this.billEntityType.getName();
        return BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])pkFilter.toArray()).values().toArray(new DynamicObject[0]);
    }

    private void toOperateErrorInfo(Long id, String msg) {
        OperateErrorInfo oei = new OperateErrorInfo();
        oei.setMessage(msg);
        oei.setPkValue((Object)id);
        oei.setErrorLevel(ErrorLevel.Error.name());
        oei.setErrorCode("not_format");
        this.getOperationResult().setSuccess(false);
        this.getOperationResult().addErrorInfo(oei);
    }

    protected void toOperateErrorInfo(DynamicObject dataEntity, String msg) {
        String[] details = msg.split(";");
        OperationResult operationResult = this.getOperationResult();
        for (String detail : details) {
            OperateErrorInfo oei = new OperateErrorInfo();
            oei.setMessage(FinalProcessUtil.formatMessage((DynamicObject)dataEntity, (String)detail));
            oei.setPkValue(dataEntity.getPkValue());
            oei.setErrorLevel(ErrorLevel.Error.name());
            operationResult.addErrorInfo(oei);
        }
        operationResult.setMessage("");
        operationResult.setSuccess(false);
    }

    private List<VoucherInfo> produceVoucher(DynamicObject dataEntity) {
        return this.constructVoucher();
    }

    public abstract void initField(DynamicObject var1);

    public abstract List<VoucherInfo> constructVoucher();

    public DataSet getBalance(AccountBookInfo accountBookInfo, String selectField, QueryParam op, Date date) {
        long orgId = accountBookInfo.getOrgId();
        long bookStypeId = accountBookInfo.getBookTypeId();
        long periodID = accountBookInfo.getCurPeriodId(this.specifiedPeriodId.longValue());
        long accountTableID = AccSysUtil.getCurPeriodAccountTableId((long)orgId, (long)bookStypeId, (long)periodID);
        op.setZeroBalNoDisplay(true);
        op.setOnlyLeafAcctBal(true);
        return BalanceQueryExecutor.getInstance().getBalance(selectField, new Long[]{orgId}, bookStypeId, accountTableID, periodID, periodID, op);
    }

    public String getAccountDirection(DynamicObject account) {
        return null;
    }

    public DynamicObject getExchangeRate() {
        return null;
    }

    public void saveVoucherValidator(Map<DynamicObject, List<VoucherInfo>> voucherInfos) {
        Map<DynamicObject, List> emptyResult = voucherInfos.entrySet().stream().filter(x -> x.getValue() == null || ((List)x.getValue()).isEmpty() || ((List)x.getValue()).get(0) == null).collect(Collectors.toMap(x -> (DynamicObject)x.getKey(), x -> (List)x.getValue()));
        emptyResult.forEach((k, v) -> {
            this.toOperateErrorInfo((DynamicObject)k, ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"AbstractFinalProcessingOperateService_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            voucherInfos.remove(k);
        });
    }

    public HashMap<Long, OperationResult> saveVoucher(Map<DynamicObject, List<VoucherInfo>> voucherInfos, List<DynamicObject> successDyns) {
        HashMap<Long, OperationResult> resultHashMap = new HashMap<Long, OperationResult>();
        if (voucherInfos == null || voucherInfos.isEmpty()) {
            return resultHashMap;
        }
        this.saveVoucherValidator(voucherInfos);
        if (this.getOption().containsVariable("MergeVoucherEntries")) {
            List<Tuple2<List<DynamicObject>, VoucherInfo>> mergeVoucherEntriesByHead = this.mergeVoucherEntriesByHead(voucherInfos);
            mergeVoucherEntriesByHead.forEach(v -> {
                DynamicObject dyn;
                String billNo;
                List<Long> pks = ((List)v.t1).stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                List<Object> vs = Collections.singletonList(v.t2);
                OperationResult operationResult = this.saveVoucherSingle(vs, billNo = this.getBillNoByType(dyn = (DynamicObject)((List)v.t1).get(0)), true, pks.toArray(new Long[0]));
                if (operationResult.isSuccess() && !operationResult.getSuccessPkIds().isEmpty()) {
                    successDyns.addAll((Collection)v.t1);
                }
                for (Long pk : pks) {
                    resultHashMap.put(pk, operationResult);
                }
            });
        } else {
            voucherInfos.forEach((k, v) -> {
                Long pkValue = (Long)k.getPkValue();
                String billNo = this.getBillNoByType((DynamicObject)k);
                OperationResult operationResult = this.saveVoucherSingle((List<VoucherInfo>)v, billNo, false, pkValue);
                this.getOperationResult().getAllErrorInfo().stream().filter(operateErrorInfo -> StringUtils.isNotEmpty((CharSequence)operateErrorInfo.getErrorCode()) && "not_format".equals(operateErrorInfo.getErrorCode())).forEach(errorInfo -> {
                    errorInfo.setMessage(FinalProcessUtil.formatMessage((DynamicObject)k, (String)errorInfo.getMessage()));
                    errorInfo.setErrorCode("");
                });
                if (operationResult.isSuccess() && !operationResult.getSuccessPkIds().isEmpty()) {
                    successDyns.add((DynamicObject)k);
                }
                resultHashMap.put(pkValue, operationResult);
            });
        }
        return resultHashMap;
    }

    private String getBillNoByType(DynamicObject dyn) {
        return dyn.getString(((BillEntityType)dyn.getDataEntityType()).getBillNo());
    }

    private List<Tuple2<List<DynamicObject>, VoucherInfo>> mergeVoucherEntriesByHead(Map<DynamicObject, List<VoucherInfo>> voucherInfos) {
        Map<String, List<Map.Entry>> collect = voucherInfos.entrySet().stream().filter(x -> x.getValue() != null && !((List)x.getValue()).isEmpty() && ((List)x.getValue()).get(0) != null).collect(Collectors.groupingBy(x -> ((VoucherInfo)((List)x.getValue()).get(0)).getGruopKey()));
        ArrayList<Tuple2<List<DynamicObject>, VoucherInfo>> result = new ArrayList<Tuple2<List<DynamicObject>, VoucherInfo>>(collect.size());
        for (List<Map.Entry> group : collect.values()) {
            List schemeDyns = group.stream().map(x -> (DynamicObject)x.getKey()).collect(Collectors.toList());
            List mergeVoucherInfos = null;
            for (Map.Entry entry : group) {
                if (mergeVoucherInfos == null) {
                    mergeVoucherInfos = (List)entry.getValue();
                    continue;
                }
                mergeVoucherInfos.addAll((Collection)entry.getValue());
            }
            if (mergeVoucherInfos == null) continue;
            VoucherInfo mergeVoucherInfo = this.mergeVoucherEntries(mergeVoucherInfos);
            if (mergeVoucherInfo.getSourceType().equals("1")) {
                VoucherEntryCollection entries = mergeVoucherInfo.getEntries();
                entries.sort(Comparator.comparing(VoucherEntryInfo::getAccNumber));
                int i = 1;
                for (VoucherEntryInfo voucherEntryInfo : entries) {
                    voucherEntryInfo.setSeq(i++);
                }
            }
            result.add((Tuple2<List<DynamicObject>, VoucherInfo>)new Tuple2(schemeDyns, (Object)mergeVoucherInfo));
        }
        return result;
    }

    private VoucherInfo mergeVoucherEntries(List<VoucherInfo> mergeVoucherInfos) {
        VoucherInfo voucherInfo = mergeVoucherInfos.get(0);
        for (int i = 1; i < mergeVoucherInfos.size(); ++i) {
            VoucherInfo tempVoucherInfo = mergeVoucherInfos.get(i);
            voucherInfo.addEntries(tempVoucherInfo.getEntries());
        }
        DynamicObjectCollection dyns = voucherInfo.toDynamicObject().getDynamicObjectCollection("entries");
        int i = 1;
        for (DynamicObject dyn : dyns) {
            dyn.set("seq", (Object)i++);
        }
        return voucherInfo;
    }

    private OperationResult saveVoucherSingle(List<VoucherInfo> voucherInfos, String billNo, boolean isMergeVoucher, Long ... ids) {
        ArrayList<DynamicObject> toSaveVoucherDyns = new ArrayList<DynamicObject>(1);
        ArrayList<Object> toSaveVoucherIds = new ArrayList<Object>(1);
        ArrayList<VoucherInfo> dbVoucherInfos = new ArrayList<VoucherInfo>(1);
        if (voucherInfos == null) {
            for (Long id : ids) {
                this.toOperateErrorInfo(id, ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"AbstractFinalProcessingOperateService_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            }
            return this.getOperationResult();
        }
        int size = voucherInfos.size();
        for (int i = 0; i < size; ++i) {
            VoucherInfo vo = voucherInfos.get(i);
            if (vo == null || vo.getEntries().size() == 0) {
                if (isMergeVoucher) {
                    this.toOperateErrorInfo(ids[0], ResManager.loadKDString((String)"\u5408\u5e76\u751f\u6210\u51ed\u8bc1\u7684\u79d1\u76ee\u91d1\u989d\u4e3a0\uff0c\u4e0d\u9700\u8981\u751f\u6210\u51ed\u8bc1\u3002", (String)"AbstractFinalProcessingOperateService_2", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (!vo.isBigEntryMode()) {
                    for (Long l : ids) {
                        this.toOperateErrorInfo(l, ResManager.loadKDString((String)"\u79d1\u76ee\u91d1\u989d\u4e3a0\uff0c\u4e0d\u9700\u8981\u751f\u6210\u51ed\u8bc1\u3002", (String)"AbstractFinalProcessingOperateService_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                    }
                    continue;
                }
            }
            if (vo.isBigEntryMode()) {
                vo.appendSave();
                toSaveVoucherIds.add(vo.getPK());
            } else {
                toSaveVoucherDyns.add(vo.toDynamicObject());
            }
            dbVoucherInfos.add(vo);
        }
        OperationResult allOperationResult = OperationServiceHelper.executeOperate((String)"save", (String)"gl_voucher", (DynamicObject[])toSaveVoucherDyns.toArray(new DynamicObject[0]), null);
        if (!toSaveVoucherIds.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("sysvoucher", Boolean.TRUE.toString());
            option.setVariableValue("isFirstOperation", Boolean.TRUE.toString());
            OperationResult idOperationResult = OperationServiceHelper.executeOperate((String)"save", (String)"gl_voucher", (Object[])toSaveVoucherIds.toArray(), (OperateOption)option);
            allOperationResult.mergeOperateResult(idOperationResult);
            for (Object e : toSaveVoucherIds) {
                if (idOperationResult.getSuccessPkIds().contains(e)) continue;
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"gl_voucher"), (Object[])new Object[]{e});
                dbVoucherInfos.removeIf(voucherInfo -> Objects.equals(voucherInfo.getPK(), voucherId));
            }
        }
        long updSeqStart = System.currentTimeMillis();
        this.updateSeq(dbVoucherInfos);
        long updSeqEnd = System.currentTimeMillis();
        logger.info("[trans_pl_huge_rows][updfseq_time]\u66f4\u65b0\u5206\u5f55seq\u671f\u95f4\u8017\u65f6: {} ms", (Object)(updSeqEnd - updSeqStart));
        for (Long id : ids) {
            this.saveAdjustRateLog(id, voucherInfos, allOperationResult);
            this.saveVoucherRelations(id, voucherInfos, allOperationResult);
        }
        if (!allOperationResult.isSuccess()) {
            ValidateResultCollection validateResultCollection = allOperationResult.getValidateResult();
            for (ValidateResult err : validateResultCollection.getValidateErrors()) {
                List errorInfos = err.getAllErrorInfo();
                for (IOperateInfo r : errorInfos) {
                    OperateErrorInfo infos = (OperateErrorInfo)r;
                    for (Long id : ids) {
                        this.toOperateErrorInfo(id, infos.getMessage());
                    }
                }
            }
            for (Long id : ids) {
                this.toOperateErrorInfo(id, allOperationResult.getMessage());
            }
        }
        return allOperationResult;
    }

    protected void updateSeq(List<VoucherInfo> dbVoucherInfos) {
    }

    public void saveAdjustRateLog(long dataEntityid, List<VoucherInfo> voucherInfos, OperationResult operationResult) {
        if (operationResult == null || operationResult.getSuccessPkIds().size() == 0) {
            return;
        }
        VoucherInfo info = voucherInfos.get(0);
        if (info.getSourceType().equals("2")) {
            Map<Long, List<DynamicObject>> map = this.getAdjustRateLogMap();
            ArrayList<DynamicObject> newAdjustRateDyns = new ArrayList<DynamicObject>();
            if (map.get(dataEntityid) != null) {
                List<DynamicObject> adjustRateDyns = map.get(dataEntityid);
                for (Object pkValue : operationResult.getSuccessPkIds()) {
                    for (DynamicObject adjustRateDyn : adjustRateDyns) {
                        DynamicObject newAdjustRateDyn = this.copyAdjustRateLog(adjustRateDyn);
                        newAdjustRateDyn.set("voucherid", pkValue);
                        newAdjustRateDyns.add(newAdjustRateDyn);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])newAdjustRateDyns.toArray(new DynamicObject[0]));
            }
        }
    }

    public DynamicObject copyAdjustRateLog(DynamicObject adjustRateLog) {
        if (adjustRateLog == null) {
            return null;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"gl_adjustratelog");
        DynamicObject adjustRateLogDyn = new DynamicObject((DynamicObjectType)type);
        adjustRateLogDyn.set("account_id", (Object)adjustRateLog.getLong("account_id"));
        adjustRateLogDyn.set("assgrp_id", (Object)adjustRateLog.getLong("assgrp_id"));
        adjustRateLogDyn.set("currency_id", (Object)adjustRateLog.getLong("currency_id"));
        adjustRateLogDyn.set("measureunit_id", (Object)adjustRateLog.getLong("measureunit_id"));
        adjustRateLogDyn.set("endfor", (Object)adjustRateLog.getBigDecimal("endfor"));
        adjustRateLogDyn.set("endlocal", (Object)adjustRateLog.getBigDecimal("endlocal"));
        return adjustRateLogDyn;
    }

    public Map<Long, List<DynamicObject>> getAdjustRateLogMap() {
        return new HashMap<Long, List<DynamicObject>>();
    }

    public void saveVoucherRelations(Long id, List<VoucherInfo> voucherInfos, OperationResult operationResult) {
        if (operationResult == null || operationResult.getSuccessPkIds().size() == 0) {
            return;
        }
        VoucherInfo info = voucherInfos.get(0);
        ArrayList<DynamicObject> relations = new ArrayList<DynamicObject>(operationResult.getSuccessPkIds().size());
        for (Object pkValue : operationResult.getSuccessPkIds()) {
            DynamicObject voucherrelation = BusinessDataServiceHelper.newDynamicObject((String)"gl_voucherrelation");
            voucherrelation.set("targentity", pkValue);
            voucherrelation.set("srcentity", (Object)id);
            if (info.getSourceType().equals("1")) {
                voucherrelation.set("type", (Object)"3");
            } else if (info.getSourceType().equals("2")) {
                voucherrelation.set("type", (Object)"4");
            } else {
                voucherrelation.set("type", (Object)"4");
            }
            voucherrelation.set("iseffective", (Object)"1");
            voucherrelation.set("period", (Object)info.getPeriod());
            relations.add(voucherrelation);
        }
        SaveServiceHelper.save((DynamicObject[])relations.toArray(new DynamicObject[0]));
    }

    public List<VoucherInfo> preSaveVoucher(List<VoucherInfo> voucherInfos, VoucherInfo vch) {
        this.isVchEmpty(vch, voucherInfos);
        return voucherInfos;
    }

    private void isVchEmpty(VoucherInfo debVch, List<VoucherInfo> voucherInfos) {
        if (!debVch.getEntries().isEmpty()) {
            voucherInfos.add(debVch);
        }
    }

    public void sortVoucherInfo(VoucherInfo vch) {
        this.sortVoucherEntryInfo(vch);
    }

    private void sortVoucherEntryInfo(VoucherInfo vch) {
        VoucherEntryCollection vchEntry = vch.getEntries();
        if (vchEntry.isEmpty()) {
            return;
        }
        ArrayList veList = new ArrayList(vchEntry);
        vchEntry.clear();
        vchEntry.addAll(veList);
    }

    protected HashSet<Long> getLeafAcct(Set<Long> ids) {
        QFilter fparent = new QFilter("id", "in", ids);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_accountview", (String)"id,parent,level,isleaf", (QFilter[])fparent.toArray());
        HashSet<Long> leafIds = new HashSet<Long>();
        if (col != null) {
            for (DynamicObject obj : col) {
                long acctId = obj.getLong("id");
                if (!obj.getBoolean("isleaf")) continue;
                leafIds.add(acctId);
            }
        }
        return leafIds;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        this.initPropsToPrepare();
        List noneEntryProp = this.newPropToPrepare.getOrDefault(null, new LinkedList());
        noneEntryProp.addAll(this.propToPrepare);
        this.newPropToPrepare.put(null, noneEntryProp);
        List res = e.getFieldKeys();
        String endingProcessType = this.getEndingProcessType();
        this.newPropToPrepare.forEach((entryProp, specifiedPropList) -> {
            if (entryProp == null) {
                entryProp = new PropertyKey(endingProcessType, "", "");
            }
            for (PropertyKey prop : specifiedPropList) {
                res.add(Constant.getSpecifiedKeyToPrepare((PropertyKey)entryProp, (PropertyKey)prop));
            }
        });
    }

    public void initPropsToPrepare() {
        this.propToPrepare.add(EndingProcessConstant.Entity_AccountBookType);
        this.propToPrepare.add(EndingProcessConstant.Entity_VoucherType);
    }

    public void putPropsToPrepare(PropertyKey entryProp, PropertyKey ... specifiedProps) {
        Arrays.stream(specifiedProps).forEach(specifiedProp -> {
            List propList = this.newPropToPrepare.getOrDefault(entryProp, new LinkedList());
            propList.add(specifiedProp);
            this.newPropToPrepare.put(entryProp, propList);
        });
    }

    public void putPropsToPrepare(PropertyKey entryProp, List<PropertyKey> specifiedPropList) {
        List propList = this.newPropToPrepare.getOrDefault(entryProp, new LinkedList());
        propList.addAll(specifiedPropList);
        this.newPropToPrepare.put(entryProp, propList);
    }

    public abstract String getEndingProcessType();
}

