/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.operateservice;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.rate.ExchangeRate;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.rate.RateType;
import kd.fi.bd.service.balance.AppHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.autotrans.FinalProcessAssgrp;
import kd.fi.gl.common.VoucherEntryInfo;
import kd.fi.gl.common.VoucherInfo;
import kd.fi.gl.enums.AmortStyle;
import kd.fi.gl.enums.PlanType;
import kd.fi.gl.enums.VoucherRelationTypeEnum;
import kd.fi.gl.finalprocess.constant.VchAmortConstant;
import kd.fi.gl.finalprocess.info.scheme.VchAmortScheme;
import kd.fi.gl.finalprocessing.amort.dest.DestEntryGeneratorFactory;
import kd.fi.gl.finalprocessing.amort.plantype.TargetEntryGeneratorFactory;
import kd.fi.gl.finalprocessing.info.AmortGenVchInfo;
import kd.fi.gl.finalprocessing.operateservice.AbstractFinalProcessingOperateService;
import kd.fi.gl.finalprocessing.validate.AmortGenVchValidator;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.VoucherAmortSchemeUtils;
import kd.sdk.fi.gl.extpoint.amort.IAmountAllocate;

public class AmortGenVchOperateService
extends AbstractFinalProcessingOperateService {
    private static final String entityName = "gl_voucheramortacheme";
    private static final String policies = "policies";
    private AmortGenVchInfo amortInfo;
    private VchAmortScheme vchAmortScheme;
    private static final String PERIODAMORTAMOUNT = "periodamortamount";
    private static final String TARGETENTRY = "targetaccounts";
    private static final String TARGETCURRENCY = "targetcurrency";
    private static final String TARGETAMOUNT = "planamount";
    private static final String TARGETASSGRP = "targetassgrp";
    private static final String TARGETLOCAL = "targetlocal";
    private static final String TARGETROWID = "targetrowid";
    private static final String DESTENTRY = "destaccounts";
    private static final String DESTCURRENCY = "destcurrency";
    private static final String DESTAMOUNT = "destamount";
    private static final String DESTLOCAL = "destlocal";
    private static final String DESTROWID = "destrowid";
    private static final String DESTASSGRP = "destassgrp";
    private static final String TOTALAMOUNT = "totalamount";
    private static final String PLANDIRECTION = "plandirection";
    private static final String DESTDIRECTION = "destdirection";
    private static final String PLANTYPE = "plantype";
    private static final String amortAssgrpEntityName = "gl_finalprocess_assgrp";
    private Map<String, Set<Long>> rowToHgMap;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new AmortGenVchValidator("org", "accountbooks"));
    }

    @Override
    public void initField(DynamicObject dataEntity) {
        this.operateOption.setVariableValue("inittable", Boolean.TRUE.toString());
        this.amortInfo = new AmortGenVchInfo(dataEntity, this.operateOption);
        String openedPeriod = this.operateOption.getVariableValue("openedperiod", "0");
        Long openedPeriodId = Long.valueOf(openedPeriod);
        this.vchAmortScheme = new VchAmortScheme(dataEntity, openedPeriodId);
    }

    @Override
    public List<VoucherInfo> constructVoucher() {
        VoucherInfo voucherInfo = this.amortInfo.getVoucherInfo();
        this.constructVoucherHead(voucherInfo);
        this.constructVoucherEntries(voucherInfo);
        this.fireAmountAllocate(voucherInfo);
        return Stream.of(voucherInfo).collect(Collectors.toList());
    }

    private void constructVoucherHead(VoucherInfo voucherInfo) {
        AccountBookInfo accountBookInfo = this.amortInfo.getAccountBookInfo();
        voucherInfo.setDesc(this.amortInfo.getVoucherDesc());
        voucherInfo.setPeriod(this.amortInfo.getCurPeriodId());
        voucherInfo.setCreator(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        voucherInfo.setAttachMent(this.amortInfo.getDataEntity().getInt("attachments"));
        voucherInfo.setStatus("A");
        voucherInfo.setSourceSys(AppHelper.getAppIdByFormId((String)"gl_voucher"));
        voucherInfo.setBookType(Long.valueOf(accountBookInfo.getBookTypeId()));
        voucherInfo.setVoucherType(Long.valueOf(this.amortInfo.getVoucherTypeId()));
        voucherInfo.setSourceType("5");
        voucherInfo.setOrg(Long.valueOf(accountBookInfo.getOrgId()));
        QFilter periodf = new QFilter("id", "=", (Object)this.amortInfo.getCurPeriodId());
        DynamicObject curPeriod = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFilter[]{periodf});
        Date newDate = new Date();
        Date beginDate = curPeriod.getDate("begindate");
        Date endDate = curPeriod.getDate("enddate");
        Date voucherDate = null;
        voucherDate = newDate.after(beginDate) && newDate.before(endDate) ? newDate : endDate;
        voucherInfo.setBizDate(voucherDate);
        voucherInfo.setBookedDate(voucherDate);
        voucherInfo.loadRefence();
    }

    private void constructVoucherEntries(VoucherInfo voucherInfo) {
        DynamicObject scheme = this.amortInfo.getDataEntity();
        if (VoucherAmortSchemeUtils.isNewVersion((DynamicObject)scheme, (VoucherAmortSchemeUtils.Action)VoucherAmortSchemeUtils.Action.GenVch)) {
            scheme.getDynamicObjectCollection(TARGETENTRY).forEach(targetRow -> this.createEntriesForSingleTargetRow(voucherInfo, (DynamicObject)targetRow));
            scheme.getDynamicObjectCollection(DESTENTRY).forEach(destRow -> this.createEntriesForSingleDestRow(voucherInfo, (DynamicObject)destRow));
        } else {
            this.genVoucher();
        }
    }

    private void createEntriesForSingleTargetRow(VoucherInfo voucherInfo, DynamicObject targetRow) {
        PlanType planType = PlanType.getType((String)targetRow.getString(PLANTYPE));
        TargetEntryGeneratorFactory.get((PlanType)planType).build(new HashMap(ImmutableMap.of((Object)"amortInfo", (Object)this.amortInfo, (Object)"targetRow", (Object)targetRow))).generateEntry(voucherInfo);
    }

    private void createEntriesForSingleDestRow(VoucherInfo voucherInfo, DynamicObject destRow) {
        DestEntryGeneratorFactory.get().build(new HashMap(ImmutableMap.of((Object)"amortInfo", (Object)this.amortInfo, (Object)"destRow", (Object)destRow))).generateEntry(voucherInfo);
    }

    @Override
    public void afterSaveVoucher(HashMap<Long, OperationResult> opResult) {
        if (opResult == null) {
            return;
        }
        HashSet<Long> schemeIds = new HashSet<Long>();
        schemeIds.addAll(opResult.keySet());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject[] schemeDyns = BusinessDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)entityType);
        ArrayList<DynamicObject> relationDyn = new ArrayList<DynamicObject>();
        BigDecimal hundred = new BigDecimal("100");
        for (DynamicObject schemeInfo : schemeDyns) {
            long schemeid = schemeInfo.getLong("id");
            OperationResult result = opResult.get(schemeid);
            List ids = result.getSuccessPkIds();
            QFilter fids = new QFilter("id", "in", (Object)ids);
            DynamicObjectCollection voucherDyns = QueryServiceHelper.query((String)"gl_voucher", (String)"id,period", (QFilter[])new QFilter[]{fids});
            if (voucherDyns.size() == 0) continue;
            for (DynamicObject voucherDyn : voucherDyns) {
                DynamicObject amortschemevoucherref = BusinessDataServiceHelper.newDynamicObject((String)"gl_voucherrelation");
                amortschemevoucherref.set("type", (Object)"5");
                amortschemevoucherref.set("iseffective", (Object)1);
                amortschemevoucherref.set("targentity", voucherDyn.get("id"));
                amortschemevoucherref.set("srcentity", schemeInfo.get("id"));
                amortschemevoucherref.set("period", voucherDyn.get("period"));
                relationDyn.add(amortschemevoucherref);
            }
            long voucherPeriodId = ((DynamicObject)voucherDyns.get(0)).getLong("period");
            DynamicObject newRow = schemeInfo.getDynamicObjectCollection(policies).addNew();
            BigDecimal periodAmortVal = this.getCurAmortAmount(schemeInfo);
            DynamicObject currency = schemeInfo.getDynamicObject("currency");
            if (currency != null) {
                periodAmortVal = periodAmortVal.setScale(currency.getInt("amtprecision"), 4);
            }
            BigDecimal totalamount = schemeInfo.getBigDecimal(TOTALAMOUNT);
            BigDecimal amortAmountVal = schemeInfo.getBigDecimal("amortamount");
            BigDecimal bigDecimal = amortAmountVal = amortAmountVal == null ? periodAmortVal : amortAmountVal.add(periodAmortVal);
            if (totalamount.compareTo(amortAmountVal) == 0) {
                schemeInfo.set("status", (Object)"3");
            } else {
                schemeInfo.set("status", (Object)"2");
            }
            schemeInfo.set("amortamount", (Object)amortAmountVal);
            BigDecimal curAmortPeriod = this.getCurAmortPeriod(schemeInfo);
            BigDecimal planperiodCount = schemeInfo.getBigDecimal("planperiod");
            schemeInfo.set("planperiod", (Object)planperiodCount.subtract(curAmortPeriod));
            BigDecimal amortperiodCount = schemeInfo.getBigDecimal("amortperiod");
            schemeInfo.set("amortperiod", (Object)amortperiodCount.add(curAmortPeriod));
            newRow.set("period", (Object)voucherPeriodId);
            newRow.set("policiesratio", (Object)periodAmortVal.multiply(hundred).divide(totalamount, 2, RoundingMode.HALF_UP));
            newRow.set("amount", (Object)periodAmortVal);
            newRow.set("curamortperiod", (Object)curAmortPeriod);
            if (!VoucherAmortSchemeUtils.isNewVersion((DynamicObject)schemeInfo, (VoucherAmortSchemeUtils.Action)VoucherAmortSchemeUtils.Action.GenVch)) continue;
            newRow.set("perioddetail", (Object)VoucherAmortSchemeUtils.getPeriodDetail((DynamicObject)schemeInfo));
        }
        SaveServiceHelper.save((DynamicObject[])schemeDyns);
        SaveServiceHelper.save((DynamicObject[])relationDyn.toArray(new DynamicObject[0]));
    }

    private BigDecimal getCurAmortPeriod(DynamicObject scheme) {
        String amortStyle = scheme.getString("amortstyle");
        BigDecimal curAmortperiod = BigDecimal.ONE;
        if (AmortStyle.DATE.getValue().equals(amortStyle)) {
            Long orgId = scheme.getLong("org.id");
            Long bookTypeId = scheme.getLong("accountbooks.id");
            Date dateBegin = scheme.getDate("begindate");
            Date dateEnd = scheme.getDate("enddate");
            curAmortperiod = VoucherAmortSchemeUtils.queryCurPeriodAmortPeriod((Long)orgId, (Long)bookTypeId, (Date)dateBegin, (Date)dateEnd, (BigDecimal)scheme.getBigDecimal("planperiod"), (Long)this.amortInfo.getCurPeriodId());
        }
        return curAmortperiod;
    }

    private BigDecimal getCurAmortAmount(DynamicObject scheme) {
        String amortStyle = scheme.getString("amortstyle");
        BigDecimal periodAmortAmountVal = scheme.getBigDecimal(PERIODAMORTAMOUNT);
        if (AmortStyle.isCustome((String)amortStyle)) {
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)scheme.getLong("org_id"), (long)scheme.getLong("accountbooks_id"));
            Optional<DynamicObject> first = scheme.getDynamicObjectCollection("custompolicies").stream().filter(v -> v.getLong("cperiod_id") == bookInfo.getCurPeriodId()).findFirst();
            if (!first.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u644a\u9500\u671f\u95f4\u4e0d\u5305\u542b\u4f1a\u8ba1\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u3002", (String)"AmortGenVchOperateService_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            }
            DynamicObject dyn = first.get();
            BigDecimal curAmortAmountFor = dyn.getBigDecimal("camount");
            BigDecimal rate = ((DynamicObject)scheme.getDynamicObjectCollection(TARGETENTRY).get(0)).getBigDecimal("rate");
            return curAmortAmountFor.multiply(rate);
        }
        long endPeriodId = 0L;
        if (!AmortStyle.DATE.getValue().equals(amortStyle)) {
            DynamicObject startDyn = scheme.getDynamicObject("startperiod");
            int planCount = scheme.getInt("planperiod");
            int amortCount = scheme.getInt("amortperiod");
            endPeriodId = VoucherAmortSchemeUtils.getMaxPeriodIdByCount((long)startDyn.getLong("id"), (int)(planCount + amortCount), (String)"0");
        } else {
            Date dateEnd = scheme.getDate("enddate");
            DynamicObject endPeriod = GLUtil.getPeriodByDate((Date)dateEnd, (long)this.amortInfo.getAccountBookInfo().getPeriodTypeId(), (Boolean)false);
            long l = endPeriodId = endPeriod == null ? 0L : endPeriod.getLong("id");
        }
        if (endPeriodId != 0L) {
            Long curPeriodId = this.amortInfo.getCurPeriodId();
            if (curPeriodId.equals(endPeriodId)) {
                BigDecimal total = scheme.getBigDecimal(TOTALAMOUNT);
                total = total != null ? total : BigDecimal.ZERO;
                BigDecimal amortAmountVal = scheme.getBigDecimal("amortamount");
                amortAmountVal = amortAmountVal != null ? amortAmountVal : BigDecimal.ZERO;
                periodAmortAmountVal = total.subtract(amortAmountVal);
            } else if (AmortStyle.DATE.getValue().equals(amortStyle)) {
                Long orgId = scheme.getLong("org.id");
                Long bookTypeId = scheme.getLong("accountbooks.id");
                Date dateBegin = scheme.getDate("begindate");
                Date dateEnd = scheme.getDate("enddate");
                BigDecimal curAmortperiod = VoucherAmortSchemeUtils.queryCurPeriodAmortPeriod((Long)orgId, (Long)bookTypeId, (Date)dateBegin, (Date)dateEnd, (BigDecimal)scheme.getBigDecimal("planperiod"), (Long)this.amortInfo.getCurPeriodId());
                periodAmortAmountVal = periodAmortAmountVal.multiply(curAmortperiod);
            }
        }
        return periodAmortAmountVal;
    }

    @Override
    public void saveVoucherRelations(Long id, List<VoucherInfo> voucherInfos, OperationResult operationResult) {
    }

    @Deprecated
    private VoucherInfo genVoucher() {
        VoucherInfo newVoucher = this.amortInfo.getVoucherInfo();
        DynamicObject schemeDyn = this.amortInfo.getDataEntity();
        long exrateTableId = this.amortInfo.getExchangeTableId();
        long baseCurrencyId = this.amortInfo.getBaseCurrencyId();
        DynamicObject localCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)baseCurrencyId, (String)"bd_currency");
        int localPrecesion = localCurrency.getInt("amtprecision");
        String amortStyle = schemeDyn.getString("amortstyle");
        this.rowToHgMap = this.parseExpToAssgrpId();
        DynamicObjectCollection destaccountsCols = schemeDyn.getDynamicObjectCollection(DESTENTRY);
        DynamicObjectCollection targetAccountsCols = schemeDyn.getDynamicObjectCollection(TARGETENTRY);
        BigDecimal currentPeriodAmount = BigDecimal.ZERO;
        String targetDc = ((DynamicObject)targetAccountsCols.get(0)).getString(PLANDIRECTION);
        String destDc = ((DynamicObject)destaccountsCols.get(0)).getString(DESTDIRECTION);
        if (AmortStyle.isCustome((String)schemeDyn.getString("amortstyle"))) {
            Optional<DynamicObject> first = schemeDyn.getDynamicObjectCollection("custompolicies").stream().filter(v -> v.getLong("cperiod_id") == this.amortInfo.getCurPeriodId().longValue()).findFirst();
            if (!first.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u644a\u9500\u671f\u95f4\u4e0d\u5305\u542b\u4f1a\u8ba1\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u3002", (String)"AmortGenVchOperateService_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            }
            DynamicObject dyn = first.get();
            currentPeriodAmount = dyn.getBigDecimal("camount");
        }
        BigDecimal periodAmortAmountval = this.getCurAmortAmount(schemeDyn);
        BigDecimal destPeriodAmortAmountval = targetDc.equals(destDc) ? periodAmortAmountval.multiply(new BigDecimal(-1)) : periodAmortAmountval;
        VoucherEntryInfo entry = null;
        int destEntryCount = destaccountsCols.size();
        int maxIndex = destEntryCount - 1;
        BigDecimal rate = ((DynamicObject)schemeDyn.getDynamicObjectCollection(TARGETENTRY).get(0)).getBigDecimal("rate");
        if (rate == null) {
            DynamicObject accountbook = BusinessDataServiceHelper.loadSingle((Object)newVoucher.getBook(), (String)"gl_accountbook");
            long baseCurrency_Id = accountbook.getLong("basecurrency_id");
            long targetCuarrencyId = ((DynamicObject)targetAccountsCols.get(0)).getLong("targetcurrency_id");
            ExchangeRate exchangeRate = RateServiceHelper.getExchangeRate((Long)targetCuarrencyId, (Long)baseCurrency_Id, (Long)exrateTableId, (Date)new Date());
            rate = baseCurrency_Id == targetCuarrencyId ? BigDecimal.ONE : exchangeRate.getDirectRate();
        }
        BigDecimal destCountAmount = BigDecimal.ZERO;
        ArrayList<Long> accountIds = new ArrayList<Long>(destaccountsCols.size() * 2);
        for (DynamicObject destAccount : destaccountsCols) {
            accountIds.add(destAccount.getLong("destaccount_id"));
        }
        Map<Long, DynamicObject> accountMap = this.getAccountMap(accountIds);
        for (int i = 0; i < destEntryCount; ++i) {
            BigDecimal locAmt;
            BigDecimal origAmt;
            DynamicObject destAccount = (DynamicObject)destaccountsCols.get(i);
            long destAccountId = destAccount.getLong("destaccount_id");
            String destAccountNumber = destAccount.getString("destaccount.number");
            if (this.vchAmortScheme.getSelfBaseDatas("bd_accountview", new Long[]{destAccountId}).isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5df2\u6ca1\u6709\u8f6c\u5165\u79d1\u76ee%s\u7684\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u65b9\u6848\u3002", (String)"AmortGenVchOperateService_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), destAccountNumber));
            }
            ThreadCache.put((Object)destAccountId, (Object)String.format(ResManager.loadKDString((String)"\u8f6c\u5165\u79d1\u76ee\u7b2c%d\u884c", (String)"AmortGenVchOperateService_4", (String)"fi-gl-opplugin", (Object[])new Object[0]), i + 1));
            try {
                destAccountId = this.getVersionAccount(destAccountId, accountMap);
            }
            catch (Exception e) {
                this.toOperateErrorInfo(schemeDyn, e.getMessage());
                continue;
            }
            DynamicObject currencyDyn = destAccount.getDynamicObject(DESTCURRENCY);
            int amtPrecision = currencyDyn.getInt("amtprecision");
            long currencyId = destAccount.getLong("destcurrency_id");
            String rowIdVal = destAccount.getString(DESTROWID);
            Set<Long> hgIds = this.rowToHgMap.get(rowIdVal);
            HashSet<Long> leafAcctId = new HashSet<Long>(16);
            HashSet<Long> acctId = new HashSet<Long>(1);
            HashSet<String> acctNumbers = new HashSet<String>(1);
            acctNumbers.add(destAccountNumber);
            acctId.add(destAccountId);
            this.getLeafAccountIds(acctNumbers, leafAcctId, schemeDyn.getLong("org.id"), this.vchAmortScheme.getAccountTableId());
            leafAcctId.addAll(this.getLeafAcct(acctId));
            BigDecimal acctCount = BigDecimal.valueOf(leafAcctId.size());
            BigDecimal hgCount = hgIds == null || hgIds.isEmpty() ? BigDecimal.ONE : new BigDecimal(hgIds.size());
            BigDecimal count = acctCount.multiply(hgCount);
            if (AmortStyle.isCustome((String)amortStyle)) {
                DynamicObjectCollection dynCustomColl = schemeDyn.getDynamicObjectCollection("custompolicies");
                long curPeriodId = this.amortInfo.getCurPeriodId();
                DynamicObject dynColl = dynCustomColl.stream().filter(v -> v.getLong("cperiod_id") == curPeriodId).findFirst().get();
                BigDecimal camount = dynColl.getBigDecimal("camount");
                origAmt = camount.multiply(destAccount.getBigDecimal("destratio")).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP);
                BigDecimal newRate = rate;
                if (newRate == null) {
                    ExchangeRate exchangeRate = RateServiceHelper.getExchangeRate((Long)currencyId, (Long)baseCurrencyId, (Long)exrateTableId, (Date)new Date());
                    newRate = baseCurrencyId == currencyId ? BigDecimal.ONE : exchangeRate.getDirectRate();
                }
                locAmt = origAmt.multiply(newRate);
            } else {
                origAmt = destAccount.getBigDecimal(DESTAMOUNT);
                locAmt = destAccount.getBigDecimal(DESTLOCAL);
            }
            if (BigDecimal.ZERO.compareTo(origAmt) == 0) continue;
            RateType rateType = RateServiceHelper.getRateType((long)destAccount.getDynamicObject(DESTCURRENCY).getLong("id"), (long)this.amortInfo.getBaseCurrencyId(), (Date)this.amortInfo.getCurPeriodEndDate());
            BigDecimal calculateRate = rateType.getRateCalculator().calRate(origAmt, locAmt, 4);
            int leafIndex = 0;
            int leafCountIndex = leafAcctId.size() - 1;
            for (Long leafAcct : leafAcctId) {
                BigDecimal local;
                if (hgIds != null && !hgIds.isEmpty()) {
                    int leafHgIndex = 0;
                    int leafHgCount = hgIds.size() - 1;
                    for (Long hgId : hgIds) {
                        BigDecimal local2;
                        entry = newVoucher.createNewEntry();
                        entry.setAssgrp(hgId);
                        entry.setDesc(schemeDyn.getString("amortabstract"));
                        entry.setCurency(Long.valueOf(currencyId));
                        BigDecimal ori = origAmt.divide(count, amtPrecision, 4);
                        if (i == maxIndex && leafIndex == leafCountIndex && leafHgIndex == leafHgCount && !AmortStyle.isCustome((String)amortStyle)) {
                            local2 = destPeriodAmortAmountval.subtract(destCountAmount).setScale(amtPrecision, 4);
                        } else {
                            local2 = locAmt.divide(count, amtPrecision, 4);
                            destCountAmount = destCountAmount.add(local2);
                        }
                        entry.setLocRate(rate);
                        entry.setAccount(leafAcct);
                        this.setEntryByDirction(entry, ori, local2, destDc);
                        ++leafHgIndex;
                    }
                    ++leafIndex;
                    continue;
                }
                entry = newVoucher.createNewEntry();
                entry.setAssgrp(null);
                entry.setDesc(schemeDyn.getString("amortabstract"));
                entry.setCurency(Long.valueOf(currencyId));
                BigDecimal ori = origAmt.divide(count, amtPrecision, 4);
                if (i == maxIndex && leafIndex == leafCountIndex && !AmortStyle.isCustome((String)amortStyle)) {
                    local = destPeriodAmortAmountval.subtract(destCountAmount).setScale(amtPrecision, 4);
                } else {
                    local = locAmt.divide(count, amtPrecision, 4);
                    destCountAmount = destCountAmount.add(local);
                }
                entry.setLocRate(calculateRate);
                entry.setAccount(leafAcct);
                this.setEntryByDirction(entry, ori, local, destDc);
                ThreadCache.put((Object)leafAcct, (Object)String.format(ResManager.loadKDString((String)"\u8f6c\u5165\u79d1\u76ee\u7b2c%d\u884c%s\u79d1\u76ee", (String)"AmortGenVchOperateService_6", (String)"fi-gl-opplugin", (Object[])new Object[0]), i + 1, destAccountNumber));
                ++leafIndex;
            }
        }
        BigDecimal totalAmountVal = schemeDyn.getBigDecimal(TOTALAMOUNT);
        int targetEntryCount = targetAccountsCols.size();
        maxIndex = targetEntryCount - 1;
        if (AmortStyle.isCustome((String)amortStyle)) {
            totalAmountVal = targetAccountsCols.stream().map(v -> v.getBigDecimal(TARGETAMOUNT)).reduce(BigDecimal::add).get();
        }
        BigDecimal targetCountAmount = BigDecimal.ZERO;
        accountIds = new ArrayList(targetAccountsCols.size() * 2);
        for (DynamicObject targetRow : targetAccountsCols) {
            accountIds.add(targetRow.getLong("targetaccount_id"));
        }
        accountMap = this.getAccountMap(accountIds);
        for (int i = 0; i < targetEntryCount; ++i) {
            BigDecimal origAmt;
            DynamicObject targetRow;
            targetRow = (DynamicObject)targetAccountsCols.get(i);
            long targetaccountId = targetRow.getLong("targetaccount_id");
            String targetAccountNumber = targetRow.getString("targetaccount.number");
            ThreadCache.put((Object)targetaccountId, (Object)String.format(ResManager.loadKDString((String)"\u5f85\u644a\u79d1\u76ee\u7b2c%d\u884c", (String)"AmortGenVchOperateService_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), i + 1));
            try {
                targetaccountId = this.getVersionAccount(targetaccountId, accountMap);
            }
            catch (Exception e) {
                this.toOperateErrorInfo(schemeDyn, e.getMessage());
                continue;
            }
            DynamicObject currencyDyn = targetRow.getDynamicObject(TARGETCURRENCY);
            int amtPrecision = currencyDyn.getInt("amtprecision");
            long currencyId = targetRow.getLong("targetcurrency_id");
            String rowIdVal = targetRow.getString(TARGETROWID);
            Set<Long> hgIds = this.rowToHgMap.get(rowIdVal);
            BigDecimal targetOrigAmt = targetRow.getBigDecimal(TARGETAMOUNT);
            BigDecimal targetLocAmt = targetRow.getBigDecimal(TARGETLOCAL);
            if (BigDecimal.ZERO.compareTo(targetLocAmt) == 0) continue;
            HashSet<Long> leafAcctId = new HashSet<Long>(16);
            HashSet<Long> acctId = new HashSet<Long>(1);
            HashSet<String> acctNumbers = new HashSet<String>(1);
            acctNumbers.add(targetAccountNumber);
            acctId.add(targetaccountId);
            this.getLeafAccountIds(acctNumbers, leafAcctId, schemeDyn.getLong("org.id"), this.vchAmortScheme.getAccountTableId());
            leafAcctId.addAll(this.getLeafAcct(acctId));
            BigDecimal planPeriod = schemeDyn.getBigDecimal("planperiod");
            if (planPeriod.compareTo(BigDecimal.ONE) == 0) {
                BigDecimal amount = this.getAccountTotalAmount(targetAccountNumber, (Long)schemeDyn.getPkValue());
                origAmt = targetOrigAmt.subtract(amount);
            } else {
                origAmt = AmortStyle.isCustome((String)amortStyle) ? currentPeriodAmount.multiply(targetOrigAmt).divide(totalAmountVal, amtPrecision, RoundingMode.HALF_UP) : targetOrigAmt.multiply(periodAmortAmountval).divide(totalAmountVal, amtPrecision, RoundingMode.HALF_UP);
            }
            RateType rateType = RateServiceHelper.getRateType((long)targetRow.getDynamicObject(TARGETCURRENCY).getLong("id"), (long)baseCurrencyId, (Date)this.amortInfo.getCurPeriodEndDate());
            BigDecimal schemeToLocRate = rateType.getRateCalculator().calRate(targetOrigAmt, targetLocAmt, 4);
            BigDecimal acctCount = BigDecimal.valueOf(leafAcctId.size());
            BigDecimal hgCount = hgIds == null || hgIds.isEmpty() ? BigDecimal.ONE : new BigDecimal(hgIds.size());
            BigDecimal count = acctCount.multiply(hgCount);
            int leafIndex = 0;
            int leafCountIndex = leafAcctId.size() - 1;
            for (Long leafAcct : leafAcctId) {
                if (hgIds != null && !hgIds.isEmpty()) {
                    int leafHgIndex = 0;
                    int leafHgCount = hgIds.size() - 1;
                    BigDecimal aveOrigAmt = origAmt.divide(count, amtPrecision, 4);
                    for (Long hgId : hgIds) {
                        BigDecimal local;
                        entry = newVoucher.createNewEntry();
                        entry.setAssgrp(hgId);
                        entry.setDesc(schemeDyn.getString("amortabstract"));
                        entry.setAccount(leafAcct);
                        entry.setCurency(Long.valueOf(currencyId));
                        BigDecimal ori = AmortStyle.isCustome((String)amortStyle) ? origAmt : aveOrigAmt;
                        if (i == maxIndex && leafIndex == leafCountIndex && leafHgCount == leafHgIndex && !AmortStyle.isCustome((String)amortStyle)) {
                            local = periodAmortAmountval.subtract(targetCountAmount).setScale(amtPrecision, 4);
                        } else {
                            local = aveOrigAmt.multiply(schemeToLocRate).setScale(localPrecesion, 4);
                            targetCountAmount = targetCountAmount.add(local);
                        }
                        entry.setLocRate(schemeToLocRate);
                        this.setEntryByDirction(entry, ori, local, targetDc);
                        ++leafHgIndex;
                    }
                    ++leafIndex;
                } else {
                    BigDecimal local;
                    entry = newVoucher.createNewEntry();
                    entry.setAssgrp(null);
                    entry.setDesc(schemeDyn.getString("amortabstract"));
                    entry.setAccount(leafAcct);
                    entry.setCurency(Long.valueOf(currencyId));
                    BigDecimal ori = AmortStyle.isCustome((String)amortStyle) ? origAmt : origAmt.divide(count, amtPrecision, 4);
                    if (i == maxIndex && leafIndex == leafCountIndex && !AmortStyle.isCustome((String)amortStyle)) {
                        local = periodAmortAmountval.subtract(targetCountAmount).setScale(amtPrecision, 4);
                    } else {
                        local = ori.multiply(schemeToLocRate);
                        targetCountAmount = targetCountAmount.add(local);
                    }
                    entry.setLocRate(schemeToLocRate);
                    this.setEntryByDirction(entry, ori, local, targetDc);
                    ++leafIndex;
                }
                ThreadCache.put((Object)leafAcct, (Object)String.format(ResManager.loadKDString((String)"\u5f85\u644a\u79d1\u76ee\u7b2c%d\u884c%s\u79d1\u76ee", (String)"AmortGenVchOperateService_5", (String)"fi-gl-opplugin", (Object[])new Object[0]), i + 1, targetAccountNumber));
            }
        }
        newVoucher.loadRefence();
        return newVoucher;
    }

    private Map<String, Set<Long>> parseExpToAssgrpId() {
        HashMap<String, Set<Long>> rowToHgMap = new HashMap<String, Set<Long>>(16);
        DynamicObject amortDyn = this.amortInfo.getDataEntity();
        long orgId = amortDyn.getLong("org_id");
        String[] entrys = new String[]{TARGETENTRY, DESTENTRY};
        ArrayList<String> rowIdList = new ArrayList<String>();
        for (String entryKey : entrys) {
            DynamicObjectCollection coll = amortDyn.getDynamicObjectCollection(entryKey);
            String rowKey = TARGETENTRY.equals(entryKey) ? TARGETROWID : DESTROWID;
            String comboKey = TARGETENTRY.equals(entryKey) ? TARGETASSGRP : DESTASSGRP;
            for (DynamicObject row : coll) {
                String assgrpTypeVal = row.getString(comboKey);
                if (StringUtils.isBlank((String)assgrpTypeVal)) continue;
                String assgrpRowVal = row.getString(rowKey);
                rowIdList.add(assgrpRowVal);
            }
        }
        QFilter forgid = new QFilter("org.id", "=", (Object)orgId);
        QFilter fassgrpRow = new QFilter("assgrprow", "in", rowIdList);
        Map assgrpExps = BusinessDataServiceHelper.loadFromCache((String)amortAssgrpEntityName, (QFilter[])new QFilter[]{forgid, fassgrpRow});
        for (DynamicObject assgrpExp : assgrpExps.values()) {
            FinalProcessAssgrp value = FinalProcessAssgrp.create((DynamicObjectCollection)assgrpExp.getDynamicObjectCollection("entryentity"));
            if (value == null) continue;
            rowToHgMap.put(assgrpExp.getString("assgrprow"), value.getHgIds());
        }
        return rowToHgMap;
    }

    private void setEntryByDirction(VoucherEntryInfo entry, BigDecimal ori, BigDecimal local, String dirction) {
        if ("-1".equals(dirction)) {
            entry.setCreOri(ori);
            entry.setCreLoc(local);
        } else {
            entry.setDebOri(ori);
            entry.setDebLoc(local);
        }
        entry.setEntryDC(dirction);
    }

    @Override
    public void initPropsToPrepare() {
        super.initPropsToPrepare();
        this.propToPrepare.add(VchAmortConstant.Entity_Amort_Style);
    }

    @Override
    public String getEndingProcessType() {
        return new VchAmortScheme().getEndingProcessType();
    }

    private Long getVersionAccount(Long accountId, Map<Long, DynamicObject> accountMap) {
        return this.getAccountOnCurPeriod(accountMap.get(accountId), this.vchAmortScheme.getOrgId(), this.vchAmortScheme.getAccountBookInfo().getBookTypeId(), this.vchAmortScheme.getCurPeriodDyn()).getLong("id");
    }

    private void getLeafAccountIds(Set<String> acctNumbers, Set<Long> leafs, long orgId, Long accountTableId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("parent.number", "in", acctNumbers));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        DynamicObject periodDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter("id", "=", (Object)this.vchAmortScheme.getCurPeriodId()).toArray());
        if (null == periodDO) {
            filters.add(new QFilter("enddate", "=", (Object)GLUtil.getEndDate()));
        } else {
            filters.add(new QFilter("startdate", "<=", (Object)periodDO.getDate("enddate")));
            filters.add(new QFilter("enddate", ">", (Object)periodDO.getDate("enddate")));
        }
        try (DataSet ds = AccountUtils.queryAccountDataSet((long)orgId, (long)accountTableId, (String)"id,number,isleaf", filters);){
            HashSet<String> unLeafAcctNumbers = new HashSet<String>(16);
            for (Row row : ds) {
                long acctId = row.getLong("id");
                String acctNumber = row.getString("number");
                if (row.getBoolean("isleaf").booleanValue()) {
                    leafs.add(acctId);
                    continue;
                }
                unLeafAcctNumbers.add(acctNumber);
            }
            if (unLeafAcctNumbers.size() > 0) {
                this.getLeafAccountIds(unLeafAcctNumbers, leafs, orgId, accountTableId);
            }
        }
    }

    private BigDecimal getAccountTotalAmount(String acctNumber, Long schmeId) {
        BigDecimal amount = BigDecimal.ZERO;
        QFilter qFilter = new QFilter("srcentity", "=", (Object)schmeId);
        qFilter.and("type", "=", (Object)VoucherRelationTypeEnum.VOUCHER_AMORTIZATION.getValue());
        HashSet<Long> voucherIds = new HashSet<Long>(16);
        try (DataSet relationDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucherrelation", (String)String.join((CharSequence)",", "targentity", "srcentity", "period"), (QFilter[])qFilter.toArray(), null);){
            for (Row row : relationDataSet) {
                voucherIds.add(row.getLong("targentity"));
            }
        }
        if (!CollectionUtils.isEmpty(voucherIds)) {
            QFilter vchQFilter = new QFilter("id", "in", voucherIds);
            vchQFilter.and("entries.account.number", "like", (Object)(acctNumber + "%"));
            DataSet voucherSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_voucher", (String)"entries.account,entries.debitori debitori,entries.creditori creditori", (QFilter[])vchQFilter.toArray(), null);
            Object object = null;
            try {
                for (Row row : voucherSet) {
                    BigDecimal debitori = row.getBigDecimal("debitori");
                    BigDecimal creditori = row.getBigDecimal("creditori");
                    if (debitori.compareTo(BigDecimal.ZERO) == 0) {
                        amount = amount.add(creditori);
                        continue;
                    }
                    amount = amount.add(debitori);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (voucherSet != null) {
                    if (object != null) {
                        try {
                            voucherSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        voucherSet.close();
                    }
                }
            }
        }
        return amount;
    }

    private void fireAmountAllocate(VoucherInfo voucherInfo) {
        PluginProxy pluginProxy = PluginProxy.create(null, IAmountAllocate.class, (String)"kd.sdk.fi.gl.extpoint.amort.IAmountAllocate.dealVoucher", null);
        pluginProxy.callReplace(plugin -> {
            if (null == this.amortInfo.getTargetDetailInfoTable()) {
                return null;
            }
            voucherInfo.loadRefence();
            int targetEntrySize = this.amortInfo.getTargetDetailInfoTable().size();
            DynamicObjectCollection entries = voucherInfo.toDynamicObject().getDynamicObjectCollection("entries");
            List targetEntries = ((DynamicObjectCollection)entries.clone()).subList(0, targetEntrySize);
            List destEntries = entries.subList(targetEntrySize, entries.size());
            plugin.dealDestEntries(destEntries, targetEntries, (DynamicObject)new CloneUtils(false, false).clone((IDataEntityBase)this.amortInfo.getDataEntity()));
            return null;
        });
    }
}

