/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.operateservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.Row;
import kd.fi.gl.common.VoucherEntryInfo;
import kd.fi.gl.finalprocessing.info.ExchangeRateType;
import kd.fi.gl.finalprocessing.info.TransPLProgramInfo;
import kd.fi.gl.finalprocessing.operateservice.IBalanceDTO;
import kd.fi.gl.finalprocessing.util.GenVchUtil;

public class BalanceDTO
implements IBalanceDTO {
    private Long acctId;
    private String accountnumber;
    private Long curId;
    private Long grpId;
    private String acctDC;
    private BigDecimal loc;
    private BigDecimal org;
    private BigDecimal qty;
    private Long measureunitId;
    private String pltype;
    private List<IBalanceDTO> extBalanceSpec;

    @Override
    public void init(Row balanceRow, List<IBalanceDTO> extBalanceSpec) {
        this.acctId = balanceRow.getLong("accountid");
        this.accountnumber = balanceRow.getString("accountnumber");
        this.curId = balanceRow.getLong("currencyid");
        this.grpId = balanceRow.getLong("assistGrpID");
        this.acctDC = balanceRow.getString("accountdc");
        this.loc = Optional.ofNullable(balanceRow.getBigDecimal("endlocal")).orElse(BigDecimal.ZERO);
        this.org = Optional.ofNullable(balanceRow.getBigDecimal("endfor")).orElse(BigDecimal.ZERO);
        this.qty = Optional.ofNullable(balanceRow.getBigDecimal("endqty")).orElse(BigDecimal.ZERO);
        this.measureunitId = balanceRow.getLong("measureunitid");
        this.pltype = balanceRow.getString("pltype");
        this.extBalanceSpec = extBalanceSpec == null ? new ArrayList() : extBalanceSpec;
        for (IBalanceDTO iBalanceDTO : this.extBalanceSpec) {
            iBalanceDTO.init(balanceRow);
        }
    }

    @Override
    public void init(Row balanceRow) {
        this.init(balanceRow, null);
    }

    @Override
    public boolean needGenVchEntry() {
        boolean needGenVchEntry;
        boolean bl = needGenVchEntry = this.loc.signum() != 0 || this.org.signum() != 0 || this.qty.signum() != 0;
        if (needGenVchEntry) {
            return true;
        }
        for (IBalanceDTO iBalanceDTO : this.extBalanceSpec) {
            if (!iBalanceDTO.needGenVchEntry()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSumKey() {
        StringBuilder sumKey = new StringBuilder();
        sumKey.append(this.curId);
        for (IBalanceDTO iBalanceDTO : this.extBalanceSpec) {
            sumKey.append("_").append(iBalanceDTO.getSumKey());
        }
        return sumKey.toString();
    }

    @Override
    public Map<String, BigDecimal> getSumMap() {
        HashMap<String, BigDecimal> sumMap = new HashMap<String, BigDecimal>();
        sumMap.put("loc", this.loc);
        sumMap.put("org", this.org);
        sumMap.put("qty", this.qty);
        for (IBalanceDTO iBalanceDTO : this.extBalanceSpec) {
            sumMap.putAll(iBalanceDTO.getSumMap());
        }
        return sumMap;
    }

    @Override
    public void fillVchEntry(TransPLProgramInfo info, VoucherEntryInfo preEntry) {
        preEntry.setAssgrp(this.grpId);
        preEntry.setAccount(this.acctId);
        preEntry.setAccNumber(this.accountnumber);
        preEntry.setCurency(this.curId);
        preEntry.setDesc(info.getVoucherDesc());
        ExchangeRateType exchangeRateType = new ExchangeRateType(info.getExchangeTableId(), info.getBaseCurrencyId(), this.curId.longValue(), info.getCurPeriodEndDate());
        preEntry.setLocRate(info.getLex(exchangeRateType, this.org, this.loc));
        BigDecimal acctdcBigDecimal = new BigDecimal(this.acctDC);
        BigDecimal locTemp = this.loc;
        BigDecimal orgTemp = this.org;
        BigDecimal qtyTemp = this.qty;
        if (!info.isTransPLByBalanceDirection()) {
            locTemp = locTemp.multiply(acctdcBigDecimal);
            orgTemp = orgTemp.multiply(acctdcBigDecimal);
        }
        if (info.isTransPLByBalanceDirection()) {
            if (locTemp.compareTo(BigDecimal.ZERO) < 0) {
                this.setVoucherEntryInfo(preEntry, "1", locTemp.negate(), BigDecimal.ZERO, orgTemp.negate(), BigDecimal.ZERO, qtyTemp.negate());
            } else if (locTemp.signum() == 0) {
                if (orgTemp.signum() != 0) {
                    if (orgTemp.signum() < 0) {
                        qtyTemp = qtyTemp.multiply(new BigDecimal(-1));
                        orgTemp = orgTemp.multiply(new BigDecimal(-1));
                        this.setVoucherEntryInfo(preEntry, "1", BigDecimal.ZERO, BigDecimal.ZERO, orgTemp, BigDecimal.ZERO, qtyTemp);
                    } else {
                        this.setVoucherEntryInfo(preEntry, "-1", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, orgTemp, qtyTemp);
                    }
                } else if (qtyTemp.signum() != 0) {
                    String dc = qtyTemp.signum() < 0 ? "1" : "-1";
                    this.setVoucherEntryInfo(preEntry, dc, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, qtyTemp.abs());
                }
            } else {
                this.setVoucherEntryInfo(preEntry, "-1", BigDecimal.ZERO, locTemp, BigDecimal.ZERO, orgTemp, qtyTemp);
            }
        } else if (this.acctDC.equals("-1")) {
            qtyTemp = qtyTemp.multiply(acctdcBigDecimal);
            this.setVoucherEntryInfo(preEntry, "1", locTemp, BigDecimal.ZERO, orgTemp, BigDecimal.ZERO, qtyTemp);
        } else {
            this.setVoucherEntryInfo(preEntry, "-1", BigDecimal.ZERO, locTemp, BigDecimal.ZERO, orgTemp, qtyTemp);
        }
        GenVchUtil.setMunit(preEntry, this.measureunitId);
        for (IBalanceDTO iBalanceDTO : this.extBalanceSpec) {
            iBalanceDTO.fillVchEntry(info, preEntry);
        }
    }

    private void setVoucherEntryInfo(VoucherEntryInfo preEntry, String dc, BigDecimal locDr, BigDecimal locCr, BigDecimal oriDr, BigDecimal oriCr, BigDecimal qty) {
        preEntry.setEntryDC(dc);
        preEntry.setLocAmt(locDr, locCr);
        preEntry.setOriAmt(oriDr, oriCr);
        preEntry.setQty(qty);
    }

    public Long getGrpId() {
        return this.grpId;
    }

    public String getAcctDC() {
        return this.acctDC;
    }

    public Long getMeasureunitId() {
        return this.measureunitId;
    }

    public String getPltype() {
        return this.pltype;
    }

    public BigDecimal getLoc() {
        return this.loc;
    }

    public Long getAcctId() {
        return this.acctId;
    }

    public String getAccountnumber() {
        return this.accountnumber;
    }

    public Long getCurId() {
        return this.curId;
    }

    public BigDecimal getOrg() {
        return this.org;
    }

    public BigDecimal getQty() {
        return this.qty;
    }
}

