/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.operateservice;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.rate.RateType;
import kd.fi.gl.common.VoucherEntryInfo;
import kd.fi.gl.finalprocessing.info.ExchangeRateType;
import kd.fi.gl.finalprocessing.info.TransPLProgramInfo;
import kd.fi.gl.finalprocessing.operateservice.BalanceDTO;
import kd.fi.gl.finalprocessing.operateservice.YearProfitAcctDTO;
import kd.fi.gl.finalprocessing.util.GenVchUtil;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GLUtil;

public class BalanceService {
    public static String appendSumKey(BalanceDTO balanceDTO, Long grpIdKey, Long measureUnitIdKey) {
        return String.join((CharSequence)"_", String.valueOf(grpIdKey), String.valueOf(measureUnitIdKey), balanceDTO.getSumKey());
    }

    public static void updatePlSumMap(String key, Map<String, HashMap<String, BigDecimal>> plSumMap, Map<String, BigDecimal> sumMap) {
        HashMap<String, BigDecimal> plSumMapVal = plSumMap.get(key);
        if (plSumMapVal == null) {
            plSumMap.put(key, new HashMap<String, BigDecimal>(sumMap));
        } else {
            for (Map.Entry<String, BigDecimal> entry : sumMap.entrySet()) {
                plSumMapVal.put(entry.getKey(), plSumMapVal.getOrDefault(entry.getKey(), BigDecimal.ZERO).add(sumMap.getOrDefault(entry.getKey(), BigDecimal.ZERO)));
            }
            plSumMap.put(key, plSumMapVal);
        }
    }

    public static String appendPlSumKey(TransPLProgramInfo info, YearProfitAcctDTO yearProfitAcctDTO) {
        StringBuilder key = new StringBuilder();
        long unitId = yearProfitAcctDTO.getUnitId();
        if (info.isByAsstTrans()) {
            long tempUnitId = info.isContainPLUnit(unitId) ? unitId : 0L;
            key.append(yearProfitAcctDTO.getGrpId()).append("_").append(tempUnitId);
        } else {
            key.append(info.isContainPLUnit(unitId) ? unitId + "" : "0");
        }
        if (!yearProfitAcctDTO.getComAssistMap().isEmpty()) {
            key.append("_").append(GenVchUtil.getComAssistKey(yearProfitAcctDTO.getComAssistMap()));
        }
        return key.toString();
    }

    public static void fillPlVchEntry(TransPLProgramInfo info, VoucherEntryInfo entry, YearProfitAcctDTO yearDTO) {
        Long unitId;
        BigDecimal lex;
        entry.setAccount(info.getYearProfitAcct());
        entry.setAccNumber(info.getYearProfitAcctNumber());
        Long curId = yearDTO.getCurId();
        entry.setCurency(curId);
        entry.setDesc(info.getVoucherDesc());
        entry.setAssgrp(yearDTO.getGrpId());
        if (yearDTO.isEnableComAssist()) {
            for (int i = 0; i < yearDTO.getComAssistMap().size(); ++i) {
                entry.setComAssist(i + 1, yearDTO.getComAssistMap().get(CommonAssistUtil.getComassistField((int)(i + 1))));
            }
        }
        String entryDC = null;
        BigDecimal loc = yearDTO.getLoc();
        BigDecimal org = yearDTO.getOrg();
        BigDecimal qty = yearDTO.getQty();
        if (loc.signum() != 0) {
            entryDC = loc.signum() < 0 ? "-1" : "1";
        } else if (org.signum() != 0) {
            entryDC = org.signum() < 0 ? "-1" : "1";
        } else if (qty.signum() != 0) {
            entryDC = qty.signum() < 0 ? "-1" : "1";
        }
        if (entryDC != null) {
            if (entryDC.equals("-1")) {
                GenVchUtil.setVoucherEntryInfo(entry, "-1", BigDecimal.ZERO, loc.negate(), BigDecimal.ZERO, org.negate(), qty.negate());
            } else {
                GenVchUtil.setVoucherEntryInfo(entry, "1", loc, BigDecimal.ZERO, org, BigDecimal.ZERO, qty);
            }
        }
        if (org.signum() == 0) {
            lex = BigDecimal.ONE;
        } else {
            int ratePrecision = GLUtil.getRatePrecision((Long)info.getExchangeTableId(), (Long)curId, (Long)info.getBaseCurrencyId(), (Date)info.getCurPeriodEndDate());
            RateType rateType = RateServiceHelper.getRateType((long)curId, (long)info.getBaseCurrencyId(), (Date)info.getCurPeriodEndDate());
            lex = rateType.getRateCalculator().calRate(org, loc, ratePrecision);
        }
        entry.setLocRate(lex);
        if (info.isTransByBaseCurrency() || info.getYearProfitAcctCurrencyIds() != null && !info.getYearProfitAcctCurrencyIds().contains(curId)) {
            entry.setCurency(Long.valueOf(info.getBaseCurrencyId()));
            entry.setOriAmt(BigDecimal.ZERO, BigDecimal.ZERO);
        }
        if (info.isContainPLUnit((unitId = yearDTO.getUnitId()).longValue())) {
            GenVchUtil.setMunit(entry, unitId);
        }
        if (yearDTO.isEnableMulCur()) {
            BalanceService.fillMulCurVchEntry(info, entry, yearDTO);
        }
    }

    public static void fillMulCurVchEntry(TransPLProgramInfo info, VoucherEntryInfo preEntry, YearProfitAcctDTO yearDTO) {
        BigDecimal baseCurAmt = preEntry.getlocAmt();
        BigDecimal mulCurAmt = BigDecimal.ZERO;
        long orgId = info.getOrgId();
        long bookTypeId = info.getAccountBookInfo().getBookTypeId();
        long baseCurId = info.getBaseCurrencyId();
        Date curPeriodEndDate = info.getCurPeriodEndDate();
        for (LocalCurrencyConfigVO config : info.getLocalCurrencyConfig()) {
            String balanceField = config.getBalanceField(MCT.END).getMetaId();
            mulCurAmt = yearDTO.getAmountVal().get(balanceField);
            String debitField = config.getVoucherField(MCT.DEBIT).getMetaId();
            String creditField = config.getVoucherField(MCT.CREDIT).getMetaId();
            if (preEntry.getEntryDC() == null && mulCurAmt.signum() != 0) {
                String entryDc = mulCurAmt.signum() < 0 ? "-1" : "1";
                preEntry.setEntryDC(entryDc);
            }
            if ("-1".equals(preEntry.getEntryDC())) {
                mulCurAmt = mulCurAmt.negate();
                preEntry.set(debitField, (Object)BigDecimal.ZERO);
                preEntry.set(creditField, (Object)mulCurAmt);
            } else {
                preEntry.set(debitField, (Object)mulCurAmt);
                preEntry.set(creditField, (Object)BigDecimal.ZERO);
            }
            long mulCurId = config.getCurrencyId(orgId, bookTypeId);
            String rateField = config.getVoucherField(MCT.EX_RATE).getMetaId();
            long exRateTableId = config.getExRateTableId(orgId, bookTypeId);
            ExchangeRateType exchangeRateType = new ExchangeRateType(exRateTableId, baseCurId, mulCurId, curPeriodEndDate);
            preEntry.set(rateField, (Object)info.getLex(exchangeRateType, baseCurAmt, mulCurAmt));
        }
    }
}

