/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.operateservice;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.gl.common.VoucherEntryInfo;
import kd.fi.gl.finalprocessing.info.TransPLProgramInfo;
import kd.fi.gl.finalprocessing.operateservice.IBalanceDTO;
import kd.fi.gl.finalprocessing.util.GenVchUtil;
import kd.fi.gl.util.CommonAssistUtil;

public class ComAssistBalanceDTO
implements IBalanceDTO {
    private final Integer comAssistCount;
    private final Map<String, Long> comAssistMap;

    public ComAssistBalanceDTO(int comAssistCount) {
        this.comAssistCount = comAssistCount;
        this.comAssistMap = new HashMap<String, Long>(this.comAssistCount);
    }

    @Override
    public void init(Row balanceRow) {
        for (int i = 0; i < this.comAssistCount; ++i) {
            String comAssistField = CommonAssistUtil.getComassistField((int)(i + 1));
            this.comAssistMap.put(comAssistField, balanceRow.getLong(comAssistField));
        }
    }

    @Override
    public String getSumKey() {
        String comAssistKey = GenVchUtil.getComAssistKey(this.comAssistMap);
        if (!StringUtils.isEmpty((CharSequence)comAssistKey)) {
            return comAssistKey;
        }
        return "";
    }

    @Override
    public void fillVchEntry(TransPLProgramInfo info, VoucherEntryInfo preEntry) {
        for (int i = 0; i < this.comAssistMap.size(); ++i) {
            preEntry.setComAssist(i + 1, this.comAssistMap.get(CommonAssistUtil.getComassistField((int)(i + 1))));
        }
    }
}

