/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.VoucherEntryInfo;
import kd.fi.gl.constant.Voucher;
import kd.fi.gl.enums.VoucherRelationTypeEnum;
import kd.fi.gl.util.CommonAssistUtil;

public class GenVchUtil {
    public static boolean existsNonPostVoucher(long orgId, long bookTypeId, long periodId) {
        QFilterBuilder qFilterBuilder = QFilterBuilder.create((String)"org", (String)"=", (Object)orgId).addEqual("booktype", (Object)bookTypeId).addEqual("period", (Object)periodId).addEqual("ispost", (Object)false).add("billstatus", "!=", (Object)"D");
        return VoucherQueryUtils.exists((QFilter[])qFilterBuilder.toArray(new QFilter[0]));
    }

    public static boolean existsRelationTempVoucher(VoucherRelationTypeEnum relationType, long schemeId, long periodId) {
        QFilterBuilder relationFilterBuilder = QFilterBuilder.create((String)"type", (String)"=", (Object)relationType.getValue()).addEqual("srcentity", (Object)schemeId).addEqual("period", (Object)periodId);
        List targetVoucherIds = QueryServiceHelper.query((String)"gl_voucherrelation", (String)"targentity", (QFilter[])relationFilterBuilder.toArray(new QFilter[0])).stream().map(row -> row.getLong("targentity")).collect(Collectors.toList());
        if (targetVoucherIds.isEmpty()) {
            return false;
        }
        QFilterBuilder existsFilterBuilder = QFilterBuilder.create((String)"id", (String)"in", targetVoucherIds).addEqual("billstatus", (Object)"A");
        return QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])existsFilterBuilder.toArray(new QFilter[0]));
    }

    public static String checkHasTempVch(DynamicObject db, AccountBookInfo accountBookInfo, Long specifiedPeriodId) {
        String errMessage = null;
        Long peroidId = accountBookInfo.getCurPeriodId(specifiedPeriodId.longValue());
        Long booktypeId = accountBookInfo.getBookTypeId();
        Long orgId = db.getDynamicObject("org").getLong("id");
        QFilter tempStatus = new QFilter("billstatus", "=", (Object)"A");
        QFilter enableStatus = new QFilter("billstatus", "!=", (Object)"D");
        QFilter enableVouCher = new QFilter("sourcetype", "=", (Object)"2");
        if (Voucher.exists((long[])new long[]{orgId}, (long)booktypeId, (long)peroidId, (QFilter[])new QFilter[]{tempStatus, enableStatus, enableVouCher})) {
            errMessage = String.format(ResManager.loadKDString((String)"%s\u5b58\u5728\u672a\u63d0\u4ea4\u7684\u671f\u672b\u8c03\u6c47\u51ed\u8bc1\u3002", (String)"GenVchUtil_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), db.getDynamicObject("org").getString("name"));
        }
        return errMessage;
    }

    public static void setMunit(VoucherEntryInfo preEntry, long measureunitId) {
        if (measureunitId != 0L) {
            BigDecimal qty;
            preEntry.setUnit(Long.valueOf(measureunitId));
            BigDecimal org = preEntry.getOriAmt();
            Long curId = preEntry.getCurency();
            BigDecimal price = BigDecimal.ZERO;
            DynamicObject curDyn = QueryServiceHelper.queryOne((String)"bd_currency", (String)"priceprecision", (QFilter[])new QFilter("id", "=", (Object)curId).toArray());
            int pricePrecision = 10;
            if (curDyn != null) {
                pricePrecision = curDyn.getInt("priceprecision");
            }
            if (BigDecimal.ZERO.compareTo(qty = preEntry.getQty()) != 0) {
                price = org.divide(qty, pricePrecision, RoundingMode.HALF_UP);
            }
            if (BigDecimal.ZERO.compareTo(price) != 0) {
                price = price.abs();
            }
            preEntry.setPrice(price);
        }
    }

    public static void setVoucherEntryInfo(VoucherEntryInfo preEntry, String dc, BigDecimal locDr, BigDecimal locCr, BigDecimal oriDr, BigDecimal oriCr, BigDecimal qty) {
        preEntry.setEntryDC(dc);
        preEntry.setLocAmt(locDr, locCr);
        preEntry.setOriAmt(oriDr, oriCr);
        preEntry.setQty(qty);
    }

    public static String getComAssistKey(Map<String, Long> comAssistMap) {
        StringBuilder comAssistKey = new StringBuilder();
        for (int i = 0; i < comAssistMap.size(); ++i) {
            comAssistKey.append(comAssistMap.get(CommonAssistUtil.getComassistField((int)(i + 1)))).append("_");
        }
        return comAssistKey.length() > 0 ? comAssistKey.delete(comAssistKey.length() - 1, comAssistKey.length()).toString() : comAssistKey.toString();
    }
}

