/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.validate;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.util.MultiLangPunc;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.finalprocess.service.AbstractEndingProcessingService;
import kd.fi.gl.util.FinalProcessUtil;
import kd.fi.gl.util.TipsUtils;

public abstract class FinalProcessingGenVchValidator
extends AbstractValidator {
    private String org;
    private String bookstype;
    protected long specifiedPeriodId = 0L;

    public FinalProcessingGenVchValidator(String org, String bookstype) {
        this.org = org;
        this.bookstype = bookstype;
    }

    protected abstract AbstractEndingProcessingService getEndingProcessService(DynamicObject var1);

    public void validate() {
        OperateOption option = this.getOption();
        String openedPeriod = option.getVariableValue("openedperiod", "0");
        this.specifiedPeriodId = Long.parseLong(openedPeriod);
        if (this.dataEntities.length > 0) {
            String entityName = this.dataEntities[0].getDataEntity().getDynamicObjectType().getName();
            ArrayList<Object> ids = new ArrayList<Object>(this.dataEntities.length);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                ids.add(dataEntity.getBillPkId());
            }
            Map map = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)entityName);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                this.checkSchemeValidity(dataEntity, map);
            }
        }
    }

    private void checkSchemeValidity(ExtendedDataEntity ext, Map<Object, DynamicObject> map) {
        this.checkGenVch(ext, map);
    }

    protected void addMessage(ExtendedDataEntity dataEntity, String content) {
        super.addMessage(dataEntity, TipsUtils.safeSuffix((String)content, (String)MultiLangPunc.fullStop()));
    }

    private boolean checkGenVch(ExtendedDataEntity ext, Map<Object, DynamicObject> map) {
        Object pkId = ext.getBillPkId();
        if (pkId == null || (Long)pkId == 0L) {
            this.addMessage(ext, ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u8be5\u65b9\u6848\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002", (String)"FinalProcessingGenVchValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject db = map.get(pkId);
        Long orgId = db.getDynamicObject(this.org).getLong("id");
        Long booktypeId = db.getDynamicObject(this.bookstype).getLong("id");
        AccountBookInfo accountBookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)booktypeId);
        if (accountBookInfo == null) {
            this.addMessage(ext, ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5\u65b9\u6848\u7684\u8d26\u7c3f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"FinalProcessingGenVchValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return false;
        }
        if ("0".equals(accountBookInfo.getEnable())) {
            this.addMessage(ext, FinalProcessUtil.formatOrgBookMessage((DynamicObject)db, (String)ResManager.loadKDString((String)"\u8d26\u7c3f\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u751f\u6210\u51ed\u8bc1\u3002", (String)"FinalProcessingGenVchValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0])));
            return false;
        }
        if ("0".equals(db.getString("billstatus"))) {
            this.addMessage(ext, FinalProcessUtil.formatOrgBookMessage((DynamicObject)db, (String)ResManager.loadKDString((String)"\u7981\u7528\u7684\u65b9\u6848\u65e0\u6cd5\u751f\u6210\u51ed\u8bc1\u3002", (String)"FinalProcessingGenVchValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0])));
            return false;
        }
        if (!accountBookInfo.isIsendinit()) {
            this.addMessage(ext, FinalProcessUtil.formatOrgBookMessage((DynamicObject)db, (String)ResManager.loadKDString((String)"\u8fd8\u6ca1\u6709\u7ed3\u675f\u521d\u59cb\u5316", (String)"FinalProcessingGenVchValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0])));
            return false;
        }
        String[] checkArray = this.check(db, accountBookInfo);
        if (checkArray != null && checkArray.length != 0) {
            for (String checkStr : checkArray) {
                this.addMessage(ext, checkStr);
            }
            return false;
        }
        return true;
    }

    public String[] check(DynamicObject db, AccountBookInfo accountBookInfo) {
        return null;
    }
}

