/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.validate;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.enums.VoucherRelationTypeEnum;
import kd.fi.gl.finalprocess.service.AbstractEndingProcessingService;
import kd.fi.gl.finalprocessing.util.GenVchUtil;
import kd.fi.gl.finalprocessing.validate.FinalProcessingGenVchValidator;
import kd.fi.gl.util.ValidateUtils;

public class TransPLProgramsGenVchValidator
extends FinalProcessingGenVchValidator {
    private static final String ALLOW_NON_POST = "allownonpost";

    public TransPLProgramsGenVchValidator(String org, String bookstype) {
        super(org, bookstype);
    }

    @Override
    protected AbstractEndingProcessingService getEndingProcessService(DynamicObject dataEntity) {
        return null;
    }

    @Override
    public String[] check(DynamicObject db, AccountBookInfo accountBookInfo) {
        super.check(db, accountBookInfo);
        ArrayList<String> list = new ArrayList<String>();
        List<String> acctAvailableInfo = this.checkIfAcctIsAvailable(db);
        if (!acctAvailableInfo.isEmpty()) {
            list.addAll(acctAvailableInfo);
            return list.toArray(new String[0]);
        }
        if (db.getBoolean(ALLOW_NON_POST) && GenVchUtil.existsRelationTempVoucher(VoucherRelationTypeEnum.TRANS_PL_PROGRAM, db.getLong("id"), accountBookInfo.getCurPeriodId())) {
            list.add(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5b58\u5728\u6682\u5b58\u72b6\u6001\u51ed\u8bc1\uff0c\u8bf7\u63d0\u4ea4\u51ed\u8bc1\u540e\u518d\u8bd5\u3002", (String)"TransPLProgramsGenVchValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
        if (!db.getBoolean(ALLOW_NON_POST) && GenVchUtil.existsNonPostVoucher(accountBookInfo.getOrgId(), accountBookInfo.getBookTypeId(), accountBookInfo.getCurPeriodId())) {
            list.add(String.format(ResManager.loadKDString((String)"%s \u5b58\u5728\u672a\u8fc7\u8d26\u51ed\u8bc1\u3002", (String)"GenVchUtil_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), db.getString("org.name")));
        }
        return list.toArray(new String[0]);
    }

    protected List<String> checkIfAcctIsAvailable(DynamicObject scheme) {
        Tuple yearProfitAcct = Tuple.create((Object)scheme.getDynamicObject("yearprofitacct"), (Object)ResManager.loadKDString((String)"\u672c\u5e74\u5229\u6da6\u79d1\u76ee", (String)"TransPLProgramsGenVchValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        Tuple transAcct = Tuple.create((Object)scheme.getDynamicObject("yearprofitacct"), (Object)ResManager.loadKDString((String)"\u7ed3\u8f6c\u79d1\u76ee", (String)"TransPLProgramsGenVchValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        boolean isdesacct = scheme.getBoolean("isdesacct");
        if (isdesacct) {
            return ValidateUtils.validateAcctAvailable(Stream.of(yearProfitAcct, transAcct));
        }
        return ValidateUtils.validateAcctAvailable(Stream.of(yearProfitAcct));
    }
}

