/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.service.LocalCurrencyQueryService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.util.CashflowLocalSetUtil;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.balance.CalculatorFactory;
import kd.fi.gl.balance.ICalculator;
import kd.fi.gl.balcal.CashflowSumCalculator;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.opplugin.AccountBookAddValidator;
import kd.fi.gl.util.AccountBookHelper;
import kd.fi.gl.util.AccountBookUtil;

public class AccountBookAddOp
extends AbstractOperationServicePlugIn {
    private static final String MASTERID = "masterid";
    private static final String VOUCHER_TYPE_ENTITY = "gl_vouchertype";
    private static final String ACCOUNT_VIEW_ENTITY = "bd_accountview";
    private static final String VOUCHER_TYPE_FIELD = "defaultvouchertype";
    private static final String ACCOUNT_VIEW_FIELD = "yearprofitacct";
    private static final Log LOGGER = LogFactory.getLog((String)"AccountBookAddOp");
    private Set<String> reCalculateMsg = new HashSet<String>(16);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AccountBookAddValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (DynamicObject obj : e.getDataEntities()) {
            if (!obj.getDataEntityState().getFromDatabase()) continue;
            long bookId = obj.getLong("id");
            QFilter fid = new QFilter("id", "=", (Object)bookId);
            DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"isendinit,startperiod,cashinitperiod, isendinitcashflow", (QFilter[])new QFilter[]{fid});
            if (!book.getBoolean("isendinit") && book.getLong("startperiod") != obj.getLong("startperiod_id")) {
                LOGGER.info("accountbook_period_is_change:before-{},after:{}", (Object)obj.getLong("startperiod_id"), (Object)book.getLong("startperiod"));
                long orgId = obj.getLong("org_id");
                long bookTypeId = obj.getLong("bookstype_id");
                QFilter forgId = new QFilter("org", "=", (Object)orgId);
                QFilter fbookTypeId = new QFilter("booktype", "=", (Object)bookTypeId);
                QFilter fdelQF = new QFilter("isdeleted", "=", (Object)false);
                boolean hasInit = QueryServiceHelper.exists((String)"gl_initbalance", (QFilter[])new QFilter[]{forgId, fbookTypeId, fdelQF});
                boolean hasVch = QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])new QFilter[]{forgId, fbookTypeId});
                if (!hasVch && !hasInit) {
                    DeleteServiceHelper.delete((String)"gl_balance", (QFilter[])new QFilter[]{forgId, fbookTypeId});
                    DeleteServiceHelper.delete((String)"gl_cashflow", (QFilter[])new QFilter[]{forgId, fbookTypeId});
                }
            }
            long cashflowPeriodid = obj.getLong(GLField.id_((String)"cashinitperiod"));
            if (book.getLong("cashinitperiod") == cashflowPeriodid) continue;
            long orgId = obj.getLong("org_id");
            long bookTypeId = obj.getLong("bookstype_id");
            QFilter forgId = new QFilter("org", "=", (Object)orgId);
            QFilter fbookTypeId = new QFilter("booktype", "=", (Object)bookTypeId);
            DeleteServiceHelper.delete((String)"gl_cashflow", (QFilter[])new QFilter[]{forgId, fbookTypeId});
            DeleteServiceHelper.delete((String)"gl_cashflowsum", (QFilter[])new QFilter[]{forgId, fbookTypeId});
            if (cashflowPeriodid != 0L) {
                this.reCalculateMsg.add(String.format("%s_%s_%s", orgId, bookTypeId, cashflowPeriodid));
            }
            if (cashflowPeriodid == 0L || obj.getDynamicObject("cashinitperiod").getInt("periodnumber") == 1) {
                DeleteServiceHelper.delete((String)"gl_initcashflow", (QFilter[])new QFilter[]{forgId, fbookTypeId});
                continue;
            }
            QFilter deleteFilter = new QFilter("tabdelete", "=", (Object)true);
            DeleteServiceHelper.delete((String)"gl_initcashflow", (QFilter[])new QFilter[]{forgId, fbookTypeId, deleteFilter});
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>(10);
        try {
            for (DynamicObject obj : e.getDataEntities()) {
                DynamicObject accountingsys = obj.getDynamicObject("accountingsys");
                DynamicObject addview = BusinessDataServiceHelper.loadSingle((String)"bd_accountingsysviewsch", (String)"id", (QFilter[])new QFilter[]{new QFilter("accountingsys", "=", accountingsys.getPkValue()), new QFilter("ismainview", "=", (Object)true)});
                HashSet<Long> leafOrgIds = new HashSet<Long>(100);
                try (DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{new QFilter("view", "=", addview.get("id")), new QFilter("isleaf", "=", (Object)true)}, null);){
                    for (Row row : dt) {
                        leafOrgIds.add(row.getLong("org"));
                    }
                }
                DynamicObjectCollection orgObjects = (DynamicObjectCollection)obj.get("multiplechoiceorg");
                DynamicObject bookStype = obj.getDynamicObject("bookstype");
                Object pkValue = obj.getPkValue();
                if (QueryServiceHelper.exists((String)"gl_accountbook", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)})) continue;
                long[] newIds = DBServiceHelper.genLongIds((String)"gl_accountbook", (int)orgObjects.size());
                int i = 0;
                if (orgObjects.isEmpty()) {
                    Long org_id = obj.getLong("org_id");
                    Map localSetInfo = CashflowLocalSetUtil.getLocalSetInfo((Set)CashflowLocalSetUtil.longToSet((long)org_id));
                    if (localSetInfo != null && localSetInfo.get(org_id) != null) {
                        obj.set("localset", ((Tuple)localSetInfo.get((Object)org_id)).item1);
                        obj.set("localsetdate", ((Tuple)localSetInfo.get((Object)org_id)).item2);
                    }
                    if (!leafOrgIds.contains(org_id)) {
                        obj.set("isbizunit", (Object)0);
                        obj.set("startperiod", null);
                        obj.set("curperiod", null);
                        obj.set("cashinitperiod", null);
                        continue;
                    }
                    obj.set("isbizunit", (Object)1);
                    continue;
                }
                for (DynamicObject org : orgObjects) {
                    Object profileAccount;
                    Object voucherType;
                    DynamicObject clone = (DynamicObject)OrmUtils.clone((IDataEntityBase)obj, (boolean)true, (boolean)true);
                    obj.set("id", (Object)newIds[i]);
                    obj.set(MASTERID, (Object)newIds[i]);
                    clone.set("id", (Object)newIds[i]);
                    clone.set(MASTERID, (Object)newIds[i]);
                    if (!leafOrgIds.contains(((DynamicObject)org.get("fbasedataid")).getLong("id"))) {
                        clone.set("startperiod", null);
                        clone.set("curperiod", null);
                        clone.set("isbizunit", (Object)0);
                        clone.set("cashinitperiod", null);
                    } else {
                        clone.set("isbizunit", (Object)1);
                    }
                    DynamicObject orgObj = (DynamicObject)org.get("fbasedataid");
                    long orgId = Long.parseLong(orgObj.getPkValue().toString());
                    clone.set("org_id", (Object)orgId);
                    Map localSetInfo = CashflowLocalSetUtil.getLocalSetInfo((Set)CashflowLocalSetUtil.longToSet((long)orgId));
                    if (localSetInfo != null && localSetInfo.get(orgId) != null) {
                        clone.set("localset", ((Tuple)localSetInfo.get((Object)Long.valueOf((long)orgId))).item1);
                        clone.set("localsetdate", ((Tuple)localSetInfo.get((Object)Long.valueOf((long)orgId))).item2);
                    }
                    if (StringUtils.isBlank((CharSequence)obj.getString("number"))) {
                        DynamicObject temp = (DynamicObject)OrmUtils.clone((IDataEntityBase)clone, (boolean)true, (boolean)true);
                        temp.set("org", (Object)orgObj);
                        String number = AccountBookUtil.getAccountBookNumber(orgObj.getString("number"), bookStype.getString("number"), temp);
                        clone.set("number", (Object)number);
                    }
                    if ((voucherType = obj.get(VOUCHER_TYPE_FIELD)) instanceof DynamicObject) {
                        this.setVoucherType(clone, orgObj, (DynamicObject)voucherType);
                    }
                    if ((profileAccount = obj.get(ACCOUNT_VIEW_FIELD)) instanceof DynamicObject) {
                        this.setProfileAccount(clone, orgObj, (DynamicObject)profileAccount);
                    }
                    successObjs.add(clone);
                    ++i;
                }
            }
        }
        catch (KDBizException exp) {
            throw new KDBizException(exp.getErrorCode(), new Object[]{exp.getMessage()});
        }
        if (!successObjs.isEmpty()) {
            e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        List configVOList = LocalCurrencyConfigService.getCurrencyConfigByEntityId((String)"gl_accountbook");
        configVOList = configVOList.stream().filter(configVO -> !configVO.isEnabled()).collect(Collectors.toList());
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<String> localCurrencyNumSet = new HashSet<String>(8);
        block0: for (LocalCurrencyConfigVO configVO2 : configVOList) {
            for (DynamicObject dataEntity : dataEntities) {
                if (!Objects.nonNull(dataEntity.getDynamicObject(configVO2.getCurrencyField()))) continue;
                localCurrencyNumSet.add(configVO2.getNumber());
                continue block0;
            }
        }
        for (String localCurrencyNum : localCurrencyNumSet) {
            LocalCurrencyConfigService.initSpecificLocalCur((String)localCurrencyNum);
        }
        LocalCurrencyConfigService.removeMulCurConfigCache();
        LocalCurrencyQueryService.removeCache();
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] successObjs;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject obj : successObjs = e.getDataEntities()) {
            AccSysUtil.clearAccountBookVersionsFromCache((long)obj.getLong("org_id"), (long)obj.getLong("bookstype_id"));
            DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.book);
            DistributeCache cacheSys = CacheHelper.getDistributeCache((CacheModule)CacheModule.accSys);
            cache.remove(this.getKey(obj.getLong("org_id") + "", obj.getLong("bookstype_id") + ""));
            cache.remove(this.getKeyByNumber(obj.getDynamicObject("org"), obj.getDynamicObject("bookstype")));
            cacheSys.remove(CacheKey.ACCSYS_MAINVIEWORGBOOKTYPE.toString());
            cacheSys.remove(CacheKey.ACCSYS_STATVIEWORGBOOKTYPE.toString());
        }
        List ids = this.operationResult.getSuccessPkIds();
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4f1a\u8ba1\u8d26\u7c3f\u66f4\u65b0", "AccountBookAddOp_0", "fi-gl-opplugin");
            ArrayList<AppLogInfo> appLogInfoList = new ArrayList<AppLogInfo>();
            String appNum = EntityMetadataCache.getDataEntityType((String)"gl_accountbook").getAppId();
            String appId = AppMetadataCache.getAppInfo((String)appNum).getId();
            for (Object id : ids) {
                Tuple value = (Tuple)ThreadCache.get((Object)AccountBookHelper.genCacheKey(id));
                if (value == null) continue;
                String operationKey = e.getOperationKey();
                AppLogInfo appLogInfo = this.buildLogInfo((String)value.item2, opNameBridge, (Long)value.item1, "gl_accountbook", appId, operationKey);
                appLogInfoList.add(appLogInfo);
            }
            LogServiceHelper.addBatchLog(appLogInfoList);
        }
        for (String msg : this.reCalculateMsg) {
            QFilter fid2;
            long booktypeId;
            String[] msgs = msg.split("_");
            long orgId = Long.parseLong(msgs[0]);
            Long vperiodId = this.getMaxVchPeriodId(orgId, booktypeId = Long.parseLong(msgs[1]));
            long endperiodid = vperiodId != null && vperiodId > Long.parseLong(msgs[2]) ? vperiodId : Long.parseLong(msgs[2]);
            QFilter ftypeId = new QFilter("periodtype", "=", (Object)PeriodUtil.getTypeid((long)Long.parseLong(msgs[2])));
            QFilter fid1 = new QFilter("id", ">=", (Object)Long.parseLong(msgs[2]));
            DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{fid1, fid2 = new QFilter("id", "<=", (Object)endperiodid), ftypeId}, (String)"id");
            if (col.isEmpty()) continue;
            for (DynamicObject obj : col) {
                this.calculate(orgId, booktypeId, obj.getLong("id"));
            }
        }
    }

    private Long getMaxVchPeriodId(long orgId, long btId) {
        return (Long)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)"select max(fperiodid) endperiod from t_gl_voucher where forgid=? and fbooktypeid=? and fbillstatus!='A'", (Object[])new Object[]{orgId, btId}, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    return resultSet.getLong("endperiod");
                }
                return null;
            }
        });
    }

    private boolean calculate(long orgId, long bookTypeId, long periodId) {
        Throwable throwable;
        TXHandle txh;
        int count = 0;
        ICalculator calculator = CalculatorFactory.createCashflowCalculator();
        do {
            txh = TX.requiresNew();
            throwable = null;
            try {
                count = calculator.calculate(orgId, bookTypeId);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (txh != null) {
                    if (throwable != null) {
                        try {
                            txh.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        txh.close();
                    }
                }
            }
        } while (count > 0);
        txh = TX.requiresNew();
        throwable = null;
        try {
            try {
                calculator.reCalculate(orgId, bookTypeId, periodId);
                new CashflowSumCalculator().reCalculate(orgId, bookTypeId, periodId);
            }
            catch (Exception ex) {
                txh.markRollback();
                throw ex;
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (txh != null) {
                if (throwable != null) {
                    try {
                        txh.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    txh.close();
                }
            }
        }
        return true;
    }

    private void setVoucherType(DynamicObject clone, DynamicObject org, DynamicObject voucherType) {
        Long orgId = (Long)org.getPkValue();
        List<Object> dataIds = this.getAssignBaseDataIdsBySingleOrg(orgId, VOUCHER_TYPE_ENTITY);
        if (!dataIds.contains(voucherType.getPkValue())) {
            clone.set(VOUCHER_TYPE_FIELD, null);
        }
    }

    private void setProfileAccount(DynamicObject clone, DynamicObject org, DynamicObject profileAccount) {
        Long orgId = (Long)org.getPkValue();
        List<Object> dataIds = this.getAssignBaseDataIdsBySingleOrg(orgId, ACCOUNT_VIEW_ENTITY);
        if (!dataIds.contains(profileAccount.getPkValue())) {
            clone.set(ACCOUNT_VIEW_FIELD, null);
        }
    }

    private List<Object> getAssignBaseDataIdsBySingleOrg(Long orgId, String entity) {
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)entity, (Long)orgId);
        ArrayList<Object> dataIds = new ArrayList<Object>(8);
        if (QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{filter})) {
            QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{filter}).forEach(dyo -> {
                if (dyo.get("id") != null) {
                    dataIds.add(dyo.get("id"));
                }
            });
        }
        return dataIds;
    }

    private AppLogInfo buildLogInfo(String opDesc, MultiLangEnumBridge opName, long orgId, String entityId, String appId, String operationKey) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizAppID(appId);
        appLogInfo.setBizObjID(entityId);
        appLogInfo.setOpDescription(opDesc.length() > 255 ? opDesc.substring(0, 255) : opDesc);
        appLogInfo.setOpName(operationKey, opName);
        appLogInfo.setOpTime(TimeServiceHelper.now());
        appLogInfo.setOrgID(Long.valueOf(orgId));
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        appLogInfo.setClientType(RequestContext.get().getClient());
        appLogInfo.setModifyContentTag(opDesc);
        return appLogInfo;
    }

    protected String getKey(String orgId, String bookTypeId) {
        return orgId + "-" + bookTypeId;
    }

    protected String getKeyByNumber(Object org, Object book) {
        String orgNumber = org == null ? "" : ((DynamicObject)org).getString("number");
        String bookTypeNumber = book == null ? "" : ((DynamicObject)book).getString("number");
        return orgNumber + "-" + bookTypeNumber;
    }
}

